/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.credentials.provider.factory.strategies;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.PropertiesFileCredentialsProvider;
import java.io.File;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processors.aws.credentials.provider.PropertiesCredentialsProvider;
import org.apache.nifi.processors.aws.credentials.provider.factory.CredentialPropertyDescriptors;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.AbstractCredentialsStrategy;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public class FileCredentialsStrategy
extends AbstractCredentialsStrategy {
    public FileCredentialsStrategy() {
        super("Credentials File", new PropertyDescriptor[]{CredentialPropertyDescriptors.CREDENTIALS_FILE});
    }

    @Override
    public AWSCredentialsProvider getCredentialsProvider(PropertyContext propertyContext) {
        String credentialsFile = propertyContext.getProperty(CredentialPropertyDescriptors.CREDENTIALS_FILE).getValue();
        return new PropertiesFileCredentialsProvider(credentialsFile);
    }

    @Override
    public AwsCredentialsProvider getAwsCredentialsProvider(PropertyContext propertyContext) {
        String credentialsFile = propertyContext.getProperty(CredentialPropertyDescriptors.CREDENTIALS_FILE).getValue();
        return new PropertiesCredentialsProvider(new File(credentialsFile));
    }
}

