/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.ml.transcribe;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.textract.model.ThrottlingException;
import com.amazonaws.services.transcribe.AmazonTranscribeClient;
import com.amazonaws.services.transcribe.AmazonTranscribeClientBuilder;
import com.amazonaws.services.transcribe.model.GetTranscriptionJobRequest;
import com.amazonaws.services.transcribe.model.GetTranscriptionJobResult;
import com.amazonaws.services.transcribe.model.TranscriptionJobStatus;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.aws.ml.AwsMachineLearningJobStatusProcessor;
import org.apache.nifi.processors.aws.ml.transcribe.StartAwsTranscribeJob;

@Tags(value={"Amazon", "AWS", "ML", "Machine Learning", "Transcribe"})
@CapabilityDescription(value="Retrieves the current status of an AWS Transcribe job.")
@SeeAlso(value={StartAwsTranscribeJob.class})
@WritesAttributes(value={@WritesAttribute(attribute="outputLocation", description="S3 path-style output location of the result.")})
public class GetAwsTranscribeJobStatus
extends AwsMachineLearningJobStatusProcessor<AmazonTranscribeClient> {
    protected AmazonTranscribeClient createClient(ProcessContext context, AWSCredentialsProvider credentialsProvider, ClientConfiguration config) {
        return (AmazonTranscribeClient)((AmazonTranscribeClientBuilder)((AmazonTranscribeClientBuilder)AmazonTranscribeClient.builder().withRegion(context.getProperty(REGION).getValue())).withCredentials(credentialsProvider)).build();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try {
            GetTranscriptionJobResult job = this.getJob(context, flowFile);
            TranscriptionJobStatus jobStatus = TranscriptionJobStatus.fromValue((String)job.getTranscriptionJob().getTranscriptionJobStatus());
            if (TranscriptionJobStatus.COMPLETED == jobStatus) {
                this.writeToFlowFile(session, flowFile, job);
                session.putAttribute(flowFile, "outputLocation", job.getTranscriptionJob().getTranscript().getTranscriptFileUri());
                session.transfer(flowFile, REL_SUCCESS);
            } else if (TranscriptionJobStatus.IN_PROGRESS == jobStatus) {
                session.transfer(flowFile, REL_RUNNING);
            } else if (TranscriptionJobStatus.FAILED == jobStatus) {
                String failureReason = job.getTranscriptionJob().getFailureReason();
                session.putAttribute(flowFile, "failure.reason", failureReason);
                session.transfer(flowFile, REL_FAILURE);
                this.getLogger().error("Transcribe Task Failed {} Reason [{}]", new Object[]{flowFile, failureReason});
            }
        }
        catch (ThrottlingException e) {
            this.getLogger().info("Request Rate Limit exceeded", (Throwable)e);
            session.transfer(flowFile, REL_THROTTLED);
            return;
        }
        catch (Exception e) {
            this.getLogger().warn("Failed to get Transcribe Job status", (Throwable)e);
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
    }

    private GetTranscriptionJobResult getJob(ProcessContext context, FlowFile flowFile) {
        String taskId = context.getProperty(TASK_ID).evaluateAttributeExpressions(flowFile).getValue();
        GetTranscriptionJobRequest request = new GetTranscriptionJobRequest().withTranscriptionJobName(taskId);
        return ((AmazonTranscribeClient)this.getClient(context)).getTranscriptionJob(request);
    }
}

