/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.credentials.provider.factory.strategies;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processors.aws.credentials.provider.factory.CredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.AbstractCredentialsStrategy;

public abstract class AbstractBooleanCredentialsStrategy
extends AbstractCredentialsStrategy {
    private PropertyDescriptor strategyProperty;

    public AbstractBooleanCredentialsStrategy(String name, PropertyDescriptor strategyProperty) {
        super("Default Credentials", new PropertyDescriptor[]{strategyProperty});
        this.strategyProperty = strategyProperty;
    }

    @Override
    public boolean canCreatePrimaryCredential(PropertyContext propertyContext) {
        PropertyValue strategyPropertyValue = propertyContext.getProperty(this.strategyProperty);
        if (strategyPropertyValue == null) {
            return false;
        }
        if (this.strategyProperty.isExpressionLanguageSupported()) {
            strategyPropertyValue = strategyPropertyValue.evaluateAttributeExpressions();
        }
        String useStrategyString = strategyPropertyValue.getValue();
        Boolean useStrategy = Boolean.parseBoolean(useStrategyString);
        return useStrategy;
    }

    @Override
    public Collection<ValidationResult> validate(ValidationContext validationContext, CredentialsStrategy primaryStrategy) {
        boolean thisIsSelectedStrategy = this == primaryStrategy;
        Boolean useStrategy = validationContext.getProperty(this.strategyProperty).asBoolean();
        if (!thisIsSelectedStrategy && useStrategy.booleanValue()) {
            String failureFormat = "property %1$s cannot be used with %2$s";
            ArrayList<ValidationResult> validationFailureResults = new ArrayList<ValidationResult>();
            String message = String.format("property %1$s cannot be used with %2$s", this.strategyProperty.getDisplayName(), primaryStrategy.getName());
            validationFailureResults.add(new ValidationResult.Builder().subject(this.strategyProperty.getDisplayName()).valid(false).explanation(message).build());
            return validationFailureResults;
        }
        return null;
    }
}

