/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.ml;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.http.SdkHttpMetadata;
import com.amazonaws.regions.Regions;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.AbstractAWSCredentialsProviderProcessor;
import org.apache.nifi.processors.aws.ml.AwsResponseMetadataDeserializer;
import org.apache.nifi.processors.aws.ml.SdkHttpMetadataDeserializer;

public abstract class AwsMachineLearningJobStatusProcessor<T extends AmazonWebServiceClient>
extends AbstractAWSCredentialsProviderProcessor<T> {
    public static final String AWS_TASK_OUTPUT_LOCATION = "outputLocation";
    public static final PropertyDescriptor MANDATORY_AWS_CREDENTIALS_PROVIDER_SERVICE = new PropertyDescriptor.Builder().fromPropertyDescriptor(AWS_CREDENTIALS_PROVIDER_SERVICE).required(true).build();
    public static final PropertyDescriptor TASK_ID = new PropertyDescriptor.Builder().name("awsTaskId").displayName("AWS Task ID").defaultValue("${awsTaskId}").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("Upon successful completion, the original FlowFile will be routed to this relationship.").autoTerminateDefault(true).build();
    public static final Relationship REL_RUNNING = new Relationship.Builder().name("running").description("The job is currently still being processed").build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Job successfully finished. FlowFile will be routed to this relation.").build();
    public static final Relationship REL_THROTTLED = new Relationship.Builder().name("throttled").description("Retrieving results failed for some reason, but the issue is likely to resolve on its own, such as Provisioned Throughput Exceeded or a Throttling failure. It is generally expected to retry this relationship.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("The job failed, the original FlowFile will be routed to this relationship.").autoTerminateDefault(true).build();
    public static final PropertyDescriptor REGION = new PropertyDescriptor.Builder().displayName("Region").name("aws-region").required(true).allowableValues(AwsMachineLearningJobStatusProcessor.getAvailableRegions()).defaultValue(AwsMachineLearningJobStatusProcessor.createAllowableValue((Regions)Regions.DEFAULT_REGION).getValue()).build();
    public static final String FAILURE_REASON_ATTRIBUTE = "failure.reason";
    protected static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(TASK_ID, MANDATORY_AWS_CREDENTIALS_PROVIDER_SERVICE, REGION, TIMEOUT, SSL_CONTEXT_SERVICE, ENDPOINT_OVERRIDE, PROXY_CONFIGURATION_SERVICE));
    private static final ObjectMapper MAPPER = ((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build();
    private static final Set<Relationship> relationships;

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    protected T createClient(ProcessContext context, AWSCredentials credentials, ClientConfiguration config) {
        throw new UnsupportedOperationException("Client creation not supported");
    }

    protected void writeToFlowFile(ProcessSession session, FlowFile flowFile, Object response) {
        session.write(flowFile, out -> MAPPER.writeValue(out, response));
    }

    static {
        SimpleModule awsResponseModule = new SimpleModule();
        awsResponseModule.addDeserializer(ResponseMetadata.class, (JsonDeserializer)new AwsResponseMetadataDeserializer());
        SimpleModule sdkHttpModule = new SimpleModule();
        awsResponseModule.addDeserializer(SdkHttpMetadata.class, (JsonDeserializer)new SdkHttpMetadataDeserializer());
        MAPPER.registerModule((Module)awsResponseModule);
        MAPPER.registerModule((Module)sdkHttpModule);
        relationships = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_ORIGINAL, REL_SUCCESS, REL_RUNNING, REL_THROTTLED, REL_FAILURE)));
    }
}

