/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.cloudwatch;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.PutMetricDataResult;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.amazonaws.services.cloudwatch.model.StatisticSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.AbstractAWSCredentialsProviderProcessor;

@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Publishes metrics to Amazon CloudWatch. Metric can be either a single value, or a StatisticSet comprised of minimum, maximum, sum and sample count.")
@DynamicProperty(name="Dimension Name", value="Dimension Value", description="Allows dimension name/value pairs to be added to the metric. AWS supports a maximum of 10 dimensions.", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES)
@Tags(value={"amazon", "aws", "cloudwatch", "metrics", "put", "publish"})
public class PutCloudWatchMetric
extends AbstractAWSCredentialsProviderProcessor<AmazonCloudWatchClient> {
    public static final Set<Relationship> relationships = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE)));
    public static final Set<String> units = Arrays.stream(StandardUnit.values()).map(StandardUnit::toString).collect(Collectors.toSet());
    private static final Validator UNIT_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                return new ValidationResult.Builder().subject(subject).input(input).explanation("Expression Language Present").valid(true).build();
            }
            String reason = null;
            if (!units.contains(input)) {
                reason = "not a valid Unit";
            }
            return new ValidationResult.Builder().subject(subject).input(input).explanation(reason).valid(reason == null).build();
        }
    };
    private static final Validator DOUBLE_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                return new ValidationResult.Builder().subject(subject).input(input).explanation("Expression Language Present").valid(true).build();
            }
            String reason = null;
            try {
                Double.parseDouble(input);
            }
            catch (NumberFormatException e) {
                reason = "not a valid Double";
            }
            return new ValidationResult.Builder().subject(subject).input(input).explanation(reason).valid(reason == null).build();
        }
    };
    public static final PropertyDescriptor NAMESPACE = new PropertyDescriptor.Builder().name("Namespace").displayName("Namespace").description("The namespace for the metric data for CloudWatch").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor METRIC_NAME = new PropertyDescriptor.Builder().name("MetricName").displayName("Metric Name").description("The name of the metric").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).addValidator((Validator)new StandardValidators.StringLengthValidator(1, 255)).build();
    public static final PropertyDescriptor VALUE = new PropertyDescriptor.Builder().name("Value").displayName("Value").description("The value for the metric. Must be a double").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).addValidator(DOUBLE_VALIDATOR).build();
    public static final PropertyDescriptor TIMESTAMP = new PropertyDescriptor.Builder().name("Timestamp").displayName("Timestamp").description("A point in time expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. If not specified, the default value is set to the time the metric data was received").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).addValidator(StandardValidators.LONG_VALIDATOR).build();
    public static final PropertyDescriptor UNIT = new PropertyDescriptor.Builder().name("Unit").displayName("Unit").description("The unit of the metric. (e.g Seconds, Bytes, Megabytes, Percent, Count,  Kilobytes/Second, Terabits/Second, Count/Second) For details see http://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).addValidator(UNIT_VALIDATOR).build();
    public static final PropertyDescriptor MAXIMUM = new PropertyDescriptor.Builder().name("maximum").displayName("Maximum").description("The maximum value of the sample set. Must be a double").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).addValidator(DOUBLE_VALIDATOR).build();
    public static final PropertyDescriptor MINIMUM = new PropertyDescriptor.Builder().name("minimum").displayName("Minimum").description("The minimum value of the sample set. Must be a double").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).addValidator(DOUBLE_VALIDATOR).build();
    public static final PropertyDescriptor SAMPLECOUNT = new PropertyDescriptor.Builder().name("sampleCount").displayName("Sample Count").description("The number of samples used for the statistic set. Must be a double").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).addValidator(DOUBLE_VALIDATOR).build();
    public static final PropertyDescriptor SUM = new PropertyDescriptor.Builder().name("sum").displayName("Sum").description("The sum of values for the sample set. Must be a double").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).addValidator(DOUBLE_VALIDATOR).build();
    public static final List<PropertyDescriptor> properties = Collections.unmodifiableList(Arrays.asList(NAMESPACE, METRIC_NAME, VALUE, MAXIMUM, MINIMUM, SAMPLECOUNT, SUM, TIMESTAMP, UNIT, REGION, ACCESS_KEY, SECRET_KEY, CREDENTIALS_FILE, AWS_CREDENTIALS_PROVIDER_SERVICE, TIMEOUT, SSL_CONTEXT_SERVICE, ENDPOINT_OVERRIDE, PROXY_HOST, PROXY_HOST_PORT, PROXY_USERNAME, PROXY_PASSWORD));
    private volatile Set<String> dynamicPropertyNames = new HashSet<String>();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dynamic(true).build();
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (descriptor.isDynamic()) {
            HashSet<String> newDynamicPropertyNames = new HashSet<String>(this.dynamicPropertyNames);
            if (newValue == null) {
                newDynamicPropertyNames.remove(descriptor.getName());
            } else if (oldValue == null) {
                newDynamicPropertyNames.add(descriptor.getName());
            }
            this.dynamicPropertyNames = Collections.unmodifiableSet(newDynamicPropertyNames);
        }
    }

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        boolean anyStatisticSetValue;
        Collection problems = super.customValidate(validationContext);
        boolean valueSet = validationContext.getProperty(VALUE).isSet();
        boolean maxSet = validationContext.getProperty(MAXIMUM).isSet();
        boolean minSet = validationContext.getProperty(MINIMUM).isSet();
        boolean sampleCountSet = validationContext.getProperty(SAMPLECOUNT).isSet();
        boolean sumSet = validationContext.getProperty(SUM).isSet();
        boolean completeStatisticSet = maxSet && minSet && sampleCountSet && sumSet;
        boolean bl = anyStatisticSetValue = maxSet || minSet || sampleCountSet || sumSet;
        if (valueSet && anyStatisticSetValue) {
            problems.add(new ValidationResult.Builder().subject("Metric").valid(false).explanation("Cannot set both Value and StatisticSet(Maximum, Minimum, SampleCount, Sum) properties").build());
        } else if (!valueSet && !completeStatisticSet) {
            problems.add(new ValidationResult.Builder().subject("Metric").valid(false).explanation("Must set either Value or complete StatisticSet(Maximum, Minimum, SampleCount, Sum) properties").build());
        }
        if (this.dynamicPropertyNames.size() > 10) {
            problems.add(new ValidationResult.Builder().subject("Metric").valid(false).explanation("Cannot set more than 10 dimensions").build());
        }
        return problems;
    }

    protected AmazonCloudWatchClient createClient(ProcessContext processContext, AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this.getLogger().info("Creating client using aws credentials provider");
        return new AmazonCloudWatchClient(awsCredentialsProvider, clientConfiguration);
    }

    protected AmazonCloudWatchClient createClient(ProcessContext processContext, AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        this.getLogger().debug("Creating client with aws credentials");
        return new AmazonCloudWatchClient(awsCredentials, clientConfiguration);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        MetricDatum datum = new MetricDatum();
        try {
            String unit;
            datum.setMetricName(context.getProperty(METRIC_NAME).evaluateAttributeExpressions(flowFile).getValue());
            String valueString = context.getProperty(VALUE).evaluateAttributeExpressions(flowFile).getValue();
            if (valueString != null) {
                datum.setValue(Double.valueOf(Double.parseDouble(valueString)));
            } else {
                StatisticSet statisticSet = new StatisticSet();
                statisticSet.setMaximum(Double.valueOf(Double.parseDouble(context.getProperty(MAXIMUM).evaluateAttributeExpressions(flowFile).getValue())));
                statisticSet.setMinimum(Double.valueOf(Double.parseDouble(context.getProperty(MINIMUM).evaluateAttributeExpressions(flowFile).getValue())));
                statisticSet.setSampleCount(Double.valueOf(Double.parseDouble(context.getProperty(SAMPLECOUNT).evaluateAttributeExpressions(flowFile).getValue())));
                statisticSet.setSum(Double.valueOf(Double.parseDouble(context.getProperty(SUM).evaluateAttributeExpressions(flowFile).getValue())));
                datum.setStatisticValues(statisticSet);
            }
            String timestamp = context.getProperty(TIMESTAMP).evaluateAttributeExpressions(flowFile).getValue();
            if (timestamp != null) {
                datum.setTimestamp(new Date(Long.parseLong(timestamp)));
            }
            if ((unit = context.getProperty(UNIT).evaluateAttributeExpressions(flowFile).getValue()) != null) {
                datum.setUnit(unit);
            }
            if (!this.dynamicPropertyNames.isEmpty()) {
                ArrayList<Dimension> dimensions = new ArrayList<Dimension>(this.dynamicPropertyNames.size());
                for (String propertyName : this.dynamicPropertyNames) {
                    String propertyValue = context.getProperty(propertyName).evaluateAttributeExpressions(flowFile).getValue();
                    if (!StringUtils.isNotBlank((CharSequence)propertyValue)) continue;
                    dimensions.add(new Dimension().withName(propertyName).withValue(propertyValue));
                }
                datum.withDimensions(dimensions);
            }
            PutMetricDataRequest metricDataRequest = new PutMetricDataRequest().withNamespace(context.getProperty(NAMESPACE).evaluateAttributeExpressions(flowFile).getValue()).withMetricData(new MetricDatum[]{datum});
            this.putMetricData(metricDataRequest);
            session.transfer(flowFile, REL_SUCCESS);
            this.getLogger().info("Successfully published cloudwatch metric for {}", new Object[]{flowFile});
        }
        catch (Exception e) {
            this.getLogger().error("Failed to publish cloudwatch metric for {} due to {}", new Object[]{flowFile, e});
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    protected PutMetricDataResult putMetricData(PutMetricDataRequest metricDataRequest) throws AmazonClientException {
        AmazonCloudWatchClient client = (AmazonCloudWatchClient)this.getClient();
        PutMetricDataResult result = client.putMetricData(metricDataRequest);
        return result;
    }
}

