/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.sqs;

import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.v2.AbstractAwsProcessor;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;

public abstract class AbstractSQSProcessor
extends AbstractAwsProcessor<SqsClient, SqsClientBuilder> {
    public static final PropertyDescriptor BATCH_SIZE = new PropertyDescriptor.Builder().name("Batch Size").description("The maximum number of messages to send in a single network request").required(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("25").build();
    public static final PropertyDescriptor QUEUE_URL = new PropertyDescriptor.Builder().name("Queue URL").description("The URL of the queue to act upon").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).build();

    @Override
    protected SqsClientBuilder createClientBuilder(ProcessContext context) {
        return SqsClient.builder();
    }
}

