/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.v2;

import java.io.File;
import java.net.Proxy;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.VerifiableProcessor;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.credentials.provider.PropertiesCredentialsProvider;
import org.apache.nifi.processors.aws.credentials.provider.factory.CredentialPropertyDescriptors;
import org.apache.nifi.processors.aws.credentials.provider.service.AWSCredentialsProviderService;
import org.apache.nifi.processors.aws.v2.AwsClientCache;
import org.apache.nifi.processors.aws.v2.AwsClientDetails;
import org.apache.nifi.processors.aws.v2.AwsClientProvider;
import org.apache.nifi.processors.aws.v2.RegionUtil;
import org.apache.nifi.proxy.ProxyConfigurationService;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.ssl.SSLContextService;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.client.builder.SdkClientBuilder;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.http.FileStoreTlsKeyManagersProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.TlsKeyManagersProvider;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.builder.SdkBuilder;

public abstract class AbstractAwsProcessor<T extends SdkClient, U extends AwsSyncClientBuilder<U, T> & AwsClientBuilder<U, T>>
extends AbstractProcessor
implements VerifiableProcessor,
AwsClientProvider<T> {
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles are routed to success relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles are routed to failure relationship").build();
    private static final Set<Relationship> relationships = Collections.unmodifiableSet(new LinkedHashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE)));
    public static final PropertyDescriptor CREDENTIALS_FILE = CredentialPropertyDescriptors.CREDENTIALS_FILE;
    public static final PropertyDescriptor ACCESS_KEY = CredentialPropertyDescriptors.ACCESS_KEY;
    public static final PropertyDescriptor SECRET_KEY = CredentialPropertyDescriptors.SECRET_KEY;
    public static final PropertyDescriptor PROXY_HOST = new PropertyDescriptor.Builder().name("Proxy Host").description("Proxy host name or IP").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PROXY_HOST_PORT = new PropertyDescriptor.Builder().name("Proxy Host Port").description("Proxy host port").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(false).addValidator(StandardValidators.PORT_VALIDATOR).build();
    public static final PropertyDescriptor PROXY_USERNAME = new PropertyDescriptor.Builder().name("proxy-user-name").displayName("Proxy Username").description("Proxy username").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PROXY_PASSWORD = new PropertyDescriptor.Builder().name("proxy-user-password").displayName("Proxy Password").description("Proxy password").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor REGION = new PropertyDescriptor.Builder().name("Region").required(true).allowableValues(RegionUtil.getAvailableRegions()).defaultValue(RegionUtil.createAllowableValue(Region.US_WEST_2).getValue()).build();
    public static final PropertyDescriptor TIMEOUT = new PropertyDescriptor.Builder().name("Communications Timeout").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("30 secs").build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("Specifies an optional SSL Context Service that, if provided, will be used to create connections").required(false).identifiesControllerService(SSLContextService.class).build();
    public static final PropertyDescriptor ENDPOINT_OVERRIDE = new PropertyDescriptor.Builder().name("Endpoint Override URL").description("Endpoint URL to use instead of the AWS default including scheme, host, port, and path. The AWS libraries select an endpoint URL based on the AWS region, but this property overrides the selected endpoint URL, allowing use with other S3-compatible endpoints.").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(false).addValidator(StandardValidators.URL_VALIDATOR).build();
    public static final PropertyDescriptor AWS_CREDENTIALS_PROVIDER_SERVICE = new PropertyDescriptor.Builder().name("AWS Credentials Provider service").displayName("AWS Credentials Provider Service").description("The Controller Service that is used to obtain AWS credentials provider").required(false).identifiesControllerService(AWSCredentialsProviderService.class).build();
    protected static final String DEFAULT_USER_AGENT = "NiFi";
    private static final ProxySpec[] PROXY_SPECS = new ProxySpec[]{ProxySpec.HTTP_AUTH};
    public static final PropertyDescriptor PROXY_CONFIGURATION_SERVICE = org.apache.nifi.proxy.ProxyConfiguration.createProxyConfigPropertyDescriptor((boolean)true, (ProxySpec[])PROXY_SPECS);
    protected volatile T client;
    protected volatile Region region;
    private final AwsClientCache<T> awsClientCache = new AwsClientCache();

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        boolean accessKeySet = validationContext.getProperty(ACCESS_KEY).isSet();
        boolean secretKeySet = validationContext.getProperty(SECRET_KEY).isSet();
        if (accessKeySet && !secretKeySet || secretKeySet && !accessKeySet) {
            validationResults.add(new ValidationResult.Builder().input("Access Key").valid(false).explanation("If setting Secret Key or Access Key, must set both").build());
        }
        boolean credentialsFileSet = validationContext.getProperty(CREDENTIALS_FILE).isSet();
        if ((secretKeySet || accessKeySet) && credentialsFileSet) {
            validationResults.add(new ValidationResult.Builder().input("Access Key").valid(false).explanation("Cannot set both Credentials File and Secret Key/Access Key").build());
        }
        boolean proxyHostSet = validationContext.getProperty(PROXY_HOST).isSet();
        boolean proxyPortSet = validationContext.getProperty(PROXY_HOST_PORT).isSet();
        boolean proxyConfigServiceSet = validationContext.getProperty(ProxyConfigurationService.PROXY_CONFIGURATION_SERVICE).isSet();
        if (proxyHostSet && !proxyPortSet || !proxyHostSet && proxyPortSet) {
            validationResults.add(new ValidationResult.Builder().subject("Proxy Host and Port").valid(false).explanation("If Proxy Host or Proxy Port is set, both must be set").build());
        }
        boolean proxyUserSet = validationContext.getProperty(PROXY_USERNAME).isSet();
        boolean proxyPwdSet = validationContext.getProperty(PROXY_PASSWORD).isSet();
        if (proxyUserSet && !proxyPwdSet || !proxyUserSet && proxyPwdSet) {
            validationResults.add(new ValidationResult.Builder().subject("Proxy User and Password").valid(false).explanation("If Proxy Username or Proxy Password is set, both must be set").build());
        }
        if (proxyUserSet && !proxyHostSet) {
            validationResults.add(new ValidationResult.Builder().subject("Proxy").valid(false).explanation("If Proxy Username or Proxy Password").build());
        }
        org.apache.nifi.proxy.ProxyConfiguration.validateProxySpec((ValidationContext)validationContext, validationResults, (ProxySpec[])PROXY_SPECS);
        if (proxyHostSet && proxyConfigServiceSet) {
            validationResults.add(new ValidationResult.Builder().subject("Proxy Configuration Service").valid(false).explanation("Either Proxy Username and Proxy Password must be set or Proxy Configuration Service but not both").build());
        }
        return validationResults;
    }

    @OnShutdown
    public void onShutDown() {
        if (this.client != null) {
            this.client.close();
        }
    }

    @OnStopped
    public void onStopped() {
        this.awsClientCache.clearCache();
    }

    public List<ConfigVerificationResult> verify(ProcessContext context, ComponentLog verificationLogger, Map<String, String> attributes) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>();
        try {
            this.createClient(context);
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).verificationStepName("Create Client").explanation("Successfully created AWS Client").build());
        }
        catch (Exception e) {
            verificationLogger.error("Failed to create AWS Client", (Throwable)e);
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.FAILED).verificationStepName("Create Client").explanation("Failed to crete AWS Client: " + e.getMessage()).build());
        }
        return results;
    }

    @Override
    public T createClient(ProcessContext context) {
        U clientBuilder = this.createClientBuilder(context);
        this.configureClientBuilder(clientBuilder, context);
        return (T)((SdkClient)((SdkBuilder)clientBuilder).build());
    }

    protected void configureClientBuilder(U clientBuilder, ProcessContext context) {
        ((SdkClientBuilder)clientBuilder).overrideConfiguration(builder -> builder.putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX, (Object)DEFAULT_USER_AGENT));
        ((SdkClientBuilder)clientBuilder).overrideConfiguration(builder -> builder.retryPolicy(RetryPolicy.none()));
        clientBuilder.httpClient(this.createSdkHttpClient(context));
        Region region = this.getRegion(context);
        if (region != null) {
            ((AwsClientBuilder)clientBuilder).region(region);
        }
        this.configureEndpoint(context, clientBuilder);
        AwsCredentialsProvider credentialsProvider = this.getCredentialsProvider(context);
        ((AwsClientBuilder)clientBuilder).credentialsProvider(credentialsProvider);
    }

    protected T getClient(ProcessContext context, AwsClientDetails awsClientDetails) {
        return this.awsClientCache.getOrCreateClient(context, awsClientDetails, this);
    }

    protected T getClient(ProcessContext context) {
        AwsClientDetails awsClientDetails = new AwsClientDetails(this.getRegion(context));
        return this.getClient(context, awsClientDetails);
    }

    protected abstract U createClientBuilder(ProcessContext var1);

    protected Region getRegion(ProcessContext context) {
        String regionValue;
        Region region = this.getSupportedPropertyDescriptors().contains(REGION) ? ((regionValue = context.getProperty(REGION).getValue()) != null ? Region.of((String)regionValue) : null) : null;
        return region;
    }

    protected void configureEndpoint(ProcessContext context, U clientBuilder) {
        String endpointOverride;
        if (this.getSupportedPropertyDescriptors().contains(ENDPOINT_OVERRIDE) && !(endpointOverride = StringUtils.trimToEmpty((String)context.getProperty(ENDPOINT_OVERRIDE).evaluateAttributeExpressions().getValue())).isEmpty()) {
            this.getLogger().info("Overriding endpoint with {}", new Object[]{endpointOverride});
            ((SdkClientBuilder)clientBuilder).endpointOverride(URI.create(endpointOverride));
        }
    }

    protected AwsCredentialsProvider getCredentialsProvider(ProcessContext context) {
        AWSCredentialsProviderService awsCredentialsProviderService = (AWSCredentialsProviderService)context.getProperty(AWS_CREDENTIALS_PROVIDER_SERVICE).asControllerService(AWSCredentialsProviderService.class);
        return awsCredentialsProviderService != null ? awsCredentialsProviderService.getAwsCredentialsProvider() : this.createStaticCredentialsProvider((PropertyContext)context);
    }

    protected AwsCredentialsProvider createStaticCredentialsProvider(PropertyContext context) {
        String accessKey = context.getProperty(ACCESS_KEY).evaluateAttributeExpressions().getValue();
        String secretKey = context.getProperty(SECRET_KEY).evaluateAttributeExpressions().getValue();
        String credentialsFile = context.getProperty(CREDENTIALS_FILE).getValue();
        if (credentialsFile != null) {
            return new PropertiesCredentialsProvider(new File(credentialsFile));
        }
        if (accessKey != null && secretKey != null) {
            return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKey, (String)secretKey));
        }
        return AnonymousCredentialsProvider.create();
    }

    private SdkHttpClient createSdkHttpClient(ProcessContext context) {
        org.apache.nifi.proxy.ProxyConfiguration proxyConfig;
        SSLContextService sslContextService;
        ApacheHttpClient.Builder builder = ApacheHttpClient.builder();
        int communicationsTimeout = context.getProperty(TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        builder.connectionTimeout(Duration.ofMillis(communicationsTimeout));
        builder.socketTimeout(Duration.ofMillis(communicationsTimeout));
        builder.maxConnections(Integer.valueOf(context.getMaxConcurrentTasks()));
        if (this.getSupportedPropertyDescriptors().contains(SSL_CONTEXT_SERVICE) && (sslContextService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class)) != null) {
            if (sslContextService.isTrustStoreConfigured()) {
                TrustManager[] trustManagers = new TrustManager[]{sslContextService.createTrustManager()};
                builder.tlsTrustManagersProvider(() -> trustManagers);
            }
            if (sslContextService.isKeyStoreConfigured()) {
                FileStoreTlsKeyManagersProvider keyManagersProvider = FileStoreTlsKeyManagersProvider.create((Path)Paths.get(sslContextService.getKeyStoreFile(), new String[0]), (String)sslContextService.getKeyStoreType(), (String)sslContextService.getKeyStorePassword());
                builder.tlsKeyManagersProvider((TlsKeyManagersProvider)keyManagersProvider);
            }
        }
        if (Proxy.Type.HTTP.equals((Object)(proxyConfig = org.apache.nifi.proxy.ProxyConfiguration.getConfiguration((PropertyContext)context, () -> {
            if (context.getProperty(PROXY_HOST).isSet()) {
                org.apache.nifi.proxy.ProxyConfiguration componentProxyConfig = new org.apache.nifi.proxy.ProxyConfiguration();
                String proxyHost = context.getProperty(PROXY_HOST).evaluateAttributeExpressions().getValue();
                Integer proxyPort = context.getProperty(PROXY_HOST_PORT).evaluateAttributeExpressions().asInteger();
                String proxyUsername = context.getProperty(PROXY_USERNAME).evaluateAttributeExpressions().getValue();
                String proxyPassword = context.getProperty(PROXY_PASSWORD).evaluateAttributeExpressions().getValue();
                componentProxyConfig.setProxyType(Proxy.Type.HTTP);
                componentProxyConfig.setProxyServerHost(proxyHost);
                componentProxyConfig.setProxyServerPort(proxyPort);
                componentProxyConfig.setProxyUserName(proxyUsername);
                componentProxyConfig.setProxyUserPassword(proxyPassword);
                return componentProxyConfig;
            }
            if (context.getProperty(ProxyConfigurationService.PROXY_CONFIGURATION_SERVICE).isSet()) {
                ProxyConfigurationService configurationService = (ProxyConfigurationService)context.getProperty(ProxyConfigurationService.PROXY_CONFIGURATION_SERVICE).asControllerService(ProxyConfigurationService.class);
                return configurationService.getConfiguration();
            }
            return org.apache.nifi.proxy.ProxyConfiguration.DIRECT_CONFIGURATION;
        })).getProxyType())) {
            ProxyConfiguration.Builder proxyConfigBuilder = ProxyConfiguration.builder().endpoint(URI.create(String.format("http://%s:%s", proxyConfig.getProxyServerHost(), proxyConfig.getProxyServerPort())));
            if (proxyConfig.hasCredential()) {
                proxyConfigBuilder.username(proxyConfig.getProxyUserName());
                proxyConfigBuilder.password(proxyConfig.getProxyUserPassword());
            }
            builder.proxyConfiguration((ProxyConfiguration)proxyConfigBuilder.build());
        }
        return builder.build();
    }
}

