/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.v2;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.aws.v2.AwsClientDetails;
import org.apache.nifi.processors.aws.v2.AwsClientProvider;
import software.amazon.awssdk.core.SdkClient;

public class AwsClientCache<T extends SdkClient> {
    private final Cache<AwsClientDetails, T> clientCache = Caffeine.newBuilder().build();

    public T getOrCreateClient(ProcessContext context, AwsClientDetails clientDetails, AwsClientProvider<T> provider) {
        return (T)((SdkClient)this.clientCache.get((Object)clientDetails, ignored -> provider.createClient(context)));
    }

    public void clearCache() {
        this.clientCache.invalidateAll();
        this.clientCache.cleanUp();
    }
}

