/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.sns;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.sns.AmazonSNSClient;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.AbstractAWSCredentialsProviderProcessor;

public abstract class AbstractSNSProcessor
extends AbstractAWSCredentialsProviderProcessor<AmazonSNSClient> {
    protected static final AllowableValue ARN_TYPE_TOPIC = new AllowableValue("Topic ARN", "Topic ARN", "The ARN is the name of a topic");
    protected static final AllowableValue ARN_TYPE_TARGET = new AllowableValue("Target ARN", "Target ARN", "The ARN is the name of a particular Target, used to notify a specific subscriber");
    public static final PropertyDescriptor ARN = new PropertyDescriptor.Builder().name("Amazon Resource Name (ARN)").description("The name of the resource to which notifications should be published").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor ARN_TYPE = new PropertyDescriptor.Builder().name("ARN Type").description("The type of Amazon Resource Name that is being used.").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(true).allowableValues(new AllowableValue[]{ARN_TYPE_TOPIC, ARN_TYPE_TARGET}).defaultValue(ARN_TYPE_TOPIC.getValue()).build();

    @Override
    protected AmazonSNSClient createClient(ProcessContext context, AWSCredentialsProvider credentialsProvider, ClientConfiguration config) {
        this.getLogger().info("Creating client using aws credentials provider");
        return new AmazonSNSClient(credentialsProvider, config);
    }

    @Override
    protected AmazonSNSClient createClient(ProcessContext context, AWSCredentials credentials, ClientConfiguration config) {
        this.getLogger().info("Creating client using aws credentials");
        return new AmazonSNSClient(credentials, config);
    }
}

