/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.S3ClientOptions;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CanonicalGrantee;
import com.amazonaws.services.s3.model.EmailAddressGrantee;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.AbstractAWSCredentialsProviderProcessor;
import org.apache.nifi.processors.aws.s3.AmazonS3EncryptionService;

public abstract class AbstractS3Processor
extends AbstractAWSCredentialsProviderProcessor<AmazonS3Client> {
    public static final PropertyDescriptor FULL_CONTROL_USER_LIST = new PropertyDescriptor.Builder().name("FullControl User List").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).description("A comma-separated list of Amazon User ID's or E-mail addresses that specifies who should have Full Control for an object").defaultValue("${s3.permissions.full.users}").build();
    public static final PropertyDescriptor READ_USER_LIST = new PropertyDescriptor.Builder().name("Read Permission User List").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).description("A comma-separated list of Amazon User ID's or E-mail addresses that specifies who should have Read Access for an object").defaultValue("${s3.permissions.read.users}").build();
    public static final PropertyDescriptor WRITE_USER_LIST = new PropertyDescriptor.Builder().name("Write Permission User List").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).description("A comma-separated list of Amazon User ID's or E-mail addresses that specifies who should have Write Access for an object").defaultValue("${s3.permissions.write.users}").build();
    public static final PropertyDescriptor READ_ACL_LIST = new PropertyDescriptor.Builder().name("Read ACL User List").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).description("A comma-separated list of Amazon User ID's or E-mail addresses that specifies who should have permissions to read the Access Control List for an object").defaultValue("${s3.permissions.readacl.users}").build();
    public static final PropertyDescriptor WRITE_ACL_LIST = new PropertyDescriptor.Builder().name("Write ACL User List").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).description("A comma-separated list of Amazon User ID's or E-mail addresses that specifies who should have permissions to change the Access Control List for an object").defaultValue("${s3.permissions.writeacl.users}").build();
    public static final PropertyDescriptor CANNED_ACL = new PropertyDescriptor.Builder().name("canned-acl").displayName("Canned ACL").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).description("Amazon Canned ACL for an object, one of: BucketOwnerFullControl, BucketOwnerRead, LogDeliveryWrite, AuthenticatedRead, PublicReadWrite, PublicRead, Private; will be ignored if any other ACL/permission/owner property is specified").defaultValue("${s3.permissions.cannedacl}").build();
    public static final PropertyDescriptor OWNER = new PropertyDescriptor.Builder().name("Owner").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).description("The Amazon ID to use for the object's owner").defaultValue("${s3.owner}").build();
    public static final PropertyDescriptor BUCKET = new PropertyDescriptor.Builder().name("Bucket").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor KEY = new PropertyDescriptor.Builder().name("Object Key").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue("${filename}").build();
    public static final PropertyDescriptor SIGNER_OVERRIDE = new PropertyDescriptor.Builder().name("Signer Override").description("The AWS libraries use the default signer but this property allows you to specify a custom signer to support older S3-compatible services.").required(false).allowableValues(new AllowableValue[]{new AllowableValue("Default Signature", "Default Signature"), new AllowableValue("AWSS3V4SignerType", "Signature v4"), new AllowableValue("S3SignerType", "Signature v2")}).defaultValue("Default Signature").build();
    public static final PropertyDescriptor ENCRYPTION_SERVICE = new PropertyDescriptor.Builder().name("encryption-service").displayName("Encryption Service").description("Specifies the Encryption Service Controller used to configure requests. PutS3Object: For backward compatibility, this value is ignored when 'Server Side Encryption' is set. FetchS3Object: Only needs to be configured in case of Server-side Customer Key, Client-side KMS and Client-side Customer Key encryptions.").required(false).identifiesControllerService(AmazonS3EncryptionService.class).build();
    public static final PropertyDescriptor USE_CHUNKED_ENCODING = new PropertyDescriptor.Builder().name("use-chunked-encoding").displayName("Use Chunked Encoding").description("Enables / disables chunked encoding for upload requests. Set it to false only if your endpoint does not support chunked uploading.").allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    public static final PropertyDescriptor USE_PATH_STYLE_ACCESS = new PropertyDescriptor.Builder().name("use-path-style-access").displayName("Use Path Style Access").description("Path-style access can be enforced by setting this property to true. Set it to true if your endpoint does not support virtual-hosted-style requests, only path-style requests.").allowableValues(new String[]{"true", "false"}).defaultValue("false").build();

    @Override
    protected AmazonS3Client createClient(ProcessContext context, AWSCredentialsProvider credentialsProvider, ClientConfiguration config) {
        this.getLogger().info("Creating client with credentials provider");
        this.initializeSignerOverride(context, config);
        AmazonS3EncryptionService encryptionService = (AmazonS3EncryptionService)context.getProperty(ENCRYPTION_SERVICE).asControllerService(AmazonS3EncryptionService.class);
        AmazonS3Client s3 = null;
        if (encryptionService != null) {
            s3 = encryptionService.createEncryptionClient(credentialsProvider, config);
        }
        if (s3 == null) {
            s3 = new AmazonS3Client(credentialsProvider, config);
        }
        this.configureClientOptions(context, s3);
        return s3;
    }

    private void configureClientOptions(ProcessContext context, AmazonS3Client s3) {
        Boolean usePathStyleAccess;
        S3ClientOptions.Builder builder = S3ClientOptions.builder();
        Boolean useChunkedEncoding = context.getProperty(USE_CHUNKED_ENCODING).asBoolean();
        if (useChunkedEncoding != null && !useChunkedEncoding.booleanValue()) {
            builder.disableChunkedEncoding();
        }
        if ((usePathStyleAccess = context.getProperty(USE_PATH_STYLE_ACCESS).asBoolean()) != null && usePathStyleAccess.booleanValue()) {
            builder.setPathStyleAccess(true);
        }
        if (!StringUtils.trimToEmpty((String)context.getProperty(ENDPOINT_OVERRIDE).evaluateAttributeExpressions().getValue()).isEmpty()) {
            builder.setPathStyleAccess(true);
        }
        s3.setS3ClientOptions(builder.build());
    }

    private void initializeSignerOverride(ProcessContext context, ClientConfiguration config) {
        String signer = context.getProperty(SIGNER_OVERRIDE).getValue();
        if (signer != null && !signer.equals(SIGNER_OVERRIDE.getDefaultValue())) {
            config.setSignerOverride(signer);
        }
    }

    @Override
    protected AmazonS3Client createClient(ProcessContext context, AWSCredentials credentials, ClientConfiguration config) {
        this.getLogger().info("Creating client with AWS credentials");
        return this.createClient(context, (AWSCredentialsProvider)new AWSStaticCredentialsProvider(credentials), config);
    }

    protected Grantee createGrantee(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        if (value.contains("@")) {
            return new EmailAddressGrantee(value);
        }
        return new CanonicalGrantee(value);
    }

    protected final List<Grantee> createGrantees(String value) {
        String[] vals;
        if (StringUtils.isEmpty((CharSequence)value)) {
            return Collections.emptyList();
        }
        ArrayList<Grantee> grantees = new ArrayList<Grantee>();
        for (String val : vals = value.split(",")) {
            String identifier = val.trim();
            Grantee grantee = this.createGrantee(identifier);
            if (grantee == null) continue;
            grantees.add(grantee);
        }
        return grantees;
    }

    protected String getUrlForObject(String bucket, String key) {
        Region region = this.getRegion();
        if (region == null) {
            return DEFAULT_PROTOCOL.toString() + "://s3.amazonaws.com/" + bucket + "/" + key;
        }
        String endpoint = region.getServiceEndpoint("s3");
        return DEFAULT_PROTOCOL.toString() + "://" + endpoint + "/" + bucket + "/" + key;
    }

    protected final AccessControlList createACL(ProcessContext context, FlowFile flowFile) {
        AccessControlList acl = null;
        String ownerId = context.getProperty(OWNER).evaluateAttributeExpressions(flowFile).getValue();
        if (!StringUtils.isEmpty((CharSequence)ownerId)) {
            Owner owner = new Owner();
            owner.setId(ownerId);
            if (acl == null) {
                acl = new AccessControlList();
            }
            acl.setOwner(owner);
        }
        for (Grantee grantee : this.createGrantees(context.getProperty(FULL_CONTROL_USER_LIST).evaluateAttributeExpressions(flowFile).getValue())) {
            if (acl == null) {
                acl = new AccessControlList();
            }
            acl.grantPermission(grantee, Permission.FullControl);
        }
        for (Grantee grantee : this.createGrantees(context.getProperty(READ_USER_LIST).evaluateAttributeExpressions(flowFile).getValue())) {
            if (acl == null) {
                acl = new AccessControlList();
            }
            acl.grantPermission(grantee, Permission.Read);
        }
        for (Grantee grantee : this.createGrantees(context.getProperty(WRITE_USER_LIST).evaluateAttributeExpressions(flowFile).getValue())) {
            if (acl == null) {
                acl = new AccessControlList();
            }
            acl.grantPermission(grantee, Permission.Write);
        }
        for (Grantee grantee : this.createGrantees(context.getProperty(READ_ACL_LIST).evaluateAttributeExpressions(flowFile).getValue())) {
            if (acl == null) {
                acl = new AccessControlList();
            }
            acl.grantPermission(grantee, Permission.ReadAcp);
        }
        for (Grantee grantee : this.createGrantees(context.getProperty(WRITE_ACL_LIST).evaluateAttributeExpressions(flowFile).getValue())) {
            if (acl == null) {
                acl = new AccessControlList();
            }
            acl.grantPermission(grantee, Permission.WriteAcp);
        }
        return acl;
    }

    protected FlowFile extractExceptionDetails(Exception e, ProcessSession session, FlowFile flowFile) {
        flowFile = session.putAttribute(flowFile, "s3.exception", e.getClass().getName());
        if (e instanceof AmazonS3Exception) {
            flowFile = this.putAttribute(session, flowFile, "s3.additionalDetails", ((AmazonS3Exception)e).getAdditionalDetails());
        }
        if (e instanceof AmazonServiceException) {
            AmazonServiceException ase = (AmazonServiceException)e;
            flowFile = this.putAttribute(session, flowFile, "s3.statusCode", ase.getStatusCode());
            flowFile = this.putAttribute(session, flowFile, "s3.errorCode", ase.getErrorCode());
            flowFile = this.putAttribute(session, flowFile, "s3.errorMessage", ase.getErrorMessage());
        }
        return flowFile;
    }

    private FlowFile putAttribute(ProcessSession session, FlowFile flowFile, String key, Object value) {
        return value == null ? flowFile : session.putAttribute(flowFile, key, value.toString());
    }

    protected final CannedAccessControlList createCannedACL(ProcessContext context, FlowFile flowFile) {
        CannedAccessControlList cannedAcl = null;
        String cannedAclString = context.getProperty(CANNED_ACL).evaluateAttributeExpressions(flowFile).getValue();
        if (!StringUtils.isEmpty((CharSequence)cannedAclString)) {
            cannedAcl = CannedAccessControlList.valueOf((String)cannedAclString);
        }
        return cannedAcl;
    }
}

