/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.avro;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processor.util.StandardValidators;

@SideEffectFree
@SupportsBatching
@Tags(value={"avro", "convert", "json"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Converts a Binary Avro record into a JSON object. This processor provides a direct mapping of an Avro field to a JSON field, such that the resulting JSON will have the same hierarchical structure as the Avro document. Note that the Avro schema information will be lost, as this is not a translation from binary Avro to JSON formatted Avro. The output JSON is encoded the UTF-8 encoding. If an incoming FlowFile contains a stream of multiple Avro records, the resultant FlowFile will contain a JSON Array containing all of the Avro records or a sequence of JSON Objects.  If an incoming FlowFile does not contain any records, an empty JSON object is the output. Empty/Single Avro record FlowFile inputs are optionally wrapped in a container as dictated by 'Wrap Single Record'")
@WritesAttribute(attribute="mime.type", description="Sets the mime type to application/json")
public class ConvertAvroToJSON
extends AbstractProcessor {
    protected static final String CONTAINER_ARRAY = "array";
    protected static final String CONTAINER_NONE = "none";
    private static final byte[] EMPTY_JSON_OBJECT = "{}".getBytes(StandardCharsets.UTF_8);
    static final PropertyDescriptor CONTAINER_OPTIONS = new PropertyDescriptor.Builder().name("JSON container options").description("Determines how stream of records is exposed: either as a sequence of single Objects (none) (i.e. writing every Object to a new line), or as an array of Objects (array).").allowableValues(new String[]{"none", "array"}).required(true).defaultValue("array").build();
    static final PropertyDescriptor WRAP_SINGLE_RECORD = new PropertyDescriptor.Builder().name("Wrap Single Record").description("Determines if the resulting output for empty records or a single record should be wrapped in a container array as specified by '" + CONTAINER_OPTIONS.getName() + "'").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    static final PropertyDescriptor SCHEMA = new PropertyDescriptor.Builder().name("Avro schema").description("If the Avro records do not contain the schema (datum only), it must be specified here.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("A FlowFile is routed to this relationship after it has been converted to JSON").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile is routed to this relationship if it cannot be parsed as Avro or cannot be converted to JSON for any reason").build();
    private List<PropertyDescriptor> properties;
    private volatile Schema schema = null;

    protected void init(ProcessorInitializationContext context) {
        super.init(context);
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(CONTAINER_OPTIONS);
        properties.add(WRAP_SINGLE_RECORD);
        properties.add(SCHEMA);
        this.properties = Collections.unmodifiableList(properties);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public Set<Relationship> getRelationships() {
        HashSet<Relationship> rels = new HashSet<Relationship>();
        rels.add(REL_SUCCESS);
        rels.add(REL_FAILURE);
        return rels;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String containerOption = context.getProperty(CONTAINER_OPTIONS).getValue();
        final boolean useContainer = containerOption.equals(CONTAINER_ARRAY);
        final boolean wrapSingleRecord = context.getProperty(WRAP_SINGLE_RECORD).asBoolean() != false && useContainer;
        final String stringSchema = context.getProperty(SCHEMA).getValue();
        final boolean schemaLess = stringSchema != null;
        try {
            flowFile = session.write(flowFile, new StreamCallback(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void process(InputStream rawIn, OutputStream rawOut) throws IOException {
                    GenericData genericData = GenericData.get();
                    if (schemaLess) {
                        if (ConvertAvroToJSON.this.schema == null) {
                            ConvertAvroToJSON.this.schema = new Schema.Parser().parse(stringSchema);
                        }
                        try (BufferedInputStream in = new BufferedInputStream(rawIn);
                             BufferedOutputStream out = new BufferedOutputStream(rawOut);){
                            GenericDatumReader reader = new GenericDatumReader(ConvertAvroToJSON.this.schema);
                            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)in, null);
                            GenericRecord record = (GenericRecord)reader.read(null, (Decoder)decoder);
                            if (useContainer && wrapSingleRecord) {
                                ((OutputStream)out).write(91);
                            }
                            byte[] outputBytes = record == null ? EMPTY_JSON_OBJECT : genericData.toString((Object)record).getBytes(StandardCharsets.UTF_8);
                            ((OutputStream)out).write(outputBytes);
                            if (!useContainer || !wrapSingleRecord) return;
                            ((OutputStream)out).write(93);
                            return;
                        }
                    }
                    try (BufferedInputStream in = new BufferedInputStream(rawIn);
                         BufferedOutputStream out = new BufferedOutputStream(rawOut);
                         DataFileStream reader = new DataFileStream((InputStream)in, (DatumReader)new GenericDatumReader());){
                        int recordCount = 0;
                        GenericRecord currRecord = null;
                        if (reader.hasNext()) {
                            currRecord = (GenericRecord)reader.next();
                            ++recordCount;
                        }
                        if (reader.hasNext() && useContainer || wrapSingleRecord) {
                            ((OutputStream)out).write(91);
                        }
                        byte[] outputBytes = currRecord == null ? EMPTY_JSON_OBJECT : genericData.toString((Object)currRecord).getBytes(StandardCharsets.UTF_8);
                        ((OutputStream)out).write(outputBytes);
                        while (reader.hasNext()) {
                            if (useContainer) {
                                ((OutputStream)out).write(44);
                            } else {
                                ((OutputStream)out).write(10);
                            }
                            currRecord = (GenericRecord)reader.next((Object)currRecord);
                            ((OutputStream)out).write(genericData.toString((Object)currRecord).getBytes(StandardCharsets.UTF_8));
                            ++recordCount;
                        }
                        if ((recordCount <= 1 || !useContainer) && !wrapSingleRecord) return;
                        ((OutputStream)out).write(93);
                        return;
                    }
                }
            });
        }
        catch (ProcessException pe) {
            this.getLogger().error("Failed to convert {} from Avro to JSON due to {}; transferring to failure", new Object[]{flowFile, pe});
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        flowFile = session.putAttribute(flowFile, CoreAttributes.MIME_TYPE.key(), "application/json");
        session.transfer(flowFile, REL_SUCCESS);
    }
}

