/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.asana;

import com.asana.Client;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.asana.AsanaClient;
import org.apache.nifi.controller.asana.AsanaClientProviderService;
import org.apache.nifi.controller.asana.StandardAsanaClient;
import org.apache.nifi.processor.util.StandardValidators;

@CapabilityDescription(value="Common service to authenticate with Asana, and to work on a specified workspace.")
@Tags(value={"asana", "service", "authentication"})
public class StandardAsanaClientProviderService
extends AbstractControllerService
implements AsanaClientProviderService {
    protected static final String ASANA_API_URL = "asana-api-url";
    protected static final String ASANA_PERSONAL_ACCESS_TOKEN = "asana-personal-access-token";
    protected static final String ASANA_WORKSPACE_NAME = "asana-workspace-name";
    protected static final PropertyDescriptor PROP_ASANA_API_BASE_URL = new PropertyDescriptor.Builder().name("asana-api-url").displayName("API URL").description("Base URL of Asana API. Leave it as default, unless you have your own Asana instance serving on a different URL. (typical for on-premise installations)").required(true).defaultValue(Client.DEFAULTS.get("base_url").toString()).addValidator(StandardValidators.URL_VALIDATOR).build();
    protected static final PropertyDescriptor PROP_ASANA_PERSONAL_ACCESS_TOKEN = new PropertyDescriptor.Builder().name("asana-personal-access-token").displayName("Personal Access Token").description("Similarly to entering your username/password into a website, when you access your Asana data via the API you need to authenticate. Personal Access Token (PAT) is an authentication mechanism for accessing the API. You can generate a PAT from the Asana developer console. Refer to Asana Authentication Quick Start for detailed instructions on getting started.").required(true).sensitive(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    protected static final PropertyDescriptor PROP_ASANA_WORKSPACE_NAME = new PropertyDescriptor.Builder().name("asana-workspace-name").displayName("Workspace").description("Specify which Asana workspace to use. Case sensitive. A workspace is the highest-level organizational unit in Asana. All projects and tasks have an associated workspace. An organization is a special kind of workspace that represents a company. In an organization, you can group your projects into teams.").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    protected static final List<PropertyDescriptor> DESCRIPTORS = Collections.unmodifiableList(Arrays.asList(PROP_ASANA_API_BASE_URL, PROP_ASANA_PERSONAL_ACCESS_TOKEN, PROP_ASANA_WORKSPACE_NAME));
    private volatile String personalAccessToken;
    private volatile String workspaceName;
    private volatile String baseUrl;

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return DESCRIPTORS;
    }

    @OnEnabled
    public synchronized void onEnabled(ConfigurationContext context) {
        this.personalAccessToken = context.getProperty(PROP_ASANA_PERSONAL_ACCESS_TOKEN).getValue();
        this.workspaceName = context.getProperty(PROP_ASANA_WORKSPACE_NAME).getValue();
        this.baseUrl = context.getProperty(PROP_ASANA_API_BASE_URL).getValue();
    }

    public synchronized AsanaClient createClient() {
        return new StandardAsanaClient(this.personalAccessToken, this.workspaceName, this.baseUrl);
    }
}

