/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.asana;

import com.asana.Client;
import com.asana.errors.InvalidTokenError;
import com.asana.models.Attachment;
import com.asana.models.Project;
import com.asana.models.ProjectMembership;
import com.asana.models.ProjectStatus;
import com.asana.models.Resource;
import com.asana.models.ResultBodyCollection;
import com.asana.models.Section;
import com.asana.models.Story;
import com.asana.models.Tag;
import com.asana.models.Task;
import com.asana.models.Team;
import com.asana.models.User;
import com.asana.models.Workspace;
import com.asana.requests.CollectionRequest;
import com.asana.requests.EventsRequest;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.nifi.controller.asana.AsanaClient;
import org.apache.nifi.controller.asana.AsanaClientException;
import org.apache.nifi.controller.asana.AsanaEventsCollection;

public class StandardAsanaClient
implements AsanaClient {
    static final String ASANA_CLIENT_OPTION_BASE_URL = "base_url";
    private final Client client;
    private final Workspace workspace;

    public StandardAsanaClient(String personalAccessToken, String workspaceName, String baseUrl) {
        this.client = Client.accessToken((String)personalAccessToken);
        if (baseUrl != null) {
            this.client.options.put(ASANA_CLIENT_OPTION_BASE_URL, baseUrl);
        }
        this.workspace = this.getWorkspaceByName(workspaceName);
    }

    public Project getProjectByName(String projectName) {
        return this.getProjects().filter(p -> p.name.equals(projectName)).findFirst().orElseThrow(() -> new AsanaClientException("No such project: " + projectName));
    }

    public Stream<Project> getProjects() {
        try {
            return StandardAsanaClient.collectionRequestToStream(this.client.projects.getProjects(null, null, this.workspace.gid, null, null, this.getSerializedFieldNames(Project.class), Boolean.valueOf(false)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Stream<User> getUsers() {
        try {
            return StandardAsanaClient.collectionRequestToStream(this.client.users.getUsersForWorkspace(this.workspace.gid, null, this.getSerializedFieldNames(User.class), Boolean.valueOf(false)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Stream<ProjectMembership> getProjectMemberships(Project project) {
        try {
            return StandardAsanaClient.collectionRequestToStream(this.client.projectMemberships.getProjectMembershipsForProject(project.gid, null, null, null, this.getSerializedFieldNames(ProjectMembership.class), Boolean.valueOf(false)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Team getTeamByName(String teamName) {
        return this.getTeams().filter(t -> t.name.equals(teamName)).findFirst().orElseThrow(() -> new AsanaClientException("No such team: " + teamName));
    }

    public Stream<Team> getTeams() {
        try {
            return StandardAsanaClient.collectionRequestToStream(this.client.teams.getTeamsForWorkspace(this.workspace.gid, null, null, this.getSerializedFieldNames(Team.class), Boolean.valueOf(false)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Stream<User> getTeamMembers(Team team) {
        try {
            return StandardAsanaClient.collectionRequestToStream(this.client.users.getUsersForTeam(team.gid, null, this.getSerializedFieldNames(User.class), Boolean.valueOf(false)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Section getSectionByName(Project project, String sectionName) {
        return this.getSections(project).filter(s -> s.name.equals(sectionName)).findFirst().orElseThrow(() -> new AsanaClientException("No such section: " + sectionName + " in project: " + project.name));
    }

    public Stream<Section> getSections(Project project) {
        try {
            return StandardAsanaClient.collectionRequestToStream(this.client.sections.getSectionsForProject(project.gid, null, null, this.getSerializedFieldNames(Section.class), Boolean.valueOf(false)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Stream<Task> getTasks(Project project) {
        try {
            return StandardAsanaClient.collectionRequestToStream(this.client.tasks.getTasksForProject(project.gid, null, null, null, this.getSerializedFieldNames(Task.class), Boolean.valueOf(false)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Stream<Task> getTasks(Tag tag) {
        try {
            return StandardAsanaClient.collectionRequestToStream(this.client.tasks.getTasksForTag(tag.gid, null, null, this.getSerializedFieldNames(Task.class), Boolean.valueOf(false)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Stream<Task> getTasks(Section section) {
        try {
            return StandardAsanaClient.collectionRequestToStream(this.client.tasks.getTasksForSection(section.gid, null, null, this.getSerializedFieldNames(Task.class), Boolean.valueOf(false)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Stream<Tag> getTags() {
        try {
            return StandardAsanaClient.collectionRequestToStream(this.client.tags.getTags(this.workspace.gid, null, null, this.getSerializedFieldNames(Tag.class), Boolean.valueOf(false)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Stream<ProjectStatus> getProjectStatusUpdates(Project project) {
        try {
            return StandardAsanaClient.collectionRequestToStream(this.client.projectStatuses.getProjectStatusesForProject(project.gid, null, null, this.getSerializedFieldNames(ProjectStatus.class), Boolean.valueOf(false)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Stream<Story> getStories(Task task) {
        try {
            return StandardAsanaClient.collectionRequestToStream(this.client.stories.getStoriesForTask(task.gid, null, null, this.getSerializedFieldNames(Story.class), Boolean.valueOf(false)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Stream<Attachment> getAttachments(Task task) {
        try {
            return StandardAsanaClient.collectionRequestToStream(this.client.attachments.getAttachmentsForObject(task.gid, null, null, this.getSerializedFieldNames(Attachment.class), Boolean.valueOf(false)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Stream<Attachment> getAttachments(ProjectStatus projectStatus) {
        try {
            return StandardAsanaClient.collectionRequestToStream(this.client.attachments.getAttachmentsForObject(projectStatus.gid, null, null, this.getSerializedFieldNames(Attachment.class), Boolean.valueOf(false)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Workspace getWorkspaceByName(String workspaceName) {
        List results;
        try {
            results = StandardAsanaClient.collectionRequestToStream(this.client.workspaces.getWorkspaces(null, null, this.getSerializedFieldNames(Workspace.class), Boolean.valueOf(false))).filter(w -> w.name.equals(workspaceName)).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (results.isEmpty()) {
            throw new AsanaClientException("No such workspace: " + workspaceName);
        }
        if (results.size() > 1) {
            throw new AsanaClientException("Multiple workspaces match: " + workspaceName);
        }
        return (Workspace)results.get(0);
    }

    public AsanaEventsCollection getEvents(Project project, String syncToken) {
        try {
            String resultSyncToken;
            List resultEvents = new ArrayList();
            try {
                EventsRequest request = this.client.events.get(project.gid, syncToken);
                ResultBodyCollection result = request.executeRaw();
                resultSyncToken = result.sync;
                resultEvents = result.data;
            }
            catch (InvalidTokenError e) {
                resultSyncToken = e.sync;
            }
            return new AsanaEventsCollection(resultSyncToken, resultEvents);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private <T> List<String> getSerializedFieldNames(Class<T> cls) {
        ArrayList<String> result = new ArrayList<String>();
        for (Field field : cls.getFields()) {
            SerializedName serializedName = field.getAnnotation(SerializedName.class);
            if (serializedName != null) {
                result.add(serializedName.value());
                continue;
            }
            result.add(field.getName());
        }
        return result;
    }

    private static <T extends Resource> Stream<T> collectionRequestToStream(CollectionRequest<T> asanaCollectionRequest) {
        return StreamSupport.stream(asanaCollectionRequest.spliterator(), false);
    }
}

