/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.asana.utils;

import java.util.Optional;
import org.apache.nifi.processors.asana.utils.AsanaObjectState;

public class AsanaObject {
    private final AsanaObjectState state;
    private final String gid;
    private final String content;
    private final String fingerprint;

    public AsanaObject(AsanaObjectState state, String gid) {
        this(state, gid, "");
    }

    public AsanaObject(AsanaObjectState state, String gid, String content) {
        this(state, gid, content, null);
    }

    public AsanaObject(AsanaObjectState state, String gid, String content, String fingerprint) {
        this.state = state;
        this.gid = gid;
        this.content = content;
        this.fingerprint = fingerprint;
    }

    public AsanaObjectState getState() {
        return this.state;
    }

    public String getGid() {
        return this.gid;
    }

    public String getContent() {
        return this.content;
    }

    public String getFingerprint() {
        return Optional.ofNullable(this.fingerprint).orElse(this.content);
    }

    public boolean equals(Object o) {
        if (o instanceof AsanaObject) {
            AsanaObject other = (AsanaObject)o;
            return this.state.equals((Object)other.state) && Optional.ofNullable(this.gid).equals(Optional.ofNullable(other.gid)) && Optional.ofNullable(this.content).equals(Optional.ofNullable(other.content)) && Optional.ofNullable(this.fingerprint).equals(Optional.ofNullable(other.fingerprint));
        }
        return false;
    }
}

