/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.asana.utils;

import com.asana.models.Team;
import com.asana.models.User;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.nifi.controller.asana.AsanaClient;
import org.apache.nifi.processors.asana.utils.AsanaObjectFetcherException;
import org.apache.nifi.processors.asana.utils.GenericAsanaObjectFetcher;

public class AsanaTeamMemberFetcher
extends GenericAsanaObjectFetcher<User> {
    private static final String TEAM_GID = ".team.gid";
    private final AsanaClient client;
    private final Team team;

    public AsanaTeamMemberFetcher(AsanaClient client, String teamName) {
        this.client = client;
        this.team = client.getTeamByName(teamName);
    }

    @Override
    public Map<String, String> saveState() {
        HashMap<String, String> state = new HashMap<String, String>(super.saveState());
        state.put(this.getClass().getName() + TEAM_GID, this.team.gid);
        return state;
    }

    @Override
    public void loadState(Map<String, String> state) {
        if (!this.team.gid.equals(state.get(this.getClass().getName() + TEAM_GID))) {
            throw new AsanaObjectFetcherException("Team gid does not match.");
        }
        super.loadState(state);
    }

    @Override
    protected Stream<User> fetchObjects() {
        return this.client.getTeamMembers(this.team);
    }
}

