/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.amqp.processors;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.GetResponse;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import org.apache.nifi.amqp.processors.AMQPException;
import org.apache.nifi.amqp.processors.AMQPWorker;
import org.apache.nifi.logging.ComponentLog;

final class AMQPConsumer
extends AMQPWorker {
    private final String queueName;
    private final BlockingQueue<GetResponse> responseQueue;
    private final boolean autoAcknowledge;
    private final Consumer consumer;

    AMQPConsumer(Connection connection, String queueName, boolean autoAcknowledge, int prefetchCount, final ComponentLog processorLog) throws IOException {
        super(connection, processorLog);
        this.validateStringProperty("queueName", queueName);
        this.queueName = queueName;
        this.autoAcknowledge = autoAcknowledge;
        this.responseQueue = new LinkedBlockingQueue<GetResponse>(10);
        processorLog.info("Successfully connected AMQPConsumer to " + connection.toString() + " and '" + queueName + "' queue");
        Channel channel = this.getChannel();
        this.consumer = new DefaultConsumer(channel){

            public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                if (AMQPConsumer.this.closed) {
                    processorLog.info("Consumer is closed, discarding message (delivery tag: {}).", new Object[]{envelope.getDeliveryTag()});
                    return;
                }
                try {
                    AMQPConsumer.this.responseQueue.put(new GetResponse(envelope, properties, body, Integer.MAX_VALUE));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }

            public void handleCancel(String consumerTag) throws IOException {
                processorLog.error("Consumer has been cancelled by the broker, eg. due to deleted queue.");
                try {
                    AMQPConsumer.this.close();
                }
                catch (Exception e) {
                    processorLog.error("Failed to close consumer.", (Throwable)e);
                }
            }
        };
        channel.basicQos(prefetchCount);
        channel.basicConsume(queueName, autoAcknowledge, this.consumer);
    }

    int getResponseQueueSize() {
        return this.responseQueue.size();
    }

    public GetResponse consume() {
        return (GetResponse)this.responseQueue.poll();
    }

    public void acknowledge(GetResponse response) {
        if (this.autoAcknowledge) {
            return;
        }
        try {
            this.getChannel().basicAck(response.getEnvelope().getDeliveryTag(), true);
        }
        catch (Exception e) {
            throw new AMQPException("Failed to acknowledge message", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws TimeoutException, IOException {
        try {
            super.close();
        }
        catch (Throwable throwable) {
            try {
                GetResponse response;
                while ((response = (GetResponse)this.responseQueue.poll()) != null) {
                    this.processorLog.info("Consumer is closed, discarding message (delivery tag: {}).", new Object[]{response.getEnvelope().getDeliveryTag()});
                }
                throw throwable;
            }
            catch (Exception e) {
                this.processorLog.error("Failed to drain response queue.");
            }
            throw throwable;
        }
        try {
            GetResponse response;
            while ((response = (GetResponse)this.responseQueue.poll()) != null) {
                this.processorLog.info("Consumer is closed, discarding message (delivery tag: {}).", new Object[]{response.getEnvelope().getDeliveryTag()});
            }
            return;
        }
        catch (Exception e) {
            this.processorLog.error("Failed to drain response queue.");
            return;
        }
    }

    @Override
    public String toString() {
        return super.toString() + ", QUEUE:" + this.queueName;
    }
}

