/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.airtable.parse;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.airtable.parse.AirtableRecordSetFlowFileWriter;
import org.apache.nifi.processors.airtable.parse.AirtableRetrievePageResult;
import org.apache.nifi.processors.airtable.parse.AirtableRetrieveTableResult;
import org.apache.nifi.processors.airtable.service.AirtableGetRecordsParameters;
import org.apache.nifi.processors.airtable.service.AirtableRestService;

public class AirtableTableRetriever {
    static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    static final JsonFactory JSON_FACTORY = OBJECT_MAPPER.getFactory().configure(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT, false);
    final AirtableRestService airtableRestService;
    final AirtableGetRecordsParameters getRecordsParameters;
    final Integer maxRecordsPerFlowFile;

    public AirtableTableRetriever(AirtableRestService airtableRestService, AirtableGetRecordsParameters getRecordsParameters, Integer maxRecordsPerFlowFile) {
        this.airtableRestService = airtableRestService;
        this.getRecordsParameters = getRecordsParameters;
        this.maxRecordsPerFlowFile = maxRecordsPerFlowFile;
    }

    public AirtableRetrieveTableResult retrieveAll(ProcessSession session) throws IOException {
        int totalRecordCount = 0;
        ArrayList<FlowFile> flowFiles = new ArrayList<FlowFile>();
        AirtableRetrievePageResult retrievePageResult = null;
        do {
            retrievePageResult = this.retrieveNextPage(session, Optional.ofNullable(retrievePageResult));
            totalRecordCount += retrievePageResult.getParsedRecordCount();
            flowFiles.addAll(retrievePageResult.getFlowFiles());
        } while (retrievePageResult.getNextOffset().isPresent());
        retrievePageResult.getOngoingRecordSetFlowFileWriter().map(writer -> {
            try {
                return writer.closeRecordSet(session);
            }
            catch (IOException e) {
                throw new ProcessException("Failed to close Airtable record writer", (Throwable)e);
            }
        }).ifPresent(flowFiles::add);
        return new AirtableRetrieveTableResult(flowFiles, totalRecordCount);
    }

    private AirtableRetrievePageResult retrieveNextPage(ProcessSession session, Optional<AirtableRetrievePageResult> previousPageResult) {
        AirtableGetRecordsParameters parameters = previousPageResult.flatMap(AirtableRetrievePageResult::getNextOffset).map(this.getRecordsParameters::withOffset).orElse(this.getRecordsParameters);
        return this.airtableRestService.getRecords(parameters, inputStream -> this.parsePage((InputStream)inputStream, session, previousPageResult));
    }

    private AirtableRetrievePageResult parsePage(InputStream inputStream, ProcessSession session, Optional<AirtableRetrievePageResult> previousPageResult) {
        ArrayList<FlowFile> flowFiles = new ArrayList<FlowFile>();
        AirtableRecordSetFlowFileWriter flowFileWriter = previousPageResult.flatMap(AirtableRetrievePageResult::getOngoingRecordSetFlowFileWriter).orElse(null);
        int parsedRecordCount = 0;
        String nextOffset = null;
        try (JsonParser jsonParser = JSON_FACTORY.createParser(inputStream);){
            while (jsonParser.nextToken() != null) {
                if (jsonParser.currentToken() != JsonToken.FIELD_NAME) continue;
                switch (jsonParser.currentName()) {
                    case "records": {
                        jsonParser.nextToken();
                        if (jsonParser.currentToken() != JsonToken.START_ARRAY) break;
                        while (jsonParser.nextToken() != null && jsonParser.currentToken() != JsonToken.END_ARRAY) {
                            if (jsonParser.currentToken() != JsonToken.START_OBJECT) continue;
                            if (flowFileWriter == null) {
                                flowFileWriter = AirtableRecordSetFlowFileWriter.startRecordSet(session);
                            }
                            ++parsedRecordCount;
                            flowFileWriter.writeRecord(jsonParser);
                            if (this.maxRecordsPerFlowFile == null || this.maxRecordsPerFlowFile.intValue() != flowFileWriter.getRecordCount()) continue;
                            flowFiles.add(flowFileWriter.closeRecordSet(session));
                            flowFileWriter = null;
                        }
                        break;
                    }
                    case "offset": {
                        jsonParser.nextToken();
                        nextOffset = jsonParser.getValueAsString();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ProcessException("Failed to parse Airtable query table response page", (Throwable)e);
        }
        return new AirtableRetrievePageResult(Optional.ofNullable(nextOffset), flowFiles, parsedRecordCount, Optional.ofNullable(flowFileWriter));
    }
}

