/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.airtable.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Range;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.airtable.service.AirtableGetRecordsParameters;
import org.apache.nifi.processors.airtable.service.RateLimitExceededException;
import org.apache.nifi.web.client.api.HttpResponseEntity;
import org.apache.nifi.web.client.api.HttpUriBuilder;
import org.apache.nifi.web.client.provider.api.WebClientServiceProvider;

public class AirtableRestService {
    public static final String API_V0_BASE_URL = "https://api.airtable.com/v0";
    private static final int TOO_MANY_REQUESTS = 429;
    private static final Range<Integer> SUCCESSFUL_RESPONSE_RANGE = Range.between((Comparable)Integer.valueOf(200), (Comparable)Integer.valueOf(299));
    private final WebClientServiceProvider webClientServiceProvider;
    private final String apiUrl;
    private final String apiKey;
    private final String baseId;
    private final String tableId;

    public AirtableRestService(WebClientServiceProvider webClientServiceProvider, String apiUrl, String apiKey, String baseId, String tableId) {
        this.webClientServiceProvider = webClientServiceProvider;
        this.apiUrl = apiUrl;
        this.apiKey = apiKey;
        this.baseId = baseId;
        this.tableId = tableId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <R> R getRecords(AirtableGetRecordsParameters getRecordsParameters, Function<InputStream, R> callback) {
        URI uri = this.buildUri(getRecordsParameters);
        try (HttpResponseEntity response = this.webClientServiceProvider.getWebClientService().get().uri(uri).header("Authorization", "Bearer " + this.apiKey).retrieve();){
            InputStream bodyInputStream = response.body();
            if (SUCCESSFUL_RESPONSE_RANGE.contains((Object)response.statusCode())) {
                R r = callback.apply(bodyInputStream);
                return r;
            }
            if (response.statusCode() == 429) {
                throw new RateLimitExceededException();
            }
            StringBuilder exceptionMessageBuilder = new StringBuilder("Error response. Code: " + response.statusCode());
            String bodyText = IOUtils.toString((InputStream)bodyInputStream, (Charset)StandardCharsets.UTF_8);
            if (bodyText == null) throw new ProcessException(exceptionMessageBuilder.toString());
            exceptionMessageBuilder.append(" Body: ").append(bodyText);
            throw new ProcessException(exceptionMessageBuilder.toString());
        }
        catch (IOException e) {
            throw new ProcessException(String.format("Airtable HTTP request failed [%s]", uri), (Throwable)e);
        }
    }

    public HttpUriBuilder createUriBuilder() {
        URI uri = URI.create(this.apiUrl);
        HttpUriBuilder uriBuilder = this.webClientServiceProvider.getHttpUriBuilder().scheme(uri.getScheme()).host(uri.getHost()).encodedPath(uri.getPath()).addPathSegment(this.baseId).addPathSegment(this.tableId);
        if (uri.getPort() != -1) {
            uriBuilder.port(uri.getPort());
        }
        return uriBuilder;
    }

    private URI buildUri(AirtableGetRecordsParameters getRecordsParameters) {
        HttpUriBuilder uriBuilder = this.createUriBuilder();
        for (String field : getRecordsParameters.getFields()) {
            uriBuilder.addQueryParameter("fields[]", field);
        }
        ArrayList filters = new ArrayList();
        getRecordsParameters.getCustomFilter().ifPresent(filters::add);
        getRecordsParameters.getModifiedAfter().map(modifiedAfter -> {
            String isSameFormula = "IS_SAME(LAST_MODIFIED_TIME(),DATETIME_PARSE(\"" + modifiedAfter + "\"), 'second')";
            String isAfterFormula = "IS_AFTER(LAST_MODIFIED_TIME(),DATETIME_PARSE(\"" + modifiedAfter + "\"))";
            return "OR(" + isSameFormula + "," + isAfterFormula + ")";
        }).ifPresent(filters::add);
        getRecordsParameters.getModifiedBefore().map(modifiedBefore -> "IS_BEFORE(LAST_MODIFIED_TIME(),DATETIME_PARSE(\"" + modifiedBefore + "\"))").ifPresent(filters::add);
        if (!filters.isEmpty()) {
            uriBuilder.addQueryParameter("filterByFormula", "AND(" + String.join((CharSequence)",", filters) + ")");
        }
        getRecordsParameters.getOffset().ifPresent(offset -> uriBuilder.addQueryParameter("offset", offset));
        getRecordsParameters.getPageSize().ifPresent(pageSize -> uriBuilder.addQueryParameter("pageSize", String.valueOf(pageSize)));
        return uriBuilder.build();
    }
}

