/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.admin.service.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.admin.dao.DataAccessException;
import org.apache.nifi.admin.service.AdministrationException;
import org.apache.nifi.admin.service.IdpUserGroupService;
import org.apache.nifi.admin.service.action.CreateIdpUserGroup;
import org.apache.nifi.admin.service.action.CreateIdpUserGroups;
import org.apache.nifi.admin.service.action.DeleteIdpUserGroupsByIdentity;
import org.apache.nifi.admin.service.action.GetIdpUserGroupsByIdentity;
import org.apache.nifi.admin.service.transaction.Transaction;
import org.apache.nifi.admin.service.transaction.TransactionBuilder;
import org.apache.nifi.admin.service.transaction.TransactionException;
import org.apache.nifi.idp.IdpType;
import org.apache.nifi.idp.IdpUserGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardIdpUserGroupService
implements IdpUserGroupService {
    private static Logger LOGGER = LoggerFactory.getLogger(StandardIdpUserGroupService.class);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private TransactionBuilder transactionBuilder;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IdpUserGroup createUserGroup(IdpUserGroup userGroup) {
        IdpUserGroup createdUserGroup;
        Transaction transaction = null;
        this.writeLock.lock();
        try {
            if (userGroup.getCreated() == null) {
                userGroup.setCreated(new Date());
            }
            transaction = this.transactionBuilder.start();
            CreateIdpUserGroup action = new CreateIdpUserGroup(userGroup);
            createdUserGroup = transaction.execute(action);
            transaction.commit();
        }
        catch (DataAccessException | TransactionException te) {
            try {
                this.rollback(transaction);
                throw new AdministrationException(te);
                catch (Throwable t) {
                    this.rollback(transaction);
                    throw t;
                }
            }
            catch (Throwable throwable) {
                this.closeQuietly(transaction);
                this.writeLock.unlock();
                throw throwable;
            }
        }
        this.closeQuietly(transaction);
        this.writeLock.unlock();
        return createdUserGroup;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<IdpUserGroup> createUserGroups(List<IdpUserGroup> userGroups) {
        List<IdpUserGroup> createdUserGroups;
        Transaction transaction = null;
        this.writeLock.lock();
        try {
            for (IdpUserGroup userGroup : userGroups) {
                if (userGroup.getCreated() != null) continue;
                userGroup.setCreated(new Date());
            }
            transaction = this.transactionBuilder.start();
            CreateIdpUserGroups action = new CreateIdpUserGroups(userGroups);
            createdUserGroups = transaction.execute(action);
            transaction.commit();
        }
        catch (DataAccessException | TransactionException te) {
            try {
                this.rollback(transaction);
                throw new AdministrationException(te);
                catch (Throwable t) {
                    this.rollback(transaction);
                    throw t;
                }
            }
            catch (Throwable throwable) {
                this.closeQuietly(transaction);
                this.writeLock.unlock();
                throw throwable;
            }
        }
        this.closeQuietly(transaction);
        this.writeLock.unlock();
        return createdUserGroups;
    }

    @Override
    public List<IdpUserGroup> getUserGroups(String identity) {
        List<IdpUserGroup> userGroups;
        Transaction transaction = null;
        this.readLock.lock();
        try {
            transaction = this.transactionBuilder.start();
            GetIdpUserGroupsByIdentity action = new GetIdpUserGroupsByIdentity(identity);
            userGroups = transaction.execute(action);
            transaction.commit();
        }
        catch (DataAccessException | TransactionException te) {
            this.rollback(transaction);
            throw new AdministrationException(te);
        }
        catch (Throwable t) {
            this.rollback(transaction);
            throw t;
        }
        finally {
            this.closeQuietly(transaction);
            this.readLock.unlock();
        }
        return userGroups;
    }

    @Override
    public void deleteUserGroups(String identity) {
        Transaction transaction = null;
        this.writeLock.lock();
        try {
            transaction = this.transactionBuilder.start();
            DeleteIdpUserGroupsByIdentity action = new DeleteIdpUserGroupsByIdentity(identity);
            Integer rowsDeleted = transaction.execute(action);
            LOGGER.debug("Deleted {} user groups for identity {}", (Object)rowsDeleted, (Object)identity);
            transaction.commit();
        }
        catch (DataAccessException | TransactionException te) {
            this.rollback(transaction);
            throw new AdministrationException(te);
        }
        catch (Throwable t) {
            this.rollback(transaction);
            throw t;
        }
        finally {
            this.closeQuietly(transaction);
            this.writeLock.unlock();
        }
    }

    @Override
    public List<IdpUserGroup> replaceUserGroups(String userIdentity, IdpType idpType, Set<String> groupNames) {
        List<IdpUserGroup> createdUserGroups;
        Transaction transaction = null;
        this.writeLock.lock();
        try {
            transaction = this.transactionBuilder.start();
            DeleteIdpUserGroupsByIdentity deleteAction = new DeleteIdpUserGroupsByIdentity(userIdentity);
            Integer rowsDeleted = transaction.execute(deleteAction);
            LOGGER.debug("Deleted {} user groups for identity {}", (Object)rowsDeleted, (Object)userIdentity);
            ArrayList<IdpUserGroup> idpUserGroups = new ArrayList<IdpUserGroup>();
            for (String groupName : groupNames) {
                IdpUserGroup idpUserGroup = new IdpUserGroup();
                idpUserGroup.setIdentity(userIdentity);
                idpUserGroup.setType(idpType);
                idpUserGroup.setGroupName(groupName);
                idpUserGroup.setCreated(new Date());
                idpUserGroups.add(idpUserGroup);
                LOGGER.debug("{} belongs to {}", (Object)userIdentity, (Object)groupName);
            }
            CreateIdpUserGroups createAction = new CreateIdpUserGroups(idpUserGroups);
            createdUserGroups = transaction.execute(createAction);
            transaction.commit();
        }
        catch (DataAccessException | TransactionException te) {
            this.rollback(transaction);
            throw new AdministrationException(te);
        }
        catch (Throwable t) {
            this.rollback(transaction);
            throw t;
        }
        finally {
            this.closeQuietly(transaction);
            this.writeLock.unlock();
        }
        return createdUserGroups;
    }

    private void rollback(Transaction transaction) {
        if (transaction != null) {
            transaction.rollback();
        }
    }

    private void closeQuietly(Transaction transaction) {
        if (transaction != null) {
            try {
                transaction.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setTransactionBuilder(TransactionBuilder transactionBuilder) {
        this.transactionBuilder = transactionBuilder;
    }
}

