/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.trogdor.basic.BasicNode;
import org.apache.kafka.trogdor.basic.BasicTopology;
import org.apache.kafka.trogdor.common.Topology;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120000L, unit=TimeUnit.MILLISECONDS)
public class TopologyTest {
    @Test
    public void testAgentNodeNames() {
        TreeMap<String, BasicNode> nodes = new TreeMap<String, BasicNode>();
        int numNodes = 5;
        for (int i = 0; i < 5; ++i) {
            HashMap<String, String> conf = new HashMap<String, String>();
            if (i == 0) {
                conf.put("trogdor.coordinator.port", String.valueOf(8889));
            } else {
                conf.put("trogdor.agent.port", String.valueOf(8888));
            }
            BasicNode node = new BasicNode(String.format("node%02d", i), String.format("node%d.example.com", i), conf, new HashSet());
            nodes.put(node.name(), node);
        }
        BasicTopology topology = new BasicTopology(nodes);
        Set names = Topology.Util.agentNodeNames((Topology)topology);
        Assertions.assertEquals((int)4, (int)names.size());
        for (int i = 1; i < 4; ++i) {
            Assertions.assertTrue((boolean)names.contains(String.format("node%02d", i)));
        }
    }
}

