/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import kafka.controller.KafkaController;
import kafka.log.LogManager;
import kafka.network.DataPlaneAcceptor;
import kafka.network.SocketServer;
import kafka.network.SocketServer$;
import kafka.server.BrokerDynamicThreadPool;
import kafka.server.BrokerReconfigurable;
import kafka.server.ControllerServer;
import kafka.server.Defaults$;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicMetricsReporters;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandlerPool;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.TestDynamicThreadPool;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.MockMetricsReporter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tEh\u0001B\u00181\u0001UBQ\u0001\u0010\u0001\u0005\u0002uBQ\u0001\u0011\u0001\u0005\u0002\u0005CQA\u0015\u0001\u0005\u0002\u0005CQ\u0001\u0016\u0001\u0005\u0002\u0005CQA\u0016\u0001\u0005\u0002\u0005CQ\u0001\u0017\u0001\u0005\u0002\u0005CQA\u0017\u0001\u0005\u0002\u0005CQ\u0001\u0018\u0001\u0005\u0002\u0005CQA\u0018\u0001\u0005\u0002\u0005CQ\u0001\u0019\u0001\u0005\u0002\u0005CQA\u0019\u0001\u0005\n\rDq!!\u0002\u0001\t\u0013\t9\u0001\u0003\u0004\u00022\u0001!\t!\u0011\u0005\u0007\u0003k\u0001A\u0011A!\t\r\u0005e\u0002\u0001\"\u0001B\r\u0019\ti\u0004\u0001\u0001\u0002@!1A\b\u0005C\u0001\u0003CB\u0011\"a\u001a\u0011\u0001\u0004%\t!!\u001b\t\u0013\u0005=\u0004\u00031A\u0005\u0002\u0005E\u0004\u0002CA<!\u0001\u0006K!a\u001b\t\u000f\u0005\u0005\u0005\u0003\"\u0011\u0002\u0004\"9\u0011Q\u0018\t\u0005B\u0005}\u0006bBAr!\u0011\u0005\u0013Q\u001d\u0005\b\u0005\u001f\u0001B\u0011\tB\t\u0011\u001d\u0011)\u0004\u0005C!\u0005oAaAa\u0011\u0011\t\u0003\n\u0005b\u0002B#!\u0011\u0005#q\t\u0005\b\u0005?\u0002B\u0011\tB1\u0011\u001d\u0011I\u0007\u0005C!\u0005WBqA!\u001f\u0011\t\u0003\u0012Y\b\u0003\u0004\u0003\n\u0002!\t!\u0011\u0005\b\u0005\u001b\u0003A\u0011\u0002BH\u0011\u0019\u0011y\n\u0001C\u0001\u0003\"9!1\u0015\u0001\u0005\n\t\u0015\u0006B\u0002BV\u0001\u0011\u0005\u0011\t\u0003\u0004\u00030\u0002!\t!\u0011\u0005\u0007\u0005g\u0003A\u0011A!\t\r\t]\u0006\u0001\"\u0001B\u0011\u0019\u0011Y\f\u0001C\u0001\u0003\"1!q\u0018\u0001\u0005\u0002\u0005CaAa1\u0001\t\u0003\t\u0005B\u0002Bd\u0001\u0011\u0005\u0011\t\u0003\u0004\u0003L\u0002!\t!\u0011\u0005\u0007\u0005\u001f\u0004A\u0011A!\t\r\tM\u0007\u0001\"\u0001B\u0011\u001d\u00119\u000e\u0001C\u0001\u00053\u0014q\u0003R=oC6L7M\u0011:pW\u0016\u00148i\u001c8gS\u001e$Vm\u001d;\u000b\u0005E\u0012\u0014AB:feZ,'OC\u00014\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u001c\u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\b\u0005\u0002@\u00015\t\u0001'\u0001\tuKN$8i\u001c8gS\u001e,\u0006\u000fZ1uKR\t!\t\u0005\u00028\u0007&\u0011A\t\u000f\u0002\u0005+:LG\u000f\u000b\u0002\u0003\rB\u0011q\tU\u0007\u0002\u0011*\u0011\u0011JS\u0001\u0004CBL'BA&M\u0003\u001dQW\u000f]5uKJT!!\u0014(\u0002\u000b),h.\u001b;\u000b\u0003=\u000b1a\u001c:h\u0013\t\t\u0006J\u0001\u0003UKN$\u0018A\n;fgR,e.\u00192mK\u0012+g-Y;miVs7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\"\u00121AR\u0001\u001ci\u0016\u001cH/\u00169eCR,G)\u001f8b[&\u001cG\u000b\u001b:fC\u0012\u0004vn\u001c7)\u0005\u00111\u0015A\n;fgR\u001cuN\u001c4jOV\u0003H-\u0019;f/&$\bnU8nK&sg/\u00197jI\u000e{gNZ5hg\"\u0012QAR\u00014i\u0016\u001cHoQ8oM&<W\u000b\u001d3bi\u0016<\u0016\u000e\u001e5SK\u000e|gNZ5hkJ\f'\r\\3WC2LG-\u0019;j_:4\u0015-\u001b7ve\u0016D#A\u0002$\u00029Q,7\u000f\u001e*fG>tg-[4ve\u0006\u0014G.\u001a,bY&$\u0017\r^5p]\"\u0012qAR\u0001\u0014i\u0016\u001cHoU3dkJLG/_\"p]\u001aLwm\u001d\u0015\u0003\u0011\u0019\u000b1\u0003^3ti\u000e{gN\\3di&|g.U;pi\u0006D#!\u0003$\u0002/Q,7\u000f^\"p]:,7\r^5p]J\u000bG/Z)v_R\f\u0007F\u0001\u0006G\u0003I1XM]5gs\u000e{gNZ5h+B$\u0017\r^3\u0015\r\t#\u0017o_A\u0001\u0011\u0015)7\u00021\u0001g\u0003\u0011q\u0017-\\3\u0011\u0005\u001dtgB\u00015m!\tI\u0007(D\u0001k\u0015\tYG'\u0001\u0004=e>|GOP\u0005\u0003[b\na\u0001\u0015:fI\u00164\u0017BA8q\u0005\u0019\u0019FO]5oO*\u0011Q\u000e\u000f\u0005\u0006e.\u0001\ra]\u0001\u0006m\u0006dW/\u001a\t\u0003ifl\u0011!\u001e\u0006\u0003m^\fA\u0001\\1oO*\t\u00010\u0001\u0003kCZ\f\u0017B\u0001>v\u0005\u0019y%M[3di\")Ap\u0003a\u0001{\u0006y\u0001/\u001a:Ce>\\WM]\"p]\u001aLw\r\u0005\u00028}&\u0011q\u0010\u000f\u0002\b\u0005>|G.Z1o\u0011\u0019\t\u0019a\u0003a\u0001{\u0006iQ\r\u001f9fGR4\u0015-\u001b7ve\u0016\f1E^3sS\u001aL8i\u001c8gS\u001e,\u0006\u000fZ1uK^KG\u000f[%om\u0006d\u0017\u000eZ\"p]\u001aLw\rF\u0005C\u0003\u0013\t\u0019\"a\t\u0002.!9\u00111\u0002\u0007A\u0002\u00055\u0011AB2p]\u001aLw\rE\u0002@\u0003\u001fI1!!\u00051\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000f\u0005UA\u00021\u0001\u0002\u0018\u0005IqN]5h!J|\u0007o\u001d\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011QD<\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003C\tYB\u0001\u0006Qe>\u0004XM\u001d;jKNDq!!\n\r\u0001\u0004\t9#\u0001\u0006wC2LG\r\u0015:paN\u0004RaZA\u0015M\u001aL1!a\u000bq\u0005\ri\u0015\r\u001d\u0005\b\u0003_a\u0001\u0019AA\u0014\u00031IgN^1mS\u0012\u0004&o\u001c9t\u0003q!Xm\u001d;QCN\u001cxo\u001c:e\u0007>tg-[4F]\u000e\u0014\u0018\u0010\u001d;j_:D#!\u0004$\u0002KQ,7\u000f\u001e)bgN<xN\u001d3D_:4\u0017nZ#oG>$WM]*fGJ,Go\u00115b]\u001e,\u0007F\u0001\bG\u0003e!Xm\u001d;Es:\fW.[2MSN$XM\\3s\u0007>tg-[4)\u0005=1%A\u0004+fgR\fU\u000f\u001e5pe&TXM]\n\u0007!M\f\t%!\u0016\u0011\t\u0005\r\u0013\u0011K\u0007\u0003\u0003\u000bRA!a\u0012\u0002J\u0005Q\u0011-\u001e;i_JL'0\u001a:\u000b\u0007E\nYEC\u00024\u0003\u001bR1!a\u0014O\u0003\u0019\t\u0007/Y2iK&!\u00111KA#\u0005)\tU\u000f\u001e5pe&TXM\u001d\t\u0005\u0003/\ni&\u0004\u0002\u0002Z)!\u00111LA&\u0003\u0019\u0019w.\\7p]&!\u0011qLA-\u00059\u0011VmY8oM&<WO]1cY\u0016$\"!a\u0019\u0011\u0007\u0005\u0015\u0004#D\u0001\u0001\u0003)\u0019X\u000f]3s+N,'o]\u000b\u0003\u0003W\u00022\u0001^A7\u0013\tyW/\u0001\btkB,'/V:feN|F%Z9\u0015\u0007\t\u000b\u0019\bC\u0005\u0002vM\t\t\u00111\u0001\u0002l\u0005\u0019\u0001\u0010J\u0019\u0002\u0017M,\b/\u001a:Vg\u0016\u00148\u000f\t\u0015\u0004)\u0005m\u0004cA\u001c\u0002~%\u0019\u0011q\u0010\u001d\u0003\u0011Y|G.\u0019;jY\u0016\fQa\u001d;beR$B!!\"\u00024B\"\u0011qQAK!!\tI\"!#\u0002\f\u0006E\u0015\u0002BA\u0016\u00037\u0001B!a\u0016\u0002\u000e&!\u0011qRA-\u0005!)e\u000e\u001a9pS:$\b\u0003BAJ\u0003+c\u0001\u0001B\u0006\u0002\u0018V\t\t\u0011!A\u0003\u0002\u0005e%aA0%qE!\u00111TAQ!\r9\u0014QT\u0005\u0004\u0003?C$a\u0002(pi\"Lgn\u001a\t\u0007\u0003G\u000bI+!,\u000e\u0005\u0005\u0015&\u0002BAT\u00037\t!bY8oGV\u0014(/\u001a8u\u0013\u0011\tY+!*\u0003\u001f\r{W\u000e\u001d7fi&|gn\u0015;bO\u0016\u00042\u0001^AX\u0013\r\t\t,\u001e\u0002\u0005->LG\rC\u0004\u00026V\u0001\r!a.\u0002\u0015M,'O^3s\u0013:4w\u000e\u0005\u0003\u0002D\u0005e\u0016\u0002BA^\u0003\u000b\u0012A#Q;uQ>\u0014\u0018N_3s'\u0016\u0014h/\u001a:J]\u001a|\u0017!C1vi\"|'/\u001b>f)\u0019\t\t-!4\u0002XB1\u0011\u0011DAb\u0003\u000fLA!!2\u0002\u001c\t!A*[:u!\u0011\t\u0019%!3\n\t\u0005-\u0017Q\t\u0002\u0014\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8SKN,H\u000e\u001e\u0005\b\u0003\u001f4\u0002\u0019AAi\u00039\u0011X-];fgR\u001cuN\u001c;fqR\u0004B!a\u0011\u0002T&!\u0011Q[A#\u0005i\tU\u000f\u001e5pe&T\u0018M\u00197f%\u0016\fX/Z:u\u0007>tG/\u001a=u\u0011\u001d\tIN\u0006a\u0001\u00037\fq!Y2uS>t7\u000f\u0005\u0004\u0002\u001a\u0005\r\u0017Q\u001c\t\u0005\u0003\u0007\ny.\u0003\u0003\u0002b\u0006\u0015#AB!di&|g.\u0001\u0006de\u0016\fG/Z!dYN$b!a:\u0002|\u0006u\b\u0007BAu\u0003[\u0004b!!\u0007\u0002D\u0006-\b\u0003BAJ\u0003[$1\"a<\u0018\u0003\u0003\u0005\tQ!\u0001\u0002r\n\u0019q\fJ\u001d\u0012\t\u0005m\u00151\u001f\t\u0007\u0003G\u000bI+!>\u0011\t\u0005\r\u0013q_\u0005\u0005\u0003s\f)EA\bBG2\u001c%/Z1uKJ+7/\u001e7u\u0011\u001d\tym\u0006a\u0001\u0003#Dq!a@\u0018\u0001\u0004\u0011\t!A\u0006bG2\u0014\u0015N\u001c3j]\u001e\u001c\bCBA\r\u0003\u0007\u0014\u0019\u0001\u0005\u0003\u0003\u0006\t-QB\u0001B\u0004\u0015\u0011\u0011I!!\u0017\u0002\u0007\u0005\u001cG.\u0003\u0003\u0003\u000e\t\u001d!AC!dY\nKg\u000eZ5oO\u0006QA-\u001a7fi\u0016\f5\r\\:\u0015\r\tM!q\u0005B\u0015a\u0011\u0011)B!\u0007\u0011\r\u0005e\u00111\u0019B\f!\u0011\t\u0019J!\u0007\u0005\u0017\tm\u0001$!A\u0001\u0002\u000b\u0005!Q\u0004\u0002\u0005?\u0012\n\u0004'\u0005\u0003\u0002\u001c\n}\u0001CBAR\u0003S\u0013\t\u0003\u0005\u0003\u0002D\t\r\u0012\u0002\u0002B\u0013\u0003\u000b\u0012q\"Q2m\t\u0016dW\r^3SKN,H\u000e\u001e\u0005\b\u0003\u001fD\u0002\u0019AAi\u0011\u001d\u0011Y\u0003\u0007a\u0001\u0005[\t\u0011#Y2m\u0005&tG-\u001b8h\r&dG/\u001a:t!\u0019\tI\"a1\u00030A!!Q\u0001B\u0019\u0013\u0011\u0011\u0019Da\u0002\u0003!\u0005\u001bGNQ5oI&twMR5mi\u0016\u0014\u0018\u0001B1dYN$BA!\u000f\u0003@A)AOa\u000f\u0003\u0004%\u0019!QH;\u0003\u0011%#XM]1cY\u0016DqA!\u0011\u001a\u0001\u0004\u0011y#\u0001\u0004gS2$XM]\u0001\u0006G2|7/Z\u0001\nG>tg-[4ve\u0016$2A\u0011B%\u0011\u001d\u0011Ye\u0007a\u0001\u0005\u001b\nqaY8oM&<7\u000f\r\u0003\u0003P\tM\u0003cBA\r\u0003\u00133'\u0011\u000b\t\u0005\u0003'\u0013\u0019\u0006\u0002\u0007\u0003V\t%\u0013\u0011!A\u0001\u0006\u0003\u00119F\u0001\u0003`IE\n\u0014\u0003BAN\u00053\u00022a\u000eB.\u0013\r\u0011i\u0006\u000f\u0002\u0004\u0003:L\u0018!\u0006:fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm\u001d\u000b\u0003\u0005G\u0002R!!\u0007\u0003f\u0019LAAa\u001a\u0002\u001c\t\u00191+\u001a;\u0002/Y\fG.\u001b3bi\u0016\u0014VmY8oM&<WO]1uS>tGc\u0001\"\u0003n!9!1J\u000fA\u0002\t=\u0004\u0007\u0002B9\u0005k\u0002r!!\u0007\u0002\n\u001a\u0014\u0019\b\u0005\u0003\u0002\u0014\nUD\u0001\u0004B<\u0005[\n\t\u0011!A\u0003\u0002\t]#\u0001B0%cI\n1B]3d_:4\u0017nZ;sKR\u0019!I! \t\u000f\t-c\u00041\u0001\u0003\u0000A\"!\u0011\u0011BC!\u001d\tI\"!#g\u0005\u0007\u0003B!a%\u0003\u0006\u0012a!q\u0011B?\u0003\u0003\u0005\tQ!\u0001\u0003X\t!q\fJ\u00194\u0003Q!Xm\u001d;BkRDwN]5{KJ\u001cuN\u001c4jO\"\u0012qDR\u0001\u001fGJ,\u0017\r^3D_6\u0014\u0017N\\3e\u0007>tGO]8mY\u0016\u00148i\u001c8gS\u001e$b!a\u0006\u0003\u0012\nm\u0005b\u0002BJA\u0001\u0007!QS\u0001\u0007]>$W-\u00133\u0011\u0007]\u00129*C\u0002\u0003\u001ab\u00121!\u00138u\u0011\u001d\u0011i\n\ta\u0001\u0005+\u000bA\u0001]8si\u00061C/Z:u\u0007>l'-\u001b8fI\u000e{g\u000e\u001e:pY2,'/Q;uQ>\u0014\u0018N_3s\u0007>tg-[4)\u0005\u00052\u0015AH2sK\u0006$X-S:pY\u0006$X\rZ\"p]R\u0014x\u000e\u001c7fe\u000e{gNZ5h)\u0019\t9Ba*\u0003*\"9!1\u0013\u0012A\u0002\tU\u0005b\u0002BOE\u0001\u0007!QS\u0001'i\u0016\u001cH/S:pY\u0006$X\rZ\"p]R\u0014x\u000e\u001c7fe\u0006+H\u000f[8sSj,'oQ8oM&<\u0007FA\u0012G\u00031!Xm\u001d;Ts:|g._7tQ\t!c)A\u0019uKN$H)\u001f8b[&\u001c7i\u001c8gS\u001eLe.\u001b;jC2L'0\u0019;j_:<\u0016\u000e\u001e5pkR\u001cuN\u001c4jONLeNW&)\u0005\u00152\u0015!\b;fgRLU\u000e\u001d:pa\u0016\u00148i\u001c8gS\u001e\u001c\u0018I]3SK6|g/\u001a3)\u0005\u00192\u0015!\u0007;fgR,\u0006\u000fZ1uK6+GO]5d%\u0016\u0004xN\u001d;feND#a\n$\u0002MQ,7\u000f^+qI\u0006$X-T3ue&\u001c'+\u001a9peR,'o\u001d(p\u00156D(+\u001a9peR,'\u000f\u000b\u0002)\r\u0006\tD/Z:u\u001d>t\u0017J\u001c;fe:\fGNV1mk\u0016\u001cHi\\3t\u001d>$X\t\u001f9pg\u0016Le\u000e^3s]\u0006d7i\u001c8gS\u001e\u001c\bFA\u0015G\u0003\u0011\"Xm\u001d;Es:\fW.[2M_\u001edunY1m%\u0016$XM\u001c;j_:l5oQ8oM&<\u0007F\u0001\u0016G\u0003\u0019\"Xm\u001d;Es:\fW.[2M_\u001edunY1m%\u0016$XM\u001c;j_:\u001c\u0016N_3D_:4\u0017n\u001a\u0015\u0003W\u0019\u000b\u0001\u0007^3ti\u0012Kh.Y7jG2{w\rT8dC2\u0014V\r^3oi&|gnU6jaN|e.\u00138wC2LGmQ8oM&<\u0007F\u0001\u0017G\u0003M\"Xm\u001d;Es:\fW.[2M_\u001edunY1m%\u0016$XM\u001c;j_:$\u0006N]8xg>s\u0017J\\2peJ,7\r^\"p]\u001aLw\r\u000b\u0002.\r\u0006)c/\u001a:jMfLenY8se\u0016\u001cG\u000fT8h\u0019>\u001c\u0017\r\u001c*fi\u0016tG/[8o!J|\u0007o\u001d\u000b\n\u0005\nm'Q\u001dBu\u0005[DqA!8/\u0001\u0004\u0011y.A\nm_\u001edunY1m%\u0016$XM\u001c;j_:l5\u000fE\u00028\u0005CL1Aa99\u0005\u0011auN\\4\t\u000f\t\u001dh\u00061\u0001\u0003`\u0006Y!/\u001a;f]RLwN\\'t\u0011\u001d\u0011YO\fa\u0001\u0005?\fa\u0003\\8h\u0019>\u001c\u0017\r\u001c*fi\u0016tG/[8o\u0005f$Xm\u001d\u0005\b\u0005_t\u0003\u0019\u0001Bp\u00039\u0011X\r^3oi&|gNQ=uKN\u0004")
public class DynamicBrokerConfigTest {
    @Test
    public void testConfigUpdate() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        String oldKeystore = "oldKs.jks";
        props.put("ssl.keystore.location", oldKeystore);
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        DynamicBrokerConfig dynamicConfig = config.dynamicConfig();
        dynamicConfig.initialize((Option)None$.MODULE$);
        Assertions.assertEquals((Object)config, (Object)dynamicConfig.currentKafkaConfig());
        Assertions.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
        Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
        Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Properties props1 = new Properties();
            String newKeystore = new StringBuilder(6).append("ks").append(i).append(".jks").toString();
            props1.put(new StringBuilder(44).append("listener.name.external.").append("ssl.keystore.location").toString(), newKeystore);
            dynamicConfig.updateBrokerConfig(0, props1, dynamicConfig.updateBrokerConfig$default$3());
            Assertions.assertNotSame((Object)config, (Object)dynamicConfig.currentKafkaConfig());
            Assertions.assertEquals((Object)newKeystore, config.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, (Object)config.getString(KafkaConfig$.MODULE$.SslKeystoreLocationProp()));
            Assertions.assertEquals((Object)oldKeystore, config.originals().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsStrings().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfig().get("ssl.keystore.location"));
        });
    }

    @Test
    public void testEnableDefaultUncleanLeaderElection() {
        int x$12 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$122 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$12, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        KafkaServer serverMock = (KafkaServer)Mockito.mock(KafkaServer.class);
        KafkaController controllerMock = (KafkaController)Mockito.mock(KafkaController.class);
        LogManager logManagerMock = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.kafkaController()).thenReturn((Object)controllerMock);
        Mockito.when((Object)serverMock.logManager()).thenReturn((Object)logManagerMock);
        Mockito.when((Object)logManagerMock.allLogs()).thenReturn((Object)package$.MODULE$.Iterable().empty());
        AtomicReference<LogConfig> currentDefaultLogConfig = new AtomicReference<LogConfig>(new LogConfig((java.util.Map)new Properties()));
        Mockito.when((Object)logManagerMock.currentDefaultConfig()).thenAnswer(x$1 -> (LogConfig)currentDefaultLogConfig.get());
        logManagerMock.reconfigureDefaultLogConfig((LogConfig)ArgumentMatchers.any(LogConfig.class));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            currentDefaultLogConfig.set(invocation.getArgument(0));
            return BoxedUnit.UNIT;
        });
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicLogConfig(logManagerMock, (KafkaBroker)serverMock));
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(config.uncleanLeaderElectionEnable()));
        ((KafkaController)Mockito.verify((Object)controllerMock)).enableDefaultUncleanLeaderElection();
    }

    @Test
    public void testUpdateDynamicThreadPool() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "4");
        origProps.put(KafkaConfig$.MODULE$.NumNetworkThreadsProp(), "2");
        origProps.put(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "1");
        origProps.put(KafkaConfig$.MODULE$.NumRecoveryThreadsPerDataDirProp(), "1");
        origProps.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "3");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        DataPlaneAcceptor acceptorMock = (DataPlaneAcceptor)Mockito.mock(DataPlaneAcceptor.class);
        KafkaRequestHandlerPool handlerPoolMock = (KafkaRequestHandlerPool)Mockito.mock(KafkaRequestHandlerPool.class);
        SocketServer socketServerMock = (SocketServer)Mockito.mock(SocketServer.class);
        ReplicaManager replicaManagerMock = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        LogManager logManagerMock = (LogManager)Mockito.mock(LogManager.class);
        KafkaScheduler schedulerMock = (KafkaScheduler)Mockito.mock(KafkaScheduler.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.dataPlaneRequestHandlerPool()).thenReturn((Object)handlerPoolMock);
        Mockito.when((Object)acceptorMock.listenerName()).thenReturn((Object)new ListenerName("plaintext"));
        Mockito.when((Object)acceptorMock.reconfigurableConfigs()).thenCallRealMethod();
        Mockito.when((Object)serverMock.socketServer()).thenReturn((Object)socketServerMock);
        Mockito.when((Object)socketServerMock.dataPlaneAcceptor(ArgumentMatchers.anyString())).thenReturn((Object)new Some((Object)acceptorMock));
        Mockito.when((Object)serverMock.replicaManager()).thenReturn((Object)replicaManagerMock);
        Mockito.when((Object)serverMock.logManager()).thenReturn((Object)logManagerMock);
        Mockito.when((Object)serverMock.kafkaScheduler()).thenReturn((Object)schedulerMock);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new BrokerDynamicThreadPool(serverMock));
        config.dynamicConfig().addReconfigurable((Reconfigurable)acceptorMock);
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "8");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)8, (Integer)config.numIoThreads());
        ((KafkaRequestHandlerPool)Mockito.verify((Object)handlerPoolMock)).resizeThreadPool(8);
        props.put(KafkaConfig$.MODULE$.NumNetworkThreadsProp(), "4");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)4, (Integer)config.numNetworkThreads());
        ArgumentCaptor captor = ArgumentCaptor.forClass(java.util.Map.class);
        ((DataPlaneAcceptor)Mockito.verify((Object)acceptorMock)).reconfigure((java.util.Map)captor.capture());
        Assertions.assertTrue((boolean)((java.util.Map)captor.getValue()).containsKey(KafkaConfig$.MODULE$.NumNetworkThreadsProp()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)4), ((java.util.Map)captor.getValue()).get(KafkaConfig$.MODULE$.NumNetworkThreadsProp()));
        props.put(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "2");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (Integer)config.numReplicaFetchers());
        ((ReplicaManager)Mockito.verify((Object)replicaManagerMock)).resizeFetcherThreadPool(2);
        props.put(KafkaConfig$.MODULE$.NumRecoveryThreadsPerDataDirProp(), "2");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (Integer)config.numRecoveryThreadsPerDataDir());
        ((LogManager)Mockito.verify((Object)logManagerMock)).resizeRecoveryThreadPool(2);
        props.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "6");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)6, (Integer)config.backgroundThreads());
        ((KafkaScheduler)Mockito.verify((Object)schedulerMock)).resizeThreadPool(6);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handlerPoolMock, socketServerMock, replicaManagerMock, logManagerMock, schedulerMock});
    }

    @Test
    public void testConfigUpdateWithSomeInvalidConfigs() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put("ssl.keystore.type", "JKS");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        scala.collection.immutable.Map validProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(44).append("listener.name.external.").append("ssl.keystore.location").toString()), (Object)"ks.p12")}));
        scala.collection.immutable.Map securityPropsWithoutListenerPrefix = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.type"), (Object)"PKCS12")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)securityPropsWithoutListenerPrefix);
        scala.collection.immutable.Map nonDynamicProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkConnectProp()), (Object)"somehost:2181")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)nonDynamicProps);
        scala.collection.immutable.Map invalidProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanerThreadsProp()), (Object)"invalid")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
        scala.collection.immutable.Map excludedTopicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogMessageFormatVersionProp()), (Object)"0.10.2")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)excludedTopicConfig);
    }

    @Test
    public void testConfigUpdateWithReconfigurableValidationFailure() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "100000000");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        scala.collection.immutable.Map validProps = Predef$.MODULE$.Map().empty();
        scala.collection.immutable.Map invalidProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanerThreadsProp()), (Object)"20")}));
        Reconfigurable reconfigurable = new Reconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp()}))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(configs);
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addReconfigurable(reconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
        config.dynamicConfig().removeReconfigurable(reconfigurable);
        BrokerReconfigurable brokerReconfigurable = new BrokerReconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public Set<String> reconfigurableConfigs() {
                return (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp()}));
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(newConfig.originals());
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addBrokerReconfigurable(brokerReconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
    }

    @Test
    public void testReconfigurableValidation() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        Set invalidReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp(), KafkaConfig$.MODULE$.BrokerIdProp(), "some.prop"}));
        Set validReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp(), KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "some.prop"}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.dynamicConfig().addReconfigurable(DynamicBrokerConfigTest.createReconfigurable$1(invalidReconfigurableProps)));
        config.dynamicConfig().addReconfigurable(DynamicBrokerConfigTest.createReconfigurable$1(validReconfigurableProps));
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.dynamicConfig().addBrokerReconfigurable(DynamicBrokerConfigTest.createBrokerReconfigurable$1(invalidReconfigurableProps)));
        config.dynamicConfig().addBrokerReconfigurable(DynamicBrokerConfigTest.createBrokerReconfigurable$1(validReconfigurableProps));
    }

    @Test
    public void testSecurityConfigs() {
        this.verifyUpdate$1("ssl.keystore.location", "ks.jks");
        this.verifyUpdate$1("ssl.keystore.type", "JKS");
        this.verifyUpdate$1("ssl.keystore.password", "password");
        this.verifyUpdate$1("ssl.key.password", "password");
    }

    @Test
    public void testConnectionQuota() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "100", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "100", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "0", false, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName1:100,hostName2:0", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName1:100,hostName2:0", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName#:100", true, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsProp(), "100", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsProp(), "100", false, false);
        String listenerMaxConnectionsProp = new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionsProp()).toString();
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", false, false);
    }

    @Test
    public void testConnectionRateQuota() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), "110", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), "120", false, false);
        String listenerMaxConnectionsProp = new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).toString();
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "20", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "30", false, false);
    }

    private void verifyConfigUpdate(String name, Object value, boolean perBrokerConfig, boolean expectFailure) {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties configProps = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        configProps.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "broker.secret");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)configProps, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties props = new Properties();
        props.put(name, value);
        Object oldValue = config.originals().get(name);
        if (!expectFailure) {
            config.dynamicConfig().validate(props, perBrokerConfig);
            DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
            Assertions.assertEquals((Object)value, config.originals().get(name));
            return;
        }
        Assertions.assertThrows(Exception.class, () -> config.dynamicConfig().validate(props, perBrokerConfig));
        DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
        Assertions.assertEquals(oldValue, config.originals().get(name));
    }

    private void verifyConfigUpdateWithInvalidConfig(KafkaConfig config, Properties origProps, scala.collection.immutable.Map<String, String> validProps, scala.collection.immutable.Map<String, String> invalidProps) {
        Properties props = new Properties();
        validProps.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return props.put(k, v);
            }
            throw new MatchError(null);
        });
        invalidProps.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                String k = (String)x0$2._1();
                String v = (String)x0$2._2();
                return props.put(k, v);
            }
            throw new MatchError(null);
        });
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, true));
        config.dynamicConfig().updateBrokerConfig(0, props, config.dynamicConfig().updateBrokerConfig$default$3());
        validProps.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$4(config, x0$3);
            return BoxedUnit.UNIT;
        });
        invalidProps.keySet().foreach((Function1 & Serializable & scala.Serializable)name -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$5(origProps, config, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPasswordConfigEncryption() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig configWithoutSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "config-encoder-secret");
        KafkaConfig configWithSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "myLoginModule required;");
        try {
            configWithoutSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        }
        catch (ConfigException configException) {}
        Properties persistedProps = configWithSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assertions.assertFalse((boolean)persistedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()).contains("myLoginModule"), (String)"Password not encoded");
        Properties decodedProps = configWithSecret.dynamicConfig().fromPersistentProps(persistedProps, true);
        Assertions.assertEquals((Object)"myLoginModule required;", (Object)decodedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()));
    }

    @Test
    public void testPasswordConfigEncoderSecretChange() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        props.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "staticLoginModule required;");
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "config-encoder-secret");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "dynamicLoginModule required;");
        Properties persistedProps = config.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assertions.assertFalse((boolean)persistedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()).contains("LoginModule"), (String)"Password not encoded");
        config.dynamicConfig().updateBrokerConfig(0, persistedProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)config.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        KafkaConfig newConfigWithSameSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        newConfigWithSameSecret.dynamicConfig().initialize((Option)None$.MODULE$);
        newConfigWithSameSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithSameSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "new-encoder-secret");
        props.put(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp(), "config-encoder-secret");
        KafkaConfig newConfigWithNewAndOldSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        newConfigWithNewAndOldSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithNewAndOldSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "another-new-encoder-secret");
        KafkaConfig newConfigWithNewSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        newConfigWithNewSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithNewSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"staticLoginModule required;", (Object)((Password)newConfigWithNewSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
    }

    @Test
    public void testDynamicListenerConfig() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 9092;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer kafkaServer = (KafkaServer)Mockito.mock(KafkaServer.class);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://hostname:9092,SASL_PLAINTEXT://hostname:9093");
        new DynamicListenerConfig((KafkaBroker)kafkaServer).validateReconfiguration(KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2()));
        props.put("listener.name.plaintext.you.should.not.pass", "failure");
        DynamicListenerConfig dynamicListenerConfig = new DynamicListenerConfig((KafkaBroker)kafkaServer);
        Assertions.assertThrows(ConfigException.class, () -> dynamicListenerConfig.validateReconfiguration(KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2())));
    }

    @Test
    public void testAuthorizerConfig() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 9092;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$);
        KafkaServer kafkaServer = (KafkaServer)Mockito.mock(KafkaServer.class);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)kafkaServer.kafkaYammerMetrics()).thenReturn((Object)KafkaYammerMetrics.INSTANCE);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)kafkaServer.metrics()).thenReturn((Object)metrics);
        QuotaFactory.QuotaManagers quotaManagers = (QuotaFactory.QuotaManagers)Mockito.mock(QuotaFactory.QuotaManagers.class);
        Mockito.when((Object)quotaManagers.clientQuotaCallback()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)kafkaServer.quotaManagers()).thenReturn((Object)quotaManagers);
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)socketServer.reconfigurableConfigs()).thenReturn((Object)SocketServer$.MODULE$.ReconfigurableConfigs());
        Mockito.when((Object)kafkaServer.socketServer()).thenReturn((Object)socketServer);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ProducerStateManagerConfig producerStateManagerConfig = (ProducerStateManagerConfig)Mockito.mock(ProducerStateManagerConfig.class);
        Mockito.when((Object)logManager.producerStateManagerConfig()).thenReturn((Object)producerStateManagerConfig);
        Mockito.when((Object)kafkaServer.logManager()).thenReturn((Object)logManager);
        TestAuthorizer authorizer = new TestAuthorizer();
        Mockito.when((Object)kafkaServer.authorizer()).thenReturn((Object)new Some((Object)authorizer));
        kafkaServer.config().dynamicConfig().addReconfigurables((KafkaBroker)kafkaServer);
        props.put("super.users", "User:admin");
        kafkaServer.config().dynamicConfig().updateBrokerConfig(0, props, kafkaServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    private Properties createCombinedControllerConfig(int nodeId, int port) {
        Properties retval = TestUtils$.MODULE$.createBrokerConfig(nodeId, null, true, true, port, TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        retval.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker,controller");
        retval.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
        retval.put(KafkaConfig$.MODULE$.ListenersProp(), new StringBuilder(25).append(retval.get(KafkaConfig$.MODULE$.ListenersProp())).append(",CONTROLLER://localhost:0").toString());
        retval.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(12).append(nodeId).append("@localhost:0").toString());
        return retval;
    }

    @Test
    public void testCombinedControllerAuthorizerConfig() {
        Properties props = this.createCombinedControllerConfig(0, 9092);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$);
        ControllerServer controllerServer = (ControllerServer)Mockito.mock(ControllerServer.class);
        Mockito.when((Object)controllerServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)controllerServer.kafkaYammerMetrics()).thenReturn((Object)KafkaYammerMetrics.INSTANCE);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)controllerServer.metrics()).thenReturn((Object)metrics);
        QuotaFactory.QuotaManagers quotaManagers = (QuotaFactory.QuotaManagers)Mockito.mock(QuotaFactory.QuotaManagers.class);
        Mockito.when((Object)quotaManagers.clientQuotaCallback()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)controllerServer.quotaManagers()).thenReturn((Object)quotaManagers);
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)socketServer.reconfigurableConfigs()).thenReturn((Object)SocketServer$.MODULE$.ReconfigurableConfigs());
        Mockito.when((Object)controllerServer.socketServer()).thenReturn((Object)socketServer);
        TestAuthorizer authorizer = new TestAuthorizer();
        Mockito.when((Object)controllerServer.authorizer()).thenReturn((Object)new Some((Object)authorizer));
        controllerServer.config().dynamicConfig().addReconfigurables(controllerServer);
        props.put("super.users", "User:admin");
        controllerServer.config().dynamicConfig().updateBrokerConfig(0, props, controllerServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    private Properties createIsolatedControllerConfig(int nodeId, int port) {
        Properties retval = TestUtils$.MODULE$.createBrokerConfig(nodeId, null, true, true, port, TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        retval.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        retval.remove(KafkaConfig$.MODULE$.AdvertisedListenersProp());
        retval.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
        retval.put(KafkaConfig$.MODULE$.ListenersProp(), "CONTROLLER://localhost:0");
        retval.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(12).append(nodeId).append("@localhost:0").toString());
        return retval;
    }

    @Test
    public void testIsolatedControllerAuthorizerConfig() {
        Properties props = this.createIsolatedControllerConfig(0, 9092);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$);
        ControllerServer controllerServer = (ControllerServer)Mockito.mock(ControllerServer.class);
        Mockito.when((Object)controllerServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)controllerServer.kafkaYammerMetrics()).thenReturn((Object)KafkaYammerMetrics.INSTANCE);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)controllerServer.metrics()).thenReturn((Object)metrics);
        QuotaFactory.QuotaManagers quotaManagers = (QuotaFactory.QuotaManagers)Mockito.mock(QuotaFactory.QuotaManagers.class);
        Mockito.when((Object)quotaManagers.clientQuotaCallback()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)controllerServer.quotaManagers()).thenReturn((Object)quotaManagers);
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)socketServer.reconfigurableConfigs()).thenReturn((Object)SocketServer$.MODULE$.ReconfigurableConfigs());
        Mockito.when((Object)controllerServer.socketServer()).thenReturn((Object)socketServer);
        TestAuthorizer authorizer = new TestAuthorizer();
        Mockito.when((Object)controllerServer.authorizer()).thenReturn((Object)new Some((Object)authorizer));
        controllerServer.config().dynamicConfig().addReconfigurables(controllerServer);
        props.put("super.users", "User:admin");
        controllerServer.config().dynamicConfig().updateBrokerConfig(0, props, controllerServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    @Test
    public void testSynonyms() {
        Assertions.assertEquals((Object)new .colon.colon((Object)"listener.name.secure.ssl.keystore.type", (List)new .colon.colon((Object)"ssl.keystore.type", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.secure.ssl.keystore.type", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)"listener.name.sasl_ssl.plain.sasl.jaas.config", (List)new .colon.colon((Object)"sasl.jaas.config", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.sasl_ssl.plain.sasl.jaas.config", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)"some.config", (List)Nil$.MODULE$), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("some.config", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeMillisProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeHoursProp(), (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(KafkaConfig$.MODULE$.LogRollTimeMillisProp(), true));
    }

    @Test
    public void testDynamicConfigInitializationWithoutConfigsInZK() {
        KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        Mockito.when((Object)zkClient.getEntityConfigs(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)new Properties());
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 9092;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties initialProps = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        initialProps.remove(KafkaConfig$.MODULE$.BackgroundThreadsProp());
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(initialProps);
        DynamicBrokerConfig dynamicBrokerConfig = new DynamicBrokerConfig(oldConfig);
        dynamicBrokerConfig.initialize((Option)new Some((Object)zkClient));
        dynamicBrokerConfig.addBrokerReconfigurable((BrokerReconfigurable)new TestDynamicThreadPool());
        Properties newprops = new Properties();
        newprops.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "10");
        newprops.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "100");
        dynamicBrokerConfig.updateBrokerConfig(0, newprops, dynamicBrokerConfig.updateBrokerConfig$default$3());
    }

    @Test
    public void testImproperConfigsAreRemoved() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Assertions.assertEquals((int)Defaults$.MODULE$.MaxConnections(), (Integer)config.maxConnections());
        Assertions.assertEquals((int)0x10000C, (Integer)config.messageMaxBytes());
        Properties newProps = new Properties();
        newProps.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "9999");
        newProps.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), "2222");
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)9999, (Integer)config.maxConnections());
        Assertions.assertEquals((int)2222, (Integer)config.messageMaxBytes());
        newProps = new Properties();
        newProps.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "INVALID_INT");
        newProps.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), "1111");
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)Defaults$.MODULE$.MaxConnections(), (Integer)config.maxConnections());
        Assertions.assertEquals((int)1111, (Integer)config.messageMaxBytes());
    }

    @Test
    public void testUpdateMetricReporters() {
        int brokerId = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(brokerId, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        DynamicMetricsReporters m = new DynamicMetricsReporters(brokerId, config, metrics, "clusterId");
        config.dynamicConfig().addReconfigurable((Reconfigurable)m);
        Assertions.assertEquals((int)1, (int)m.currentReporters().size());
        Assertions.assertEquals((Object)JmxReporter.class.getName(), (Object)m.currentReporters().keySet().head());
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.MetricReporterClassesProp(), MockMetricsReporter.class.getName());
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (int)m.currentReporters().size());
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{JmxReporter.class.getName(), MockMetricsReporter.class.getName()})), (Object)m.currentReporters().keySet());
    }

    @Test
    public void testUpdateMetricReportersNoJmxReporter() {
        int brokerId = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(brokerId, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put(KafkaConfig$.MODULE$.AutoIncludeJmxReporterProp(), "false");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        DynamicMetricsReporters m = new DynamicMetricsReporters(brokerId, config, metrics, "clusterId");
        config.dynamicConfig().addReconfigurable((Reconfigurable)m);
        Assertions.assertTrue((boolean)m.currentReporters().isEmpty());
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.MetricReporterClassesProp(), MockMetricsReporter.class.getName());
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)1, (int)m.currentReporters().size());
        Assertions.assertEquals((Object)MockMetricsReporter.class.getName(), (Object)m.currentReporters().keySet().head());
        props.remove(KafkaConfig$.MODULE$.MetricReporterClassesProp());
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertTrue((boolean)m.currentReporters().isEmpty());
    }

    @Test
    public void testNonInternalValuesDoesNotExposeInternalConfigs() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.MetadataLogSegmentMinBytesProp(), "1024");
        KafkaConfig config = new KafkaConfig((java.util.Map)props);
        Assertions.assertFalse((boolean)config.nonInternalValues().containsKey(KafkaConfig$.MODULE$.MetadataLogSegmentMinBytesProp()));
        config.updateCurrentConfig(new KafkaConfig((java.util.Map)props));
        Assertions.assertFalse((boolean)config.nonInternalValues().containsKey(KafkaConfig$.MODULE$.MetadataLogSegmentMinBytesProp()));
    }

    @Test
    public void testDynamicLogLocalRetentionMsConfig() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), "2592000000");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        DynamicLogConfig dynamicLogConfig = new DynamicLogConfig((LogManager)Mockito.mock(LogManager.class), (KafkaBroker)Mockito.mock(KafkaServer.class));
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicLogConfig);
        Properties newProps = new Properties();
        newProps.put("log.local.retention.ms", "2160000000");
        config.dynamicConfig().validate(newProps, false);
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)2160000000L, (Long)config.logLocalRetentionMs());
        config.dynamicConfig().validate(newProps, true);
        newProps.put("log.local.retention.ms", "2150000000");
        config.dynamicConfig().updateBrokerConfig(0, newProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)2150000000L, (Long)config.logLocalRetentionMs());
    }

    @Test
    public void testDynamicLogLocalRetentionSizeConfig() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        props.put(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "4294967296");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        DynamicLogConfig dynamicLogConfig = new DynamicLogConfig((LogManager)Mockito.mock(LogManager.class), (KafkaBroker)Mockito.mock(KafkaServer.class));
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicLogConfig);
        Properties newProps = new Properties();
        newProps.put("log.local.retention.bytes", "4294967295");
        config.dynamicConfig().validate(newProps, false);
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)0xFFFFFFFFL, (Long)config.logLocalRetentionBytes());
        config.dynamicConfig().validate(newProps, true);
        newProps.put("log.local.retention.bytes", "4294967294");
        config.dynamicConfig().updateBrokerConfig(0, newProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)0xFFFFFFFEL, (Long)config.logLocalRetentionBytes());
    }

    @Test
    public void testDynamicLogLocalRetentionSkipsOnInvalidConfig() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        props.put("log.local.retention.ms", "1000");
        props.put("log.local.retention.bytes", "1024");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        this.verifyConfigUpdateWithInvalidConfig(config, props, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log.local.retention.ms"), (Object)"-3")}))));
        this.verifyConfigUpdateWithInvalidConfig(config, props, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log.local.retention.bytes"), (Object)"-3")}))));
    }

    @Test
    public void testDynamicLogLocalRetentionThrowsOnIncorrectConfig() {
        this.verifyIncorrectLogLocalRetentionProps(2000L, 1000L, 2L, 100L);
        this.verifyIncorrectLogLocalRetentionProps(500L, 1000L, 200L, 100L);
        this.verifyIncorrectLogLocalRetentionProps(-1L, 1000L, 200L, 100L);
        this.verifyIncorrectLogLocalRetentionProps(2000L, 1000L, -1L, 100L);
    }

    public void verifyIncorrectLogLocalRetentionProps(long logLocalRetentionMs, long retentionMs, long logLocalRetentionBytes, long retentionBytes) {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), Long.toString(retentionMs));
        props.put(KafkaConfig$.MODULE$.LogRetentionBytesProp(), Long.toString(retentionBytes));
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        DynamicLogConfig dynamicLogConfig = new DynamicLogConfig((LogManager)Mockito.mock(LogManager.class), (KafkaBroker)Mockito.mock(KafkaServer.class));
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicLogConfig);
        Properties newProps = new Properties();
        newProps.put("log.local.retention.ms", Long.toString(logLocalRetentionMs));
        newProps.put("log.local.retention.bytes", Long.toString(logLocalRetentionBytes));
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(newProps, false));
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(newProps, true));
    }

    public static final void kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(java.util.Map configs) {
        int cleanerThreads = new StringOps(Predef$.MODULE$.augmentString(configs.get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).toString())).toInt();
        if (cleanerThreads <= 0 || cleanerThreads >= 5) {
            throw new ConfigException(new StringBuilder(24).append("Invalid cleaner threads ").append(cleanerThreads).toString());
        }
    }

    private static final Reconfigurable createReconfigurable$1(Set configs) {
        return new Reconfigurable(null, configs){
            private final Set configs$1;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(this.configs$1).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                this.configs$1 = configs$1;
            }
        };
    }

    private static final BrokerReconfigurable createBrokerReconfigurable$1(Set configs) {
        return new BrokerReconfigurable(null, configs){
            private final Set configs$2;

            public Set<String> reconfigurableConfigs() {
                return this.configs$2;
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                this.configs$2 = configs$2;
            }
        };
    }

    private final void verifyUpdate$1(String name, Object value) {
        this.verifyConfigUpdate(name, value, true, true);
        this.verifyConfigUpdate(new StringBuilder(23).append("listener.name.external.").append(name).toString(), value, true, false);
        this.verifyConfigUpdate(name, value, false, true);
        this.verifyConfigUpdate(new StringBuilder(23).append("listener.name.external.").append(name).toString(), value, false, true);
    }

    private static final void updateConfig$1(boolean perBrokerConfig$1, KafkaConfig config$3, Properties props$1) {
        if (perBrokerConfig$1) {
            config$3.dynamicConfig().updateBrokerConfig(0, config$3.dynamicConfig().toPersistentProps(props$1, perBrokerConfig$1), config$3.dynamicConfig().updateBrokerConfig$default$3());
            return;
        }
        config$3.dynamicConfig().updateDefaultConfig(props$1, config$3.dynamicConfig().updateDefaultConfig$default$2());
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$4(KafkaConfig config$4, Tuple2 x0$3) {
        if (x0$3 != null) {
            String name = (String)x0$3._1();
            Assertions.assertEquals((Object)((String)x0$3._2()), config$4.originals().get(name));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$5(Properties origProps$1, KafkaConfig config$4, String name) {
        Assertions.assertEquals((Object)origProps$1.get(name), config$4.originals().get(name));
    }

    public class TestAuthorizer
    implements Authorizer,
    Reconfigurable {
        private volatile String superUsers;

        public int aclCount() {
            return super.aclCount();
        }

        public AuthorizationResult authorizeByResourceType(AuthorizableRequestContext x$1, AclOperation x$2, ResourceType x$3) {
            return super.authorizeByResourceType(x$1, x$2, x$3);
        }

        public String superUsers() {
            return this.superUsers;
        }

        public void superUsers_$eq(String x$1) {
            this.superUsers = x$1;
        }

        public java.util.Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
            return (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava();
        }

        public java.util.List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, java.util.List<Action> actions) {
            return null;
        }

        public java.util.List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, java.util.List<AclBinding> aclBindings) {
            return null;
        }

        public java.util.List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, java.util.List<AclBindingFilter> aclBindingFilters) {
            return null;
        }

        public Iterable<AclBinding> acls(AclBindingFilter filter) {
            return null;
        }

        public void close() {
        }

        public void configure(java.util.Map<String, ?> configs) {
        }

        public java.util.Set<String> reconfigurableConfigs() {
            return (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"super.users"}))).asJava();
        }

        public void validateReconfiguration(java.util.Map<String, ?> configs) {
        }

        public void reconfigure(java.util.Map<String, ?> configs) {
            this.superUsers_$eq(configs.get("super.users").toString());
        }

        public /* synthetic */ DynamicBrokerConfigTest kafka$server$DynamicBrokerConfigTest$TestAuthorizer$$$outer() {
            return DynamicBrokerConfigTest.this;
        }

        public TestAuthorizer() {
            if (DynamicBrokerConfigTest.this == null) {
                throw null;
            }
            this.superUsers = "";
        }
    }
}

