/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.server.log.remote.storage.NoOpRemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.storage.NoOpRemoteStorageManager;
import org.apache.kafka.server.log.remote.storage.RemoteStorageMetrics;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r-a\u0001\u0002\u0014(\u00011BQ\u0001\u000e\u0001\u0005\u0002UBqa\u000e\u0001C\u0002\u0013\u0005\u0003\b\u0003\u0004@\u0001\u0001\u0006I!\u000f\u0005\u0006\u0001\u0002!\t&\u0011\u0005\b\u001f\u0002\u0011\r\u0011\"\u0003Q\u0011\u0019I\u0006\u0001)A\u0005#\"9!\f\u0001b\u0001\n\u0013Y\u0006B\u00023\u0001A\u0003%A\fC\u0004f\u0001\t\u0007I\u0011\u00024\t\rE\u0004\u0001\u0015!\u0003h\u0011\u0015\u0011\b\u0001\"\u0015t\u0011\u001da\bA1A\u0005RuDq!a\u0004\u0001A\u0003%a\u0010\u0003\u0005\u0002\u0012\u0001\u0011\r\u0011\"\u0015~\u0011\u001d\t\u0019\u0002\u0001Q\u0001\nyDq!!\u0006\u0001\t\u0003\n9\u0002C\u0004\u0002>\u0001!\t%a\u0010\t\u000f\u0005%\u0003\u0001\"\u0001\u0002L!9\u0011\u0011\u0011\u0001\u0005\n\u0005\r\u0005bBA\\\u0001\u0011%\u0011\u0011\u0018\u0005\b\u0003{\u0003A\u0011BA`\u0011\u001d\t\t\u000e\u0001C\u0005\u0003'DqA!\u0001\u0001\t\u0013\u0011\u0019\u0001C\u0004\u0003\u0014\u0001!IA!\u0006\t\u000f\tu\u0001\u0001\"\u0003\u0003 !9!q\u0005\u0001\u0005\n\t%\u0002b\u0002B\u0017\u0001\u0011%!q\u0006\u0005\n\u0005s\u0002\u0011\u0013!C\u0005\u0005wBqA!&\u0001\t\u0013\u00119\nC\u0004\u00032\u0002!IAa-\t\u0013\t\u001d\u0007!%A\u0005\n\tu\u0004b\u0002Be\u0001\u0011%!1\u001a\u0005\b\u0005\u001f\u0004A\u0011\u0002Bi\u0011\u001d\u0011Y\u000f\u0001C\u0005\u0005[D\u0011B!>\u0001#\u0003%IAa>\t\u000f\tm\b\u0001\"\u0003\u0003~\"911\u0001\u0001\u0005\n\r\u0015!aC'fiJL7m\u001d+fgRT!\u0001K\u0015\u0002\u0007\u0005\u0004\u0018NC\u0001+\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u00172!\tqs&D\u0001(\u0013\t\u0001tE\u0001\fJ]R,wM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t!\tq#'\u0003\u00024O\tI1+Y:m'\u0016$X\u000f]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0002\"A\f\u0001\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002sA\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t\u0019\u0011J\u001c;\u0002\u0019\t\u0014xn[3s\u0007>,h\u000e\u001e\u0011\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0016\u0003\t\u0003\"aQ'\u000e\u0003\u0011S!!\u0012$\u0002\u000f9,Go^8sW*\u0011q\tS\u0001\u0007G>lWn\u001c8\u000b\u0005)J%B\u0001&L\u0003\u0019\t\u0007/Y2iK*\tA*A\u0002pe\u001eL!A\u0014#\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u00021-\fgm[1DY&,g\u000e^*bg2lUm\u00195b]&\u001cX.F\u0001R!\t\u0011v+D\u0001T\u0015\t!V+\u0001\u0003mC:<'\"\u0001,\u0002\t)\fg/Y\u0005\u00031N\u0013aa\u0015;sS:<\u0017!G6bM.\f7\t\\5f]R\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[\u0002\n\u0011d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ngV\tA\fE\u0002^EFk\u0011A\u0018\u0006\u0003?\u0002\f\u0011\"[7nkR\f'\r\\3\u000b\u0005\u0005\\\u0014AC2pY2,7\r^5p]&\u00111M\u0018\u0002\u0005\u0019&\u001cH/\u0001\u000elC\u001a\\\u0017mU3sm\u0016\u00148+Y:m\u001b\u0016\u001c\u0007.\u00198jg6\u001c\b%\u0001\rlC\u001a\\\u0017mU3sm\u0016\u0014(*Y1t\u000b:$(/\u001f(b[\u0016,\u0012a\u001a\t\u0003Q>t!![7\u0011\u0005)\\T\"A6\u000b\u00051\\\u0013A\u0002\u001fs_>$h(\u0003\u0002ow\u00051\u0001K]3eK\u001aL!\u0001\u00179\u000b\u00059\\\u0014!G6bM.\f7+\u001a:wKJT\u0015-Y:F]R\u0014\u0018PT1nK\u0002\n\u0001c]3dkJLG/\u001f)s_R|7m\u001c7\u0016\u0003Q\u0004\"!\u001e>\u000e\u0003YT!a\u001e=\u0002\t\u0005,H\u000f\u001b\u0006\u0003s\u001a\u000b\u0001b]3dkJLG/_\u0005\u0003wZ\u0014\u0001cU3dkJLG/\u001f)s_R|7m\u001c7\u0002)M,'O^3s'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3t+\u0005q\b\u0003\u0002\u001e\u0000\u0003\u0007I1!!\u0001<\u0005\u0011\u0019v.\\3\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003V\u0003\u0011)H/\u001b7\n\t\u00055\u0011q\u0001\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!F:feZ,'oU1tYB\u0013x\u000e]3si&,7\u000fI\u0001\u0015G2LWM\u001c;TCNd\u0007K]8qKJ$\u0018.Z:\u0002+\rd\u0017.\u001a8u'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3tA\u0005)1/\u001a;VaR!\u0011\u0011DA\u0010!\rQ\u00141D\u0005\u0004\u0003;Y$\u0001B+oSRDq!!\t\u0011\u0001\u0004\t\u0019#\u0001\u0005uKN$\u0018J\u001c4p!\u0011\t)#!\r\u000e\u0005\u0005\u001d\"b\u0001\u0015\u0002*)!\u00111FA\u0017\u0003\u001dQW\u000f]5uKJT1!a\fL\u0003\u0015QWO\\5u\u0013\u0011\t\u0019$a\n\u0003\u0011Q+7\u000f^%oM>D3\u0001EA\u001c!\u0011\t)#!\u000f\n\t\u0005m\u0012q\u0005\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8\u0015\u0005\u0005e\u0001fA\t\u0002DA!\u0011QEA#\u0013\u0011\t9%a\n\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017a\u0003;fgRlU\r\u001e:jGN$B!!\u0007\u0002N!9\u0011q\n\nA\u0002\u0005E\u0013AG:zgR,WNU3n_R,7\u000b^8sC\u001e,WI\\1cY\u0016$\u0007c\u0001\u001e\u0002T%\u0019\u0011QK\u001e\u0003\u000f\t{w\u000e\\3b]\":!#!\u0017\u0002j\u0005-\u0004\u0003BA.\u0003Kj!!!\u0018\u000b\t\u0005}\u0013\u0011M\u0001\taJ|g/\u001b3fe*!\u00111MA\u0015\u0003\u0019\u0001\u0018M]1ng&!\u0011qMA/\u0005-1\u0016\r\\;f'>,(oY3\u0002\u0011\t|w\u000e\\3b]NdC!!\u001c\u0002pe\t\u0011!G\u0001\u0001Q\u001d\u0011\u00121OA>\u0003{\u0002B!!\u001e\u0002x5\u0011\u0011\u0011M\u0005\u0005\u0003s\n\tGA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\u0012\u0011qP\u00011i\u0016\u001cH/T3ue&\u001c7\u000fI<ji\"\u00043/_:uK6\u0014V-\\8uKN#xN]1hK\u0016s\u0017M\u00197fIj\u00023\u0010M?\u0002\u0017M,g\u000e\u001a*fG>\u0014Hm\u001d\u000b\u000b\u00033\t))a)\u0002(\u0006-\u0006bBAD'\u0001\u0007\u0011\u0011R\u0001\taJ|G-^2feBA\u00111RAJ\u0003/\u000b9*\u0004\u0002\u0002\u000e*!\u0011qQAH\u0015\r\t\t\nS\u0001\bG2LWM\u001c;t\u0013\u0011\t)*!$\u0003\u001b-\u000bgm[1Qe>$WoY3s!\u0015Q\u0014\u0011TAO\u0013\r\tYj\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004u\u0005}\u0015bAAQw\t!!)\u001f;f\u0011\u0019\t)k\u0005a\u0001s\u0005Qa.^7SK\u000e|'\u000fZ:\t\r\u0005%6\u00031\u0001:\u0003)\u0011XmY8sINK'0\u001a\u0005\b\u0003[\u001b\u0002\u0019AAX\u0003\t!\b\u000f\u0005\u0003\u00022\u0006MV\"\u0001$\n\u0007\u0005UfI\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002;\u001d,g.\u001a:bi\u0016\fU\u000f\u001e5f]RL7-\u0019;j_:4\u0015-\u001b7ve\u0016$B!!\u0007\u0002<\"9\u0011Q\u0016\u000bA\u0002\u0005=\u0016!\u000b<fe&4\u0017pS1gW\u0006\u0014\u0016\r^3NKR\u0014\u0018nY:ICZ,7)^7vY\u0006$\u0018N^3D_VtG\u000f\u0006\u0004\u0002\u001a\u0005\u0005\u00171\u0019\u0005\b\u0003\u000f+\u0002\u0019AAE\u0011\u001d\t)-\u0006a\u0001\u0003\u000f\f\u0001bY8ogVlWM\u001d\t\t\u0003\u0013\fi-a&\u0002\u00186\u0011\u00111\u001a\u0006\u0005\u0003\u000b\fy)\u0003\u0003\u0002P\u0006-'\u0001C\"p]N,X.\u001a:\u00025Y,'/\u001b4z\u00072LWM\u001c;WKJ\u001c\u0018n\u001c8NKR\u0014\u0018nY:\u0015\r\u0005e\u0011Q[A\u007f\u0011\u001d\t9N\u0006a\u0001\u00033\fq!\\3ue&\u001c7\u000f\r\u0003\u0002\\\u0006-\b\u0003CA\u0003\u0003;\f\t/a:\n\t\u0005}\u0017q\u0001\u0002\u0004\u001b\u0006\u0004\b\u0003BAY\u0003GL1!!:G\u0005)iU\r\u001e:jG:\u000bW.\u001a\t\u0005\u0003S\fY\u000f\u0004\u0001\u0005\u0019\u00055\u0018Q[A\u0001\u0002\u0003\u0015\t!a<\u0003\u0007}#\u0013'\u0005\u0003\u0002r\u0006]\bc\u0001\u001e\u0002t&\u0019\u0011Q_\u001e\u0003\u000f9{G\u000f[5oOB!\u0011\u0011WA}\u0013\r\tYP\u0012\u0002\u0007\u001b\u0016$(/[2\t\r\u0005}h\u00031\u0001h\u0003\u0019)g\u000e^5us\u0006\tc/\u001a:jMf\u0014%o\\6fe\u0006+H\u000f[3oi&\u001c\u0017\r^5p]6+GO]5dgR!\u0011\u0011\u0004B\u0003\u0011\u001d\u00119a\u0006a\u0001\u0005\u0013\taa]3sm\u0016\u0014\b\u0003\u0002B\u0006\u0005\u001fi!A!\u0004\u000b\u0007\t\u001d\u0011&\u0003\u0003\u0003\u0012\t5!aC&bM.\f7+\u001a:wKJ\fAE^3sS\u001aL(I]8lKJlUm]:bO\u0016\u001cuN\u001c<feNLwN\\'fiJL7m\u001d\u000b\t\u00033\u00119B!\u0007\u0003\u001c!9!q\u0001\rA\u0002\t%\u0001BBAU1\u0001\u0007\u0011\bC\u0004\u0002.b\u0001\r!a,\u0002+Y,'/\u001b4z\u0005J|7.\u001a:[W6+GO]5dgR1\u0011\u0011\u0004B\u0011\u0005GAqAa\u0002\u001a\u0001\u0004\u0011I\u0001\u0003\u0004\u0003&e\u0001\raZ\u0001\u0006i>\u0004\u0018nY\u0001\u0019m\u0016\u0014\u0018NZ=Ce>\\WM]#se>\u0014X*\u001a;sS\u000e\u001cH\u0003BA\r\u0005WAqAa\u0002\u001b\u0001\u0004\u0011I!A\twKJLg-_&bM.\fW*\u001a;sS\u000e,BA!\r\u00038QQ!1\u0007B0\u0005C\u0012iGa\u001c\u0015\t\tU\"1\t\t\u0005\u0003S\u00149\u0004B\u0004\u0003:m\u0011\rAa\u000f\u0003\u0003Q\u000bB!!=\u0003>A\u0019!Ha\u0010\n\u0007\t\u00053HA\u0002B]fDqA!\u0012\u001c\u0001\u0004\u00119%\u0001\u0004wKJLg-\u001f\t\bu\t%#Q\nB\u001b\u0013\r\u0011Ye\u000f\u0002\n\rVt7\r^5p]F\u0002bAa\u0014\u0003Z\u0005]h\u0002\u0002B)\u0005+r1A\u001bB*\u0013\u0005a\u0014b\u0001B,w\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B.\u0005;\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0005/Z\u0004BBA>7\u0001\u0007q\rC\u0004\u0002Xn\u0001\rAa\u00191\t\t\u0015$\u0011\u000e\t\t\u0003\u000b\ti.!9\u0003hA!\u0011\u0011\u001eB5\t1\u0011YG!\u0019\u0002\u0002\u0003\u0005)\u0011AAx\u0005\ryFE\r\u0005\u0007\u0003\u007f\\\u0002\u0019A4\t\u0013\tE4\u0004%AA\u0002\tM\u0014!B4s_V\u0004\b\u0003\u0002\u001e\u0003v\u001dL1Aa\u001e<\u0005\u0019y\u0005\u000f^5p]\u0006Yb/\u001a:jMf\\\u0015MZ6b\u001b\u0016$(/[2%I\u00164\u0017-\u001e7uIQ*BA! \u0003\u0014V\u0011!q\u0010\u0016\u0005\u0005g\u0012\ti\u000b\u0002\u0003\u0004B!!Q\u0011BH\u001b\t\u00119I\u0003\u0003\u0003\n\n-\u0015!C;oG\",7m[3e\u0015\r\u0011iiO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BI\u0005\u000f\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u001d\u0011I\u0004\bb\u0001\u0005w\t1#\\1y\u0017\u000647.Y'fiJL7MV1mk\u0016$\"B!'\u0003 \n\u0005&Q\u0016BX!\rQ$1T\u0005\u0004\u0005;[$A\u0002#pk\ndW\r\u0003\u0004\u0002|u\u0001\ra\u001a\u0005\b\u0003/l\u0002\u0019\u0001BRa\u0011\u0011)K!+\u0011\u0011\u0005\u0015\u0011Q\\Aq\u0005O\u0003B!!;\u0003*\u0012a!1\u0016BQ\u0003\u0003\u0005\tQ!\u0001\u0002p\n\u0019q\fJ\u001a\t\r\u0005}X\u00041\u0001h\u0011\u001d\u0011\t(\ba\u0001\u0005g\n\u0011D^3sS\u001aL8*\u00194lC6+GO]5d%\u0016\u001cwN\u001d3fIRQ\u0011\u0011\u0004B[\u0005o\u0013\u0019M!2\t\r\u0005md\u00041\u0001h\u0011\u001d\t9N\ba\u0001\u0005s\u0003DAa/\u0003@BA\u0011QAAo\u0003C\u0014i\f\u0005\u0003\u0002j\n}F\u0001\u0004Ba\u0005o\u000b\t\u0011!A\u0003\u0002\u0005=(aA0%i!1\u0011q \u0010A\u0002\u001dD\u0011B!\u001d\u001f!\u0003\u0005\rAa\u001d\u0002GY,'/\u001b4z\u0017\u000647.Y'fiJL7MU3d_J$W\r\u001a\u0013eK\u001a\fW\u000f\u001c;%i\u0005\t\u00120Y7nKJlU\r\u001e:jGZ\u000bG.^3\u0015\t\tu\"Q\u001a\u0005\u0007\u0003w\u0002\u0003\u0019A4\u0002\u001fe\fW.\\3s\u0011&\u001cHo\\4sC6$BAa5\u0003jB!!Q\u001bBs\u001b\t\u00119N\u0003\u0003\u0003Z\nm\u0017\u0001B2pe\u0016TA!a6\u0003^*!!q\u001cBq\u0003\u0019I\u0018-\\7fe*\u0011!1]\u0001\u0004G>l\u0017\u0002\u0002Bt\u0005/\u0014\u0011\u0002S5ti><'/Y7\t\r\u0005m\u0014\u00051\u0001h\u0003i1XM]5gsf\u000bW.\\3s\u001b\u0016$(/[2SK\u000e|'\u000fZ3e)\u0019\u0011IJa<\u0003r\"1\u00111\u0010\u0012A\u0002\u001dD\u0011B!\u0012#!\u0003\u0005\rAa=\u0011\u000fi\u0012IE!'\u0002R\u0005!c/\u001a:jMfL\u0016-\\7fe6+GO]5d%\u0016\u001cwN\u001d3fI\u0012\"WMZ1vYR$#'\u0006\u0002\u0003z*\"!1\u001fBA\u0003Y1XM]5gs:{'+Z9vKN$X*\u001a;sS\u000e\u001cH\u0003BA\r\u0005\u007fDaa!\u0001%\u0001\u00049\u0017\u0001D3se>\u0014X*Z:tC\u001e,\u0017A\u0007<fe&4\u0017PU3n_R,7\u000b^8sC\u001e,W*\u001a;sS\u000e\u001cH\u0003BA\r\u0007\u000fAqa!\u0003&\u0001\u0004\t\t&\u0001\u000btQ>,H\u000eZ\"p]R\f\u0017N\\'fiJL7m\u001d")
public class MetricsTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int brokerCount;
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final String kafkaServerJaasEntryName;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public String jaasAdminLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasAdminLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasAdminLoginModule$default$2() {
        return SaslSetup.jaasAdminLoginModule$default$2$(this);
    }

    @Override
    public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
        return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return SaslSetup.createPrivilegedAdminClient$(this);
    }

    @Override
    public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
        return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
    }

    @Override
    public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
        SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
    }

    @Override
    public void createScramCredentials(Admin adminClient, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, adminClient, userName, password);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName("CLIENT");
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private String kafkaServerJaasEntryName() {
        return this.kafkaServerJaasEntryName;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        if (testInfo.getDisplayName().contains("testMetrics") && testInfo.getDisplayName().endsWith("true")) {
            this.serverConfig().setProperty("remote.log.storage.system.enable", "true");
            this.serverConfig().setProperty("remote.log.storage.manager.class.name", NoOpRemoteStorageManager.class.getName());
            this.serverConfig().setProperty("remote.log.metadata.manager.class.name", NoOpRemoteLogMetadataManager.class.getName());
        }
        this.verifyNoRequestMetrics("Request metrics not removed in a previous test");
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, this.kafkaServerJaasEntryName()));
        super.setUp(testInfo);
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
        this.verifyNoRequestMetrics("Request metrics not removed in this test");
    }

    @ParameterizedTest(name="testMetrics with systemRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testMetrics(boolean systemRemoteStorageEnabled) {
        String topic = "topicWithOldMessageFormat";
        Properties props = new Properties();
        props.setProperty("message.format.version", "0.9.0");
        this.createTopic(topic, 1, 1, props, this.createTopic$default$5(), this.createTopic$default$6());
        TopicPartition tp = new TopicPartition(topic, 0);
        int numRecords = 10;
        int recordSize = 100000;
        Properties prop = new Properties();
        prop.setProperty("enable.idempotence", "false");
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        KafkaProducer producer = this.createProducer(x$2, x$3, prop);
        this.sendRecords(producer, numRecords, recordSize, tp);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp, (List)Nil$.MODULE$)).asJava());
        consumer.seek(tp, 0L);
        TestUtils$.MODULE$.consumeRecords(consumer, numRecords, TestUtils$.MODULE$.consumeRecords$default$3());
        this.verifyKafkaRateMetricsHaveCumulativeCount(producer, consumer);
        this.verifyClientVersionMetrics(consumer.metrics(), "Consumer");
        this.verifyClientVersionMetrics(producer.metrics(), "Producer");
        KafkaServer server = (KafkaServer)this.servers().head();
        this.verifyBrokerMessageConversionMetrics(server, recordSize, tp);
        this.verifyBrokerErrorMetrics((KafkaServer)this.servers().head());
        this.verifyBrokerZkMetrics(server, topic);
        this.generateAuthenticationFailure(tp);
        this.verifyBrokerAuthenticationMetrics(server);
        this.verifyRemoteStorageMetrics(systemRemoteStorageEnabled);
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, int recordSize, TopicPartition tp) {
        byte[] bytes = new byte[recordSize];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), Predef$.MODULE$.long2Long((long)BoxesRunTime.unboxToInt((Object)i)), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(), (Object)bytes)), IndexedSeq$.MODULE$.canBuildFrom());
        producer.flush();
    }

    private void generateAuthenticationFailure(TopicPartition tp) {
        Properties saslProps = new Properties();
        saslProps.put("sasl.mechanism", this.kafkaClientSaslMechanism());
        saslProps.put("sasl.jaas.config", TestJaasConfig.jaasConfigProperty((String)this.kafkaClientSaslMechanism(), (String)"badUser", (String)"badPass"));
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        int x$2 = 0;
        int x$3 = 1000;
        long x$4 = 1000L;
        SecurityProtocol x$5 = this.securityProtocol();
        Option<File> x$6 = this.trustStoreFile();
        Some x$7 = new Some((Object)saslProps);
        long x$8 = TestUtils$.MODULE$.createProducer$default$4();
        int x$9 = TestUtils$.MODULE$.createProducer$default$5();
        int x$10 = TestUtils$.MODULE$.createProducer$default$6();
        int x$11 = TestUtils$.MODULE$.createProducer$default$7();
        int x$12 = TestUtils$.MODULE$.createProducer$default$8();
        String x$13 = TestUtils$.MODULE$.createProducer$default$9();
        ByteArraySerializer x$14 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$15 = TestUtils$.MODULE$.createProducer$default$15();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$1, x$2, x$4, x$8, x$9, x$10, x$11, x$12, x$13, x$3, x$5, x$6, (Option<Properties>)x$7, x$14, x$15, x$16);){
            try {
                producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), (Object)"key".getBytes(), (Object)"value".getBytes())).get();
            }
            catch (Exception exception) {}
        }
    }

    private void verifyKafkaRateMetricsHaveCumulativeCount(KafkaProducer<byte[], byte[]> producer, Consumer<byte[], byte[]> consumer) {
        Set consumerMetricNames = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(consumer.metrics().keySet()).asScala()).toSet();
        ((IterableLike)consumerMetricNames.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(x$1)))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            MetricsTest.verify$1(x$2, consumerMetricNames);
            return BoxedUnit.UNIT;
        });
        Set producerMetricNames = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(producer.metrics().keySet()).asScala()).toSet();
        Set producerExclusions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"compression-rate"}));
        ((IterableLike)((TraversableLike)producerMetricNames.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(x$3)))).filterNot((Function1 & Serializable & scala.Serializable)metricName -> BoxesRunTime.boxToBoolean((boolean)producerExclusions.contains((Object)metricName.name())))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            MetricsTest.verify$1(x$4, producerMetricNames);
            return BoxedUnit.UNIT;
        });
        this.verifyKafkaMetricRecorded("records-consumed-rate", consumer.metrics(), "Consumer", this.verifyKafkaMetricRecorded$default$4());
        this.verifyKafkaMetricRecorded("records-consumed-total", consumer.metrics(), "Consumer", this.verifyKafkaMetricRecorded$default$4());
        this.verifyKafkaMetricRecorded("record-send-rate", producer.metrics(), "Producer", this.verifyKafkaMetricRecorded$default$4());
        this.verifyKafkaMetricRecorded("record-send-total", producer.metrics(), "Producer", this.verifyKafkaMetricRecorded$default$4());
    }

    private void verifyClientVersionMetrics(Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity) {
        new .colon.colon((Object)"commit-id", (List)new .colon.colon((Object)"version", (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)name -> {
            MetricsTest.$anonfun$verifyClientVersionMetrics$1(this, metrics, entity, name);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void verifyBrokerAuthenticationMetrics(KafkaServer server) {
        Map metrics = server.metrics().metrics();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetricsTest.$anonfun$verifyBrokerAuthenticationMetrics$1(this, metrics)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)MetricsTest.$anonfun$verifyBrokerAuthenticationMetrics$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.verifyKafkaMetricRecorded("successful-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("successful-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
    }

    private void verifyBrokerMessageConversionMetrics(KafkaServer server, int recordSize, TopicPartition tp) {
        String requestMetricsPrefix = "kafka.network:type=RequestMetrics";
        double requestBytes = this.verifyYammerMetricRecorded(new StringBuilder(34).append(requestMetricsPrefix).append(",name=RequestBytes,request=Produce").toString(), this.verifyYammerMetricRecorded$default$2());
        double tempBytes = this.verifyYammerMetricRecorded(new StringBuilder(42).append(requestMetricsPrefix).append(",name=TemporaryMemoryBytes,request=Produce").toString(), this.verifyYammerMetricRecorded$default$2());
        Assertions.assertTrue((tempBytes >= (double)recordSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("Unexpected temporary memory size requestBytes ").append(requestBytes).append(" tempBytes ").append(tempBytes).toString());
        this.verifyYammerMetricRecorded("kafka.server:type=BrokerTopicMetrics,name=ProduceMessageConversionsPerSec", this.verifyYammerMetricRecorded$default$2());
        String verifyYammerMetricRecorded_name = new StringBuilder(46).append(requestMetricsPrefix).append(",name=MessageConversionsTimeMs,request=Produce").toString();
        double verifyYammerMetricRecorded_metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(verifyYammerMetricRecorded_name));
        Assertions.assertTrue((boolean)MetricsTest.$anonfun$verifyBrokerMessageConversionMetrics$1(verifyYammerMetricRecorded_metricValue), (String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(verifyYammerMetricRecorded_name).append(" value ").append(verifyYammerMetricRecorded_metricValue).toString());
        this.verifyYammerMetricRecorded(new StringBuilder(32).append(requestMetricsPrefix).append(",name=RequestBytes,request=Fetch").toString(), this.verifyYammerMetricRecorded$default$2());
        String verifyYammerMetricRecorded_name2 = new StringBuilder(40).append(requestMetricsPrefix).append(",name=TemporaryMemoryBytes,request=Fetch").toString();
        double verifyYammerMetricRecorded_metricValue2 = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(verifyYammerMetricRecorded_name2));
        Assertions.assertTrue((boolean)MetricsTest.$anonfun$verifyBrokerMessageConversionMetrics$2(verifyYammerMetricRecorded_metricValue2), (String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(verifyYammerMetricRecorded_name2).append(" value ").append(verifyYammerMetricRecorded_metricValue2).toString());
        this.verifyYammerMetricRecorded(new StringBuilder(35).append(requestMetricsPrefix).append(",name=RequestBytes,request=Metadata").toString(), this.verifyYammerMetricRecorded$default$2());
    }

    private void verifyBrokerZkMetrics(KafkaServer server, String topic) {
        Histogram histogram = this.yammerHistogram("kafka.server:type=ZooKeeperClientMetrics,name=ZooKeeperRequestLatencyMs");
        long initialCount = histogram.count();
        ((KafkaServer)this.servers().head()).zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assertions.assertTrue((histogram.count() > initialCount ? 1 : 0) != 0, (String)"ZooKeeper latency not recorded");
        double min = histogram.min();
        Assertions.assertTrue((min >= 0.0 ? 1 : 0) != 0, (String)new StringBuilder(36).append("Min latency should not be negative: ").append(min).toString());
        Assertions.assertEquals((Object)"CONNECTED", (Object)this.yammerMetricValue("SessionState"), (String)"Unexpected ZK state");
    }

    private void verifyBrokerErrorMetrics(KafkaServer server) {
        int startErrorMetricCount = MetricsTest.errorMetricCount$1();
        String errorMetricPrefix = "kafka.network:type=RequestMetrics,name=ErrorsPerSec";
        this.verifyYammerMetricRecorded(new StringBuilder(28).append(errorMetricPrefix).append(",request=Metadata,error=NONE").toString(), this.verifyYammerMetricRecorded$default$2());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        try {
            consumer.partitionsFor("12{}!");
        }
        catch (InvalidTopicException invalidTopicException) {}
        this.verifyYammerMetricRecorded(new StringBuilder(47).append(errorMetricPrefix).append(",request=Metadata,error=INVALID_TOPIC_EXCEPTION").toString(), this.verifyYammerMetricRecorded$default$2());
        int currentErrorMetricCount = MetricsTest.errorMetricCount$1();
        Assertions.assertEquals((int)(startErrorMetricCount + 1), (int)currentErrorMetricCount);
        Assertions.assertTrue((currentErrorMetricCount < 10 ? 1 : 0) != 0, (String)new StringBuilder(23).append("Too many error metrics ").append(currentErrorMetricCount).toString());
        try {
            consumer.partitionsFor("non-existing-topic");
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {}
        this.verifyYammerMetricRecorded(new StringBuilder(50).append(errorMetricPrefix).append(",request=Metadata,error=UNKNOWN_TOPIC_OR_PARTITION").toString(), this.verifyYammerMetricRecorded$default$2());
    }

    private <T> T verifyKafkaMetric(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group, Function1<Iterable<org.apache.kafka.common.Metric>, T> verify) {
        scala.collection.mutable.Map matchingMetrics = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(metrics).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, verifyKafkaMetric_group, x0$1)));
        Assertions.assertTrue((boolean)matchingMetrics.nonEmpty(), (String)new StringBuilder(17).append("Metric not found ").append(name).toString());
        return (T)verify.apply((Object)matchingMetrics.values());
    }

    private <T> Option<String> verifyKafkaMetric$default$4() {
        return None$.MODULE$;
    }

    private double maxKafkaMetricValue(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        scala.collection.mutable.Map verifyKafkaMetric_matchingMetrics = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(metrics).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, verifyKafkaMetric_group, x0$1)));
        Assertions.assertTrue((boolean)verifyKafkaMetric_matchingMetrics.nonEmpty(), (String)new StringBuilder(17).append("Metric not found ").append(name).toString());
        return MetricsTest.$anonfun$maxKafkaMetricValue$1(verifyKafkaMetric_matchingMetrics.values());
    }

    private void verifyKafkaMetricRecorded(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        double value = this.maxKafkaMetricValue(name, metrics, entity, group);
        Assertions.assertTrue((value > 0.0 ? 1 : 0) != 0, (String)new StringBuilder(42).append(entity).append(" metric not recorded correctly for ").append(name).append(" value ").append(value).toString());
    }

    private Option<String> verifyKafkaMetricRecorded$default$4() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private Object yammerMetricValue(String name) {
        void var4_4;
        scala.collection.mutable.Map allMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$yammerMetricValue$1(name, x0$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getMBeanName(), Set$.MODULE$.canBuildFrom())).toString()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        if (var4_4 instanceof Meter) {
            return BoxesRunTime.boxToDouble((double)((Meter)var4_4).count());
        }
        if (var4_4 instanceof Histogram) {
            return BoxesRunTime.boxToDouble((double)((Histogram)var4_4).max());
        }
        if (var4_4 instanceof Gauge) {
            return ((Gauge)var4_4).value();
        }
        return Assertions.fail((String)new StringBuilder(34).append("Unexpected broker metric of class ").append(var4_4.getClass()).toString());
    }

    /*
     * WARNING - void declaration
     */
    private Histogram yammerHistogram(String name) {
        void var4_4;
        scala.collection.mutable.Map allMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$yammerHistogram$1(name, x0$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getMBeanName(), Set$.MODULE$.canBuildFrom())).toString()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        if (var4_4 instanceof Histogram) {
            return (Histogram)var4_4;
        }
        throw new AssertionError((Object)new StringBuilder(34).append("Unexpected broker metric of class ").append(var4_4.getClass()).toString());
    }

    private double verifyYammerMetricRecorded(String name, Function1<Object, Object> verify) {
        double metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(name));
        Assertions.assertTrue((boolean)verify.apply$mcZD$sp(metricValue), (String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(name).append(" value ").append(metricValue).toString());
        return metricValue;
    }

    private Function1<Object, Object> verifyYammerMetricRecorded$default$2() {
        return (JFunction1.mcZD.sp & Serializable & scala.Serializable)d -> d > 0.0;
    }

    private void verifyNoRequestMetrics(String errorMessage) {
        scala.collection.mutable.Map metrics = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyNoRequestMetrics$1(x0$1)));
        Assertions.assertTrue((boolean)metrics.isEmpty(), (String)new StringBuilder(2).append(errorMessage).append(": ").append(metrics.keys()).toString());
    }

    private void verifyRemoteStorageMetrics(boolean shouldContainMetrics) {
        List metrics = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(RemoteStorageMetrics.allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyRemoteStorageMetrics$1(name)))).toList();
        if (shouldContainMetrics) {
            Assertions.assertEquals((int)RemoteStorageMetrics.allMetrics().size(), (int)metrics.size(), (String)new StringBuilder(27).append("Only ").append(metrics).append(" appear in the metrics").toString());
            return;
        }
        Assertions.assertEquals((int)0, (int)metrics.size(), (String)new StringBuilder(33).append(metrics).append(" should not appear in the metrics").toString());
    }

    private static final boolean exists$1(String name, MetricName rateMetricName, Set allMetricNames) {
        return allMetricNames.contains((Object)new MetricName(name, rateMetricName.group(), "", rateMetricName.tags()));
    }

    private static final void verify$1(MetricName rateMetricName, Set allMetricNames) {
        String name = rateMetricName.name();
        boolean totalExists = MetricsTest.exists$1(name.replace("-rate", "-total"), rateMetricName, allMetricNames);
        boolean totalTimeExists = MetricsTest.exists$1(name.replace("-rate", "-time"), rateMetricName, allMetricNames);
        Assertions.assertTrue((totalExists || totalTimeExists ? 1 : 0) != 0, (String)new StringBuilder(48).append("No cumulative count/time metric for rate metric ").append(rateMetricName).toString());
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(MetricName x$1) {
        return x$1.name().endsWith("-rate");
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(MetricName x$3) {
        return x$3.name().endsWith("-rate");
    }

    public static final /* synthetic */ void $anonfun$verifyClientVersionMetrics$2(String entity$1, String name$1, Iterable matchingMetrics) {
        Assertions.assertEquals((int)1, (int)matchingMetrics.size());
        org.apache.kafka.common.Metric metric = (org.apache.kafka.common.Metric)matchingMetrics.head();
        Object value = metric.metricValue();
        Assertions.assertNotNull((Object)value, (String)new StringBuilder(21).append(entity$1).append(" metric not recorded ").append(name$1).toString());
        Assertions.assertNotNull((Object)BoxesRunTime.boxToBoolean((value instanceof String && new StringOps(Predef$.MODULE$.augmentString((String)value)).nonEmpty() ? 1 : 0) != 0), (String)new StringBuilder(37).append(entity$1).append(" metric ").append(name$1).append(" should be a non-empty String").toString());
        Assertions.assertTrue((boolean)metric.metricName().tags().containsKey("client-id"), (String)"Client-id not specified");
    }

    public static final /* synthetic */ void $anonfun$verifyClientVersionMetrics$1(MetricsTest $this, Map metrics$1, String entity$1, String name) {
        Option<String> verifyKafkaMetric_group = $this.verifyKafkaMetric$default$4();
        scala.collection.mutable.Map verifyKafkaMetric_matchingMetrics = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(metrics$1).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, verifyKafkaMetric_group, x0$1)));
        Assertions.assertTrue((boolean)verifyKafkaMetric_matchingMetrics.nonEmpty(), (String)new StringBuilder(17).append("Metric not found ").append(name).toString());
        Iterable iterable = verifyKafkaMetric_matchingMetrics.values();
        MetricsTest.$anonfun$verifyClientVersionMetrics$2(entity$1, name, iterable);
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerAuthenticationMetrics$1(MetricsTest $this, Map metrics$2) {
        return $this.maxKafkaMetricValue("failed-authentication-total", metrics$2, "Broker", (Option<String>)new Some((Object)"socket-server-metrics")) > 0.0;
    }

    public static final /* synthetic */ String $anonfun$verifyBrokerAuthenticationMetrics$2() {
        return "failed-authentication-total not updated";
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerMessageConversionMetrics$1(double value) {
        return value > 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerMessageConversionMetrics$2(double value) {
        return value == 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerErrorMetrics$1(com.yammer.metrics.core.MetricName x$5) {
        String string = x$5.getName();
        String string2 = "ErrorsPerSec";
        return string != null && string.equals(string2);
    }

    private static final int errorMetricCount$1() {
        return ((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyBrokerErrorMetrics$1(x$5)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$2(MetricName metricName$1, String x$6) {
        String string = x$6;
        String string2 = metricName$1.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$1(String name$2, Option group$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName metricName = (MetricName)x0$1._1();
            String string = metricName.name();
            return !(string != null ? !string.equals(name$2) : name$2 != null) && group$1.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$2(metricName, x$6)));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$2(double max, org.apache.kafka.common.Metric metric) {
        return Math.max(max, BoxesRunTime.unboxToDouble((Object)metric.metricValue()));
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$1(Iterable matchingMetrics) {
        return BoxesRunTime.unboxToDouble((Object)matchingMetrics.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, metric) -> BoxesRunTime.boxToDouble((double)MetricsTest.$anonfun$maxKafkaMetricValue$2(BoxesRunTime.unboxToDouble((Object)max), metric))));
    }

    public static final /* synthetic */ boolean $anonfun$yammerMetricValue$1(String name$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().endsWith(name$3);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$yammerHistogram$1(String name$4, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().endsWith(name$4);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyNoRequestMetrics$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().startsWith("kafka.network:type=RequestMetrics");
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemoteStorageMetrics$2(com.yammer.metrics.core.MetricName name$5, Tuple2 metric) {
        return ((com.yammer.metrics.core.MetricName)metric._1()).getMBeanName().equals(name$5.getMBeanName());
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemoteStorageMetrics$1(com.yammer.metrics.core.MetricName name) {
        return ((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).find((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyRemoteStorageMetrics$2(name, metric))).isDefined();
    }

    public MetricsTest() {
        SaslSetup.$init$(this);
        this.brokerCount = 1;
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = new .colon.colon((Object)this.kafkaClientSaslMechanism(), (List)Nil$.MODULE$);
        this.kafkaServerJaasEntryName = new StringBuilder(1).append(this.listenerName().value().toLowerCase(Locale.ROOT)).append(".").append(JaasTestUtils$.MODULE$.KafkaServerContextName()).toString();
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "2.8");
        this.producerConfig().setProperty("linger.ms", "10");
        this.producerConfig().setProperty("compression.type", "gzip");
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
    }

    public static final /* synthetic */ Object $anonfun$maxKafkaMetricValue$1$adapted(Iterable matchingMetrics) {
        return BoxesRunTime.boxToDouble((double)MetricsTest.$anonfun$maxKafkaMetricValue$1(matchingMetrics));
    }

    public static final /* synthetic */ Object $anonfun$verifyClientVersionMetrics$2$adapted(String entity$1, String name$1, Iterable matchingMetrics) {
        MetricsTest.$anonfun$verifyClientVersionMetrics$2(entity$1, name$1, matchingMetrics);
        return BoxedUnit.UNIT;
    }
}

