/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.raft.KafkaRaftManager;
import kafka.server.DynamicBrokerConfig;
import kafka.server.FaultHandlerFactory;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.KafkaRaftServer$BrokerRole$;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.server.MetaProperties;
import kafka.server.Server$;
import kafka.server.metadata.BrokerServerMetrics;
import kafka.server.metadata.BrokerServerMetrics$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.metrics.ControllerMetadataMetrics;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.loader.MetadataLoader;
import org.apache.kafka.image.loader.metrics.MetadataLoaderMetrics;
import org.apache.kafka.image.publisher.SnapshotEmitter;
import org.apache.kafka.image.publisher.SnapshotGenerator;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tEg\u0001\u0002$H\u00011C\u0001\"\u0017\u0001\u0003\u0006\u0004%IA\u0017\u0005\t?\u0002\u0011\t\u0011)A\u00057\"A\u0001\r\u0001BC\u0002\u0013\u0005\u0011\r\u0003\u0005f\u0001\t\u0005\t\u0015!\u0003c\u0011!1\u0007A!b\u0001\n\u00039\u0007\u0002\u0003;\u0001\u0005\u0003\u0005\u000b\u0011\u00025\t\u0011U\u0004!Q1A\u0005\nYD\u0001\" \u0001\u0003\u0002\u0003\u0006Ia\u001e\u0005\t}\u0002\u0011)\u0019!C\u0001\u007f\"Q\u0011\u0011\u000b\u0001\u0003\u0002\u0003\u0006I!!\u0001\t\u0015\u0005M\u0003A!b\u0001\n\u0003\t)\u0006\u0003\u0006\u0002^\u0001\u0011\t\u0011)A\u0005\u0003/Bq!a\u0018\u0001\t\u0003\t\t\u0007C\u0005\u0002r\u0001\u0011\r\u0011\"\u0003\u0002t!A\u00111\u0010\u0001!\u0002\u0013\t)\bC\u0005\u0002~\u0001\u0001\r\u0011\"\u0003\u0002\u0000!I\u0011q\u0011\u0001A\u0002\u0013%\u0011\u0011\u0012\u0005\t\u0003+\u0003\u0001\u0015)\u0003\u0002\u0002\"I\u0011q\u0013\u0001A\u0002\u0013%\u0011q\u0010\u0005\n\u00033\u0003\u0001\u0019!C\u0005\u00037C\u0001\"a(\u0001A\u0003&\u0011\u0011\u0011\u0005\n\u0003C\u0003\u0001\u0019!C\u0005\u0003\u007fB\u0011\"a)\u0001\u0001\u0004%I!!*\t\u0011\u0005%\u0006\u0001)Q\u0005\u0003\u0003C\u0001\"a+\u0001\u0005\u0004%\tA\u0017\u0005\b\u0003[\u0003\u0001\u0015!\u0003\\\u0011!\ty\u000b\u0001b\u0001\n\u0003Q\u0006bBAY\u0001\u0001\u0006Ia\u0017\u0005\bu\u0002\u0001\r\u0011\"\u0001w\u0011%\t\u0019\f\u0001a\u0001\n\u0003\t)\fC\u0004\u0002:\u0002\u0001\u000b\u0015B<\t\u0017\u0005\r\u0007\u00011AA\u0002\u0013\u0005\u0011Q\u0019\u0005\f\u0003;\u0004\u0001\u0019!a\u0001\n\u0003\ty\u000eC\u0006\u0002d\u0002\u0001\r\u0011!Q!\n\u0005\u001d\u0007bCAt\u0001\u0001\u0007\t\u0019!C\u0001\u0003SD1\"a>\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002z\"Y\u0011Q \u0001A\u0002\u0003\u0005\u000b\u0015BAv\u0011-\u0011\t\u0001\u0001a\u0001\u0002\u0004%\tAa\u0001\t\u0017\tM\u0001\u00011AA\u0002\u0013\u0005!Q\u0003\u0005\f\u00053\u0001\u0001\u0019!A!B\u0013\u0011)\u0001C\u0006\u0003\u001e\u0001\u0001\r\u00111A\u0005\u0002\t}\u0001b\u0003B\u0018\u0001\u0001\u0007\t\u0019!C\u0001\u0005cA1B!\u000e\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003\"!I!\u0011\b\u0001C\u0002\u0013\u0005!1\b\u0005\t\u00053\u0002\u0001\u0015!\u0003\u0003>!Y!1\f\u0001A\u0002\u0003\u0007I\u0011\u0001B/\u0011-\u0011Y\u0007\u0001a\u0001\u0002\u0004%\tA!\u001c\t\u0017\tE\u0004\u00011A\u0001B\u0003&!q\f\u0005\f\u0005k\u0002\u0001\u0019!a\u0001\n\u0003\u00119\bC\u0006\u0003\u0000\u0001\u0001\r\u00111A\u0005\u0002\t\u0005\u0005b\u0003BC\u0001\u0001\u0007\t\u0011)Q\u0005\u0005sB1B!#\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003\f\"Y!q\u0013\u0001A\u0002\u0003\u0007I\u0011\u0001BM\u0011-\u0011i\n\u0001a\u0001\u0002\u0003\u0006KA!$\t\u000f\t\u0005\u0006\u0001\"\u0001\u0003$\"9!Q\u0015\u0001\u0005\u0002\t\u001d\u0006b\u0002BU\u0001\u0011\u0005!q\u0015\u0005\b\u0005W\u0003A\u0011\u0001BT\u0011\u001d\u0011i\u000b\u0001C\u0001\u0005OCqAa,\u0001\t\u0003\u0011\t\fC\u0004\u0003@\u0002!\tA!-\t\u000f\t\u0005\u0007\u0001\"\u0001\u00032\"9!1\u0019\u0001\u0005\u0002\tE\u0006b\u0002Bc\u0001\u0011\u0005!\u0011\u0017\u0005\b\u0005\u000f\u0004A\u0011\u0001BY\u0011\u001d\u0011I\r\u0001C\u0001\u0005cCqAa3\u0001\t\u0013\u00119\u000bC\u0004\u0003N\u0002!\tAa*\t\u000f\t=\u0007\u0001\"\u0003\u0003(\na1\u000b[1sK\u0012\u001cVM\u001d<fe*\u0011\u0001*S\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003)\u000bQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u001bN\u0003\"AT)\u000e\u0003=S\u0011\u0001U\u0001\u0006g\u000e\fG.Y\u0005\u0003%>\u0013a!\u00118z%\u00164\u0007C\u0001+X\u001b\u0005)&B\u0001,J\u0003\u0015)H/\u001b7t\u0013\tAVKA\u0004M_\u001e<\u0017N\\4\u0002%MD\u0017M]3e'\u0016\u0014h/\u001a:D_:4\u0017nZ\u000b\u00027B\u0011A,X\u0007\u0002\u000f&\u0011al\u0012\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\ntQ\u0006\u0014X\rZ*feZ,'oQ8oM&<\u0007%A\u0005nKR\f\u0007K]8qgV\t!\r\u0005\u0002]G&\u0011Am\u0012\u0002\u000f\u001b\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t\u0003)iW\r^1Qe>\u00048\u000fI\u0001\u0005i&lW-F\u0001i!\tI'/D\u0001k\u0015\t16N\u0003\u0002m[\u000611m\\7n_:T!A\u00138\u000b\u0005=\u0004\u0018AB1qC\u000eDWMC\u0001r\u0003\ry'oZ\u0005\u0003g*\u0014A\u0001V5nK\u0006)A/[7fA\u0005Aq,\\3ue&\u001c7/F\u0001x!\tA80D\u0001z\u0015\tQ8.A\u0004nKR\u0014\u0018nY:\n\u0005qL(aB'fiJL7m]\u0001\n?6,GO]5dg\u0002\nAdY8oiJ|G\u000e\\3s#V|'/^7W_R,'o\u001d$viV\u0014X-\u0006\u0002\u0002\u0002A1\u00111AA\t\u0003+i!!!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\u000bG>t7-\u001e:sK:$(\u0002BA\u0006\u0003\u001b\tA!\u001e;jY*\u0011\u0011qB\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0014\u0005\u0015!!E\"p[BdW\r^1cY\u00164U\u000f^;sKBA\u0011qCA\r\u0003;\tI#\u0004\u0002\u0002\n%!\u00111DA\u0005\u0005\ri\u0015\r\u001d\t\u0005\u0003?\t)#\u0004\u0002\u0002\")!\u00111EA\u0007\u0003\u0011a\u0017M\\4\n\t\u0005\u001d\u0012\u0011\u0005\u0002\b\u0013:$XmZ3s!\u0011\tY#a\u0013\u000f\t\u00055\u0012Q\t\b\u0005\u0003_\t\tE\u0004\u0003\u00022\u0005}b\u0002BA\u001a\u0003{qA!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003sY\u0015A\u0002\u001fs_>$h(C\u0001r\u0013\ty\u0007/\u0003\u0002K]&\u0019\u00111I7\u0002\tI\fg\r^\u0005\u0005\u0003\u000f\nI%\u0001\u0006SC\u001a$8i\u001c8gS\u001eT1!a\u0011n\u0013\u0011\ti%a\u0014\u0003\u0017\u0005#GM]3tgN\u0003Xm\u0019\u0006\u0005\u0003\u000f\nI%A\u000fd_:$(o\u001c7mKJ\fVo\u001c:v[Z{G/\u001a:t\rV$XO]3!\u0003M1\u0017-\u001e7u\u0011\u0006tG\r\\3s\r\u0006\u001cGo\u001c:z+\t\t9\u0006E\u0002]\u00033J1!a\u0017H\u0005M1\u0015-\u001e7u\u0011\u0006tG\r\\3s\r\u0006\u001cGo\u001c:z\u0003Q1\u0017-\u001e7u\u0011\u0006tG\r\\3s\r\u0006\u001cGo\u001c:zA\u00051A(\u001b8jiz\"b\"a\u0019\u0002f\u0005\u001d\u0014\u0011NA6\u0003[\ny\u0007\u0005\u0002]\u0001!)\u0011,\u0004a\u00017\")\u0001-\u0004a\u0001E\")a-\u0004a\u0001Q\")Q/\u0004a\u0001o\"1a0\u0004a\u0001\u0003\u0003Aq!a\u0015\u000e\u0001\u0004\t9&\u0001\u0006m_\u001e\u001cuN\u001c;fqR,\"!!\u001e\u0011\u0007%\f9(C\u0002\u0002z)\u0014!\u0002T8h\u0007>tG/\u001a=u\u0003-awnZ\"p]R,\u0007\u0010\u001e\u0011\u0002\u000fM$\u0018M\u001d;fIV\u0011\u0011\u0011\u0011\t\u0004\u001d\u0006\r\u0015bAAC\u001f\n9!i\\8mK\u0006t\u0017aC:uCJ$X\rZ0%KF$B!a#\u0002\u0012B\u0019a*!$\n\u0007\u0005=uJ\u0001\u0003V]&$\b\"CAJ#\u0005\u0005\t\u0019AAA\u0003\rAH%M\u0001\tgR\f'\u000f^3eA\u0005aQo]3e\u0005f\u0014%o\\6fe\u0006\u0001Ro]3e\u0005f\u0014%o\\6fe~#S-\u001d\u000b\u0005\u0003\u0017\u000bi\nC\u0005\u0002\u0014R\t\t\u00111\u0001\u0002\u0002\u0006iQo]3e\u0005f\u0014%o\\6fe\u0002\n\u0001#^:fI\nK8i\u001c8ue>dG.\u001a:\u0002)U\u001cX\r\u001a\"z\u0007>tGO]8mY\u0016\u0014x\fJ3r)\u0011\tY)a*\t\u0013\u0005Mu#!AA\u0002\u0005\u0005\u0015!E;tK\u0012\u0014\u0015pQ8oiJ|G\u000e\\3sA\u0005a!M]8lKJ\u001cuN\u001c4jO\u0006i!M]8lKJ\u001cuN\u001c4jO\u0002\n\u0001cY8oiJ|G\u000e\\3s\u0007>tg-[4\u0002#\r|g\u000e\u001e:pY2,'oQ8oM&<\u0007%A\u0006nKR\u0014\u0018nY:`I\u0015\fH\u0003BAF\u0003oC\u0001\"a%\u001f\u0003\u0003\u0005\ra^\u0001\t[\u0016$(/[2tA!\u001aq$!0\u0011\u00079\u000by,C\u0002\u0002B>\u0013\u0001B^8mCRLG.Z\u0001\fe\u00064G/T1oC\u001e,'/\u0006\u0002\u0002HB1\u0011\u0011ZAg\u0003#l!!a3\u000b\u0007\u0005\r\u0013*\u0003\u0003\u0002P\u0006-'\u0001E&bM.\f'+\u00194u\u001b\u0006t\u0017mZ3s!\u0011\t\u0019.!7\u000e\u0005\u0005U'b\u00017\u0002X*\u0011\u0001*\\\u0005\u0005\u00037\f)N\u0001\u000bBa&lUm]:bO\u0016\fe\u000e\u001a,feNLwN\\\u0001\u0010e\u00064G/T1oC\u001e,'o\u0018\u0013fcR!\u00111RAq\u0011%\t\u0019*IA\u0001\u0002\u0004\t9-\u0001\u0007sC\u001a$X*\u00198bO\u0016\u0014\b\u0005K\u0002#\u0003{\u000bQB\u0019:pW\u0016\u0014X*\u001a;sS\u000e\u001cXCAAv!\u0011\ti/a=\u000e\u0005\u0005=(bAAy\u000f\u0006AQ.\u001a;bI\u0006$\u0018-\u0003\u0003\u0002v\u0006=(a\u0005\"s_.,'oU3sm\u0016\u0014X*\u001a;sS\u000e\u001c\u0018!\u00052s_.,'/T3ue&\u001c7o\u0018\u0013fcR!\u00111RA~\u0011%\t\u0019\nJA\u0001\u0002\u0004\tY/\u0001\bce>\\WM]'fiJL7m\u001d\u0011)\u0007\u0015\ni,A\fd_:$(o\u001c7mKJ\u001cVM\u001d<fe6+GO]5dgV\u0011!Q\u0001\t\u0005\u0005\u000f\u0011y!\u0004\u0002\u0003\n)\u0019!Pa\u0003\u000b\u0007\t5Q.\u0001\u0006d_:$(o\u001c7mKJLAA!\u0005\u0003\n\tI2i\u001c8ue>dG.\u001a:NKR\fG-\u0019;b\u001b\u0016$(/[2t\u0003m\u0019wN\u001c;s_2dWM]*feZ,'/T3ue&\u001c7o\u0018\u0013fcR!\u00111\u0012B\f\u0011%\t\u0019jJA\u0001\u0002\u0004\u0011)!\u0001\rd_:$(o\u001c7mKJ\u001cVM\u001d<fe6+GO]5dg\u0002B3\u0001KA_\u0003\u0019aw.\u00193feV\u0011!\u0011\u0005\t\u0005\u0005G\u0011Y#\u0004\u0002\u0003&)!!Q\u0004B\u0014\u0015\r\u0011I#\\\u0001\u0006S6\fw-Z\u0005\u0005\u0005[\u0011)C\u0001\bNKR\fG-\u0019;b\u0019>\fG-\u001a:\u0002\u00151|\u0017\rZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002\f\nM\u0002\"CAJU\u0005\u0005\t\u0019\u0001B\u0011\u0003\u001daw.\u00193fe\u0002B3aKA_\u0003]\u0019h.\u00199tQ>$8\u000fR5tC\ndW\r\u001a*fCN|g.\u0006\u0002\u0003>A1!q\bB#\u0005\u0013j!A!\u0011\u000b\t\t\r\u0013QA\u0001\u0007CR|W.[2\n\t\t\u001d#\u0011\t\u0002\u0010\u0003R|W.[2SK\u001a,'/\u001a8dKB!!1\nB*\u001d\u0011\u0011iEa\u0014\u0011\u0007\u0005Ur*C\u0002\u0003R=\u000ba\u0001\u0015:fI\u00164\u0017\u0002\u0002B+\u0005/\u0012aa\u0015;sS:<'b\u0001B)\u001f\u0006A2O\\1qg\"|Go\u001d#jg\u0006\u0014G.\u001a3SK\u0006\u001cxN\u001c\u0011\u0002\u001fMt\u0017\r]:i_R,U.\u001b;uKJ,\"Aa\u0018\u0011\t\t\u0005$qM\u0007\u0003\u0005GRAA!\u001a\u0003(\u0005I\u0001/\u001e2mSNDWM]\u0005\u0005\u0005S\u0012\u0019GA\bT]\u0006\u00048\u000f[8u\u000b6LG\u000f^3s\u0003M\u0019h.\u00199tQ>$X)\\5ui\u0016\u0014x\fJ3r)\u0011\tYIa\u001c\t\u0013\u0005Mu&!AA\u0002\t}\u0013\u0001E:oCB\u001c\bn\u001c;F[&$H/\u001a:!Q\r\u0001\u0014QX\u0001\u0012g:\f\u0007o\u001d5pi\u001e+g.\u001a:bi>\u0014XC\u0001B=!\u0011\u0011\tGa\u001f\n\t\tu$1\r\u0002\u0012':\f\u0007o\u001d5pi\u001e+g.\u001a:bi>\u0014\u0018!F:oCB\u001c\bn\u001c;HK:,'/\u0019;pe~#S-\u001d\u000b\u0005\u0003\u0017\u0013\u0019\tC\u0005\u0002\u0014J\n\t\u00111\u0001\u0003z\u0005\u00112O\\1qg\"|GoR3oKJ\fGo\u001c:!Q\r\u0019\u0014QX\u0001\u0016[\u0016$\u0018\rZ1uC2{\u0017\rZ3s\u001b\u0016$(/[2t+\t\u0011i\t\u0005\u0003\u0003\u0010\nMUB\u0001BI\u0015\rQ(QE\u0005\u0005\u0005+\u0013\tJA\u000bNKR\fG-\u0019;b\u0019>\fG-\u001a:NKR\u0014\u0018nY:\u000235,G/\u00193bi\u0006du.\u00193fe6+GO]5dg~#S-\u001d\u000b\u0005\u0003\u0017\u0013Y\nC\u0005\u0002\u0014V\n\t\u00111\u0001\u0003\u000e\u00061R.\u001a;bI\u0006$\u0018\rT8bI\u0016\u0014X*\u001a;sS\u000e\u001c\b\u0005K\u00027\u0003{\u000ba![:Vg\u0016$GCAAA\u00039\u0019H/\u0019:u\r>\u0014(I]8lKJ$\"!a#\u0002%M$\u0018M\u001d;G_J\u001cuN\u001c;s_2dWM]\u0001\u000egR|\u0007OR8s\u0005J|7.\u001a:\u0002#M$x\u000e\u001d$pe\u000e{g\u000e\u001e:pY2,'/A\fsC\u001a$X*\u00198bO\u0016\u0014h)Y;mi\"\u000bg\u000e\u001a7feV\u0011!1\u0017\t\u0005\u0005k\u0013Y,\u0004\u0002\u00038*!!\u0011XAl\u0003\u00151\u0017-\u001e7u\u0013\u0011\u0011iLa.\u0003\u0019\u0019\u000bW\u000f\u001c;IC:$G.\u001a:\u000255,G/\u00193bi\u0006du.\u00193fe\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u0002;\r|g\u000e\u001e:pY2,'o\u0015;beR,\bOR1vYRD\u0015M\u001c3mKJ\fQ%\u001b8ji&\fGN\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018\rT8bI\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u0002C\u0019\fG/\u00197Rk>\u0014X/\\\"p]R\u0014x\u000e\u001c7fe\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u0002I9|gNR1uC2\fVo\u001c:v[\u000e{g\u000e\u001e:pY2,'OR1vYRD\u0015M\u001c3mKJ\fa$\\3uC\u0012\fG/\u0019)vE2L7\u000f[5oO\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u0002\u000bM$\u0018M\u001d;\u0002'\u0015t7/\u001e:f\u001d>$(+\u00194u\u0019\u0016\fG-\u001a:\u0002\tM$x\u000e\u001d")
public class SharedServer
implements Logging {
    private final KafkaConfig sharedServerConfig;
    private final MetaProperties metaProps;
    private final Time time;
    private final Metrics _metrics;
    private final CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final FaultHandlerFactory faultHandlerFactory;
    private final LogContext logContext;
    private boolean started;
    private boolean usedByBroker;
    private boolean usedByController;
    private final KafkaConfig brokerConfig;
    private final KafkaConfig controllerConfig;
    private volatile Metrics metrics;
    private volatile KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private volatile BrokerServerMetrics brokerMetrics;
    private volatile ControllerMetadataMetrics controllerServerMetrics;
    private volatile MetadataLoader loader;
    private final AtomicReference<String> snapshotsDisabledReason;
    private volatile SnapshotEmitter snapshotEmitter;
    private volatile SnapshotGenerator snapshotGenerator;
    private volatile MetadataLoaderMetrics metadataLoaderMetrics;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig sharedServerConfig() {
        return this.sharedServerConfig;
    }

    public MetaProperties metaProps() {
        return this.metaProps;
    }

    public Time time() {
        return this.time;
    }

    private Metrics _metrics() {
        return this._metrics;
    }

    public CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public FaultHandlerFactory faultHandlerFactory() {
        return this.faultHandlerFactory;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private boolean started() {
        return this.started;
    }

    private void started_$eq(boolean x$1) {
        this.started = x$1;
    }

    private boolean usedByBroker() {
        return this.usedByBroker;
    }

    private void usedByBroker_$eq(boolean x$1) {
        this.usedByBroker = x$1;
    }

    private boolean usedByController() {
        return this.usedByController;
    }

    private void usedByController_$eq(boolean x$1) {
        this.usedByController = x$1;
    }

    public KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    public KafkaConfig controllerConfig() {
        return this.controllerConfig;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public KafkaRaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public void raftManager_$eq(KafkaRaftManager<ApiMessageAndVersion> x$1) {
        this.raftManager = x$1;
    }

    public BrokerServerMetrics brokerMetrics() {
        return this.brokerMetrics;
    }

    public void brokerMetrics_$eq(BrokerServerMetrics x$1) {
        this.brokerMetrics = x$1;
    }

    public ControllerMetadataMetrics controllerServerMetrics() {
        return this.controllerServerMetrics;
    }

    public void controllerServerMetrics_$eq(ControllerMetadataMetrics x$1) {
        this.controllerServerMetrics = x$1;
    }

    public MetadataLoader loader() {
        return this.loader;
    }

    public void loader_$eq(MetadataLoader x$1) {
        this.loader = x$1;
    }

    public AtomicReference<String> snapshotsDisabledReason() {
        return this.snapshotsDisabledReason;
    }

    public SnapshotEmitter snapshotEmitter() {
        return this.snapshotEmitter;
    }

    public void snapshotEmitter_$eq(SnapshotEmitter x$1) {
        this.snapshotEmitter = x$1;
    }

    public SnapshotGenerator snapshotGenerator() {
        return this.snapshotGenerator;
    }

    public void snapshotGenerator_$eq(SnapshotGenerator x$1) {
        this.snapshotGenerator = x$1;
    }

    public MetadataLoaderMetrics metadataLoaderMetrics() {
        return this.metadataLoaderMetrics;
    }

    public void metadataLoaderMetrics_$eq(MetadataLoaderMetrics x$1) {
        this.metadataLoaderMetrics = x$1;
    }

    public synchronized boolean isUsed() {
        return this.usedByController() || this.usedByBroker();
    }

    public synchronized void startForBroker() {
        if (!this.isUsed()) {
            this.start();
        }
        this.usedByBroker_$eq(true);
    }

    public synchronized void startForController() {
        if (!this.isUsed()) {
            this.start();
        }
        this.usedByController_$eq(true);
    }

    public synchronized void stopForBroker() {
        if (this.usedByBroker()) {
            this.usedByBroker_$eq(false);
            if (!this.isUsed()) {
                this.stop();
                return;
            }
            return;
        }
    }

    public synchronized void stopForController() {
        if (this.usedByController()) {
            this.usedByController_$eq(false);
            if (!this.isUsed()) {
                this.stop();
                return;
            }
            return;
        }
    }

    public FaultHandler raftManagerFaultHandler() {
        return this.faultHandlerFactory().build("raft manager", true, () -> {});
    }

    public FaultHandler metadataLoaderFaultHandler() {
        return this.faultHandlerFactory().build("metadata loading", this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$), () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$metadataLoaderFaultHandler$2(x$1)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                    x$2.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "metadata loading fault");
                return;
            }
        });
    }

    public FaultHandler controllerStartupFaultHandler() {
        return this.faultHandlerFactory().build("controller startup", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    x$3.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "controller startup fault");
                return;
            }
        });
    }

    public FaultHandler initialBrokerMetadataLoadFaultHandler() {
        return this.faultHandlerFactory().build("initial broker metadata loading", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$initialBrokerMetadataLoadFaultHandler$2(x$4)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                    x$5.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "initial broker metadata loading fault");
                return;
            }
        });
    }

    public FaultHandler fatalQuorumControllerFaultHandler() {
        return this.faultHandlerFactory().build("quorum controller", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                    x$6.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "quorum controller fatal fault");
                return;
            }
        });
    }

    public FaultHandler nonFatalQuorumControllerFaultHandler() {
        return this.faultHandlerFactory().build("quorum controller", false, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                    x$7.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        });
    }

    public FaultHandler metadataPublishingFaultHandler() {
        return this.faultHandlerFactory().build("metadata publishing", false, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$metadataPublishingFaultHandler$2(x$8)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
                    x$9.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        });
    }

    private synchronized void start() {
        if (this.started()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "SharedServer has already been started.");
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting SharedServer");
        try {
            if (this.metrics() == null) {
                this.metrics_$eq(new Metrics());
            }
            this.sharedServerConfig().dynamicConfig().initialize((Option<KafkaZkClient>)None$.MODULE$);
            if (this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$)) {
                this.brokerMetrics_$eq(BrokerServerMetrics$.MODULE$.apply(this.metrics()));
            }
            if (this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$)) {
                this.controllerServerMetrics_$eq(new ControllerMetadataMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry())));
            }
            KafkaRaftManager<ApiMessageAndVersion> _raftManager = new KafkaRaftManager<ApiMessageAndVersion>(this.metaProps(), this.sharedServerConfig(), (RecordSerde<ApiMessageAndVersion>)new MetadataRecordSerde(), KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), this.time(), this.metrics(), (Option<String>)new Some((Object)new StringBuilder(11).append("kafka-").append(this.sharedServerConfig().nodeId()).append("-raft").toString()), this.controllerQuorumVotersFuture(), this.raftManagerFaultHandler());
            this.raftManager_$eq(_raftManager);
            _raftManager.startup();
            this.metadataLoaderMetrics_$eq(this.brokerMetrics() != null ? new MetadataLoaderMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry()), elapsedNs -> this.brokerMetrics().updateBatchProcessingTime(Predef$.MODULE$.Long2long(elapsedNs)), batchSize -> this.brokerMetrics().updateBatchSize(Predef$.MODULE$.Integer2int(batchSize)), this.brokerMetrics().lastAppliedImageProvenance()) : new MetadataLoaderMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry()), x$10 -> {}, x$11 -> {}, new AtomicReference<MetadataProvenance>(MetadataProvenance.EMPTY)));
            MetadataLoader.Builder loaderBuilder = new MetadataLoader.Builder().setNodeId(this.metaProps().nodeId()).setTime(this.time()).setThreadNamePrefix(new StringBuilder(7).append("kafka-").append(this.sharedServerConfig().nodeId()).append("-").toString()).setFaultHandler(this.metadataLoaderFaultHandler()).setHighWaterMarkAccessor(() -> _raftManager.client().highWatermark()).setMetrics(this.metadataLoaderMetrics());
            this.loader_$eq(loaderBuilder.build());
            this.snapshotEmitter_$eq(new SnapshotEmitter.Builder().setNodeId(this.metaProps().nodeId()).setRaftClient(_raftManager.client()).build());
            this.snapshotGenerator_$eq(new SnapshotGenerator.Builder((SnapshotGenerator.Emitter)this.snapshotEmitter()).setNodeId(this.metaProps().nodeId()).setTime(this.time()).setFaultHandler(this.metadataPublishingFaultHandler()).setMaxBytesSinceLastSnapshot(Predef$.MODULE$.Long2long(this.sharedServerConfig().metadataSnapshotMaxNewRecordBytes())).setMaxTimeSinceLastSnapshotNs(TimeUnit.MILLISECONDS.toNanos(Predef$.MODULE$.Long2long(this.sharedServerConfig().metadataSnapshotMaxIntervalMs()))).setDisabledReason(this.snapshotsDisabledReason()).setThreadNamePrefix(new StringBuilder(7).append("kafka-").append(this.sharedServerConfig().nodeId()).append("-").toString()).build());
            try {
                this.loader().installPublishers(Arrays.asList((Object[])new SnapshotGenerator[]{this.snapshotGenerator()})).get();
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unable to install metadata publishers", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                throw new RuntimeException("Unable to install metadata publishers.", t);
            }
            _raftManager.register((RaftClient.Listener<ApiMessageAndVersion>)this.loader());
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Completed SharedServer startup.");
            this.started_$eq(true);
            return;
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Got exception while starting SharedServer", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            this.stop();
            return;
        }
    }

    public synchronized void ensureNotRaftLeader() {
        Option$.MODULE$.apply(this.raftManager()).foreach((Function1 & Serializable & scala.Serializable)_raftManager -> {
            SharedServer.$anonfun$ensureNotRaftLeader$1(this, _raftManager);
            return BoxedUnit.UNIT;
        });
    }

    private synchronized void stop() {
        if (!this.started()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "SharedServer is not running.");
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping SharedServer");
        if (this.loader() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.loader().beginShutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        if (this.snapshotGenerator() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.snapshotGenerator().beginShutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        if (this.loader() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.loader().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.loader_$eq(null);
        }
        if (this.metadataLoaderMetrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.metadataLoaderMetrics().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.metadataLoaderMetrics_$eq(null);
        }
        if (this.snapshotGenerator() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.snapshotGenerator().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.snapshotGenerator_$eq(null);
        }
        if (this.raftManager() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.raftManager().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.raftManager_$eq(null);
        }
        if (this.controllerServerMetrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.controllerServerMetrics().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.controllerServerMetrics_$eq(null);
        }
        if (this.brokerMetrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.brokerMetrics().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.brokerMetrics_$eq(null);
        }
        if (this.metrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.metrics().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.metrics_$eq(null);
        }
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AppInfoParser.unregisterAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString(this.sharedServerConfig().nodeId()), (Metrics)this.metrics()), this, CoreUtils$.MODULE$.swallow$default$3());
        this.started_$eq(false);
    }

    public static final /* synthetic */ long $anonfun$metadataLoaderFaultHandler$2(BrokerServerMetrics x$1) {
        return x$1.metadataLoadErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ long $anonfun$initialBrokerMetadataLoadFaultHandler$2(BrokerServerMetrics x$4) {
        return x$4.metadataApplyErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ long $anonfun$metadataPublishingFaultHandler$2(BrokerServerMetrics x$8) {
        return x$8.metadataApplyErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ void $anonfun$ensureNotRaftLeader$1(SharedServer $this, KafkaRaftManager _raftManager) {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> _raftManager.shutdown(), $this, CoreUtils$.MODULE$.swallow$default$3());
        $this.raftManager_$eq(null);
    }

    public SharedServer(KafkaConfig sharedServerConfig, MetaProperties metaProps, Time time, Metrics _metrics, CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture, FaultHandlerFactory faultHandlerFactory) {
        this.sharedServerConfig = sharedServerConfig;
        this.metaProps = metaProps;
        this.time = time;
        this._metrics = _metrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.faultHandlerFactory = faultHandlerFactory;
        Logging.$init$(this);
        this.logContext = new LogContext(new StringBuilder(19).append("[SharedServer id=").append(sharedServerConfig.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.started = false;
        this.usedByBroker = false;
        this.usedByController = false;
        this.brokerConfig = new KafkaConfig(sharedServerConfig.props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$);
        this.controllerConfig = new KafkaConfig(sharedServerConfig.props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$);
        this.metrics = _metrics;
        this.snapshotsDisabledReason = new AtomicReference<Object>(null);
    }
}

