/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.server.AlterPartitionItem;
import kafka.server.AlterPartitionManager;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.OperationNotAttemptedException;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001\u0002\u000e\u001c\u0001\u0001B\u0001\"\r\u0001\u0003\u0006\u0004%\tA\r\u0005\tm\u0001\u0011\t\u0011)A\u0005g!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003:\u0011!1\u0005A!b\u0001\n\u00039\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u0011A\u0003!Q1A\u0005\u0002EC\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\t-\u0002\u0011)\u0019!C\u0001/\"Aa\f\u0001B\u0001B\u0003%\u0001\f\u0003\u0005`\u0001\t\u0015\r\u0011\"\u0001a\u0011!9\u0007A!A!\u0002\u0013\t\u0007\"\u00025\u0001\t\u0003I\u0007\u0002C9\u0001\u0005\u0004%\ta\u0007:\t\u000f\u0005\r\u0001\u0001)A\u0005g\"I\u0011Q\u0001\u0001C\u0002\u0013%\u0011q\u0001\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\n!9\u00111\u0004\u0001\u0005B\u0005u\u0001bBA\u0013\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003O\u0001A\u0011IA\u0015\u0011!\t\t\u0006\u0001C\u00017\u0005u\u0001\u0002CA*\u0001\u0011\u00051$!\b\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X!9\u0011Q\u000f\u0001\u0005\n\u0005]\u0004bBA_\u0001\u0011\u0005\u0011q\u0018\u0002\u001d\t\u00164\u0017-\u001e7u\u00032$XM\u001d)beRLG/[8o\u001b\u0006t\u0017mZ3s\u0015\taR$\u0001\u0004tKJ4XM\u001d\u0006\u0002=\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\"O-\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0007C\u0001\u0015*\u001b\u0005Y\u0012B\u0001\u0016\u001c\u0005U\tE\u000e^3s!\u0006\u0014H/\u001b;j_:l\u0015M\\1hKJ\u0004\"\u0001L\u0018\u000e\u00035R!AL\u000f\u0002\u000bU$\u0018\u000e\\:\n\u0005Aj#a\u0002'pO\u001eLgnZ\u0001\u0019G>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014X#A\u001a\u0011\u0005!\"\u0014BA\u001b\u001c\u0005\u0001\u0012%o\\6feR{7i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u00023\r|g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'\u000fI\u0001\ng\u000eDW\rZ;mKJ,\u0012!\u000f\t\u0003u\rk\u0011a\u000f\u0006\u0003yu\nA!\u001e;jY*\u0011AD\u0010\u0006\u0003=}R!\u0001Q!\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0015aA8sO&\u0011Ai\u000f\u0002\n'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u0003\u0011!\u0018.\\3\u0016\u0003!\u0003\"!S'\u000e\u0003)S!AL&\u000b\u00051s\u0014AB2p[6|g.\u0003\u0002O\u0015\n!A+[7f\u0003\u0015!\u0018.\\3!\u0003!\u0011'o\\6fe&#W#\u0001*\u0011\u0005\t\u001a\u0016B\u0001+$\u0005\rIe\u000e^\u0001\nEJ|7.\u001a:JI\u0002\n1C\u0019:pW\u0016\u0014X\t]8dQN+\b\u000f\u001d7jKJ,\u0012\u0001\u0017\t\u0004Ee[\u0016B\u0001.$\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002#9&\u0011Ql\t\u0002\u0005\u0019>tw-\u0001\u000bce>\\WM]#q_\u000eD7+\u001e9qY&,'\u000fI\u0001\u0018[\u0016$\u0018\rZ1uCZ+'o]5p]N+\b\u000f\u001d7jKJ,\u0012!\u0019\t\u0004Ee\u0013\u0007CA2f\u001b\u0005!'B\u0001'>\u0013\t1GMA\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0003aiW\r^1eCR\fg+\u001a:tS>t7+\u001e9qY&,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f)\\G.\u001c8paB\u0011\u0001\u0006\u0001\u0005\u0006c5\u0001\ra\r\u0005\u0006o5\u0001\r!\u000f\u0005\u0006\r6\u0001\r\u0001\u0013\u0005\u0006!6\u0001\rA\u0015\u0005\u0006-6\u0001\r\u0001\u0017\u0005\u0006?6\u0001\r!Y\u0001\u0011k:\u001cXM\u001c;JgJ,\u0006\u000fZ1uKN,\u0012a\u001d\t\u0005ibTh0D\u0001v\u0015\tadOC\u0001x\u0003\u0011Q\u0017M^1\n\u0005e,(aA'baB\u00111\u0010`\u0007\u0002\u0017&\u0011Qp\u0013\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\tAs0C\u0002\u0002\u0002m\u0011!#\u00117uKJ\u0004\u0016M\u001d;ji&|g.\u0013;f[\u0006\tRO\\:f]RL5O]+qI\u0006$Xm\u001d\u0011\u0002\u001f%tg\r\\5hQR\u0014V-];fgR,\"!!\u0003\u0011\t\u0005-\u0011QC\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u00051\u0011\r^8nS\u000eT1!a\u0005v\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003/\tiAA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u0011S:4G.[4iiJ+\u0017/^3ti\u0002\nQa\u001d;beR$\"!a\b\u0011\u0007\t\n\t#C\u0002\u0002$\r\u0012A!\u00168ji\u0006A1\u000f[;uI><h.\u0001\u0004tk\nl\u0017\u000e\u001e\u000b\t\u0003W\ty$!\u0013\u0002NA1\u0011QFA\u0018\u0003gi!!!\u0005\n\t\u0005E\u0012\u0011\u0003\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007\u0003BA\u001b\u0003wi!!a\u000e\u000b\u0007\u0005eR$A\u0002ba&LA!!\u0010\u00028\taA*Z1eKJ\fe\u000eZ%te\"9\u0011\u0011\t\u000bA\u0002\u0005\r\u0013\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o!\rY\u0018QI\u0005\u0004\u0003\u000fZ%\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0011\u001d\tY\u0005\u0006a\u0001\u0003g\tA\u0002\\3bI\u0016\u0014\u0018I\u001c3JgJDa!a\u0014\u0015\u0001\u0004\u0011\u0016aD2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\u000215\f\u0017PY3Qe>\u0004\u0018mZ1uK&\u001b(o\u00115b]\u001e,7/\u0001\u000bdY\u0016\f'/\u00138GY&<\u0007\u000e\u001e*fcV,7\u000f^\u0001\fg\u0016tGMU3rk\u0016\u001cH\u000f\u0006\u0003\u0002 \u0005e\u0003bBA./\u0001\u0007\u0011QL\u0001\u001cS:4G.[4ii\u0006cG/\u001a:QCJ$\u0018\u000e^5p]&#X-\\:\u0011\u000b\u0005}\u0013q\u000e@\u000f\t\u0005\u0005\u00141\u000e\b\u0005\u0003G\nI'\u0004\u0002\u0002f)\u0019\u0011qM\u0010\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0013bAA7G\u00059\u0001/Y2lC\u001e,\u0017\u0002BA9\u0003g\u00121aU3r\u0015\r\tigI\u0001\rEVLG\u000e\u001a*fcV,7\u000f\u001e\u000b\u0007\u0003s\n9,!/\u0011\u000f\t\nY(a \u0002\u0014&\u0019\u0011QP\u0012\u0003\rQ+\b\u000f\\33!\u0011\t\t)!$\u000f\t\u0005\r\u0015\u0011R\u0007\u0003\u0003\u000bS1!a\"L\u0003!\u0011X-];fgR\u001c\u0018\u0002BAF\u0003\u000b\u000bQ#\u00117uKJ\u0004\u0016M\u001d;ji&|gNU3rk\u0016\u001cH/\u0003\u0003\u0002\u0010\u0006E%a\u0002\"vS2$WM\u001d\u0006\u0005\u0003\u0017\u000b)\t\u0005\u0005\u0002\u0016\u0006}\u0015\u0011UAT\u001b\t\t9J\u0003\u0003\u0002\u001a\u0006m\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003;\u001b\u0013AC2pY2,7\r^5p]&\u0019\u00110a&\u0011\u0007m\f\u0019+C\u0002\u0002&.\u0013A!V;jIB!\u0011\u0011VAY\u001d\u0011\tY+!,\u0011\u0007\u0005\r4%C\u0002\u00020\u000e\na\u0001\u0015:fI\u00164\u0017\u0002BAZ\u0003k\u0013aa\u0015;sS:<'bAAXG!9\u00111\f\rA\u0002\u0005u\u0003BBA^1\u0001\u00071,A\u0006ce>\\WM]#q_\u000eD\u0017\u0001\b5b]\u0012dW-\u00117uKJ\u0004\u0016M\u001d;ji&|gNU3ta>t7/\u001a\u000b\r\u0003\u0003\fi-a6\u0002b\u0006\u0015\u0018q\u001d\t\u0005\u0003\u0007\fI-\u0004\u0002\u0002F*\u0019\u0011qY&\u0002\u0011A\u0014x\u000e^8d_2LA!a3\u0002F\n1QI\u001d:peNDq!a4\u001a\u0001\u0004\t\t.A\u0007sKF,Xm\u001d;IK\u0006$WM\u001d\t\u0005\u0003\u0007\u000b\u0019.\u0003\u0003\u0002V\u0006\u0015%!\u0004*fcV,7\u000f\u001e%fC\u0012,'\u000fC\u0004\u0002Zf\u0001\r!a7\u0002%\u0005dG/\u001a:QCJ$\u0018\u000e^5p]J+7\u000f\u001d\t\u0005\u0003\u0007\u000bi.\u0003\u0003\u0002`\u0006\u0015%AF!mi\u0016\u0014\b+\u0019:uSRLwN\u001c*fgB|gn]3\t\r\u0005\r\u0018\u00041\u0001\\\u0003=\u0019XM\u001c;Ce>\\WM]#q_\u000eD\u0007bBA.3\u0001\u0007\u0011Q\f\u0005\b\u0003SL\u0002\u0019AAJ\u0003=!x\u000e]5d\u001d\u0006lWm\u001d\"z\u0013\u0012\u001c\b")
public class DefaultAlterPartitionManager
implements AlterPartitionManager,
Logging {
    private final BrokerToControllerChannelManager controllerChannelManager;
    private final Scheduler scheduler;
    private final Time time;
    private final int brokerId;
    private final Function0<Object> brokerEpochSupplier;
    private final Function0<MetadataVersion> metadataVersionSupplier;
    private final Map<TopicPartition, AlterPartitionItem> unsentIsrUpdates;
    private final AtomicBoolean inflightRequest;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public BrokerToControllerChannelManager controllerChannelManager() {
        return this.controllerChannelManager;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Time time() {
        return this.time;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Function0<Object> brokerEpochSupplier() {
        return this.brokerEpochSupplier;
    }

    public Function0<MetadataVersion> metadataVersionSupplier() {
        return this.metadataVersionSupplier;
    }

    public Map<TopicPartition, AlterPartitionItem> unsentIsrUpdates() {
        return this.unsentIsrUpdates;
    }

    private AtomicBoolean inflightRequest() {
        return this.inflightRequest;
    }

    @Override
    public void start() {
        this.controllerChannelManager().start();
    }

    @Override
    public void shutdown() {
        this.controllerChannelManager().shutdown();
    }

    @Override
    public CompletableFuture<LeaderAndIsr> submit(TopicIdPartition topicIdPartition, LeaderAndIsr leaderAndIsr, int controllerEpoch) {
        CompletableFuture<LeaderAndIsr> future = new CompletableFuture<LeaderAndIsr>();
        AlterPartitionItem alterPartitionItem = new AlterPartitionItem(topicIdPartition, leaderAndIsr, future, controllerEpoch);
        if (this.unsentIsrUpdates().putIfAbsent(alterPartitionItem.topicIdPartition().topicPartition(), alterPartitionItem) == null) {
            this.maybePropagateIsrChanges();
        } else {
            future.completeExceptionally((Throwable)new OperationNotAttemptedException(new StringBuilder(50).append("Failed to enqueue ISR change state ").append(leaderAndIsr).append(" for partition ").append(topicIdPartition).toString()));
        }
        return future;
    }

    public void maybePropagateIsrChanges() {
        if (!this.unsentIsrUpdates().isEmpty() && this.inflightRequest().compareAndSet(false, true)) {
            ListBuffer inflightAlterPartitionItems = new ListBuffer();
            this.unsentIsrUpdates().values().forEach(item -> inflightAlterPartitionItems.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterPartitionItem[]{item})));
            this.sendRequest((Seq<AlterPartitionItem>)inflightAlterPartitionItems.toSeq());
            return;
        }
    }

    public void clearInFlightRequest() {
        if (!this.inflightRequest().compareAndSet(true, false)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempting to clear AlterPartition in-flight flag when no apparent request is in-flight");
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sendRequest(Seq<AlterPartitionItem> inflightAlterPartitionItems) {
        void var6_5;
        void var5_4;
        long brokerEpoch = this.brokerEpochSupplier().apply$mcJ$sp();
        Tuple2<AlterPartitionRequest.Builder, scala.collection.mutable.Map<Uuid, String>> tuple2 = this.buildRequest(inflightAlterPartitionItems, brokerEpoch);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        AlterPartitionRequest.Builder request = (AlterPartitionRequest.Builder)tuple2._1();
        scala.collection.mutable.Map topicNamesByIds = (scala.collection.mutable.Map)tuple2._2();
        void request2 = var5_4;
        void topicNamesByIds2 = var6_5;
        this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> DefaultAlterPartitionManager.$anonfun$sendRequest$1((AlterPartitionRequest.Builder)request2)));
        this.controllerChannelManager().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)request2, new ControllerRequestCompletionHandler(this, brokerEpoch, inflightAlterPartitionItems, (scala.collection.mutable.Map)topicNamesByIds2){
            private final /* synthetic */ DefaultAlterPartitionManager $outer;
            private final long brokerEpoch$1;
            private final Seq inflightAlterPartitionItems$2;
            private final scala.collection.mutable.Map topicNamesByIds$1;

            public void onComplete(ClientResponse response) {
                Errors errors;
                this.$outer.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Received AlterPartition response ").append(response).toString());
                try {
                    errors = response.authenticationException() != null ? Errors.NETWORK_EXCEPTION : (response.versionMismatch() != null ? Errors.UNSUPPORTED_VERSION : this.$outer.handleAlterPartitionResponse(response.requestHeader(), (AlterPartitionResponse)response.responseBody(), this.brokerEpoch$1, (Seq<AlterPartitionItem>)this.inflightAlterPartitionItems$2, (scala.collection.mutable.Map<Uuid, String>)this.topicNamesByIds$1));
                }
                finally {
                    this.$outer.clearInFlightRequest();
                }
                Errors error = errors;
                if (Errors.NONE.equals(error)) {
                    this.$outer.maybePropagateIsrChanges();
                    return;
                }
                this.$outer.scheduler().scheduleOnce("send-alter-partition", () -> $this.$outer.maybePropagateIsrChanges(), 50L);
            }

            public void onTimeout() {
                throw new IllegalStateException("Encountered unexpected timeout when sending AlterPartition to the controller");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.brokerEpoch$1 = brokerEpoch$1;
                this.inflightAlterPartitionItems$2 = inflightAlterPartitionItems$2;
                this.topicNamesByIds$1 = topicNamesByIds$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(org.apache.kafka.clients.ClientResponse )}, serializedLambda);
            }
        });
    }

    private Tuple2<AlterPartitionRequest.Builder, scala.collection.mutable.Map<Uuid, String>> buildRequest(Seq<AlterPartitionItem> inflightAlterPartitionItems, long brokerEpoch) {
        MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionSupplier().apply();
        HashMap topicNamesByIds = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef canUseTopicIds = BooleanRef.create((boolean)metadataVersion.isTopicIdsSupported());
        AlterPartitionRequestData message = new AlterPartitionRequestData().setBrokerId(this.brokerId()).setBrokerEpoch(brokerEpoch);
        inflightAlterPartitionItems.groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.topicIdPartition().topic()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DefaultAlterPartitionManager.$anonfun$buildRequest$2(canUseTopicIds, topicNamesByIds, message, metadataVersion, x0$1);
            return BoxedUnit.UNIT;
        });
        return new Tuple2((Object)new AlterPartitionRequest.Builder(message, canUseTopicIds.elem), (Object)topicNamesByIds);
    }

    public Errors handleAlterPartitionResponse(RequestHeader requestHeader, AlterPartitionResponse alterPartitionResp, long sentBrokerEpoch, Seq<AlterPartitionItem> inflightAlterPartitionItems, scala.collection.mutable.Map<Uuid, String> topicNamesByIds) {
        AlterPartitionResponseData data = alterPartitionResp.data();
        Errors errors = Errors.forCode((short)data.errorCode());
        if (Errors.STALE_BROKER_EPOCH.equals(errors)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Broker had a stale broker epoch (").append(sentBrokerEpoch).append("), retrying.").toString());
        } else if (Errors.CLUSTER_AUTHORIZATION_FAILED.equals(errors)) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Broker is not authorized to send AlterPartition to controller", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> Errors.CLUSTER_AUTHORIZATION_FAILED.exception("Broker is not authorized to send AlterPartition to controller"));
        } else if (Errors.NONE.equals(errors)) {
            HashMap partitionResponses = new HashMap();
            data.topics().forEach(topic -> {
                String topicName;
                String string = topicName = requestHeader.apiVersion() > 1 ? (String)topicNamesByIds.get((Object)topic.topicId()).orNull(Predef$.MODULE$.$conforms()) : topic.topicName();
                if (topicName == null || topicName.isEmpty()) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Received an unexpected topic ").append(topic).append(" in the alter partition response, ignoring it.").toString());
                    return;
                }
                topic.partitions().forEach(partition -> {
                    TopicPartition tp = new TopicPartition(topicName, partition.partitionIndex());
                    Errors apiError = Errors.forCode((short)partition.errorCode());
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Controller successfully handled AlterPartition request for ").append(tp).append(": ").append(partition).toString());
                    Errors errors = apiError;
                    Errors errors2 = Errors.NONE;
                    if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(LeaderRecoveryState.optionalOf((byte)partition.leaderRecoveryState())));
                        if (option instanceof Some) {
                            LeaderRecoveryState leaderRecoveryState = (LeaderRecoveryState)((Some)option).value();
                            partitionResponses.update((Object)tp, (Object)package$.MODULE$.Right().apply((Object)LeaderAndIsr$.MODULE$.apply(partition.leaderId(), partition.leaderEpoch(), (List<Object>)((List)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(partition.isr()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$3)), List$.MODULE$.canBuildFrom())), leaderRecoveryState, partition.partitionEpoch())));
                            return;
                        }
                        if (None$.MODULE$.equals(option)) {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Controller returned an invalid leader recovery state (").append(partition.leaderRecoveryState()).append(") for ").append(tp).append(": ").append(partition).toString());
                            partitionResponses.update((Object)tp, (Object)package$.MODULE$.Left().apply((Object)Errors.UNKNOWN_SERVER_ERROR));
                            return;
                        }
                        throw new MatchError((Object)option);
                    }
                    partitionResponses.update((Object)tp, (Object)package$.MODULE$.Left().apply((Object)apiError));
                });
            });
            inflightAlterPartitionItems.foreach((Function1 & Serializable & scala.Serializable)inflightAlterPartition -> {
                Option option = partitionResponses.get((Object)inflightAlterPartition.topicIdPartition().topicPartition());
                if (option instanceof Some) {
                    boolean bl;
                    Either leaderAndIsrOrError = (Either)((Some)option).value();
                    this.unsentIsrUpdates().remove(inflightAlterPartition.topicIdPartition().topicPartition());
                    if (leaderAndIsrOrError instanceof Left) {
                        Errors error = (Errors)((Left)leaderAndIsrOrError).value();
                        bl = inflightAlterPartition.future().completeExceptionally((Throwable)error.exception());
                    } else if (leaderAndIsrOrError instanceof Right) {
                        LeaderAndIsr leaderAndIsr = (LeaderAndIsr)((Right)leaderAndIsrOrError).value();
                        bl = inflightAlterPartition.future().complete(leaderAndIsr);
                    } else {
                        throw new MatchError((Object)leaderAndIsrOrError);
                    }
                    return BoxesRunTime.boxToBoolean((boolean)bl);
                }
                if (None$.MODULE$.equals(option)) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Partition ").append(inflightAlterPartition.topicIdPartition()).append(" was sent but not included in the response").toString());
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)option);
            });
        } else {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("Controller returned an unexpected top-level error when handling AlterPartition request: ").append(errors).toString());
        }
        return Errors.forCode((short)data.errorCode());
    }

    public static final /* synthetic */ String $anonfun$sendRequest$1(AlterPartitionRequest.Builder request$1) {
        return new StringBuilder(37).append("Sending AlterPartition to controller ").append(request$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$buildRequest$3(MetadataVersion metadataVersion$1, AlterPartitionRequestData.TopicData topicData$1, AlterPartitionItem item) {
        AlterPartitionRequestData.PartitionData partitionData = new AlterPartitionRequestData.PartitionData().setPartitionIndex(item.topicIdPartition().partition()).setLeaderEpoch(item.leaderAndIsr().leaderEpoch()).setNewIsrWithEpochs((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(item.leaderAndIsr().isrWithBrokerEpoch()).asJava()).setPartitionEpoch(item.leaderAndIsr().partitionEpoch());
        if (metadataVersion$1.isLeaderRecoverySupported()) {
            partitionData.setLeaderRecoveryState(item.leaderAndIsr().leaderRecoveryState().value());
        }
        return topicData$1.partitions().add(partitionData);
    }

    public static final /* synthetic */ void $anonfun$buildRequest$2(BooleanRef canUseTopicIds$1, HashMap topicNamesByIds$2, AlterPartitionRequestData message$1, MetadataVersion metadataVersion$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String topicName = (String)x0$1._1();
            Seq items = (Seq)x0$1._2();
            Uuid topicId = ((AlterPartitionItem)items.head()).topicIdPartition().topicId();
            Uuid uuid = topicId;
            Uuid uuid2 = Uuid.ZERO_UUID;
            canUseTopicIds$1.elem = canUseTopicIds$1.elem & (uuid == null ? uuid2 != null : !uuid.equals(uuid2));
            topicNamesByIds$2.update((Object)topicId, (Object)topicName);
            AlterPartitionRequestData.TopicData topicData = new AlterPartitionRequestData.TopicData().setTopicName(topicName).setTopicId(topicId);
            message$1.topics().add(topicData);
            items.foreach((Function1 & Serializable & scala.Serializable)item -> BoxesRunTime.boxToBoolean((boolean)DefaultAlterPartitionManager.$anonfun$buildRequest$3(metadataVersion$1, topicData, item)));
            return;
        }
        throw new MatchError(null);
    }

    public DefaultAlterPartitionManager(BrokerToControllerChannelManager controllerChannelManager, Scheduler scheduler, Time time, int brokerId, Function0<Object> brokerEpochSupplier, Function0<MetadataVersion> metadataVersionSupplier) {
        this.controllerChannelManager = controllerChannelManager;
        this.scheduler = scheduler;
        this.time = time;
        this.brokerId = brokerId;
        this.brokerEpochSupplier = brokerEpochSupplier;
        this.metadataVersionSupplier = metadataVersionSupplier;
        AlterPartitionManager.$init$(this);
        Logging.$init$(this);
        this.unsentIsrUpdates = new ConcurrentHashMap<TopicPartition, AlterPartitionItem>();
        this.inflightRequest = new AtomicBoolean(false);
    }
}

