/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.ProducerIdManager$;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.ProducerIdsBlock;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\u000b\u0017\u0001uA\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0011\u0015i\u0005\u0001\"\u0001O\u0011!!\u0006\u00011A\u0005\u0002Y)\u0006\u0002\u00035\u0001\u0001\u0004%\tAF5\t\r=\u0004\u0001\u0015)\u0003W\u0011\u001d\u0001\bA1A\u0005\nUCa!\u001d\u0001!\u0002\u00131\u0006b\u0002:\u0001\u0005\u0004%Ia\u001d\u0005\u0007o\u0002\u0001\u000b\u0011\u0002;\t\u000fa\u0004!\u0019!C\u0005s\"1Q\u0010\u0001Q\u0001\niDQA \u0001\u0005B}Dq!a\u0002\u0001\t\u0003\nI\u0001\u0003\u0005\u0002\u0016\u0001!\tAFA\f\u0011!\tI\u0002\u0001C\u0001-\u0005]\u0001\u0002CA\u000e\u0001\u0011\u0005a#!\b\t\u000f\u0005=\u0002\u0001\"\u0003\u0002\u0018\t!\"\u000bU\"Qe>$WoY3s\u0013\u0012l\u0015M\\1hKJT!a\u0006\r\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u00033i\t1bY8pe\u0012Lg.\u0019;pe*\t1$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001qB\u0005\u000b\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u00152S\"\u0001\f\n\u0005\u001d2\"!\u0005)s_\u0012,8-\u001a:JI6\u000bg.Y4feB\u0011\u0011\u0006L\u0007\u0002U)\u00111FG\u0001\u0006kRLGn]\u0005\u0003[)\u0012q\u0001T8hO&tw-\u0001\u0005ce>\\WM]%e!\ty\u0002'\u0003\u00022A\t\u0019\u0011J\u001c;\u0002\tQLW.\u001a\t\u0003iuj\u0011!\u000e\u0006\u0003WYR!a\u000e\u001d\u0002\r\r|W.\\8o\u0015\tY\u0012H\u0003\u0002;w\u00051\u0011\r]1dQ\u0016T\u0011\u0001P\u0001\u0004_J<\u0017B\u0001 6\u0005\u0011!\u0016.\\3\u0002'\t\u0014xn[3s\u000bB|7\r[*vaBd\u0017.\u001a:\u0011\u0007}\t5)\u0003\u0002CA\tIa)\u001e8di&|g\u000e\r\t\u0003?\u0011K!!\u0012\u0011\u0003\t1{gnZ\u0001\u0012G>tGO]8mY\u0016\u00148\t[1o]\u0016d\u0007C\u0001%L\u001b\u0005I%B\u0001&\u001b\u0003\u0019\u0019XM\u001d<fe&\u0011A*\u0013\u0002!\u0005J|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'/\u0001\u0004=S:LGO\u0010\u000b\u0006\u001fB\u000b&k\u0015\t\u0003K\u0001AQAL\u0003A\u0002=BQAM\u0003A\u0002MBQaP\u0003A\u0002\u0001CQAR\u0003A\u0002\u001d\u000b1C\\3yiB\u0013x\u000eZ;dKJLEM\u00117pG.,\u0012A\u0016\t\u0004/\u0002\u0014W\"\u0001-\u000b\u0005eS\u0016AB1u_6L7M\u0003\u0002\\9\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005us\u0016\u0001B;uS2T\u0011aX\u0001\u0005U\u00064\u0018-\u0003\u0002b1\ny\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0002dM6\tAM\u0003\u00028K*\u0011!\nO\u0005\u0003O\u0012\u0014\u0001\u0003\u0015:pIV\u001cWM]%eg\ncwnY6\u0002/9,\u0007\u0010\u001e)s_\u0012,8-\u001a:JI\ncwnY6`I\u0015\fHC\u00016n!\ty2.\u0003\u0002mA\t!QK\\5u\u0011\u001dqw!!AA\u0002Y\u000b1\u0001\u001f\u00132\u0003QqW\r\u001f;Qe>$WoY3s\u0013\u0012\u0014En\\2lA\u000512-\u001e:sK:$\bK]8ek\u000e,'/\u00133CY>\u001c7.A\fdkJ\u0014XM\u001c;Qe>$WoY3s\u0013\u0012\u0014En\\2lA\u0005y!/Z9vKN$\u0018J\u001c$mS\u001eDG/F\u0001u!\t9V/\u0003\u0002w1\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:\f\u0001C]3rk\u0016\u001cH/\u00138GY&<\u0007\u000e\u001e\u0011\u0002#\t\f7m[8gM\u0012+\u0017\r\u001a7j]\u0016l5/F\u0001{!\t960\u0003\u0002}1\nQ\u0011\t^8nS\u000eduN\\4\u0002%\t\f7m[8gM\u0012+\u0017\r\u001a7j]\u0016l5\u000fI\u0001\u000eQ\u0006\u001ch+\u00197jI\ncwnY6\u0016\u0005\u0005\u0005\u0001cA\u0010\u0002\u0004%\u0019\u0011Q\u0001\u0011\u0003\u000f\t{w\u000e\\3b]\u0006\u0011r-\u001a8fe\u0006$X\r\u0015:pIV\u001cWM]%e)\t\tY\u0001E\u0003\u0002\u000e\u0005E1)\u0004\u0002\u0002\u0010)\u0011Q\fI\u0005\u0005\u0003'\tyAA\u0002Uef\fQ#\\1zE\u0016\u0014V-];fgRtU\r\u001f;CY>\u001c7\u000eF\u0001k\u0003-\u0019XM\u001c3SKF,Xm\u001d;\u0002C!\fg\u000e\u001a7f\u00032dwnY1uKB\u0013x\u000eZ;dKJLEm\u001d*fgB|gn]3\u0015\u0007)\fy\u0002C\u0004\u0002\"M\u0001\r!a\t\u0002\u0011I,7\u000f]8og\u0016\u0004B!!\n\u0002,5\u0011\u0011q\u0005\u0006\u0004\u0003S1\u0014\u0001\u0003:fcV,7\u000f^:\n\t\u00055\u0012q\u0005\u0002\u001c\u00032dwnY1uKB\u0013x\u000eZ;dKJLEm\u001d*fgB|gn]3\u0002\u001b!\fg\u000e\u001a7f)&lWm\\;u\u0001")
public class RPCProducerIdManager
implements ProducerIdManager,
Logging {
    private final int brokerId;
    private final Time time;
    private final Function0<Object> brokerEpochSupplier;
    private final BrokerToControllerChannelManager controllerChannel;
    private AtomicReference<ProducerIdsBlock> nextProducerIdBlock;
    private final AtomicReference<ProducerIdsBlock> currentProducerIdBlock;
    private final AtomicBoolean requestInFlight;
    private final AtomicLong backoffDeadlineMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void shutdown() {
        ProducerIdManager.shutdown$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public AtomicReference<ProducerIdsBlock> nextProducerIdBlock() {
        return this.nextProducerIdBlock;
    }

    public void nextProducerIdBlock_$eq(AtomicReference<ProducerIdsBlock> x$1) {
        this.nextProducerIdBlock = x$1;
    }

    private AtomicReference<ProducerIdsBlock> currentProducerIdBlock() {
        return this.currentProducerIdBlock;
    }

    private AtomicBoolean requestInFlight() {
        return this.requestInFlight;
    }

    private AtomicLong backoffDeadlineMs() {
        return this.backoffDeadlineMs;
    }

    @Override
    public boolean hasValidBlock() {
        return this.nextProducerIdBlock().get() != null;
    }

    @Override
    public Try<Object> generateProducerId() {
        Failure result = null;
        int iteration = 0;
        while (result == null) {
            Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.currentProducerIdBlock().get().claimNextId()));
            if (None$.MODULE$.equals(option)) {
                ProducerIdsBlock block = this.nextProducerIdBlock().getAndSet(null);
                if (block == null) {
                    this.maybeRequestNextBlock();
                    result = new Failure((Throwable)Errors.COORDINATOR_LOAD_IN_PROGRESS.exception("Producer ID block is full. Waiting for next block"));
                } else {
                    this.currentProducerIdBlock().set(block);
                    this.requestInFlight().set(false);
                    ++iteration;
                }
            } else if (option instanceof Some) {
                long prefetchTarget;
                Long nextProducerId = (Long)((Some)option).value();
                if (BoxesRunTime.equalsNumObject((Number)nextProducerId, (Object)BoxesRunTime.boxToLong((long)(prefetchTarget = this.currentProducerIdBlock().get().firstProducerId() + (long)((double)this.currentProducerIdBlock().get().size() * ProducerIdManager$.MODULE$.PidPrefetchThreshold()))))) {
                    this.maybeRequestNextBlock();
                }
                result = new Success((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(nextProducerId)));
            } else {
                throw new MatchError((Object)option);
            }
            if (iteration != ProducerIdManager$.MODULE$.IterationLimit()) continue;
            result = new Failure((Throwable)Errors.COORDINATOR_LOAD_IN_PROGRESS.exception("Producer ID block is full. Waiting for next block"));
        }
        return result;
    }

    public void maybeRequestNextBlock() {
        long retryTimestamp = this.backoffDeadlineMs().get();
        if (retryTimestamp == ProducerIdManager$.MODULE$.NoRetry() || this.time.milliseconds() >= retryTimestamp) {
            if (this.nextProducerIdBlock().get() == null && this.requestInFlight().compareAndSet(false, true)) {
                this.sendRequest();
                this.backoffDeadlineMs().set(ProducerIdManager$.MODULE$.NoRetry());
                return;
            }
            return;
        }
    }

    public void sendRequest() {
        AllocateProducerIdsRequestData message = new AllocateProducerIdsRequestData().setBrokerEpoch(this.brokerEpochSupplier.apply$mcJ$sp()).setBrokerId(this.brokerId);
        AllocateProducerIdsRequest.Builder request = new AllocateProducerIdsRequest.Builder(message);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Requesting next Producer ID block");
        this.controllerChannel.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)request, new ControllerRequestCompletionHandler(this){
            private final /* synthetic */ RPCProducerIdManager $outer;

            public void onComplete(ClientResponse response) {
                AllocateProducerIdsResponse message = (AllocateProducerIdsResponse)response.responseBody();
                this.$outer.handleAllocateProducerIdsResponse(message);
            }

            public void onTimeout() {
                this.$outer.kafka$coordinator$transaction$RPCProducerIdManager$$handleTimeout();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void handleAllocateProducerIdsResponse(AllocateProducerIdsResponse response) {
        AllocateProducerIdsResponseData data = response.data();
        boolean successfulResponse = false;
        Errors errors = Errors.forCode((short)data.errorCode());
        if (Errors.NONE.equals(errors)) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Got next producer ID block from controller ").append(data).toString());
            if (data.producerIdStart() < this.currentProducerIdBlock().get().lastProducerId()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Producer ID block is not monotonic with current block: current=").append(this.currentProducerIdBlock()).append(" response=").append(data).toString());
            } else if (data.producerIdStart() < 0L || data.producerIdLen() < 0 || data.producerIdStart() > Long.MAX_VALUE - (long)data.producerIdLen()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Producer ID block includes invalid ID range: ").append(data).toString());
            } else {
                this.nextProducerIdBlock().set(new ProducerIdsBlock(this.brokerId, data.producerIdStart(), data.producerIdLen()));
                successfulResponse = true;
            }
        } else if (Errors.STALE_BROKER_EPOCH.equals(errors)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Our broker currentBlockCount was stale, trying again.");
        } else if (Errors.BROKER_ID_NOT_REGISTERED.equals(errors)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Our broker ID is not yet known by the controller, trying again.");
        } else if (errors != null) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Received an unexpected error code from the controller: ").append(errors).toString());
        } else {
            throw new MatchError(null);
        }
        if (!successfulResponse) {
            this.backoffDeadlineMs().set(this.time.milliseconds() + (long)ProducerIdManager$.MODULE$.RetryBackoffMs());
            this.requestInFlight().set(false);
            return;
        }
    }

    public void kafka$coordinator$transaction$RPCProducerIdManager$$handleTimeout() {
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Timed out when requesting AllocateProducerIds from the controller.");
        this.requestInFlight().set(false);
    }

    public RPCProducerIdManager(int brokerId, Time time, Function0<Object> brokerEpochSupplier, BrokerToControllerChannelManager controllerChannel) {
        this.brokerId = brokerId;
        this.time = time;
        this.brokerEpochSupplier = brokerEpochSupplier;
        this.controllerChannel = controllerChannel;
        ProducerIdManager.$init$(this);
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(27).append("[RPC ProducerId Manager ").append(brokerId).append("]: ").toString());
        this.nextProducerIdBlock = new AtomicReference<Object>(null);
        this.currentProducerIdBlock = new AtomicReference<ProducerIdsBlock>(ProducerIdsBlock.EMPTY);
        this.requestInFlight = new AtomicBoolean(false);
        this.backoffDeadlineMs = new AtomicLong(ProducerIdManager$.MODULE$.NoRetry());
    }
}

