/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.cluster.BrokerEndPoint;
import kafka.server.FailedPartitions;
import kafka.server.FetcherThreadTestUtils$;
import kafka.server.Fetching$;
import kafka.server.MockFetcherThread;
import kafka.server.MockFetcherThread$;
import kafka.server.MockLeaderEndPoint;
import kafka.server.MockLeaderEndPoint$;
import kafka.server.MockTierStateMachine;
import kafka.server.PartitionFetchState;
import kafka.server.PartitionState;
import kafka.server.PartitionState$;
import kafka.server.Truncating$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001u3A\u0001D\u0007\u0001%!)\u0011\u0004\u0001C\u00015!9Q\u0004\u0001b\u0001\n\u0003q\u0002B\u0002\u0012\u0001A\u0003%q\u0004C\u0004$\u0001\t\u0007I\u0011\u0001\u0013\t\ry\u0002\u0001\u0015!\u0003&\u0011\u001dy\u0004A1A\u0005\u0002\u0001Ca\u0001\u0012\u0001!\u0002\u0013\t\u0005bB#\u0001\u0005\u0004%IA\u0012\u0005\u0007\u0015\u0002\u0001\u000b\u0011B$\t\u000b-\u0003A\u0011\u0001'\t\u000bm\u0003A\u0011\u0001'\u0003EI+\u0007\u000f\\5dC\u001a+Go\u00195feRKWM]*uCR,W*Y2iS:,G+Z:u\u0015\tqq\"\u0001\u0004tKJ4XM\u001d\u0006\u0002!\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0014!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011!D\u0001\u0010iJ,hnY1uK>sg)\u001a;dQV\tq\u0004\u0005\u0002\u0015A%\u0011\u0011%\u0006\u0002\b\u0005>|G.Z1o\u0003A!(/\u001e8dCR,wJ\u001c$fi\u000eD\u0007%\u0001\u0005u_BL7-\u00133t+\u0005)\u0003\u0003\u0002\u0014*WMj\u0011a\n\u0006\u0003QU\t!bY8mY\u0016\u001cG/[8o\u0013\tQsEA\u0002NCB\u0004\"\u0001L\u0019\u000e\u00035R!AL\u0018\u0002\t1\fgn\u001a\u0006\u0002a\u0005!!.\u0019<b\u0013\t\u0011TF\u0001\u0004TiJLgn\u001a\t\u0003iqj\u0011!\u000e\u0006\u0003m]\naaY8n[>t'B\u0001\t9\u0015\tI$(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002w\u0005\u0019qN]4\n\u0005u*$\u0001B+vS\u0012\f\u0011\u0002^8qS\u000eLEm\u001d\u0011\u0002\u000fY,'o]5p]V\t\u0011\t\u0005\u0002\u0015\u0005&\u00111)\u0006\u0002\u0006'\"|'\u000f^\u0001\tm\u0016\u00148/[8oA\u0005\u0001b-Y5mK\u0012\u0004\u0016M\u001d;ji&|gn]\u000b\u0002\u000fB\u0011A\u0004S\u0005\u0003\u00136\u0011\u0001CR1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0002#\u0019\f\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\b%A\u0012uKN$hi\u001c7m_^,'OR3uG\"luN^3e)>$\u0016.\u001a:fIN#xN]3\u0015\u00035\u0003\"\u0001\u0006(\n\u0005=+\"\u0001B+oSRD#AC)\u0011\u0005IKV\"A*\u000b\u0005Q+\u0016aA1qS*\u0011akV\u0001\bUV\u0004\u0018\u000e^3s\u0015\tA&(A\u0003kk:LG/\u0003\u0002['\n!A+Z:u\u0003-\"Xm\u001d;GK:\u001cW\rZ(gMN,GOU3tKR\fe\r^3s\u001b>4X\r\u001a+p%\u0016lw\u000e^3US\u0016\u0014\bFA\u0006R\u0001")
public class ReplicaFetcherTierStateMachineTest {
    private final boolean truncateOnFetch;
    private final Map<String, Uuid> topicIds = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic1"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic2"), (Object)Uuid.randomUuid())}));
    private final short version = ApiKeys.FETCH.latestVersion();
    private final FailedPartitions failedPartitions = new FailedPartitions();

    public boolean truncateOnFetch() {
        return this.truncateOnFetch;
    }

    public Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    public short version() {
        return this.version;
    }

    private FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    @Test
    public void testFollowerFetchMovedToTieredStore() {
        TopicPartition partition = new TopicPartition("topic", 0);
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, 0L, true);
        boolean x$12 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$12, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, MockFetcherThread$.MODULE$.$lessinit$greater$default$3(), MockFetcherThread$.MODULE$.$lessinit$greater$default$4(), MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), MockFetcherThread$.MODULE$.$lessinit$greater$default$6());
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 5))})));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(5L, 5, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("f".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(6L, 5, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("g".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(7L, 5, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("h".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(8L, 5, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("i".getBytes())})), (List)Nil$.MODULE$))));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 5, 8L, true);
        leaderState.logStartOffset_$eq(0L);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        Assertions.assertEquals((long)3L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)(this.truncateOnFetch() ? Option$.MODULE$.apply((Object)Fetching$.MODULE$) : Option$.MODULE$.apply((Object)Truncating$.MODULE$)), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.state()));
        fetcher.doWork();
        Assertions.assertEquals((long)0L, (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)5L, (long)replicaState.localLogStartOffset());
        Assertions.assertEquals((long)5L, (long)replicaState.highWatermark());
        Assertions.assertEquals((long)5L, (long)replicaState.logEndOffset());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> fetcher.doWork());
        Assertions.assertEquals((int)4, (int)replicaState.log().size());
        Assertions.assertEquals((long)0L, (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)5L, (long)replicaState.localLogStartOffset());
        Assertions.assertEquals((long)8L, (long)replicaState.highWatermark());
        Assertions.assertEquals((long)9L, (long)replicaState.logEndOffset());
    }

    @Test
    public void testFencedOffsetResetAfterMovedToRemoteTier() {
        TopicPartition partition = new TopicPartition("topic", 0);
        BooleanRef isErrorHandled = BooleanRef.create((boolean)false);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(null, mockLeaderEndpoint, isErrorHandled){
            private final BooleanRef isErrorHandled$1;

            public PartitionFetchState start(TopicPartition topicPartition, PartitionFetchState currentFetchState, FetchResponseData.PartitionData fetchPartitionData) {
                this.isErrorHandled$1.elem = true;
                throw new FencedLeaderEpochException(new StringBuilder(16).append("Epoch ").append(currentFetchState.currentLeaderEpoch()).append(" is fenced").toString());
            }
            {
                this.isErrorHandled$1 = isErrorHandled$1;
                super(mockLeaderEndpoint$1);
            }
        };
        FailedPartitions x$6 = this.failedPartitions();
        int x$7 = MockFetcherThread$.MODULE$.$lessinit$greater$default$3();
        int x$8 = MockFetcherThread$.MODULE$.$lessinit$greater$default$4();
        int x$9 = MockFetcherThread$.MODULE$.$lessinit$greater$default$5();
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, x$7, x$8, x$9, x$6);
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, 2L, true);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 5))})));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(5L, 5, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(6L, 5, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 5, 6L, true);
        leaderState.logStartOffset_$eq(0L);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)3L, (long)replicaState.logEndOffset());
        Assertions.assertTrue((boolean)isErrorHandled.elem);
        Assertions.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
        Assertions.assertTrue((boolean)this.failedPartitions().contains(partition));
    }

    public ReplicaFetcherTierStateMachineTest() {
        this.truncateOnFetch = true;
    }
}

