/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTests;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.FeatureMetadata;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.FinalizedVersionRange;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;

@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0001A4A!\u0002\u0004\u0001\u0017!)!\u0003\u0001C\u0001'!)a\u0003\u0001C\u0001/!)A\u000b\u0001C\u0001+\")\u0001\f\u0001C\u00013\nqR*\u001a;bI\u0006$\u0018MV3sg&|g.\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u000f!\taa]3sm\u0016\u0014(\"A\u0005\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\u0002CA\u000b\u0001\u001b\u00051\u0011a\b;fgR\u0014\u0015m]5d\u001b\u0016$\u0018\rZ1uCZ+'o]5p]V\u0003xM]1eKR\u0011\u0001d\u0007\t\u0003\u001beI!A\u0007\b\u0003\tUs\u0017\u000e\u001e\u0005\u00069\t\u0001\r!H\u0001\u0010G2,8\u000f^3s\u0013:\u001cH/\u00198dKB\u0011a$I\u0007\u0002?)\u0011\u0001\u0005C\u0001\u0005i\u0016\u001cH/\u0003\u0002#?\ty1\t\\;ti\u0016\u0014\u0018J\\:uC:\u001cW\r\u000b\u0003\u0003I)Z\u0003CA\u0013)\u001b\u00051#BA\u0014 \u0003)\tgN\\8uCRLwN\\\u0005\u0003S\u0019\u0012Ab\u00117vgR,'\u000fV3tiN\fQA^1mk\u0016dc\u0001\f#I\u0019B\u00036&B\u00171cY:\u0004CA\u0013/\u0013\tycEA\u0006DYV\u001cH/\u001a:UKN$\u0018aC2mkN$XM\u001d+za\u0016$\u0013AM\u0005\u0003gQ\nQa\u0013*B\rRS!!\u000e\u0014\u0002\tQK\b/Z\u0001\u0010[\u0016$\u0018\rZ1uCZ+'o]5p]\u0012\n\u0001(\u0003\u0002:u\u0005Y\u0011J\u0011)`g}\u001bt,\u0013,1\u0015\tYD(A\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0015\tid(\u0001\u0004d_6lwN\u001c\u0006\u0003\u000f}R!!\u0003!\u000b\u0005\u0005\u0013\u0015AB1qC\u000eDWMC\u0001D\u0003\ry'oZ\u0016\u0006[A\nd'\u0012\u0013\u0002\r&\u0011qIO\u0001\f\u0013\n\u0003vlM04?&3\u0016gK\u0003.aE2\u0014\nJ\u0001K\u0013\tY%(A\u0006J\u0005B{6gX\u001a`\u0013Z\u00134&B\u00171cYjE%\u0001(\n\u0005=S\u0014aC%C!~\u001btlM0J-NZS!\f\u00192mE#\u0013AU\u0005\u0003'j\n1\"\u0013\"Q?NzFgX%Wa\u00051B/Z:u+B<'/\u00193f'\u0006lWMV3sg&|g\u000e\u0006\u0002\u0019-\")Ad\u0001a\u0001;!21!\f\u00192m]\n!\u0004^3ti\u0012+g-Y;mi&\u001bH*\u0019;fgR4VM]:j_:$\"\u0001\u0007.\t\u000bq!\u0001\u0019A\u000f)\t\u0011i\u0003'\r\u0015\u0005\u0001uS\u0013\u000e\u0005\u0002_O6\tqL\u0003\u0002aC\u0006IQ\r\u001f;f]NLwN\u001c\u0006\u0003E\u000e\f1!\u00199j\u0015\t!W-A\u0004kkBLG/\u001a:\u000b\u0005\u0019\u0014\u0015!\u00026v]&$\u0018B\u00015`\u0005))\u0005\u0010^3oI^KG\u000f\u001b\u0017\u0002U\u000e\n1\u000e\u0005\u0002m]6\tQN\u0003\u0002g?%\u0011q.\u001c\u0002\u0016\u00072,8\u000f^3s)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8t\u0001")
public class MetadataVersionIntegrationTest {
    /*
     * WARNING - void declaration
     */
    @ClusterTests(value={@ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_3_IV0), @ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_3_IV1), @ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_3_IV2), @ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_3_IV3), @ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_4_IV0), @ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_4_IV0)})
    public void testBasicMetadataVersionUpgrade(ClusterInstance clusterInstance) {
        Admin admin = clusterInstance.createAdminClient();
        FinalizedVersionRange ff = (FinalizedVersionRange)((FeatureMetadata)admin.describeFeatures().featureMetadata().get()).finalizedFeatures().get("metadata.version");
        Assertions.assertEquals((short)ff.minVersionLevel(), (short)clusterInstance.config().metadataVersion().featureLevel());
        Assertions.assertEquals((short)ff.maxVersionLevel(), (short)clusterInstance.config().metadataVersion().featureLevel());
        short updateVersion = MetadataVersion.IBP_3_5_IV1.featureLevel();
        admin.updateFeatures((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.version"), (Object)new FeatureUpdate(updateVersion, FeatureUpdate.UpgradeType.UPGRADE))}))).asJava(), new UpdateFeaturesOptions()).all().get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetadataVersionIntegrationTest.$anonfun$testBasicMetadataVersionUpgrade$1(admin, updateVersion)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)MetadataVersionIntegrationTest.$anonfun$testBasicMetadataVersionUpgrade$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_3_IV0)
    public void testUpgradeSameVersion(ClusterInstance clusterInstance) {
        Admin admin = clusterInstance.createAdminClient();
        short updateVersion = MetadataVersion.IBP_3_3_IV0.featureLevel();
        admin.updateFeatures((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.version"), (Object)new FeatureUpdate(updateVersion, FeatureUpdate.UpgradeType.UPGRADE))}))).asJava(), new UpdateFeaturesOptions()).all().get();
    }

    @ClusterTest(clusterType=Type.KRAFT)
    public void testDefaultIsLatestVersion(ClusterInstance clusterInstance) {
        FinalizedVersionRange ff = (FinalizedVersionRange)((FeatureMetadata)clusterInstance.createAdminClient().describeFeatures().featureMetadata().get()).finalizedFeatures().get("metadata.version");
        Assertions.assertEquals((short)ff.minVersionLevel(), (short)MetadataVersion.latest().featureLevel(), (String)"If this test fails, check the default MetadataVersion in the @ClusterTest annotation");
        Assertions.assertEquals((short)ff.maxVersionLevel(), (short)MetadataVersion.latest().featureLevel());
    }

    public static final /* synthetic */ boolean $anonfun$testBasicMetadataVersionUpgrade$1(Admin admin$1, short updateVersion$1) {
        FinalizedVersionRange ff2 = (FinalizedVersionRange)((FeatureMetadata)admin$1.describeFeatures().featureMetadata().get()).finalizedFeatures().get("metadata.version");
        return ff2.minVersionLevel() == updateVersion$1 && ff2.maxVersionLevel() == updateVersion$1;
    }

    public static final /* synthetic */ String $anonfun$testBasicMetadataVersionUpgrade$2() {
        return "Never saw metadata.version increase on broker";
    }
}

