/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.api.Both$;
import kafka.api.IntegrationTestHarness;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.TestableKerberosLogin;
import kafka.server.TestableKerberosLogin$;
import kafka.utils.JaasTestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ChannelState;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkTestUtils;
import org.apache.kafka.common.network.SaslChannelBuilder;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.TestSecurityConfig;
import org.apache.kafka.common.security.auth.Login;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u0015+\u0001=BQ!\u000f\u0001\u0005\u0002iBq!\u0010\u0001C\u0002\u0013\u0005c\b\u0003\u0004F\u0001\u0001\u0006Ia\u0010\u0005\u0006\r\u0002!\tf\u0012\u0005\b/\u0002\u0011\r\u0011\"\u0003Y\u0011\u0019\t\u0007\u0001)A\u00053\"9!\r\u0001b\u0001\n\u0013\u0019\u0007B\u00027\u0001A\u0003%A\rC\u0004n\u0001\t\u0007I\u0011\u0002 \t\r9\u0004\u0001\u0015!\u0003@\u0011\u001dy\u0007A1A\u0005\nADa!\u001f\u0001!\u0002\u0013\t\bb\u0002>\u0001\u0005\u0004%Ia\u001f\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003}\u0011-\t\u0019\u0001\u0001a\u0001\u0002\u0004%I!!\u0002\t\u0017\u0005M\u0001\u00011AA\u0002\u0013%\u0011Q\u0003\u0005\f\u0003C\u0001\u0001\u0019!A!B\u0013\t9\u0001C\u0005\u0002$\u0001\u0011\r\u0011\"\u0003\u0002&!A\u00111\u0007\u0001!\u0002\u0013\t9\u0003\u0003\u0005\u00026\u0001\u0011\r\u0011\"\u0001Y\u0011\u001d\t9\u0004\u0001Q\u0001\neC\u0001\"!\u000f\u0001\u0005\u0004%\tA\u0010\u0005\b\u0003w\u0001\u0001\u0015!\u0003@\u0011%\ti\u0004\u0001b\u0001\n\u0003\ty\u0004\u0003\u0005\u0002J\u0001\u0001\u000b\u0011BA!\u0011!\tY\u0005\u0001b\u0001\n\u0013q\u0004bBA'\u0001\u0001\u0006Ia\u0010\u0005\b\u0003\u001f\u0002A\u0011IA)\u0011\u001d\t\t\b\u0001C!\u0003gBq!! \u0001\t\u0003\t\u0019\bC\u0004\u0002\b\u0002!\t!a\u001d\t\u000f\u0005-\u0005\u0001\"\u0001\u0002t!9\u0011q\u0012\u0001\u0005\n\u0005E\u0005bBAW\u0001\u0011\u0005\u00111\u000f\u0005\b\u0003c\u0003A\u0011AA:\u0011\u001d\t)\f\u0001C\u0005\u0003oCq!!0\u0001\t\u0013\ty\fC\u0004\u0002b\u0002!I!a\u001d\t\u000f\u0005\r\b\u0001\"\u0003\u0002f\"9\u0011q\u001d\u0001\u0005\n\u0005\u0015(\u0001G$tg\u0006\u0004\u0018.Q;uQ\u0016tG/[2bi&|g\u000eV3ti*\u00111\u0006L\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00035\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001aY\u0002\"!\r\u001b\u000e\u0003IR!a\r\u0017\u0002\u0007\u0005\u0004\u0018.\u0003\u00026e\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u00022o%\u0011\u0001H\r\u0002\n'\u0006\u001cHnU3ukB\fa\u0001P5oSRtD#A\u001e\u0011\u0005q\u0002Q\"\u0001\u0016\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002\u007fA\u0011\u0001iQ\u0007\u0002\u0003*\t!)A\u0003tG\u0006d\u0017-\u0003\u0002E\u0003\n\u0019\u0011J\u001c;\u0002\u0019\t\u0014xn[3s\u0007>,h\u000e\u001e\u0011\u0002!M,7-\u001e:jif\u0004&o\u001c;pG>dW#\u0001%\u0011\u0005%+V\"\u0001&\u000b\u0005-c\u0015\u0001B1vi\"T!!\u0014(\u0002\u0011M,7-\u001e:jifT!a\u0014)\u0002\r\r|W.\\8o\u0015\ti\u0013K\u0003\u0002S'\u00061\u0011\r]1dQ\u0016T\u0011\u0001V\u0001\u0004_J<\u0017B\u0001,K\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G.\u0001\rlC\u001a\\\u0017m\u00117jK:$8+Y:m\u001b\u0016\u001c\u0007.\u00198jg6,\u0012!\u0017\t\u00035~k\u0011a\u0017\u0006\u00039v\u000bA\u0001\\1oO*\ta,\u0001\u0003kCZ\f\u0017B\u00011\\\u0005\u0019\u0019FO]5oO\u0006I2.\u00194lC\u000ec\u0017.\u001a8u'\u0006\u001cH.T3dQ\u0006t\u0017n]7!\u0003eY\u0017MZ6b'\u0016\u0014h/\u001a:TCNdW*Z2iC:L7/\\:\u0016\u0003\u0011\u00042!\u001a6Z\u001b\u00051'BA4i\u0003%IW.\\;uC\ndWM\u0003\u0002j\u0003\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005-4'\u0001\u0002'jgR\f!d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ng\u0002\n!B\\;n)\"\u0014X-\u00193t\u0003-qW/\u001c+ie\u0016\fGm\u001d\u0011\u0002\u0011\u0015DXmY;u_J,\u0012!\u001d\t\u0003e^l\u0011a\u001d\u0006\u0003iV\f!bY8oGV\u0014(/\u001a8u\u0015\t1X,\u0001\u0003vi&d\u0017B\u0001=t\u0005=)\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017!C3yK\u000e,Ho\u001c:!\u00031\u0019G.[3oi\u000e{gNZ5h+\u0005a\bCA?\u007f\u001b\u0005)\u0018BA@v\u0005)\u0001&o\u001c9feRLWm]\u0001\u000eG2LWM\u001c;D_:4\u0017n\u001a\u0011\u0002\u0015M,'O^3s\u0003\u0012$'/\u0006\u0002\u0002\bA!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000eu\u000b1A\\3u\u0013\u0011\t\t\"a\u0003\u0003#%sW\r^*pG.,G/\u00113ee\u0016\u001c8/\u0001\btKJ4XM]!eIJ|F%Z9\u0015\t\u0005]\u0011Q\u0004\t\u0004\u0001\u0006e\u0011bAA\u000e\u0003\n!QK\\5u\u0011%\ty\u0002EA\u0001\u0002\u0004\t9!A\u0002yIE\n1b]3sm\u0016\u0014\u0018\t\u001a3sA\u0005!A/[7f+\t\t9\u0003\u0005\u0003\u0002*\u0005=RBAA\u0016\u0015\r\tiCT\u0001\u0006kRLGn]\u0005\u0005\u0003c\tYC\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u0015!x\u000e]5d\u0003\u0019!x\u000e]5dA\u0005!\u0001/\u0019:u\u0003\u0015\u0001\u0018M\u001d;!\u0003\t!\b/\u0006\u0002\u0002BA!\u00111IA#\u001b\u0005q\u0015bAA$\u001d\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0001;qA\u0005Yb-Y5mK\u0012\fU\u000f\u001e5f]RL7-\u0019;j_:$U\r\\1z\u001bN\fADZ1jY\u0016$\u0017)\u001e;iK:$\u0018nY1uS>tG)\u001a7bs6\u001b\b%A\u0003tKR,\u0006\u000f\u0006\u0003\u0002\u0018\u0005M\u0003bBA+9\u0001\u0007\u0011qK\u0001\ti\u0016\u001cH/\u00138g_B!\u0011\u0011LA3\u001b\t\tYFC\u00024\u0003;RA!a\u0018\u0002b\u00059!.\u001e9ji\u0016\u0014(bAA2'\u0006)!.\u001e8ji&!\u0011qMA.\u0005!!Vm\u001d;J]\u001a|\u0007f\u0001\u000f\u0002lA!\u0011\u0011LA7\u0013\u0011\ty'a\u0017\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<o)\t\t9\u0002K\u0002\u001e\u0003o\u0002B!!\u0017\u0002z%!\u00111PA.\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u000buKN$(+Z9vKN$\u0018j]!SKBd\u0017-\u001f\u0015\u0004=\u0005\u0005\u0005\u0003BA-\u0003\u0007KA!!\"\u0002\\\t!A+Z:u\u0003A!Xm\u001d;M_\u001eLgNR1jYV\u0014X\rK\u0002 \u0003\u0003\u000b1\u0002^3tiJ+Gj\\4j]\"\u001a\u0001%!!\u0002\u001bY,'/\u001b4z%\u0016dwnZ5o)\u0019\t9\"a%\u0002$\"9\u0011QS\u0011A\u0002\u0005]\u0015\u0001C:fY\u0016\u001cGo\u001c:\u0011\t\u0005e\u0015qT\u0007\u0003\u00037S1!!(O\u0003\u001dqW\r^<pe.LA!!)\u0002\u001c\nA1+\u001a7fGR|'\u000fC\u0004\u0002&\u0006\u0002\r!a*\u0002\u000b1|w-\u001b8\u0011\u0007q\nI+C\u0002\u0002,*\u0012Q\u0003V3ti\u0006\u0014G.Z&fe\n,'o\\:M_\u001eLg.\u0001\u0013uKN$8+\u001a:wKJtu\u000e\u001e$pk:$\u0017J\\&fe\n,'o\\:ECR\f'-Y:fQ\r\u0011\u0013\u0011Q\u0001 i\u0016\u001cHoU3sm\u0016\u0014\u0018)\u001e;iK:$\u0018nY1uS>tg)Y5mkJ,\u0007fA\u0012\u0002\u0002\u0006Yc/\u001a:jMf\u0014V\r\u001e:jC\ndWMR1jYV\u0014Xm\u001d#ve&tw-Q;uQ\u0016tG/[2bi&|g\u000e\u0006\u0003\u0002\u0018\u0005e\u0006BBA^I\u0001\u0007q(\u0001\nok6\u001cVoY2fgN4W\u000f\\!vi\"\u001c\u0018\u0001\b9pY2,f\u000e^5m%\u0016\fG-_(s\t&\u001c8m\u001c8oK\u000e$X\r\u001a\u000b\u0007\u0003\u0003\f9-!3\u0011\u0007\u0001\u000b\u0019-C\u0002\u0002F\u0006\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002\u0016\u0016\u0002\r!a&\t\u000f\u0005-W\u00051\u0001\u0002N\u00061an\u001c3f\u0013\u0012\u0004B!a4\u0002^:!\u0011\u0011[Am!\r\t\u0019.Q\u0007\u0003\u0003+T1!a6/\u0003\u0019a$o\\8u}%\u0019\u00111\\!\u0002\rA\u0013X\rZ3g\u0013\r\u0001\u0017q\u001c\u0006\u0004\u00037\f\u0015a\n<fe&4\u0017PT8o%\u0016$(/[1cY\u0016\fU\u000f\u001e5f]RL7-\u0019;j_:4\u0015-\u001b7ve\u0016\fab\u0019:fCR,7+\u001a7fGR|'\u000f\u0006\u0002\u0002\u0018\u0006I2M]3bi\u0016\u001cV\r\\3di>\u0014x+\u001b;i%\u0016dwnZ5o\u0001")
public class GssapiAuthenticationTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int brokerCount;
    private final String kafka$server$GssapiAuthenticationTest$$kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final int numThreads;
    private final ExecutorService executor;
    private final Properties clientConfig;
    private InetSocketAddress serverAddr;
    private final MockTime kafka$server$GssapiAuthenticationTest$$time;
    private final String topic;
    private final int part;
    private final TopicPartition tp;
    private final int failedAuthenticationDelayMs;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public String jaasAdminLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasAdminLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasAdminLoginModule$default$2() {
        return SaslSetup.jaasAdminLoginModule$default$2$(this);
    }

    @Override
    public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
        return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return SaslSetup.createPrivilegedAdminClient$(this);
    }

    @Override
    public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
        return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
    }

    @Override
    public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
        SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
    }

    @Override
    public void createScramCredentials(Admin adminClient, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, adminClient, userName, password);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    public String kafka$server$GssapiAuthenticationTest$$kafkaClientSaslMechanism() {
        return this.kafka$server$GssapiAuthenticationTest$$kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private int numThreads() {
        return this.numThreads;
    }

    private ExecutorService executor() {
        return this.executor;
    }

    private Properties clientConfig() {
        return this.clientConfig;
    }

    private InetSocketAddress serverAddr() {
        return this.serverAddr;
    }

    private void serverAddr_$eq(InetSocketAddress x$1) {
        this.serverAddr = x$1;
    }

    public MockTime kafka$server$GssapiAuthenticationTest$$time() {
        return this.kafka$server$GssapiAuthenticationTest$$time;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    private int failedAuthenticationDelayMs() {
        return this.failedAuthenticationDelayMs;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        TestableKerberosLogin$.MODULE$.reset();
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)Option$.MODULE$.apply((Object)this.kafka$server$GssapiAuthenticationTest$$kafkaClientSaslMechanism()), Both$.MODULE$, this.jaasSections$default$4()));
        this.serverConfig().put(KafkaConfig$.MODULE$.SslClientAuthProp(), "required");
        this.serverConfig().put(KafkaConfig$.MODULE$.FailedAuthenticationDelayMsProp(), Integer.toString(this.failedAuthenticationDelayMs()));
        super.setUp(testInfo);
        this.serverAddr_$eq(new InetSocketAddress("localhost", ((KafkaServer)this.servers().head()).boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT))));
        this.clientConfig().put("security.protocol", SecurityProtocol.SASL_PLAINTEXT.name);
        this.clientConfig().put("sasl.mechanism", this.kafka$server$GssapiAuthenticationTest$$kafkaClientSaslMechanism());
        this.clientConfig().put("sasl.jaas.config", this.jaasClientLoginModule(this.kafka$server$GssapiAuthenticationTest$$kafkaClientSaslMechanism(), this.jaasClientLoginModule$default$2()));
        this.clientConfig().put("connections.max.idle.ms", "5000");
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.executor().shutdownNow();
        super.tearDown();
        this.closeSasl();
        TestableKerberosLogin$.MODULE$.reset();
    }

    @Test
    public void testRequestIsAReplay() {
        int successfulAuthsPerThread = 10;
        ((IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numThreads()).map((Function1 & Serializable & scala.Serializable)x$1 -> GssapiAuthenticationTest.$anonfun$testRequestIsAReplay$1(this, successfulAuthsPerThread, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get(60L, TimeUnit.SECONDS));
        Assertions.assertEquals((long)0L, (long)TestUtils$.MODULE$.totalMetricValue((KafkaBroker)this.servers().head(), "failed-authentication-total"));
        long successfulAuths = TestUtils$.MODULE$.totalMetricValue((KafkaBroker)this.servers().head(), "successful-authentication-total");
        Assertions.assertTrue((successfulAuths > (long)(successfulAuthsPerThread * this.numThreads()) ? 1 : 0) != 0, (String)new StringBuilder(25).append("Too few authentications: ").append(successfulAuths).toString());
    }

    @Test
    public void testLoginFailure() {
        try (Selector selector = this.createSelectorWithRelogin();){
            TestableKerberosLogin login = TestableKerberosLogin$.MODULE$.instance();
            Assertions.assertNotNull((Object)((Object)login));
            login.loginException_$eq((Option<RuntimeException>)new Some((Object)new RuntimeException("Test exception to fail login")));
            this.executor().submit(() -> login.reLogin(), BoxesRunTime.boxToInteger((int)0));
            this.executor().submit(() -> login.reLogin(), BoxesRunTime.boxToInteger((int)0));
            this.verifyRelogin(selector, login);
            Assertions.assertEquals((int)2, (int)login.loginAttempts());
            Assertions.assertEquals((int)1, (int)login.logoutAttempts());
        }
    }

    @Test
    public void testReLogin() {
        try (Selector selector = this.createSelectorWithRelogin();){
            TestableKerberosLogin login = TestableKerberosLogin$.MODULE$.instance();
            Assertions.assertNotNull((Object)((Object)login));
            this.executor().submit(() -> login.reLogin(), BoxesRunTime.boxToInteger((int)0));
            this.verifyRelogin(selector, login);
        }
    }

    private void verifyRelogin(Selector selector, TestableKerberosLogin login) {
        String node1 = "1";
        selector.connect(node1, this.serverAddr(), 1024, 1024);
        login.logoutResumeLatch().countDown();
        login.logoutCompleteLatch().await(15L, TimeUnit.SECONDS);
        Assertions.assertFalse((boolean)this.pollUntilReadyOrDisconnected(selector, node1), (String)"Authenticated during re-login");
        login.reLoginResumeLatch().countDown();
        login.reLoginCompleteLatch().await(15L, TimeUnit.SECONDS);
        String node2 = "2";
        selector.connect(node2, this.serverAddr(), 1024, 1024);
        Assertions.assertTrue((boolean)this.pollUntilReadyOrDisconnected(selector, node2), (String)"Authenticated failed after re-login");
    }

    @Test
    public void testServerNotFoundInKerberosDatabase() {
        String invalidServiceConfig = this.clientConfig().getProperty("sasl.jaas.config").replace("serviceName=\"kafka\"", "serviceName=\"invalid-service\"");
        this.clientConfig().put("sasl.jaas.config", invalidServiceConfig);
        this.clientConfig().put("sasl.kerberos.service.name", "invalid-service");
        this.verifyNonRetriableAuthenticationFailure();
    }

    @Test
    public void testServerAuthenticationFailure() {
        String clientLoginContext = this.jaasClientLoginModule(this.kafka$server$GssapiAuthenticationTest$$kafkaClientSaslMechanism(), (Option<String>)new Some((Object)"another-kafka-service"));
        Properties configOverrides = new Properties();
        configOverrides.setProperty("sasl.jaas.config", clientLoginContext);
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, configOverrides, x$4);
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        long startMs = System.currentTimeMillis();
        Assertions.assertThrows(SaslAuthenticationException.class, () -> consumer.poll(Duration.ofMillis(50L)));
        long endMs = System.currentTimeMillis();
        Predef$.MODULE$.require(endMs - startMs < (long)this.failedAuthenticationDelayMs(), (Function0 & Serializable & scala.Serializable)() -> "Failed authentication must not be delayed on the client");
        consumer.close();
    }

    public void kafka$server$GssapiAuthenticationTest$$verifyRetriableFailuresDuringAuthentication(int numSuccessfulAuths) {
        try (Selector selector = this.createSelector();){
            int actualSuccessfulAuths = 0;
            while (actualSuccessfulAuths < numSuccessfulAuths) {
                String nodeId = Integer.toString(actualSuccessfulAuths);
                selector.connect(nodeId, this.serverAddr(), 1024, 1024);
                if (this.pollUntilReadyOrDisconnected(selector, nodeId)) {
                    ++actualSuccessfulAuths;
                }
                selector.close(nodeId);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean pollUntilReadyOrDisconnected(Selector selector, String nodeId) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!GssapiAuthenticationTest.$anonfun$pollUntilReadyOrDisconnected$1(selector, nodeId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)GssapiAuthenticationTest.$anonfun$pollUntilReadyOrDisconnected$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        boolean isReady = selector.isChannelReady(nodeId);
        selector.close(nodeId);
        return isReady;
    }

    /*
     * WARNING - void declaration
     */
    private void verifyNonRetriableAuthenticationFailure() {
        Selector selector = this.createSelector();
        String nodeId = "1";
        selector.connect(nodeId, this.serverAddr(), 1024, 1024);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!GssapiAuthenticationTest.$anonfun$verifyNonRetriableAuthenticationFailure$1(selector, nodeId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)GssapiAuthenticationTest.$anonfun$verifyNonRetriableAuthenticationFailure$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private Selector createSelector() {
        return NetworkTestUtils.createSelector((ChannelBuilder)ChannelBuilders.clientChannelBuilder((SecurityProtocol)this.securityProtocol(), (JaasContext.Type)JaasContext.Type.CLIENT, (AbstractConfig)new TestSecurityConfig((Map)this.clientConfig()), null, (String)this.kafka$server$GssapiAuthenticationTest$$kafkaClientSaslMechanism(), (Time)this.kafka$server$GssapiAuthenticationTest$$time(), (boolean)true, (LogContext)new LogContext()), (Time)this.kafka$server$GssapiAuthenticationTest$$time());
    }

    private Selector createSelectorWithRelogin() {
        this.clientConfig().setProperty("sasl.kerberos.min.time.before.relogin", "0");
        TestSecurityConfig config = new TestSecurityConfig((Map)this.clientConfig());
        Map<String, JaasContext> jaasContexts = Collections.singletonMap("GSSAPI", JaasContext.loadClientContext((Map)config.values()));
        SaslChannelBuilder channelBuilder = new SaslChannelBuilder(this, jaasContexts){

            public Class<? extends Login> defaultLoginClass() {
                return TestableKerberosLogin.class;
            }
        };
        channelBuilder.configure(config.values());
        return NetworkTestUtils.createSelector((ChannelBuilder)channelBuilder, (Time)this.kafka$server$GssapiAuthenticationTest$$time());
    }

    public static final /* synthetic */ Future $anonfun$testRequestIsAReplay$1(GssapiAuthenticationTest $this, int successfulAuthsPerThread$1, int x$1) {
        return $this.executor().submit(new Runnable($this, successfulAuthsPerThread$1){
            private final /* synthetic */ GssapiAuthenticationTest $outer;
            private final int successfulAuthsPerThread$1;

            public void run() {
                this.$outer.kafka$server$GssapiAuthenticationTest$$verifyRetriableFailuresDuringAuthentication(this.successfulAuthsPerThread$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.successfulAuthsPerThread$1 = successfulAuthsPerThread$1;
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$pollUntilReadyOrDisconnected$1(Selector selector$1, String nodeId$1) {
        selector$1.poll(100L);
        ChannelState disconnectState = (ChannelState)selector$1.disconnected().get(nodeId$1);
        if (disconnectState != null) {
            Assertions.assertEquals((Object)ChannelState.State.AUTHENTICATE, (Object)disconnectState.state(), (String)new StringBuilder(37).append("Authentication failed with exception ").append(disconnectState.exception()).toString());
        }
        return selector$1.isChannelReady(nodeId$1) || disconnectState != null;
    }

    public static final /* synthetic */ String $anonfun$pollUntilReadyOrDisconnected$2() {
        return "Client not ready or disconnected within timeout";
    }

    public static final /* synthetic */ boolean $anonfun$verifyNonRetriableAuthenticationFailure$1(Selector selector$2, String nodeId$2) {
        selector$2.poll(100L);
        ChannelState disconnectState = (ChannelState)selector$2.disconnected().get(nodeId$2);
        if (disconnectState != null) {
            Assertions.assertEquals((Object)ChannelState.State.AUTHENTICATION_FAILED, (Object)disconnectState.state());
        }
        return disconnectState != null;
    }

    public static final /* synthetic */ String $anonfun$verifyNonRetriableAuthenticationFailure$2() {
        return "Client not disconnected within timeout";
    }

    public GssapiAuthenticationTest() {
        SaslSetup.$init$(this);
        this.brokerCount = 1;
        this.kafka$server$GssapiAuthenticationTest$$kafkaClientSaslMechanism = "GSSAPI";
        this.kafkaServerSaslMechanisms = new .colon.colon((Object)"GSSAPI", (List)Nil$.MODULE$);
        this.numThreads = 10;
        this.executor = Executors.newFixedThreadPool(this.numThreads());
        this.clientConfig = new Properties();
        this.kafka$server$GssapiAuthenticationTest$$time = new MockTime(10L);
        this.topic = "topic";
        this.part = 0;
        this.tp = new TopicPartition(this.topic(), this.part());
        this.failedAuthenticationDelayMs = 2000;
    }
}

