/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.OptionalLong;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogTestUtils$;
import kafka.log.UnifiedLog$;
import kafka.server.Defaults$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpoint;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.BatchMetadata;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.ProducerStateEntry;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.RollParams;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t-d\u0001\u0002\u0016,\u0001ABQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013%A\b\u0003\u0004I\u0001\u0001\u0006I!\u0010\u0005\b\u0013\u0002\u0011\r\u0011\"\u0003K\u0011\u00191\u0006\u0001)A\u0005\u0017\"Iq\u000b\u0001a\u0001\u0002\u0004%I\u0001\u0017\u0005\nC\u0002\u0001\r\u00111A\u0005\n\tD\u0011\u0002\u001b\u0001A\u0002\u0003\u0005\u000b\u0015B-\t\u000b%\u0004A\u0011\u00016\t\u000fu\u0004\u0011\u0013!C\u0001}\"I\u00111\u0003\u0001\u0012\u0002\u0013\u0005\u0011Q\u0003\u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017Bq!a\u0019\u0001\t\u0003\tY\u0005C\u0004\u0002n\u0001!\t!a\u001c\t\u000f\u0005U\u0006\u0001\"\u0001\u0002L!9\u0011q\u0018\u0001\u0005\u0002\u0005-\u0003bBAb\u0001\u0011\u0005\u00111\n\u0005\b\u0003\u000f\u0004A\u0011AA&\u0011\u001d\tY\r\u0001C\u0001\u0003\u0017Bq!a4\u0001\t\u0003\tY\u0005C\u0004\u0002T\u0002!\t!a\u0013\t\u000f\u0005]\u0007\u0001\"\u0001\u0002L!9\u00111\u001c\u0001\u0005\u0002\u0005-\u0003bBAp\u0001\u0011\u0005\u00111\n\u0005\b\u0003G\u0004A\u0011AA&\u0011\u001d\t9\u000f\u0001C\u0001\u0003\u0017Bq!a;\u0001\t\u0003\tY\u0005C\u0004\u0002p\u0002!\t!a\u0013\t\u000f\u0005M\b\u0001\"\u0003\u0002v\"A!Q\u0004\u0001\u0012\u0002\u0013%a\u0010\u0003\u0005\u0003 \u0001\t\n\u0011\"\u0003\u007f\u0011%\u0011\t\u0003AI\u0001\n\u0013\u0011\u0019\u0003C\u0004\u0003(\u0001!\t!a\u0013\t\u000f\t-\u0002\u0001\"\u0001\u0002L!1\u0011\u000e\u0001C\u0005\u0005_AqA!\u0012\u0001\t\u0003\tY\u0005C\u0004\u0003J\u0001!\t!a\u0013\t\u000f\t5\u0003\u0001\"\u0001\u0002L!9!\u0011\u000b\u0001\u0005\u0002\u0005-\u0003b\u0002B+\u0001\u0011%!q\u000b\u0002\u000f\u0019><7+Z4nK:$H+Z:u\u0015\taS&A\u0002m_\u001eT\u0011AL\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0007\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0002\"A\u000f\u0001\u000e\u0003-\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001>!\tqd)D\u0001@\u0015\t\u0001\u0015)\u0001\u0004d_6lwN\u001c\u0006\u0003]\tS!a\u0011#\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0015aA8sO&\u0011qi\u0010\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013\u0001C:fO6,g\u000e^:\u0016\u0003-\u00032\u0001T)T\u001b\u0005i%B\u0001(P\u0003\u001diW\u000f^1cY\u0016T!\u0001U\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002S\u001b\nY\u0011I\u001d:bs\n+hMZ3s!\tQD+\u0003\u0002VW\tQAj\\4TK\u001elWM\u001c;\u0002\u0013M,w-\\3oiN\u0004\u0013A\u00027pO\u0012K'/F\u0001Z!\tQv,D\u0001\\\u0015\taV,\u0001\u0002j_*\ta,\u0001\u0003kCZ\f\u0017B\u00011\\\u0005\u00111\u0015\u000e\\3\u0002\u00151|w\rR5s?\u0012*\u0017\u000f\u0006\u0002dMB\u0011!\u0007Z\u0005\u0003KN\u0012A!\u00168ji\"9qmBA\u0001\u0002\u0004I\u0016a\u0001=%c\u00059An\\4ESJ\u0004\u0013!D2sK\u0006$XmU3h[\u0016tG\u000f\u0006\u0003TWB,\b\"\u00027\n\u0001\u0004i\u0017AB8gMN,G\u000f\u0005\u00023]&\u0011qn\r\u0002\u0005\u0019>tw\rC\u0004r\u0013A\u0005\t\u0019\u0001:\u0002%%tG-\u001a=J]R,'O^1m\u0005f$Xm\u001d\t\u0003eML!\u0001^\u001a\u0003\u0007%sG\u000fC\u0004w\u0013A\u0005\t\u0019A<\u0002\tQLW.\u001a\t\u0003qnl\u0011!\u001f\u0006\u0003u~\nQ!\u001e;jYNL!\u0001`=\u0003\tQKW.Z\u0001\u0018GJ,\u0017\r^3TK\u001elWM\u001c;%I\u00164\u0017-\u001e7uII*\u0012a \u0016\u0004e\u0006\u00051FAA\u0002!\u0011\t)!a\u0004\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u000551'\u0001\u0006b]:|G/\u0019;j_:LA!!\u0005\u0002\b\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002/\r\u0014X-\u0019;f'\u0016<W.\u001a8uI\u0011,g-Y;mi\u0012\u001aTCAA\fU\r9\u0018\u0011A\u0001\be\u0016\u001cwN\u001d3t)\u0019\ti\"!\u000b\u0002,A!\u0011qDA\u0013\u001b\t\t\tCC\u0002\u0002$}\naA]3d_J$\u0017\u0002BA\u0014\u0003C\u0011Q\"T3n_JL(+Z2pe\u0012\u001c\b\"\u00027\r\u0001\u0004i\u0007bBA\r\u0019\u0001\u0007\u0011Q\u0006\t\u0006e\u0005=\u00121G\u0005\u0004\u0003c\u0019$A\u0003\u001fsKB,\u0017\r^3e}A!\u0011QGA\"\u001d\u0011\t9$a\u0010\u0011\u0007\u0005e2'\u0004\u0002\u0002<)\u0019\u0011QH\u0018\u0002\rq\u0012xn\u001c;?\u0013\r\t\teM\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0013q\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u00053'A\u0003tKR,\b\u000fF\u0001dQ\ri\u0011q\n\t\u0005\u0003#\ny&\u0004\u0002\u0002T)!\u0011QKA,\u0003\r\t\u0007/\u001b\u0006\u0005\u00033\nY&A\u0004kkBLG/\u001a:\u000b\u0007\u0005uC)A\u0003kk:LG/\u0003\u0003\u0002b\u0005M#A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1sI><h\u000eK\u0002\u000f\u0003O\u0002B!!\u0015\u0002j%!\u00111NA*\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0018uKN$\u0018\t\u001d9f]\u00124uN\u001d'pON+w-\\3oi>3gm]3u\u001fZ,'O\u001a7po\u0016C8-\u001a9uS>tG#B2\u0002r\u0005U\u0004BBA:\u001f\u0001\u0007Q.\u0001\u0006cCN,wJ\u001a4tKRDa!a\u001e\u0010\u0001\u0004i\u0017!\u00047be\u001e,7\u000f^(gMN,G\u000fK\u0004\u0010\u0003w\nY)!$\u0011\t\u0005u\u0014qQ\u0007\u0003\u0003\u007fRA!!!\u0002\u0004\u0006A\u0001O]8wS\u0012,'O\u0003\u0003\u0002\u0006\u0006]\u0013A\u00029be\u0006l7/\u0003\u0003\u0002\n\u0006}$!C\"tmN{WO]2f\u0003\u00151\u0018\r\\;fY9\ty)a%\u0002\u0018\u0006m\u0015qTAR\u0003O\u000b#!!%\u0002\u001dAb\u0003%\f\u001a2i]\"\u0004h\r\u001c5q\u0005\u0012\u0011QS\u0001\u000ea1\u0002#'\r\u001b8ia\u001ad\u0007\u000e\u001d\"\u0005\u0005e\u0015\u0001B\u0019-AA\n#!!(\u0002\u000fE\u0002\u0004\u0007\f\u00112a\u0005\u0012\u0011\u0011U\u0001\u000eeE\"t\u0007\u000e\u001d4mQBD\u0006\t\u0019\"\u0005\u0005\u0015\u0016AD\u00173cQ:D\u0007O\u001a7iab\u0003\u0005M\u0011\u0003\u0003S\u000bQCM\u00195oQB4G\u000e\u001b9YQ\u0012\u0014\bN\u001d7oIJd\u0007K\u0002\u0010\u0003[\u0003B!a,\u000226\u0011\u00111Q\u0005\u0005\u0003g\u000b\u0019IA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fa\u0003^3tiJ+\u0017\rZ(o\u000b6\u0004H/_*fO6,g\u000e\u001e\u0015\u0004!\u0005e\u0006\u0003BA)\u0003wKA!!0\u0002T\t!A+Z:u\u0003e!Xm\u001d;SK\u0006$')\u001a4pe\u00164\u0015N]:u\u001f\u001a47/\u001a;)\u0007E\tI,A\tuKN$(+Z1e\u0003\u001a$XM\u001d'bgRD3AEA]\u0003=!Xm\u001d;SK\u0006$gI]8n\u000f\u0006\u0004\bfA\n\u0002:\u0006aA/Z:u)J,hnY1uK\"\u001aA#!/\u00021Q,7\u000f\u001e+sk:\u001c\u0017\r^3F[B$\u0018pU3h[\u0016tG\u000fK\u0002\u0016\u0003s\u000ba\u0007^3tiJ+Gn\\1e\u0019\u0006\u0014x-Z:u)&lWm\u001d;b[B\fe\u000e\u001a(fqR|eMZ:fi\u00063G/\u001a:UeVt7-\u0019;j_:D3AFA]\u0003A!Xm\u001d;UeVt7-\u0019;f\rVdG\u000eK\u0002\u0018\u0003s\u000b\u0011\u0004^3ti\u001aKg\u000eZ(gMN,GOQ=US6,7\u000f^1na\"\u001a\u0001$!/\u00023Q,7\u000f\u001e(fqR|eMZ:fi\u000e\u000bGnY;mCRLwN\u001c\u0015\u00043\u0005e\u0016A\u0006;fgR\u001c\u0005.\u00198hK\u001aKG.Z*vM\u001aL\u00070Z:)\u0007i\tI,A\u000fuKN$(+Z2pm\u0016\u0014\u0018PR5yKN\u001cuN\u001d:vaRLe\u000eZ3yQ\rY\u0012\u0011X\u0001\u001ci\u0016\u001cHOU3d_Z,'\u000f\u0016:b]N\f7\r^5p]&sG-\u001a=)\u0007q\tI,\u0001\u0010uKN$(+Z2pm\u0016\u0014\u0018PU3ck&dGm]#q_\u000eD7)Y2iK\"\u001aQ$!/\u0002\u001b\u0015tG\r\u0016=o%\u0016\u001cwN\u001d3t)A\ti\"a>\u0003\u0002\t\u0015!q\u0002B\t\u0005+\u0011I\u0002C\u0004\u0002zz\u0001\r!a?\u0002#\r|g\u000e\u001e:pYJ+7m\u001c:e)f\u0004X\r\u0005\u0003\u0002 \u0005u\u0018\u0002BA\u0000\u0003C\u0011\u0011cQ8oiJ|GNU3d_J$G+\u001f9f\u0011\u0019\u0011\u0019A\ba\u0001[\u0006Q\u0001O]8ek\u000e,'/\u00133\t\u000f\t\u001da\u00041\u0001\u0003\n\u0005i\u0001O]8ek\u000e,'/\u00129pG\"\u00042A\rB\u0006\u0013\r\u0011ia\r\u0002\u0006'\"|'\u000f\u001e\u0005\u0006Yz\u0001\r!\u001c\u0005\t\u0005'q\u0002\u0013!a\u0001e\u0006!\u0002/\u0019:uSRLwN\u001c'fC\u0012,'/\u00129pG\"D\u0001Ba\u0006\u001f!\u0003\u0005\rA]\u0001\u0011G>|'\u000fZ5oCR|'/\u00129pG\"D\u0001Ba\u0007\u001f!\u0003\u0005\r!\\\u0001\ni&lWm\u001d;b[B\fq#\u001a8e)bt'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0002/\u0015tG\r\u0016=o%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u00122\u0014aF3oIRChNU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011)CK\u0002n\u0003\u0003\t\u0011\u0005^3tiJ+7m\u001c<fef4\u0015\u000e_3t\u0007>\u0014(/\u001e9u)&lW-\u00138eKbD3AIA]\u0003y!Xm\u001d;SK\u000e|g/\u001a:z/&$\bnQ8seV\u0004H/T3tg\u0006<W\rK\u0002$\u0003s#\u0012b\u0015B\u0019\u0005g\u0011iD!\u0011\t\r\u0005MD\u00051\u0001n\u0011\u001d\u0011)\u0004\na\u0001\u0005o\t\u0011CZ5mK\u0006c'/Z1es\u0016C\u0018n\u001d;t!\r\u0011$\u0011H\u0005\u0004\u0005w\u0019$a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0005\u007f!\u0003\u0019\u0001:\u0002\u0019%t\u0017\u000e\u001e$jY\u0016\u001c\u0016N_3\t\u000f\t\rC\u00051\u0001\u00038\u0005Y\u0001O]3bY2|7-\u0019;f\u0003\u001d\"Xm\u001d;De\u0016\fG/Z,ji\"Le.\u001b;GS2,7+\u001b>f\u0003B\u0004XM\u001c3NKN\u001c\u0018mZ3)\u0007\u0015\nI,A\u0014uKN$8I]3bi\u0016<\u0016\u000e\u001e5J]&$h)\u001b7f'&TXm\u00117fCJ\u001c\u0006.\u001e;e_^t\u0007f\u0001\u0014\u0002:\u0006q3\u000f[8vY\u0012$&/\u001e8dCR,WI^3o\u0013\u001a|eMZ:fiB{\u0017N\u001c;t)>\fu)\u00199J]RCW\rT8hQ\r9\u0013\u0011X\u0001\u0013i\u0016\u001cH/\u00119qK:$gI]8n\r&dW\rK\u0002)\u0003s\u000bqC\\3x!J|G-^2feN#\u0018\r^3NC:\fw-\u001a:\u0015\u0005\te\u0003\u0003\u0002B.\u0005Oj!A!\u0018\u000b\u00071\u0012yF\u0003\u0003\u0003b\t\r\u0014!C5oi\u0016\u0014h.\u00197t\u0015\r\u0011)'Q\u0001\bgR|'/Y4f\u0013\u0011\u0011IG!\u0018\u0003)A\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0001")
public class LogSegmentTest {
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final ArrayBuffer<LogSegment> segments = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private File logDir;

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private ArrayBuffer<LogSegment> segments() {
        return this.segments;
    }

    private File logDir() {
        return this.logDir;
    }

    private void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogSegment createSegment(long offset, int indexIntervalBytes, Time time) {
        LogSegment seg = LogTestUtils$.MODULE$.createSegment(offset, this.logDir(), indexIntervalBytes, time);
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public MemoryRecords records(long offset, Seq<String> records) {
        return MemoryRecords.withRecords((byte)1, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)records.map((Function1 & Serializable & scala.Serializable)s -> new SimpleRecord(offset * 10L, s.getBytes()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
    }

    @BeforeEach
    public void setup() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
    }

    @AfterEach
    public void teardown() {
        this.segments().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    @ParameterizedTest
    @CsvSource(value={"0, -2147483648", "0, 2147483648", "1, 0", "100, 10", "2147483648, 0", "-2147483648, 0", "2147483648,4294967296"})
    public void testAppendForLogSegmentOffsetOverflowException(long baseOffset, long largestOffset) {
        LogSegment seg = this.createSegment(baseOffset, this.createSegment$default$2(), this.createSegment$default$3());
        long currentTime = Time.SYSTEM.milliseconds();
        MemoryRecords memoryRecords = this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
        Assertions.assertThrows(LogSegmentOffsetOverflowException.class, () -> seg.append(largestOffset, currentTime, largestOffset, memoryRecords));
    }

    @Test
    public void testReadOnEmptySegment() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        Assertions.assertNull((Object)seg.read(40L, 300, seg.read$default$3(), seg.read$default$4()), (String)"Read beyond the last offset in the segment should be null");
    }

    @Test
    public void testReadBeforeFirstOffset() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "little", "bee"}));
        seg.append(53L, -1L, -1L, ms);
        Records read = seg.read((long)41L, (int)300, (long)seg.read$default$3(), (boolean)seg.read$default$4()).records;
        TestUtils$.MODULE$.checkEquals(ms.records().iterator(), read.records().iterator());
    }

    @Test
    public void testReadAfterLast() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        Assertions.assertNull((Object)seg.read(52L, 200, seg.read$default$3(), seg.read$default$4()), (String)"Read beyond the last offset in the segment should give null");
    }

    @Test
    public void testReadFromGap() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200, seg.read$default$3(), seg.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records.records().iterator());
    }

    @Test
    public void testTruncate() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 30).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords ms1 = this.records(offset$2.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
            seg.append((long)offset$2.elem, -1L, -1L, ms1);
            MemoryRecords ms2 = this.records(offset$2.elem + 1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
            seg.append((long)(offset$2.elem + 1), -1L, -1L, ms2);
            FetchDataInfo read = seg.read((long)offset$2.elem, 10000, seg.read$default$3(), seg.read$default$4());
            Assertions.assertEquals((Object)new .colon.colon((Object)((Record)ms1.records().iterator().next()), (List)new .colon.colon((Object)((Record)ms2.records().iterator().next()), (List)Nil$.MODULE$)), (Object)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(read.records.records()).asScala()).toList());
            seg.truncateTo((long)(offset$2.elem + 1));
            FetchDataInfo read2 = seg.read((long)offset$2.elem, 10000, seg.read$default$3(), seg.read$default$4());
            Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(read2.records.records()).asScala()).size());
            TestUtils$.MODULE$.checkEquals(ms1.records().iterator(), read2.records.records().iterator());
            ++offset$2.elem;
        });
    }

    @Test
    public void testTruncateEmptySegment() {
        int maxSegmentMs = 300000;
        MockTime time = new MockTime();
        long x$1 = 0L;
        int x$3 = this.createSegment$default$2();
        LogSegment seg = this.createSegment(x$1, x$3, (Time)time);
        seg.timeIndex();
        seg.offsetIndex();
        seg.close();
        long x$4 = 0L;
        int x$6 = this.createSegment$default$2();
        LogSegment reopened = this.createSegment(x$4, x$6, (Time)time);
        Assertions.assertEquals((int)0, (int)seg.timeIndex().sizeInBytes());
        Assertions.assertEquals((int)0, (int)seg.offsetIndex().sizeInBytes());
        time.sleep(500L);
        reopened.truncateTo(57L);
        Assertions.assertEquals((long)0L, (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        Assertions.assertFalse((boolean)reopened.timeIndex().isFull());
        Assertions.assertFalse((boolean)reopened.offsetIndex().isFull());
        RollParams rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds());
        Assertions.assertFalse((boolean)reopened.shouldRoll(rollParams));
        time.sleep((long)(maxSegmentMs + 1));
        Assertions.assertEquals((long)(maxSegmentMs + 1), (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds());
        Assertions.assertFalse((boolean)reopened.shouldRoll(rollParams));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, (long)Integer.MAX_VALUE + 200L, 1024, time.milliseconds());
        Assertions.assertTrue((boolean)reopened.shouldRoll(rollParams));
    }

    @Test
    public void testReloadLargestTimestampAndNextOffsetAfterTruncation() {
        int numMessages = 30;
        LogSegment seg = this.createSegment(40L, 2 * this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})).sizeInBytes() - 1, this.createSegment$default$3());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            seg.append((long)offset$3.elem, (long)offset$3.elem, (long)offset$3.elem, this.records(offset$3.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})));
            ++offset$3.elem;
        });
        Assertions.assertEquals((long)offset.elem, (long)seg.readNextOffset());
        int expectedNumEntries = numMessages / 2 - 1;
        Assertions.assertEquals((int)expectedNumEntries, (int)seg.timeIndex().entries(), (String)new StringBuilder(25).append("Should have ").append(expectedNumEntries).append(" time indexes").toString());
        seg.truncateTo(41L);
        Assertions.assertEquals((int)0, (int)seg.timeIndex().entries(), (String)"Should have 0 time indexes");
        Assertions.assertEquals((long)400L, (long)seg.largestTimestamp(), (String)"Largest timestamp should be 400");
        Assertions.assertEquals((long)41L, (long)seg.readNextOffset());
    }

    @Test
    public void testTruncateFull() {
        MockTime time = new MockTime();
        long x$1 = 40L;
        int x$3 = this.createSegment$default$2();
        LogSegment seg = this.createSegment(x$1, x$3, (Time)time);
        seg.append(41L, -1L, -1L, this.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
        time.sleep(500L);
        Assertions.assertEquals((long)500L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        seg.truncateTo(0L);
        Assertions.assertEquals((long)0L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        Assertions.assertFalse((boolean)seg.timeIndex().isFull());
        Assertions.assertFalse((boolean)seg.offsetIndex().isFull());
        Assertions.assertNull((Object)seg.read(0L, 1024, seg.read$default$3(), seg.read$default$4()), (String)"Segment should be empty.");
        seg.append(41L, -1L, -1L, this.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
    }

    @Test
    public void testFindOffsetByTimestamp() {
        int messageSize = this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"msg00"})).sizeInBytes();
        LogSegment seg = this.createSegment(40L, messageSize * 2 - 1, this.createSegment$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(40), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, (long)(i * 10), (long)i, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(3).append("msg").append(i).toString()}))));
        Assertions.assertEquals((long)490L, (long)seg.largestTimestamp());
        Assertions.assertEquals((long)42L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)420L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assertions.assertEquals((long)43L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)421L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assertions.assertEquals((long)43L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)430L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assertions.assertEquals((long)44L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)431L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)seg.findOffsetByTimestamp(491L, seg.findOffsetByTimestamp$default$2()));
        Assertions.assertEquals((long)41L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)401L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assertions.assertEquals((long)40L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)399L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
    }

    @Test
    public void testNextOffsetCalculation() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        Assertions.assertEquals((long)40L, (long)seg.readNextOffset());
        seg.append(52L, -1L, -1L, this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Assertions.assertEquals((long)53L, (long)seg.readNextOffset());
    }

    @Test
    public void testChangeFileSuffixes() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        File logFile = seg.log().file();
        File indexFile = seg.lazyOffsetIndex().file();
        File timeIndexFile = seg.lazyTimeIndex().file();
        Assertions.assertFalse((boolean)seg.lazyOffsetIndex().file().exists());
        Assertions.assertFalse((boolean)seg.lazyTimeIndex().file().exists());
        seg.changeFileSuffixes("", ".deleted");
        Assertions.assertFalse((boolean)seg.lazyOffsetIndex().file().exists());
        Assertions.assertFalse((boolean)seg.lazyTimeIndex().file().exists());
        Assertions.assertEquals((Object)new StringBuilder(8).append(logFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.log().file().getAbsolutePath());
        Assertions.assertEquals((Object)new StringBuilder(8).append(indexFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.lazyOffsetIndex().file().getAbsolutePath());
        Assertions.assertEquals((Object)new StringBuilder(8).append(timeIndexFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.lazyTimeIndex().file().getAbsolutePath());
        Assertions.assertTrue((boolean)seg.log().file().exists());
        seg.lazyOffsetIndex().get();
        Assertions.assertTrue((boolean)seg.lazyOffsetIndex().file().exists());
        seg.lazyTimeIndex().get();
        Assertions.assertTrue((boolean)seg.lazyTimeIndex().file().exists());
    }

    @Test
    public void testRecoveryFixesCorruptIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, -1L, -1L, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(i)}))));
        File indexFile = seg.lazyOffsetIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(indexFile, 5L, (int)indexFile.length());
        seg.recover(this.newProducerStateManager(), seg.recover$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            long x$1 = i;
            int x$2 = 1;
            boolean x$3 = true;
            long x$4 = seg.read$default$3();
            Iterable records = seg$5.read((long)x$1, (int)x$2, (long)x$4, (boolean)x$3).records.records();
            Assertions.assertEquals((long)i, (long)((Record)records.iterator().next()).offset());
        });
    }

    @Test
    public void testRecoverTransactionIndex() {
        LogSegment segment = this.createSegment(100L, this.createSegment$default$2(), this.createSegment$default$3());
        short producerEpoch = (short)0;
        int partitionLeaderEpoch = 15;
        int sequence = 100;
        long pid1 = 5L;
        long pid2 = 10L;
        segment.append(101L, -1L, 100L, MemoryRecords.withTransactionalRecords((long)100L, (CompressionType)CompressionType.NONE, (long)pid1, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(103L, -1L, 102L, MemoryRecords.withTransactionalRecords((long)102L, (CompressionType)CompressionType.NONE, (long)pid2, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(105L, -1L, 104L, MemoryRecords.withRecords((long)104L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(partitionLeaderEpoch), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(106L, -1L, 106L, this.endTxnRecords(ControlRecordType.ABORT, pid2, producerEpoch, 106L, this.endTxnRecords$default$5(), this.endTxnRecords$default$6(), this.endTxnRecords$default$7()));
        segment.append(107L, -1L, 107L, this.endTxnRecords(ControlRecordType.COMMIT, pid1, producerEpoch, 107L, this.endTxnRecords$default$5(), this.endTxnRecords$default$6(), this.endTxnRecords$default$7()));
        ProducerStateManager stateManager = this.newProducerStateManager();
        segment.recover(stateManager, segment.recover$default$2());
        Assertions.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        java.util.List abortedTxns = segment.txnIndex().allAbortedTxns();
        Assertions.assertEquals((int)1, (int)abortedTxns.size());
        AbortedTxn abortedTxn = (AbortedTxn)abortedTxns.get(0);
        Assertions.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assertions.assertEquals((long)102L, (long)abortedTxn.firstOffset());
        Assertions.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assertions.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
        stateManager = this.newProducerStateManager();
        stateManager.loadProducerEntry(new ProducerStateEntry(pid2, producerEpoch, 0, -1L, OptionalLong.of(75L), Optional.of(new BatchMetadata(10, 10L, 5, -1L))));
        segment.recover(stateManager, segment.recover$default$2());
        Assertions.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        abortedTxns = segment.txnIndex().allAbortedTxns();
        Assertions.assertEquals((int)1, (int)abortedTxns.size());
        abortedTxn = (AbortedTxn)abortedTxns.get(0);
        Assertions.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assertions.assertEquals((long)75L, (long)abortedTxn.firstOffset());
        Assertions.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assertions.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
    }

    @Test
    public void testRecoveryRebuildsEpochCache() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        LeaderEpochCheckpoint checkpoint = new LeaderEpochCheckpoint(null){
            private Seq<EpochEntry> epochs;

            private Seq<EpochEntry> epochs() {
                return this.epochs;
            }

            private void epochs_$eq(Seq<EpochEntry> x$1) {
                this.epochs = x$1;
            }

            public void write(Collection<EpochEntry> epochs) {
                this.epochs_$eq((Seq<EpochEntry>)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(epochs).asScala()).toSeq());
            }

            public java.util.List<EpochEntry> read() {
                return (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.epochs()).asJava();
            }
            {
                this.epochs = Nil$.MODULE$;
            }
        };
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.topicPartition(), checkpoint);
        seg.append(105L, -1L, 104L, MemoryRecords.withRecords((long)104L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        seg.append(107L, -1L, 106L, MemoryRecords.withRecords((long)106L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(1), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        seg.append(109L, -1L, 108L, MemoryRecords.withRecords((long)108L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(1), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        seg.append(111L, -1L, 110L, MemoryRecords.withRecords((long)110L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(2), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        seg.recover(this.newProducerStateManager(), (Option)new Some((Object)cache));
        Assertions.assertEquals(Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(0, 104L), new EpochEntry(1, 106L), new EpochEntry(2, 110L)}), (Object)cache.epochEntries());
    }

    private MemoryRecords endTxnRecords(ControlRecordType controlRecordType, long producerId, short producerEpoch, long offset, int partitionLeaderEpoch, int coordinatorEpoch, long timestamp) {
        EndTransactionMarker marker = new EndTransactionMarker(controlRecordType, coordinatorEpoch);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)partitionLeaderEpoch, (long)producerId, (short)producerEpoch, (EndTransactionMarker)marker);
    }

    private int endTxnRecords$default$5() {
        return 0;
    }

    private int endTxnRecords$default$6() {
        return 0;
    }

    private long endTxnRecords$default$7() {
        return -1L;
    }

    @Test
    public void testRecoveryFixesCorruptTimeIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, (long)(i * 10), (long)i, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(i)}))));
        File timeIndexFile = seg.lazyTimeIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(timeIndexFile, 5L, (int)timeIndexFile.length());
        seg.recover(this.newProducerStateManager(), seg.recover$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Assertions.assertEquals((long)i, (long)((FileRecords.TimestampAndOffset)seg$6.findOffsetByTimestamp((long)((long)(i * 10)), (long)seg$6.findOffsetByTimestamp$default$2()).get()).offset);
            if (i < 99) {
                Assertions.assertEquals((long)(i + 1), (long)((FileRecords.TimestampAndOffset)seg$6.findOffsetByTimestamp((long)((long)(i * 10 + 1)), (long)seg$6.findOffsetByTimestamp$default$2()).get()).offset);
                return;
            }
        });
    }

    @Test
    public void testRecoveryWithCorruptMessage() {
        int messagesAppended = 20;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messagesAppended).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, -1L, -1L, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(i)}))));
            int offsetToBeginCorruption = TestUtils$.MODULE$.random().nextInt(messagesAppended);
            int position = seg.log().searchForOffsetWithSize((long)((long)offsetToBeginCorruption), (int)0).position + TestUtils$.MODULE$.random().nextInt(15);
            TestUtils$.MODULE$.writeNonsenseToFile(seg.log().file(), position, (int)(seg.log().file().length() - (long)position));
            seg.recover(this.newProducerStateManager(), seg.recover$default$2());
            Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), offsetToBeginCorruption).toList(), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(seg.log().batches()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.lastOffset()), Iterable$.MODULE$.canBuildFrom())).toList(), (String)"Should have truncated off bad messages.");
            seg.deleteIfExists();
        });
    }

    private LogSegment createSegment(long baseOffset, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogConfig logConfig = new LogConfig((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index.interval.bytes"), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.index.bytes"), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.jitter.ms"), (Object)BoxesRunTime.boxToInteger((int)0))}))).asJava());
        LogSegment seg = LogSegment$.MODULE$.open(tempDir, baseOffset, logConfig, Time.SYSTEM, fileAlreadyExists, initFileSize, preallocate, LogSegment$.MODULE$.open$default$8());
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public int createSegment$default$2() {
        return 10;
    }

    public Time createSegment$default$3() {
        return Time.SYSTEM;
    }

    @Test
    public void testCreateWithInitFileSizeAppendMessage() {
        LogSegment seg = this.createSegment(40L, false, 0x20000000, true);
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200, seg.read$default$3(), seg.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records.records().iterator());
    }

    @Test
    public void testCreateWithInitFileSizeClearShutdown() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogConfig logConfig = new LogConfig((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index.interval.bytes"), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.index.bytes"), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.jitter.ms"), (Object)BoxesRunTime.boxToInteger((int)0))}))).asJava());
        long x$2 = 40L;
        Time x$4 = Time.SYSTEM;
        int x$5 = 0x20000000;
        boolean x$6 = true;
        boolean x$7 = LogSegment$.MODULE$.open$default$5();
        String x$8 = LogSegment$.MODULE$.open$default$8();
        LogSegment seg = LogSegment$.MODULE$.open(tempDir, x$2, logConfig, x$4, x$7, x$5, x$6, x$8);
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200, seg.read$default$3(), seg.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records.records().iterator());
        int oldSize = seg.log().sizeInBytes();
        long oldPosition = seg.log().channel().position();
        long oldFileSize = seg.log().file().length();
        Assertions.assertEquals((long)0x20000000L, (long)oldFileSize);
        seg.close();
        Assertions.assertEquals((long)oldSize, (long)seg.log().file().length());
        LogSegment segReopen = LogSegment$.MODULE$.open(tempDir, 40L, logConfig, Time.SYSTEM, true, 0x20000000, true, LogSegment$.MODULE$.open$default$8());
        this.segments().$plus$eq((Object)segReopen);
        FetchDataInfo readAgain = segReopen.read(55L, 200, segReopen.read$default$3(), segReopen.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), readAgain.records.records().iterator());
        int size = segReopen.log().sizeInBytes();
        long position = segReopen.log().channel().position();
        long fileSize = segReopen.log().file().length();
        Assertions.assertEquals((long)oldPosition, (long)position);
        Assertions.assertEquals((int)oldSize, (int)size);
        Assertions.assertEquals((long)size, (long)fileSize);
    }

    @Test
    public void shouldTruncateEvenIfOffsetPointsToAGapInTheLog() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        int offset = 40;
        MemoryRecords ms1 = LogSegmentTest.records$1(offset, "first message");
        seg.append((long)offset, -1L, -1L, ms1);
        MemoryRecords ms2 = LogSegmentTest.records$1(offset + 3, "message after gap");
        seg.append((long)(offset + 3), -1L, -1L, ms2);
        seg.truncateTo((long)(offset + 1));
        FetchDataInfo log = seg.read((long)offset, 10000, seg.read$default$3(), seg.read$default$4());
        Assertions.assertEquals((long)offset, (long)((RecordBatch)log.records.batches().iterator().next()).baseOffset());
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(log.records.batches()).asScala()).size());
    }

    @Test
    public void testAppendFromFile() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        FileRecords fileRecords = FileRecords.open((File)UnifiedLog$.MODULE$.logFile(tempDir, 0L, UnifiedLog$.MODULE$.logFile$default$3()));
        fileRecords.append(LogSegmentTest.records$2(0L, 1024));
        fileRecords.append(LogSegmentTest.records$2(500L, 0x100001));
        int sizeBeforeOverflow = fileRecords.sizeInBytes();
        fileRecords.append(LogSegmentTest.records$2(0x80000004L, 1024));
        int sizeAfterOverflow = fileRecords.sizeInBytes();
        LogSegment segment = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        int bytesAppended = segment.appendFromFile(fileRecords, 0);
        Assertions.assertEquals((int)sizeBeforeOverflow, (int)bytesAppended);
        Assertions.assertEquals((int)sizeBeforeOverflow, (int)segment.size());
        LogSegment overflowSegment = this.createSegment(Integer.MAX_VALUE, this.createSegment$default$2(), this.createSegment$default$3());
        int overflowBytesAppended = overflowSegment.appendFromFile(fileRecords, sizeBeforeOverflow);
        Assertions.assertEquals((int)(sizeAfterOverflow - sizeBeforeOverflow), (int)overflowBytesAppended);
        Assertions.assertEquals((int)overflowBytesAppended, (int)overflowSegment.size());
        Utils.delete((File)tempDir);
    }

    private ProducerStateManager newProducerStateManager() {
        return new ProducerStateManager(this.topicPartition(), this.logDir(), 300000, new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs(), false), (Time)new MockTime());
    }

    private static final MemoryRecords records$1(long offset, String record) {
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(offset * 1000L, record.getBytes())});
    }

    private static final MemoryRecords records$2(long offset, int size) {
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new byte[size])});
    }
}

