/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.cluster;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.api.ApiVersion$;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.cluster.PartitionStateStore;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.Defaults$;
import kafka.server.MetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Before;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u0013'\u00015BQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001C\u0002\u0013\u0005\u0011\b\u0003\u0004>\u0001\u0001\u0006IA\u000f\u0005\b}\u0001\u0011\r\u0011\"\u0001@\u0011\u0019Y\u0005\u0001)A\u0005\u0001\"9A\n\u0001b\u0001\n\u0003i\u0005BB+\u0001A\u0003%a\nC\u0005W\u0001\u0001\u0007\t\u0019!C\u0001/\"I\u0001\r\u0001a\u0001\u0002\u0004%\t!\u0019\u0005\nO\u0002\u0001\r\u0011!Q!\naC\u0011\u0002\u001b\u0001A\u0002\u0003\u0007I\u0011A,\t\u0013%\u0004\u0001\u0019!a\u0001\n\u0003Q\u0007\"\u00037\u0001\u0001\u0004\u0005\t\u0015)\u0003Y\u0011%i\u0007\u00011AA\u0002\u0013\u0005q\u000bC\u0005o\u0001\u0001\u0007\t\u0019!C\u0001_\"I\u0011\u000f\u0001a\u0001\u0002\u0003\u0006K\u0001\u0017\u0005\ne\u0002\u0001\r\u00111A\u0005\u0002MD\u0011B\u001f\u0001A\u0002\u0003\u0007I\u0011A>\t\u0013u\u0004\u0001\u0019!A!B\u0013!\b\"\u0003@\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0000\u0011-\t9\u0001\u0001a\u0001\u0002\u0004%\t!!\u0003\t\u0017\u00055\u0001\u00011A\u0001B\u0003&\u0011\u0011\u0001\u0005\n\u0003\u001f\u0001!\u0019!C\u0001\u0003#A\u0001\"!\b\u0001A\u0003%\u00111\u0003\u0005\n\u0003?\u0001!\u0019!C\u0001\u0003CA\u0001\"!\u000b\u0001A\u0003%\u00111\u0005\u0005\n\u0003W\u0001!\u0019!C\u0001\u0003[A\u0001\"a\u000f\u0001A\u0003%\u0011q\u0006\u0005\n\u0003{\u0001!\u0019!C\u0001\u0003\u007fA\u0001\"!\u0014\u0001A\u0003%\u0011\u0011\t\u0005\f\u0003\u001f\u0002\u0001\u0019!a\u0001\n\u0003\t\t\u0006C\u0006\u0002Z\u0001\u0001\r\u00111A\u0005\u0002\u0005m\u0003bCA0\u0001\u0001\u0007\t\u0011)Q\u0005\u0003'Bq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0004\u0002t\u0001!\t!!\u001e\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002d\t)\u0012IY:ue\u0006\u001cG\u000fU1si&$\u0018n\u001c8UKN$(BA\u0014)\u0003\u001d\u0019G.^:uKJT!!\u000b\u0016\u0002\u000b-\fgm[1\u000b\u0003-\nA!\u001e8ji\u000e\u00011C\u0001\u0001/!\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u000e\t\u0003o\u0001i\u0011AJ\u0001\tEJ|7.\u001a:JIV\t!\b\u0005\u00020w%\u0011A\b\r\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\u0012\u0001\u0011\t\u0003\u0003&k\u0011A\u0011\u0006\u0003\u0007\u0012\u000baaY8n[>t'BA\u0015F\u0015\t1u)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0011\u0006\u0019qN]4\n\u0005)\u0013%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u0005!A/[7f+\u0005q\u0005CA(T\u001b\u0005\u0001&BA)S\u0003\u0015)H/\u001b7t\u0015\u0005I\u0013B\u0001+Q\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013A\u0002;na\u0012K'/F\u0001Y!\tIf,D\u0001[\u0015\tYF,\u0001\u0002j_*\tQ,\u0001\u0003kCZ\f\u0017BA0[\u0005\u00111\u0015\u000e\\3\u0002\u0015Ql\u0007\u000fR5s?\u0012*\u0017\u000f\u0006\u0002cKB\u0011qfY\u0005\u0003IB\u0012A!\u00168ji\"9a-CA\u0001\u0002\u0004A\u0016a\u0001=%c\u00059A/\u001c9ESJ\u0004\u0013a\u00027pO\u0012K'/M\u0001\fY><G)\u001b:2?\u0012*\u0017\u000f\u0006\u0002cW\"9a\rDA\u0001\u0002\u0004A\u0016\u0001\u00037pO\u0012K'/\r\u0011\u0002\u000f1|w\rR5se\u0005YAn\\4ESJ\u0014t\fJ3r)\t\u0011\u0007\u000fC\u0004g\u001f\u0005\u0005\t\u0019\u0001-\u0002\u00111|w\rR5se\u0001\n!\u0002\\8h\u001b\u0006t\u0017mZ3s+\u0005!\bCA;y\u001b\u00051(BA<S\u0003\rawnZ\u0005\u0003sZ\u0014!\u0002T8h\u001b\u0006t\u0017mZ3s\u00039awnZ'b]\u0006<WM]0%KF$\"A\u0019?\t\u000f\u0019\u0014\u0012\u0011!a\u0001i\u0006YAn\\4NC:\fw-\u001a:!\u0003%awnZ\"p]\u001aLw-\u0006\u0002\u0002\u0002A\u0019Q/a\u0001\n\u0007\u0005\u0015aOA\u0005M_\u001e\u001cuN\u001c4jO\u0006iAn\\4D_:4\u0017nZ0%KF$2AYA\u0006\u0011!1W#!AA\u0002\u0005\u0005\u0011A\u00037pO\u000e{gNZ5hA\u0005Q1\u000f^1uKN#xN]3\u0016\u0005\u0005M\u0001\u0003BA\u000b\u00033i!!a\u0006\u000b\u0005\u001d\u0012\u0016\u0002BA\u000e\u0003/\u00111\u0003U1si&$\u0018n\u001c8Ti\u0006$Xm\u0015;pe\u0016\f1b\u001d;bi\u0016\u001cFo\u001c:fA\u0005\tB-\u001a7bs\u0016$w\n]3sCRLwN\\:\u0016\u0005\u0005\r\u0002\u0003BA\u000b\u0003KIA!a\n\u0002\u0018\t\tB)\u001a7bs\u0016$w\n]3sCRLwN\\:\u0002%\u0011,G.Y=fI>\u0003XM]1uS>t7\u000fI\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0005\u0005=\u0002\u0003BA\u0019\u0003oi!!a\r\u000b\u0007\u0005U\"+\u0001\u0004tKJ4XM]\u0005\u0005\u0003s\t\u0019DA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u000f[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3!\u0003EygMZ:fi\u000eCWmY6q_&tGo]\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\n\u0019$A\u0006dQ\u0016\u001c7\u000e]8j]R\u001c\u0018\u0002BA&\u0003\u000b\u0012\u0011c\u00144gg\u0016$8\t[3dWB|\u0017N\u001c;t\u0003IygMZ:fi\u000eCWmY6q_&tGo\u001d\u0011\u0002\u0013A\f'\u000f^5uS>tWCAA*!\u0011\t)\"!\u0016\n\t\u0005]\u0013q\u0003\u0002\n!\u0006\u0014H/\u001b;j_:\fQ\u0002]1si&$\u0018n\u001c8`I\u0015\fHc\u00012\u0002^!Aa\rIA\u0001\u0002\u0004\t\u0019&\u0001\u0006qCJ$\u0018\u000e^5p]\u0002\nQa]3ukB$\u0012A\u0019\u0015\u0004E\u0005\u001d\u0004\u0003BA5\u0003_j!!a\u001b\u000b\u0007\u00055t)A\u0003kk:LG/\u0003\u0003\u0002r\u0005-$A\u0002\"fM>\u0014X-A\nde\u0016\fG/\u001a'pOB\u0013x\u000e]3si&,7\u000f\u0006\u0003\u0002x\u0005\r\u0005\u0003BA=\u0003\u007fj!!a\u001f\u000b\u0007\u0005uD,\u0001\u0003vi&d\u0017\u0002BAA\u0003w\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\t)i\ta\u0001\u0003\u000f\u000b\u0011b\u001c<feJLG-Z:\u0011\u0011\u0005%\u0015qSAO\u0003;sA!a#\u0002\u0014B\u0019\u0011Q\u0012\u0019\u000e\u0005\u0005=%bAAIY\u00051AH]8pizJ1!!&1\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011TAN\u0005\ri\u0015\r\u001d\u0006\u0004\u0003+\u0003\u0004\u0003BAE\u0003?KA!!)\u0002\u001c\n11\u000b\u001e:j]\u001e\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004I\u0005\u001d\u0006\u0003BA5\u0003SKA!a+\u0002l\t)\u0011I\u001a;fe\u0002")
public class AbstractPartitionTest {
    private final int brokerId;
    private final TopicPartition topicPartition = new TopicPartition("test-topic", 0);
    private final MockTime time = new MockTime();
    private File tmpDir;
    private File logDir1;
    private File logDir2;
    private LogManager logManager;
    private LogConfig logConfig;
    private final PartitionStateStore stateStore = (PartitionStateStore)Mockito.mock(PartitionStateStore.class);
    private final DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
    private Partition partition;

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MockTime time() {
        return this.time;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir1() {
        return this.logDir1;
    }

    public void logDir1_$eq(File x$1) {
        this.logDir1 = x$1;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public void logDir2_$eq(File x$1) {
        this.logDir2 = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public void logConfig_$eq(LogConfig x$1) {
        this.logConfig = x$1;
    }

    public PartitionStateStore stateStore() {
        return this.stateStore;
    }

    public DelayedOperations delayedOperations() {
        return this.delayedOperations;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public OffsetCheckpoints offsetCheckpoints() {
        return this.offsetCheckpoints;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    @Before
    public void setup() {
        TestUtils$.MODULE$.clearYammerMetrics();
        Properties logProps = this.createLogProperties((Map<String, String>)Predef$.MODULE$.Map().empty());
        this.logConfig_$eq(new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2()));
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logDir1_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.logDir2_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        boolean x$1 = false;
        int x$2 = CleanerConfig$.MODULE$.apply$default$1();
        long x$3 = CleanerConfig$.MODULE$.apply$default$2();
        double x$4 = CleanerConfig$.MODULE$.apply$default$3();
        int x$5 = CleanerConfig$.MODULE$.apply$default$4();
        int x$6 = CleanerConfig$.MODULE$.apply$default$5();
        double x$7 = CleanerConfig$.MODULE$.apply$default$6();
        long x$8 = CleanerConfig$.MODULE$.apply$default$7();
        String x$9 = CleanerConfig$.MODULE$.apply$default$9();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)this.logDir1(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$)), this.logConfig(), new CleanerConfig(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1, x$9), this.time()));
        this.logManager().startup();
        this.partition_$eq(new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), this.stateStore(), this.delayedOperations(), this.metadataCache(), this.logManager()));
        Mockito.when((Object)this.stateStore().fetchTopicConfig()).thenReturn((Object)this.createLogProperties((Map<String, String>)Predef$.MODULE$.Map().empty()));
        Mockito.when((Object)this.offsetCheckpoints().fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()))).thenReturn((Object)None$.MODULE$);
    }

    public Properties createLogProperties(Map<String, String> overrides) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return logProps.put(k, v);
            }
            throw new MatchError(null);
        });
        return logProps;
    }

    @After
    public void tearDown() {
        if (this.tmpDir().exists()) {
            this.logManager().shutdown();
            Utils.delete((File)this.tmpDir());
            TestUtils$.MODULE$.clearYammerMetrics();
            return;
        }
    }

    public AbstractPartitionTest() {
        this.brokerId = 101;
    }
}

