/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import kafka.log.CorruptIndexException;
import kafka.log.TimeIndex;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.Range;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001a4Aa\u0005\u000b\u00013!)\u0001\u0005\u0001C\u0001C!9A\u0005\u0001a\u0001\n\u0003)\u0003bB\u0015\u0001\u0001\u0004%\tA\u000b\u0005\u0007a\u0001\u0001\u000b\u0015\u0002\u0014\t\u000fE\u0002!\u0019!C\u0001e!1a\u0007\u0001Q\u0001\nMBqa\u000e\u0001C\u0002\u0013\u0005\u0001\b\u0003\u0004=\u0001\u0001\u0006I!\u000f\u0005\u0006{\u0001!\tA\u0010\u0005\u0006\u0011\u0002!\tA\u0010\u0005\u0006\u001b\u0002!\tA\u0010\u0005\u0006%\u0002!\tA\u0010\u0005\u0006)\u0002!\tA\u0010\u0005\u0006I\u0002!\tA\u0010\u0005\u0006M\u0002!\tA\u0010\u0005\u0006Q\u0002!I!\u001b\u0005\u0006Y\u0002!\t!\u001c\u0005\u0006m\u0002!\tA\u0010\u0002\u000e)&lW-\u00138eKb$Vm\u001d;\u000b\u0005U1\u0012a\u00017pO*\tq#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u00111\u0005A\u0007\u0002)\u0005\u0019\u0011\u000e\u001a=\u0016\u0003\u0019\u0002\"aI\u0014\n\u0005!\"\"!\u0003+j[\u0016Le\u000eZ3y\u0003\u001dIG\r_0%KF$\"a\u000b\u0018\u0011\u0005ma\u0013BA\u0017\u001d\u0005\u0011)f.\u001b;\t\u000f=\u001a\u0011\u0011!a\u0001M\u0005\u0019\u0001\u0010J\u0019\u0002\t%$\u0007\u0010I\u0001\u000b[\u0006DXI\u001c;sS\u0016\u001cX#A\u001a\u0011\u0005m!\u0014BA\u001b\u001d\u0005\rIe\u000e^\u0001\f[\u0006DXI\u001c;sS\u0016\u001c\b%\u0001\u0006cCN,wJ\u001a4tKR,\u0012!\u000f\t\u00037iJ!a\u000f\u000f\u0003\t1{gnZ\u0001\fE\u0006\u001cXm\u00144gg\u0016$\b%A\u0003tKR,\b\u000fF\u0001,Q\tI\u0001\t\u0005\u0002B\r6\t!I\u0003\u0002D\t\u0006)!.\u001e8ji*\tQ)A\u0002pe\u001eL!a\u0012\"\u0003\r\t+gm\u001c:f\u0003!!X-\u0019:e_^t\u0007F\u0001\u0006K!\t\t5*\u0003\u0002M\u0005\n)\u0011I\u001a;fe\u0006QA/Z:u\u0019>|7.\u00169)\u0005-y\u0005CA!Q\u0013\t\t&I\u0001\u0003UKN$\u0018!\u0003;fgR,e\u000e\u001e:zQ\taq*A\tuKN$XI\u001c;ss>3XM\u001d4m_^DC!D(W/\u0006AQ\r\u001f9fGR,GmI\u0001Y!\tI\u0016M\u0004\u0002[?:\u00111LX\u0007\u00029*\u0011Q\fG\u0001\u0007yI|w\u000e\u001e \n\u0003uI!\u0001\u0019\u000f\u0002\u000fA\f7m[1hK&\u0011!m\u0019\u0002\u0019\u00132dWmZ1m\u0003J<W/\\3oi\u0016C8-\u001a9uS>t'B\u00011\u001d\u00031!Xm\u001d;UeVt7-\u0019;fQ\tqq*\u0001\u0006uKN$\u0018\t\u001d9f]\u0012D#aD(\u0002\u001b\u0005\u0004\b/\u001a8e\u000b:$(/[3t)\tY#\u000eC\u0003l!\u0001\u00071'\u0001\u0006ok6,e\u000e\u001e:jKN\f1C\\8o\u000bbL7\u000f^1oiR+W\u000e\u001d$jY\u0016$\u0012A\u001c\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\f!![8\u000b\u0003M\fAA[1wC&\u0011Q\u000f\u001d\u0002\u0005\r&dW-A\buKN$8+\u00198jif\u001c\u0005.Z2lQ\t\u0011r\n")
public class TimeIndexTest {
    private TimeIndex idx = null;
    private final int maxEntries;
    private final long baseOffset;

    public TimeIndex idx() {
        return this.idx;
    }

    public void idx_$eq(TimeIndex x$1) {
        this.idx = x$1;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    @Before
    public void setup() {
        this.idx_$eq(new TimeIndex(this.nonExistantTempFile(), this.baseOffset(), this.maxEntries() * 12, TimeIndex$.MODULE$.$lessinit$greater$default$4()));
    }

    @After
    public void teardown() {
        if (this.idx() != null) {
            this.idx().file().delete();
            return;
        }
    }

    @Test
    public void testLookUp() {
        Assert.assertEquals((Object)new TimestampOffset(-1L, this.baseOffset()), (Object)this.idx().lookup(100L));
        this.appendEntries(this.maxEntries() - 1);
        Assert.assertEquals((Object)new TimestampOffset(-1L, this.baseOffset()), (Object)this.idx().lookup(9L));
        Assert.assertEquals((Object)new TimestampOffset(20L, 65L), (Object)this.idx().lookup(25L));
        Assert.assertEquals((Object)new TimestampOffset(30L, 75L), (Object)this.idx().lookup(30L));
    }

    @Test
    public void testEntry() {
        this.appendEntries(this.maxEntries() - 1);
        Assert.assertEquals((Object)new TimestampOffset(10L, 55L), (Object)this.idx().entry(0));
        Assert.assertEquals((Object)new TimestampOffset(20L, 65L), (Object)this.idx().entry(1));
        Assert.assertEquals((Object)new TimestampOffset(30L, 75L), (Object)this.idx().entry(2));
        Assert.assertEquals((Object)new TimestampOffset(40L, 85L), (Object)this.idx().entry(3));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEntryOverflow() {
        this.idx().entry(0);
    }

    @Test
    public void testTruncate() {
        this.appendEntries(this.maxEntries() - 1);
        this.idx().truncate();
        Assert.assertEquals((long)0L, (long)this.idx().entries());
        this.appendEntries(this.maxEntries() - 1);
        this.idx().truncateTo(10L + this.baseOffset());
        Assert.assertEquals((long)0L, (long)this.idx().entries());
    }

    @Test
    public void testAppend() {
        this.appendEntries(this.maxEntries() - 1);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TimeIndex qual$1 = this.idx();
            long x$1 = 10000L;
            long x$2 = 1000L;
            boolean x$3 = qual$1.maybeAppend$default$3();
            qual$1.maybeAppend(x$1, x$2, x$3);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TimeIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.idx().maybeAppend(10000L, (long)((this.maxEntries() - 2) * 10), true), ClassTag$.MODULE$.apply(InvalidOffsetException.class), new Position("TimeIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        this.idx().maybeAppend(10000L, 1000L, true);
    }

    private void appendEntries(int numEntries) {
        int n = 1;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, numEntries);
        if (inclusive == null) {
            throw null;
        }
        Range.Inclusive foreach$mVc$sp_this = inclusive;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                TimeIndexTest.$anonfun$appendEntries$1(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    public File nonExistantTempFile() {
        File file = TestUtils$.MODULE$.tempFile();
        file.delete();
        return file;
    }

    @Test
    public void testSanityCheck() {
        this.idx().sanityCheck();
        this.appendEntries(5);
        TimestampOffset firstEntry = this.idx().entry(0);
        this.idx().sanityCheck();
        this.idx().close();
        BooleanRef shouldCorruptOffset = BooleanRef.create((boolean)false);
        BooleanRef shouldCorruptTimestamp = BooleanRef.create((boolean)false);
        BooleanRef shouldCorruptLength = BooleanRef.create((boolean)false);
        this.idx_$eq(new TimeIndex(this, shouldCorruptOffset, shouldCorruptTimestamp, firstEntry, shouldCorruptLength){
            private final BooleanRef shouldCorruptOffset$1;
            private final BooleanRef shouldCorruptTimestamp$1;
            private final TimestampOffset firstEntry$1;
            private final BooleanRef shouldCorruptLength$1;

            public TimestampOffset lastEntry() {
                TimestampOffset superLastEntry = super.lastEntry();
                long offset = this.shouldCorruptOffset$1.elem ? this.baseOffset() - 1L : superLastEntry.offset();
                long timestamp = this.shouldCorruptTimestamp$1.elem ? this.firstEntry$1.timestamp() - 1L : superLastEntry.timestamp();
                return new TimestampOffset(timestamp, offset);
            }

            public long length() {
                long superLength = super.length();
                if (this.shouldCorruptLength$1.elem) {
                    return superLength - 1L;
                }
                return superLength;
            }
            {
                this.shouldCorruptOffset$1 = shouldCorruptOffset$1;
                this.shouldCorruptTimestamp$1 = shouldCorruptTimestamp$1;
                this.firstEntry$1 = firstEntry$1;
                this.shouldCorruptLength$1 = shouldCorruptLength$1;
                super($outer.idx().file(), $outer.baseOffset(), $outer.maxEntries() * 12, TimeIndex$.MODULE$.$lessinit$greater$default$4());
            }
        });
        shouldCorruptOffset.elem = true;
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.idx().sanityCheck(), ClassTag$.MODULE$.apply(CorruptIndexException.class), new Position("TimeIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        shouldCorruptOffset.elem = false;
        shouldCorruptTimestamp.elem = true;
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.idx().sanityCheck(), ClassTag$.MODULE$.apply(CorruptIndexException.class), new Position("TimeIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        shouldCorruptTimestamp.elem = false;
        shouldCorruptLength.elem = true;
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.idx().sanityCheck(), ClassTag$.MODULE$.apply(CorruptIndexException.class), new Position("TimeIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        shouldCorruptLength.elem = false;
        this.idx().sanityCheck();
        this.idx().close();
    }

    public static final /* synthetic */ void $anonfun$appendEntries$1(TimeIndexTest $this, int i) {
        TimeIndex qual$1 = $this.idx();
        long x$1 = i * 10;
        long x$2 = (long)(i * 10) + $this.baseOffset();
        boolean x$3 = qual$1.maybeAppend$default$3();
        qual$1.maybeAppend(x$1, x$2, x$3);
    }

    public TimeIndexTest() {
        this.maxEntries = 30;
        this.baseOffset = 45L;
    }
}

