/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerState;
import kafka.controller.KafkaController;
import kafka.controller.MockEvent;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionState;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\n\u0015\u0001eAQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013\u00051\u0006\u0003\u00047\u0001\u0001\u0006I\u0001\f\u0005\bo\u0001\u0011\r\u0011\"\u00019\u0011\u0019y\u0004\u0001)A\u0005s!9\u0001\t\u0001b\u0001\n\u0003A\u0004BB!\u0001A\u0003%\u0011\bC\u0004C\u0001\t\u0007I\u0011\u0001\u001d\t\r\r\u0003\u0001\u0015!\u0003:\u0011\u001d!\u0005A1A\u0005\u0002\u0015CaA\u0014\u0001!\u0002\u00131\u0005bB(\u0001\u0005\u0004%\t\u0001\u0015\u0005\u0007/\u0002\u0001\u000b\u0011B)\t\u000fa\u0003!\u0019!C\u00013\"1!\r\u0001Q\u0001\niCQa\u0019\u0001\u0005B\u0011DQ!\u001d\u0001\u0005BIDQ! \u0001\u0005\u0002I\u0014acQ8oiJ|G\u000e\\3s\r\u0006LGn\u001c<feR+7\u000f\u001e\u0006\u0003+Y\t!bY8oiJ|G\u000e\\3s\u0015\u00059\u0012!B6bM.\f7\u0001A\n\u0004\u0001i\u0001\u0003CA\u000e\u001f\u001b\u0005a\"BA\u000f\u0017\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u0005}a\"AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r2\u0012!B;uS2\u001c\u0018BA\u0013#\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#\u0001\u0015\u0011\u0005%\u0002Q\"\u0001\u000b\u0002\u00071|w-F\u0001-!\tiC'D\u0001/\u0015\ty\u0003'A\u0003m_\u001e$$N\u0003\u00022e\u00051\u0011\r]1dQ\u0016T\u0011aM\u0001\u0004_J<\u0017BA\u001b/\u0005\u0019aunZ4fe\u0006!An\\4!\u0003!qW/\u001c(pI\u0016\u001cX#A\u001d\u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\u0007%sG/A\u0005ok6tu\u000eZ3tA\u0005Aa.^7QCJ$8/A\u0005ok6\u0004\u0016M\u001d;tA\u0005aQn]4Rk\u0016,XmU5{K\u0006iQn]4Rk\u0016,XmU5{K\u0002\nQ\u0001^8qS\u000e,\u0012A\u0012\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000bA\u0001\\1oO*\t1*\u0001\u0003kCZ\f\u0017BA'I\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\nqb\u001c<feJLG-\u001b8h!J|\u0007o]\u000b\u0002#B\u0011!+V\u0007\u0002'*\u0011AKS\u0001\u0005kRLG.\u0003\u0002W'\nQ\u0001K]8qKJ$\u0018.Z:\u0002!=4XM\u001d:jI&tw\r\u0015:paN\u0004\u0013aB7fiJL7m]\u000b\u00025B\u00111\fY\u0007\u00029*\u0011\u0001,\u0018\u0006\u0003=~\u000baaY8n[>t'BA\f1\u0013\t\tGLA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\nqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002KB\u0019a-[6\u000e\u0003\u001dT!\u0001[\u001e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002kO\n\u00191+Z9\u0011\u00051|W\"A7\u000b\u000594\u0012AB:feZ,'/\u0003\u0002q[\nY1*\u00194lC\u000e{gNZ5h\u0003!!X-\u0019:E_^tG#A:\u0011\u0005i\"\u0018BA;<\u0005\u0011)f.\u001b;)\u0005E9\bC\u0001=|\u001b\u0005I(B\u0001>3\u0003\u0015QWO\\5u\u0013\ta\u0018PA\u0003BMR,'/A\u0010uKN$\b*\u00198eY\u0016LE\u000e\\3hC2\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:D#AE@\u0011\u0007a\f\t!C\u0002\u0002\u0004e\u0014A\u0001V3ti\u0002")
public class ControllerFailoverTest
extends KafkaServerTestHarness {
    private final Logger log = Logger.getLogger(ControllerFailoverTest.class);
    private final int numNodes;
    private final int numParts;
    private final int msgQueueSize;
    private final String topic;
    private final Properties overridingProps = new Properties();
    private final Metrics metrics = new Metrics();

    public Logger log() {
        return this.log;
    }

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public int msgQueueSize() {
        return this.msgQueueSize;
    }

    public String topic() {
        return this.topic;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numNodes(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHandleIllegalStateException() {
        Option option = this.servers().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ControllerFailoverTest.$anonfun$testHandleIllegalStateException$1(x$2)));
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((KafkaServer)map_this.get()).kafkaController());
        if (object == null) {
            throw null;
        }
        None$ getOrElse_this = object;
        if (getOrElse_this.isEmpty()) {
            throw Assertions$.MODULE$.fail("Could not find controller", new Position("ControllerFailoverTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        }
        KafkaController initialController = (KafkaController)getOrElse_this.get();
        int initialEpoch = initialController.epoch();
        this.createTopic(this.topic(), 1, 1, this.createTopic$default$4());
        TopicPartition topicPartition = new TopicPartition("topic1", 0);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerFailoverTest.$anonfun$testHandleIllegalStateException$4(initialController, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ControllerFailoverTest.$anonfun$testHandleIllegalStateException$5(topicPartition), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference exceptionThrown = new AtomicReference();
        MockEvent illegalStateEvent = new MockEvent(null, initialController, exceptionThrown, latch){
            private final KafkaController initialController$1;
            private final AtomicReference exceptionThrown$1;
            private final CountDownLatch latch$1;

            public void process() {
                try {
                    throw this.initialController$1.handleIllegalState(new IllegalStateException("Thrown for test purposes"));
                }
                catch (Throwable t) {
                    this.exceptionThrown$1.set(t);
                    this.latch$1.await();
                    return;
                }
            }
            {
                this.initialController$1 = initialController$1;
                this.exceptionThrown$1 = exceptionThrown$1;
                this.latch$1 = latch$1;
                super((ControllerState)ControllerState.BrokerChange$.MODULE$);
            }
        };
        initialController.eventManager().put((ControllerEvent)illegalStateEvent);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerFailoverTest.$anonfun$testHandleIllegalStateException$6(initialController)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ControllerFailoverTest.$anonfun$testHandleIllegalStateException$7(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ControllerFailoverTest.$anonfun$testHandleIllegalStateException$8(initialController)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ControllerFailoverTest.$anonfun$testHandleIllegalStateException$9(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        latch.countDown();
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!ControllerFailoverTest.$anonfun$testHandleIllegalStateException$10(exceptionThrown)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ControllerFailoverTest.$anonfun$testHandleIllegalStateException$11(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Assert.assertTrue((String)new StringBuilder(73).append("handleIllegalState should throw an IllegalStateException, but ").append(exceptionThrown).append(" was thrown").toString(), (boolean)(exceptionThrown.get() instanceof IllegalStateException));
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!ControllerFailoverTest.$anonfun$testHandleIllegalStateException$12(this, initialEpoch)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ControllerFailoverTest.$anonfun$testHandleIllegalStateException$14(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testHandleIllegalStateException$1(KafkaServer x$2) {
        return x$2.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testHandleIllegalStateException$4(KafkaController initialController$1, TopicPartition topicPartition$1) {
        return initialController$1.controllerContext().partitionsInState((PartitionState)OnlinePartition$.MODULE$).contains((Object)topicPartition$1);
    }

    public static final /* synthetic */ String $anonfun$testHandleIllegalStateException$5(TopicPartition topicPartition$1) {
        return new StringBuilder(45).append("Partition ").append(topicPartition$1).append(" did not transition to online state").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testHandleIllegalStateException$6(KafkaController initialController$1) {
        return !initialController$1.kafkaScheduler().isStarted();
    }

    public static final /* synthetic */ String $anonfun$testHandleIllegalStateException$7() {
        return "Scheduler was not shutdown";
    }

    public static final /* synthetic */ boolean $anonfun$testHandleIllegalStateException$8(KafkaController initialController$1) {
        return !initialController$1.isActive();
    }

    public static final /* synthetic */ String $anonfun$testHandleIllegalStateException$9() {
        return "Controller did not become inactive";
    }

    public static final /* synthetic */ boolean $anonfun$testHandleIllegalStateException$10(AtomicReference exceptionThrown$1) {
        return Option$.MODULE$.apply(exceptionThrown$1.get()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testHandleIllegalStateException$11() {
        return "handleIllegalState did not throw an exception";
    }

    public static final /* synthetic */ boolean $anonfun$testHandleIllegalStateException$13(int initialEpoch$1, KafkaServer server) {
        return server.kafkaController().isActive() && server.kafkaController().epoch() > initialEpoch$1;
    }

    public static final /* synthetic */ boolean $anonfun$testHandleIllegalStateException$12(ControllerFailoverTest $this, int initialEpoch$1) {
        return $this.servers().exists((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)ControllerFailoverTest.$anonfun$testHandleIllegalStateException$13(initialEpoch$1, server)));
    }

    public static final /* synthetic */ String $anonfun$testHandleIllegalStateException$14() {
        return "Failed to find controller";
    }

    public ControllerFailoverTest() {
        this.numNodes = 2;
        this.numParts = 1;
        this.msgQueueSize = 1;
        this.topic = "topic1";
        this.overridingProps().put(KafkaConfig$.MODULE$.NumPartitionsProp(), Integer.toString(this.numParts()));
    }
}

