/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.ApiVersion$;
import kafka.api.BaseAdminIntegrationTest;
import kafka.api.PlaintextAdminIntegrationTest$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.security.authorizer.AclEntry$;
import kafka.server.Defaults$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsResult;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.ElectLeadersOptions;
import org.apache.kafka.clients.admin.ElectLeadersResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClientTest;
import org.apache.kafka.clients.admin.ListConsumerGroupsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.admin.MemberToRemove;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupOptions;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ElectionNotNeededException;
import org.apache.kafka.common.errors.EligibleLeadersNotAvailableException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.errors.GroupSubscribedToTopicException;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.PreferredLeaderNotAvailableException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\r}a\u0001B'O\u0001MCQ\u0001\u0017\u0001\u0005\u0002eCqa\u0017\u0001C\u0002\u0013\u0005A\f\u0003\u0004f\u0001\u0001\u0006I!\u0018\u0005\bM\u0002\u0011\r\u0011\"\u0001h\u0011\u0019q\u0007\u0001)A\u0005Q\"9q\u000e\u0001b\u0001\n\u0003\u0001\bB\u0002?\u0001A\u0003%\u0011\u000fC\u0005~\u0001\u0001\u0007\t\u0019!C\u0005}\"Y\u00111\u0002\u0001A\u0002\u0003\u0007I\u0011BA\u0007\u0011)\tI\u0002\u0001a\u0001\u0002\u0003\u0006Ka \u0005\n\u00037\u0001!\u0019!C\u0005\u0003;A\u0001\"a\u0011\u0001A\u0003%\u0011q\u0004\u0005\b\u0003\u000b\u0002A\u0011IA$\u0011\u001d\t9\u0006\u0001C!\u0003\u000fBq!!\u0019\u0001\t\u0003\t9\u0005C\u0004\u0002l\u0001!\t!a\u0012\t\u000f\u0005=\u0004\u0001\"\u0001\u0002H!9\u00111\u000f\u0001\u0005\u0002\u0005\u001d\u0003bBA<\u0001\u0011\u0005\u0011q\t\u0005\b\u0003w\u0002A\u0011AA$\u0011\u001d\ty\b\u0001C\u0001\u0003\u000fBq!a!\u0001\t\u0003\t9\u0005C\u0004\u0002\b\u0002!\t!a\u0012\t\u000f\u0005-\u0005\u0001\"\u0001\u0002H!9\u0011q\u0012\u0001\u0005\u0002\u0005\u001d\u0003bBAJ\u0001\u0011\u0005\u0011q\t\u0005\b\u0003/\u0003A\u0011AA$\u0011\u001d\tY\n\u0001C\u0001\u0003\u000fBq!a(\u0001\t\u0003\t9\u0005C\u0004\u0002$\u0002!\t!a\u0012\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002H!9\u00111\u0016\u0001\u0005\u0002\u0005\u001d\u0003bBAX\u0001\u0011\u0005\u0011q\t\u0005\b\u0003g\u0003A\u0011AA$\u0011\u001d\t9\f\u0001C\u0005\u0003sCq!a7\u0001\t\u0013\ti\u000eC\u0004\u0002t\u0002!\t!a\u0012\t\u000f\u0005]\b\u0001\"\u0001\u0002H!9\u00111 \u0001\u0005\u0002\u0005\u001d\u0003bBA\u0000\u0001\u0011\u0005\u0011q\t\u0005\b\u0005\u0007\u0001A\u0011AA$\u0011\u001d\u00119\u0001\u0001C\u0001\u0003\u000fBqAa\u0003\u0001\t\u0003\t9\u0005C\u0004\u0003\u0010\u0001!\t!a\u0012\t\u000f\tM\u0001\u0001\"\u0001\u0002H!9!q\u0003\u0001\u0005\u0002\u0005\u001d\u0003b\u0002B\u000e\u0001\u0011\u0005\u0011q\t\u0005\b\u0005?\u0001A\u0011AA$\u0011\u001d\u0011\u0019\u0003\u0001C\u0001\u0003\u000fBqAa\n\u0001\t\u0003\t9\u0005C\u0004\u0003,\u0001!\t!a\u0012\t\u000f\t=\u0002\u0001\"\u0001\u0002H!9!1\u0007\u0001\u0005\u0002\u0005\u001d\u0003b\u0002B\u001c\u0001\u0011\u0005\u0011q\t\u0005\b\u0005w\u0001A\u0011AA$\u0011\u001d\u0011y\u0004\u0001C\u0001\u0003\u000fBqAa\u0011\u0001\t\u0003\t9\u0005C\u0004\u0003H\u0001!\t!a\u0012\t\u000f\t-\u0003\u0001\"\u0001\u0002H!9!q\n\u0001\u0005\u0002\u0005\u001d\u0003b\u0002B*\u0001\u0011\u0005\u0011q\t\u0005\b\u0005/\u0002A\u0011AA$\u0011\u001d\u0011Y\u0006\u0001C\u0001\u0003\u000fBqAa\u001a\u0001\t\u0003\t9\u0005C\u0004\u0003n\u0001!\t!a\u0012\t\u000f\tM\u0004\u0001\"\u0001\u0002H!9!\u0011\u0010\u0001\u0005\u0002\u0005\u001d\u0003b\u0002B@\u0001\u0011\u0005!\u0011\u0011\u0005\n\u0005S\u0003\u0011\u0013!C\u0001\u0005WCqA!1\u0001\t\u0003\u0011\u0019\rC\u0004\u0003L\u0002!I!a\u0012\b\u000f\t5g\n#\u0001\u0003P\u001a1QJ\u0014E\u0001\u0005#Da\u0001W%\u0005\u0002\te\u0007b\u0002Bn\u0013\u0012\u0005!Q\u001c\u0005\b\u0005cLE\u0011\u0001Bz\u0005u\u0001F.Y5oi\u0016DH/\u00113nS:Le\u000e^3he\u0006$\u0018n\u001c8UKN$(BA(Q\u0003\r\t\u0007/\u001b\u0006\u0002#\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001U!\t)f+D\u0001O\u0013\t9fJ\u0001\rCCN,\u0017\tZ7j]&sG/Z4sCRLwN\u001c+fgR\fa\u0001P5oSRtD#\u0001.\u0011\u0005U\u0003\u0011!\u0002;pa&\u001cW#A/\u0011\u0005y\u001bW\"A0\u000b\u0005\u0001\f\u0017\u0001\u00027b]\u001eT\u0011AY\u0001\u0005U\u00064\u0018-\u0003\u0002e?\n11\u000b\u001e:j]\u001e\fa\u0001^8qS\u000e\u0004\u0013!\u00039beRLG/[8o+\u0005A\u0007CA5m\u001b\u0005Q'\"A6\u0002\u000bM\u001c\u0017\r\\1\n\u00055T'aA%oi\u0006Q\u0001/\u0019:uSRLwN\u001c\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\t\u0011\u000f\u0005\u0002su6\t1O\u0003\u0002uk\u000611m\\7n_:T!!\u0015<\u000b\u0005]D\u0018AB1qC\u000eDWMC\u0001z\u0003\ry'oZ\u0005\u0003wN\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u0003i\u0011'o\\6fe2{wmZ3s\u0007>tg-[4SKN|WO]2f+\u0005y\b\u0003BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u00151/\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003\u0013\t\u0019A\u0001\bD_:4\u0017n\u001a*fg>,(oY3\u0002=\t\u0014xn[3s\u0019><w-\u001a:D_:4\u0017n\u001a*fg>,(oY3`I\u0015\fH\u0003BA\b\u0003+\u00012![A\t\u0013\r\t\u0019B\u001b\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0018%\t\t\u00111\u0001\u0000\u0003\rAH%M\u0001\u001cEJ|7.\u001a:M_\u001e<WM]\"p]\u001aLwMU3t_V\u00148-\u001a\u0011\u0002)\rD\u0017M\\4fI\n\u0013xn[3s\u0019><w-\u001a:t+\t\ty\u0002\u0005\u0004\u0002\"\u0005-\u0012qF\u0007\u0003\u0003GQA!!\n\u0002(\u00059Q.\u001e;bE2,'bAA\u0015U\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055\u00121\u0005\u0002\u0004'\u0016$\b\u0003BA\u0019\u0003\u007fqA!a\r\u0002<A\u0019\u0011Q\u00076\u000e\u0005\u0005]\"bAA\u001d%\u00061AH]8pizJ1!!\u0010k\u0003\u0019\u0001&/\u001a3fM&\u0019A-!\u0011\u000b\u0007\u0005u\".A\u000bdQ\u0006tw-\u001a3Ce>\\WM\u001d'pO\u001e,'o\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0005=\u0001fA\u0007\u0002LA!\u0011QJA*\u001b\t\tyEC\u0002\u0002Ra\fQA[;oSRLA!!\u0016\u0002P\t1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004\u001d\u0005m\u0003\u0003BA'\u0003;JA!a\u0018\u0002P\t)\u0011I\u001a;fe\u0006IA/Z:u\u00072|7/\u001a\u0015\u0004\u001f\u0005\u0015\u0004\u0003BA'\u0003OJA!!\u001b\u0002P\t!A+Z:u\u00035!Xm\u001d;MSN$hj\u001c3fg\"\u001a\u0001#!\u001a\u0002cQ,7\u000f^\"sK\u0006$X-\u0012=jgRLgn\u001a+pa&\u001c7\u000f\u00165s_^$v\u000e]5d\u000bbL7\u000f^:Fq\u000e,\u0007\u000f^5p]\"\u001a\u0011#!\u001a\u0002'Q,7\u000f^'fi\u0006$\u0017\r^1SK\u001a\u0014Xm\u001d5)\u0007I\t)'\u0001\u000fuKN$H)Z:de&\u0014WMT8o\u000bbL7\u000f^5oOR{\u0007/[2)\u0007M\t)'A\nuKN$H)Z:de&\u0014Wm\u00117vgR,'\u000fK\u0002\u0015\u0003K\n1\u0003^3ti\u0012+7o\u0019:jE\u0016dun\u001a#jeND3!FA3\u0003i!Xm\u001d;EKN\u001c'/\u001b2f%\u0016\u0004H.[2b\u0019><G)\u001b:tQ\r1\u0012QM\u0001\u0018i\u0016\u001cH/\u00117uKJ\u0014V\r\u001d7jG\u0006dun\u001a#jeND3aFA3\u0003m!Xm\u001d;EKN\u001c'/\u001b2f\u0003:$\u0017\t\u001c;fe\u000e{gNZ5hg\"\u001a\u0001$!\u001a\u0002)Q,7\u000f^\"sK\u0006$X\rU1si&$\u0018n\u001c8tQ\rI\u0012QM\u0001\u001bi\u0016\u001cHoU3fW\u00063G/\u001a:EK2,G/\u001a*fG>\u0014Hm\u001d\u0015\u00045\u0005\u0015\u0014\u0001\b;fgRdunZ*uCJ$xJ\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e\u0015\u00047\u0005\u0015\u0014\u0001\n;fgRdunZ*uCJ$xJ\u001a4tKR\fe\r^3s\t\u0016dW\r^3SK\u000e|'\u000fZ:)\u0007q\t)'A\u001cuKN$(+\u001a9mS\u000e\f7)\u00198GKR\u001c\u0007N\u0012:p[2{wm\u0015;beR|eMZ:fi\u00063G/\u001a:EK2,G/\u001a*fG>\u0014Hm\u001d\u0015\u0004;\u0005\u0015\u0014A\t;fgR\fE\u000e^3s\u0019><G)\u001b:t\u0003\u001a$XM\u001d#fY\u0016$XMU3d_J$7\u000fK\u0002\u001f\u0003K\nQ\u0005^3ti>3gm]3ug\u001a{'\u000fV5nKN\fe\r^3s\t\u0016dW\r^3SK\u000e|'\u000fZ:)\u0007}\t)'A\u000fuKN$8i\u001c8tk6,\u0017I\u001a;fe\u0012+G.\u001a;f%\u0016\u001cwN\u001d3tQ\r\u0001\u0013QM\u0001\u001fi\u0016\u001cH\u000fR3mKR,'+Z2pe\u0012\u001cx+\u001b;i\u000bb\u001cW\r\u001d;j_:D3!IA3\u0003m!Xm\u001d;EKN\u001c'/\u001b2f\u0007>tg-[4t\r>\u0014Hk\u001c9jG\"\u001a!%!\u001a\u0002;M,(m]2sS\n,\u0017I\u001c3XC&$hi\u001c:BgNLwM\\7f]R$b!a\u0004\u0002<\u0006u\u0006BB.$\u0001\u0004\ty\u0003C\u0004\u0002@\u000e\u0002\r!!1\u0002\u0011\r|gn];nKJ\u0004\u0002\"a1\u0002L\u0006=\u0017qZ\u0007\u0003\u0003\u000bTA!a0\u0002H*\u0019\u0011\u0011Z;\u0002\u000f\rd\u0017.\u001a8ug&!\u0011QZAc\u00055Y\u0015MZ6b\u0007>t7/^7feB)\u0011.!5\u0002V&\u0019\u00111\u001b6\u0003\u000b\u0005\u0013(/Y=\u0011\u0007%\f9.C\u0002\u0002Z*\u0014AAQ=uK\u0006Y1/\u001a8e%\u0016\u001cwN\u001d3t)!\ty!a8\u0002n\u0006E\bbBAqI\u0001\u0007\u00111]\u0001\taJ|G-^2feBA\u0011Q]Au\u0003\u001f\fy-\u0004\u0002\u0002h*!\u0011\u0011]Ad\u0013\u0011\tY/a:\u0003\u001b-\u000bgm[1Qe>$WoY3s\u0011\u0019\ty\u000f\na\u0001Q\u0006Qa.^7SK\u000e|'\u000fZ:\t\u000b=$\u0003\u0019A9\u0002/Q,7\u000f^%om\u0006d\u0017\u000eZ!mi\u0016\u00148i\u001c8gS\u001e\u001c\bfA\u0013\u0002f\u0005\tB/Z:u\u0003\u000edw\n]3sCRLwN\\:)\u0007\u0019\n)'\u0001\tuKN$H)\u001a7bs\u0016$7\t\\8tK\"\u001aq%!\u001a\u0002\u001dQ,7\u000f\u001e$pe\u000e,7\t\\8tK\"\u001a\u0001&!\u001a\u00025Q,7\u000f^'j]&lW/\u001c*fcV,7\u000f\u001e+j[\u0016|W\u000f^:)\u0007%\n)'\u0001\ruKN$8)\u00197m\u0013:4E.[4iiRKW.Z8viND3AKA3\u0003I!Xm\u001d;D_:\u001cX/\\3s\u000fJ|W\u000f]:)\u0007-\n)'\u0001\u0010uKN$H)\u001a7fi\u0016\u001cuN\\:v[\u0016\u0014xI]8va>3gm]3ug\"\u001aA&!\u001a\u00023Q,7\u000f^#mK\u000e$\bK]3gKJ\u0014X\r\u001a'fC\u0012,'o\u001d\u0015\u0004[\u0005\u0015\u0014A\n;fgR,E.Z2u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:t\r>\u0014xJ\\3QCJ$\u0018\u000e^5p]\"\u001aa&!\u001a\u0002QQ,7\u000f^#mK\u000e$XK\\2mK\u0006tG*Z1eKJ\u001chi\u001c:NC:L\b+\u0019:uSRLwN\\:)\u0007=\n)'A\u0014uKN$X\t\\3diVs7\r\\3b]2+\u0017\rZ3sg\u001a{'/\u00117m!\u0006\u0014H/\u001b;j_:\u001c\bf\u0001\u0019\u0002f\u0005YC/Z:u\u000b2,7\r^+oG2,\u0017M\u001c'fC\u0012,'o\u001d$peVs7N\\8x]B\u000b'\u000f^5uS>t7\u000fK\u00022\u0003K\n\u0001\u0006^3ti\u0016cWm\u0019;V]\u000edW-\u00198MK\u0006$WM]:XQ\u0016tgj\u001c'jm\u0016\u0014%o\\6feND3AMA3\u0003m!Xm\u001d;FY\u0016\u001cG/\u00168dY\u0016\fg\u000eT3bI\u0016\u00148OT8pa\"\u001a1'!\u001a\u0002=Q,7\u000f^#mK\u000e$XK\\2mK\u0006tG*Z1eKJ\u001c\u0018I\u001c3O_>\u0004\bf\u0001\u001b\u0002f\u0005AD/Z:u\u0019&\u001cHOU3bgNLwM\\7f]R\u001cHi\\3t\u001d>$8\u000b[8x\u001d>t'+Z1tg&<g.\u001b8h!\u0006\u0014H/\u001b;j_:\u001c\bfA\u001b\u0002f\u0005\tD/Z:u\u0019&\u001cHOU3bgNLwM\\7f]R\u001cHi\\3t\u001d>$8\u000b[8x\t\u0016dW\r^3e!\u0006\u0014H/\u001b;j_:\u001c\bf\u0001\u001c\u0002f\u0005\u0001C/Z:u-\u0006d\u0017\u000eZ%oGJ,W.\u001a8uC2\fE\u000e^3s\u0007>tg-[4tQ\r9\u0014QM\u00015i\u0016\u001cH/\u00138de\u0016lWM\u001c;bY\u0006cG/\u001a:D_:4\u0017nZ:EK2,G/Z!oIN+GO\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001c\bf\u0001\u001d\u0002f\u0005qC/Z:u\u0013:\u001c'/Z7f]R\fG.\u00117uKJ\u001cuN\u001c4jON$U\r\\3uK\n\u0013xn[3s\u0007>tg-[4tQ\rI\u0014QM\u0001#i\u0016\u001cH/\u00138wC2LG-\u00138de\u0016lWM\u001c;bY\u0006cG/\u001a:D_:4\u0017nZ:)\u0007i\n)'\u0001\u0014uKN$\u0018J\u001c<bY&$\u0017\t\u001c;feB\u000b'\u000f^5uS>t'+Z1tg&<g.\\3oiND3aOA3\u0003I!Xm\u001d;M_:<Gk\u001c9jG:\u000bW.Z:)\u0007q\n)'A\buKN$h*\u001e7m\u0007>tg-[4tQ\ri\u0014QM\u0001%i\u0016\u001cH\u000fR3tGJL'-Z\"p]\u001aLwm\u001d$pe2{w\r\u000e6M_\u001edUM^3mg\"\u001aa(!\u001a\u0002YQ,7\u000f^%oGJ,W.\u001a8uC2\fE\u000e^3s\u0007>tg-[4t\r>\u0014Hj\\45U2{w\rT3wK2\u001c\bfA \u0003`A!\u0011Q\nB1\u0013\u0011\u0011\u0019'a\u0014\u0003\r%;gn\u001c:fQ\ry\u0014QM\u0001Hi\u0016\u001cH/\u00138de\u0016lWM\u001c;bY\u0006cG/\u001a:D_:4\u0017nZ:G_Jdun\u001a\u001bk\u0019><G*\u001a<fYN\u001c\u0015M\u001c*fg\u0016$Hj\\4hKJ$vnQ;se\u0016tGOU8pi\"\u001a\u0001Ia\u0018)\u0007\u0001\u000b)'A!uKN$\u0018J\\2sK6,g\u000e^1m\u00032$XM]\"p]\u001aLwm\u001d$pe2{w\r\u000e6M_\u001edUM^3mg\u000e\u000bgN\\8u%\u0016\u001cX\r\u001e*p_RdunZ4fe\"\u001a\u0011Ia\u0018)\u0007\u0005\u000b)'A%uKN$\u0018J\\2sK6,g\u000e^1m\u00032$XM]\"p]\u001aLwm\u001d$pe2{w\r\u000e6M_\u001edUM^3mg\u0012{Wm\u001d(pi^{'o[,ji\"LeN^1mS\u0012\u001cuN\u001c4jOND3A\u0011B0Q\r\u0011\u0015QM\u0001-i\u0016\u001cH/\u00117uKJ\u001cuN\u001c4jON4uN\u001d'pORRGj\\4MKZ,Gn\u001d#pKNtu\u000e^,pe.D3a\u0011B0Q\r\u0019\u0015QM\u0001\u0013C2$XM\u001d\"s_.,'\u000fT8hO\u0016\u00148\u000f\u0006\u0004\u0002\u0010\t\r%q\u0014\u0005\b\u0005\u000b#\u0005\u0019\u0001BD\u0003\u001d)g\u000e\u001e:jKN\u0004bA!#\u0003\u0010\nMUB\u0001BF\u0015\r\u0011i)Y\u0001\u0005kRLG.\u0003\u0003\u0003\u0012\n-%AC\"pY2,7\r^5p]B!!Q\u0013BN\u001b\t\u00119J\u0003\u0003\u0003\u001a\u0006\u001d\u0017!B1e[&t\u0017\u0002\u0002BO\u0005/\u0013Q\"\u00117uKJ\u001cuN\u001c4jO>\u0003\b\"\u0003BQ\tB\u0005\t\u0019\u0001BR\u000311\u0018\r\\5eCR,wJ\u001c7z!\rI'QU\u0005\u0004\u0005OS'a\u0002\"p_2,\u0017M\\\u0001\u001dC2$XM\u001d\"s_.,'\u000fT8hO\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011iK\u000b\u0003\u0003$\n=6F\u0001BY!\u0011\u0011\u0019L!0\u000e\u0005\tU&\u0002\u0002B\\\u0005s\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tm&.\u0001\u0006b]:|G/\u0019;j_:LAAa0\u00036\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002+\u0011,7o\u0019:jE\u0016\u0014%o\\6fe2{wmZ3sgR\u0011!Q\u0019\t\u0005\u0005+\u00139-\u0003\u0003\u0003J\n]%AB\"p]\u001aLw-A\u000buK\u0006\u0014Hm\\<o\u0005J|7.\u001a:M_\u001e<WM]:\u0002;Ac\u0017-\u001b8uKb$\u0018\tZ7j]&sG/Z4sCRLwN\u001c+fgR\u0004\"!V%\u0014\u0007%\u0013\u0019\u000eE\u0002j\u0005+L1Aa6k\u0005\u0019\te.\u001f*fMR\u0011!qZ\u0001\u0017G\",7m\u001b,bY&$\u0017\t\u001c;fe\u000e{gNZ5hgRA\u0011q\u0002Bp\u0005S\u0014i\u000fC\u0004\u0003b.\u0003\rAa9\u0002\r\rd\u0017.\u001a8u!\u0011\u0011)J!:\n\t\t\u001d(q\u0013\u0002\u0006\u0003\u0012l\u0017N\u001c\u0005\u0007\u0005W\\\u0005\u0019A@\u0002\u001dQ|\u0007/[2SKN|WO]2fc!1!q^&A\u0002}\fa\u0002^8qS\u000e\u0014Vm]8ve\u000e,''\u0001\rdQ\u0016\u001c7.\u00138wC2LG-\u00117uKJ\u001cuN\u001c4jON$\u0002\"a\u0004\u0003v\u000e\u00151Q\u0004\u0005\b\u0005od\u0005\u0019\u0001B}\u0003!Q8n\u00117jK:$\b\u0003\u0002B~\u0007\u0003i!A!@\u000b\u0007\t}\b+\u0001\u0002{W&!11\u0001B\u007f\u00055Y\u0015MZ6b5.\u001cE.[3oi\"91q\u0001'A\u0002\r%\u0011aB:feZ,'o\u001d\t\u0007\u0007\u0017\u0019ia!\u0005\u000e\u0005\u0005\u001d\u0012\u0002BB\b\u0003O\u00111aU3r!\u0011\u0019\u0019b!\u0007\u000e\u0005\rU!bAB\f!\u000611/\u001a:wKJLAaa\u0007\u0004\u0016\tY1*\u00194lCN+'O^3s\u0011\u001d\u0011\t\u000f\u0014a\u0001\u0005G\u0004")
public class PlaintextAdminIntegrationTest
extends BaseAdminIntegrationTest {
    private final String topic;
    private final int partition;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), this.partition());
    private ConfigResource brokerLoggerConfigResource;
    private final Set<String> changedBrokerLoggers = (Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);

    public static void checkInvalidAlterConfigs(KafkaZkClient kafkaZkClient, Seq<KafkaServer> seq, Admin admin) {
        PlaintextAdminIntegrationTest$.MODULE$.checkInvalidAlterConfigs(kafkaZkClient, seq, admin);
    }

    public static void checkValidAlterConfigs(Admin admin, ConfigResource configResource, ConfigResource configResource2) {
        PlaintextAdminIntegrationTest$.MODULE$.checkValidAlterConfigs(admin, configResource, configResource2);
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private ConfigResource brokerLoggerConfigResource() {
        return this.brokerLoggerConfigResource;
    }

    private void brokerLoggerConfigResource_$eq(ConfigResource x$1) {
        this.brokerLoggerConfigResource = x$1;
    }

    private Set<String> changedBrokerLoggers() {
        return this.changedBrokerLoggers;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.brokerLoggerConfigResource_$eq(new ConfigResource(ConfigResource.Type.BROKER_LOGGER, Integer.toString(((KafkaServer)this.servers().head()).config().brokerId())));
    }

    @Override
    @After
    public void tearDown() {
        this.teardownBrokerLoggers();
        super.tearDown();
    }

    @Test
    public void testClose() {
        Admin client = Admin.create(this.createConfig());
        client.close();
        client.close();
    }

    @Test
    public void testListNodes() {
        List nodeStrs;
        this.client_$eq(Admin.create(this.createConfig()));
        List brokerStrs = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.brokerList().split(","))).toList().sorted((Ordering)Ordering.String$.MODULE$);
        while ((nodeStrs = (List)((TraversableOnce)((Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)this.client().describeCluster().nodes().get()).asScala()).map((Function1 & Serializable & scala.Serializable)node -> new StringBuilder(1).append(node.host()).append(":").append(node.port()).toString(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).size() < brokerStrs.size()) {
        }
        Assert.assertEquals((Object)brokerStrs.mkString(","), (Object)nodeStrs.mkString(","));
    }

    @Test
    public void testCreateExistingTopicsThrowTopicExistsException() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "mytopic";
        .colon.colon topics = new .colon.colon((Object)topic, (List)Nil$.MODULE$);
        .colon.colon newTopics = new .colon.colon((Object)new NewTopic(topic, 1, (short)1), (List)Nil$.MODULE$);
        this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        .colon.colon newTopicsWithInvalidRF = new .colon.colon((Object)new NewTopic(topic, 1, (short)(this.servers().size() + 1)), (List)Nil$.MODULE$);
        Assert.assertTrue((boolean)(((ExecutionException)Assertions$.MODULE$.intercept(() -> PlaintextAdminIntegrationTest.$anonfun$testCreateExistingTopicsThrowTopicExistsException$1(this, (Seq)newTopicsWithInvalidRF), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113))).getCause() instanceof TopicExistsException));
    }

    @Test
    public void testMetadataRefresh() {
        this.client_$eq(Admin.create(this.createConfig()));
        .colon.colon topics = new .colon.colon((Object)"mytopic", (List)Nil$.MODULE$);
        .colon.colon newTopics = new .colon.colon((Object)new NewTopic("mytopic", 3, (short)3), (List)Nil$.MODULE$);
        this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        KafkaServer controller = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testMetadataRefresh$1(this, x$1))).get();
        controller.shutdown();
        controller.awaitShutdown();
        java.util.Map topicDesc = (java.util.Map)this.client().describeTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)topics).asJava()).all().get();
        Assert.assertEquals((Object)topics.toSet(), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(topicDesc.keySet()).asScala());
    }

    @Test
    public void testDescribeNonExistingTopic() {
        this.client_$eq(Admin.create(this.createConfig()));
        String existingTopic = "existing-topic";
        this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)existingTopic, (List)Nil$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$2 -> new NewTopic(x$2, 1, (short)1), Seq$.MODULE$.canBuildFrom())).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)new .colon.colon((Object)existingTopic, (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
        String nonExistingTopic = "non-existing";
        java.util.Map results = this.client().describeTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)nonExistingTopic, (List)new .colon.colon((Object)existingTopic, (List)Nil$.MODULE$))).asJava()).values();
        Assert.assertEquals((Object)existingTopic, (Object)((TopicDescription)((KafkaFuture)results.get(existingTopic)).get()).name());
        boolean cfr_ignored_0 = ((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (TopicDescription)((KafkaFuture)results.get(nonExistingTopic)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148))).getCause() instanceof UnknownTopicOrPartitionException;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionCount(nonExistingTopic));
    }

    @Test
    public void testDescribeCluster() {
        this.client_$eq(Admin.create(this.createConfig()));
        DescribeClusterResult result = this.client().describeCluster();
        Collection nodes = (Collection)result.nodes().get();
        String clusterId = (String)result.clusterId().get();
        Assert.assertEquals((Object)((KafkaServer)this.servers().head()).dataPlaneRequestProcessor().clusterId(), (Object)clusterId);
        Node controller = (Node)result.controller().get();
        Option option = ((KafkaServer)this.servers().head()).dataPlaneRequestProcessor().metadataCache().getControllerId();
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        Assert.assertEquals((long)BoxesRunTime.unboxToInt((Object)(getOrElse_this.isEmpty() ? BoxesRunTime.boxToInteger((int)PlaintextAdminIntegrationTest.$anonfun$testDescribeCluster$1()) : getOrElse_this.get())), (long)controller.id());
        String[] brokers = this.brokerList().split(",");
        Assert.assertEquals((long)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokers)).size(), (long)nodes.size());
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(nodes).asScala()).foreach((Function1 & Serializable & scala.Serializable)node -> {
            PlaintextAdminIntegrationTest.$anonfun$testDescribeCluster$2(brokers, node);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeLogDirs() {
        void intWrapper_x;
        void intWrapper_x2;
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "topic";
        scala.collection.immutable.Map partitionsByBroker = (scala.collection.immutable.Map)this.createTopic(topic, 10, 1, this.createTopic$default$4()).groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$1(x0$1))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                void $minus$greater$extension_y;
                void $minus$greater$extension_$this;
                int k = x0$2._1$mcI$sp();
                scala.collection.immutable.Map v = (scala.collection.immutable.Map)x0$2._2();
                Seq seq = v.keys().toSeq();
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k));
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
                return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            }
            throw new MatchError(null);
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.until$extension0((int)intWrapper_x2, this.brokerCount()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), IndexedSeq$.MODULE$.canBuildFrom());
        java.util.Map logDirInfosByBroker = (java.util.Map)this.client().describeLogDirs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava()).all().get();
        boolean bl2 = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0((int)intWrapper_x, this.brokerCount());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$4(this, partitionsByBroker, logDirInfosByBroker, topic, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    @Test
    public void testDescribeReplicaLogDirs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "topic";
        Seq replicas = ((TraversableOnce)this.createTopic(topic, 10, 1, this.createTopic$default$4()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                int partition = x0$1._1$mcI$sp();
                int brokerId = x0$1._2$mcI$sp();
                return new TopicPartitionReplica(topic, partition, brokerId);
            }
            throw new MatchError(null);
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        ((java.util.Map)this.client().describeReplicaLogDirs(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)replicas).asJavaCollection()).all().get()).forEach((topicPartitionReplica, replicaDirInfo) -> {
            KafkaServer server = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testDescribeReplicaLogDirs$3(topicPartitionReplica, x$5))).get();
            TopicPartition tp = new TopicPartition(topicPartitionReplica.topic(), topicPartitionReplica.partition());
            LogManager qual$1 = server.logManager();
            boolean x$2 = qual$1.getLog$default$2();
            Assert.assertEquals((Object)((Log)qual$1.getLog(tp, x$2).get()).dir().getParent(), (Object)replicaDirInfo.getCurrentReplicaLogDir());
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterReplicaLogDirs() {
        void apply_executor;
        void apply_body;
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "topic";
        TopicPartition tp = new TopicPartition(topic, 0);
        scala.collection.immutable.Map randomNums = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Integer n = BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt(2));
            Object object = Predef$.MODULE$.ArrowAssoc(server);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map firstReplicaAssignment = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
            void $minus$greater$extension_$this;
            String logDir = new File((String)server.config().logDirs().apply(BoxesRunTime.unboxToInt((Object)randomNums.apply(server)))).getAbsolutePath();
            Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topic, 0, server.config().brokerId()));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)logDir);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map secondReplicaAssignment = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
            void $minus$greater$extension_$this;
            String logDir = new File((String)server.config().logDirs().apply(1 - BoxesRunTime.unboxToInt((Object)randomNums.apply(server)))).getAbsolutePath();
            Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topic, 0, server.config().brokerId()));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)logDir);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.client().alterReplicaLogDirs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)firstReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).values()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)future -> {
            PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$4(future);
            return BoxedUnit.UNIT;
        });
        this.createTopic(topic, 1, this.brokerCount(), this.createTopic$default$4());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$6(tp, firstReplicaAssignment, topic, server);
            return BoxedUnit.UNIT;
        });
        this.client().alterReplicaLogDirs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)secondReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).all().get();
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$7(tp, secondReplicaAssignment, topic, server);
            return BoxedUnit.UNIT;
        });
        AtomicBoolean running = new AtomicBoolean(true);
        AtomicInteger numMessages = new AtomicInteger();
        Future$ future$ = Future$.MODULE$;
        ExecutionContext executionContext = ExecutionContext.Implicits$.MODULE$.global();
        JFunction0.mcI.sp & Serializable & scala.Serializable intersect = (JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            int n;
            String x$5 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), this.securityProtocol());
            SecurityProtocol x$6 = this.securityProtocol();
            Option<File> x$7 = this.trustStoreFile();
            int x$8 = 0;
            int x$9 = 10000;
            int x$10 = -1;
            long x$11 = TestUtils$.MODULE$.createProducer$default$3();
            long x$12 = TestUtils$.MODULE$.createProducer$default$4();
            int x$13 = TestUtils$.MODULE$.createProducer$default$6();
            int x$14 = TestUtils$.MODULE$.createProducer$default$7();
            int x$15 = TestUtils$.MODULE$.createProducer$default$8();
            String x$16 = TestUtils$.MODULE$.createProducer$default$9();
            Option<Properties> x$17 = TestUtils$.MODULE$.createProducer$default$13();
            ByteArraySerializer x$18 = TestUtils$.MODULE$.createProducer$default$14();
            ByteArraySerializer x$19 = TestUtils$.MODULE$.createProducer$default$15();
            boolean x$20 = TestUtils$.MODULE$.createProducer$default$16();
            try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$5, x$10, x$11, x$12, x$8, x$13, x$14, x$15, x$16, x$9, x$6, x$7, x$17, x$18, x$19, x$20);){
                while (running.get()) {
                    Future future = producer.send(new ProducerRecord(topic, (Object)new StringBuilder(21).append("xxxxxxxxxxxxxxxxxxxx-").append(numMessages).toString().getBytes()));
                    numMessages.incrementAndGet();
                    future.get(10L, TimeUnit.SECONDS);
                }
                n = numMessages.get();
            }
            return n;
        };
        if (future$ == null) {
            throw null;
        }
        scala.concurrent.Future producerFuture = future$.unit().map(arg_0 -> Future$.$anonfun$apply$1((Function0)apply_body, arg_0), (ExecutionContext)apply_executor);
        try {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$11(numMessages)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$12(numMessages, producerFuture), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
                }
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
            }
            this.client().alterReplicaLogDirs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)firstReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).all().get();
            this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
                PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$13(tp, firstReplicaAssignment, topic, producerFuture, server);
                return BoxedUnit.UNIT;
            });
            int currentMessagesNum = numMessages.get();
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$16(numMessages, currentMessagesNum)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$17(numMessages, currentMessagesNum, producerFuture), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
                }
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
            }
        }
        finally {
            running.set(false);
        }
        int finalNumMessages = BoxesRunTime.unboxToInt((Object)Await$.MODULE$.result((Awaitable)producerFuture, (Duration)Duration$.MODULE$.apply(20L, TimeUnit.SECONDS)));
        Buffer<KafkaServer> x$23 = this.servers();
        SecurityProtocol x$26 = this.securityProtocol();
        Option<File> x$27 = this.trustStoreFile();
        String x$28 = TestUtils$.MODULE$.consumeTopicRecords$default$4();
        long x$29 = TestUtils$.MODULE$.consumeTopicRecords$default$7();
        ((IterableLike)TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)x$23, topic, finalNumMessages, x$28, x$26, x$27, x$29).zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$18(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeAndAlterConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), "500000");
        topicConfig1.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        this.createTopic(topic1, 1, 1, topicConfig1);
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        ConfigResource brokerResource1 = new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(((KafkaServer)this.servers().apply(1)).config().brokerId()));
        ConfigResource brokerResource2 = new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(((KafkaServer)this.servers().apply(2)).config().brokerId()));
        .colon.colon configResources = new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)new .colon.colon((Object)brokerResource1, (List)new .colon.colon((Object)brokerResource2, (List)Nil$.MODULE$))));
        java.util.Map configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)configResources).asJava()).all().get();
        Assert.assertEquals((long)4L, (long)configs.size());
        ConfigEntry maxMessageBytes1 = ((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assert.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes1.name());
        Assert.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.MaxMessageBytesProp()), (Object)maxMessageBytes1.value());
        Assert.assertFalse((boolean)maxMessageBytes1.isDefault());
        Assert.assertFalse((boolean)maxMessageBytes1.isSensitive());
        Assert.assertFalse((boolean)maxMessageBytes1.isReadOnly());
        Assert.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.RetentionMsProp()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        ConfigEntry maxMessageBytes2 = ((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assert.assertEquals((Object)Integer.toString(Defaults$.MODULE$.MessageMaxBytes()), (Object)maxMessageBytes2.value());
        Assert.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes2.name());
        Assert.assertTrue((boolean)maxMessageBytes2.isDefault());
        Assert.assertFalse((boolean)maxMessageBytes2.isSensitive());
        Assert.assertFalse((boolean)maxMessageBytes2.isReadOnly());
        Assert.assertEquals((long)((KafkaServer)this.servers().apply(1)).config().values().size(), (long)((Config)configs.get(brokerResource1)).entries().size());
        Assert.assertEquals((Object)Integer.toString(((KafkaServer)this.servers().apply(1)).config().brokerId()), (Object)((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        ConfigEntry listenerSecurityProtocolMap = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().getString(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp()), (Object)listenerSecurityProtocolMap.value());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), (Object)listenerSecurityProtocolMap.name());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isDefault());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isSensitive());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isReadOnly());
        ConfigEntry truststorePassword = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.SslTruststorePasswordProp(), (Object)truststorePassword.name());
        Assert.assertNull((Object)truststorePassword.value());
        Assert.assertFalse((boolean)truststorePassword.isDefault());
        Assert.assertTrue((boolean)truststorePassword.isSensitive());
        Assert.assertFalse((boolean)truststorePassword.isReadOnly());
        ConfigEntry compressionType = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.CompressionTypeProp());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().compressionType(), (Object)compressionType.value());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.CompressionTypeProp(), (Object)compressionType.name());
        Assert.assertTrue((boolean)compressionType.isDefault());
        Assert.assertFalse((boolean)compressionType.isSensitive());
        Assert.assertFalse((boolean)compressionType.isReadOnly());
        Assert.assertEquals((long)((KafkaServer)this.servers().apply(2)).config().values().size(), (long)((Config)configs.get(brokerResource2)).entries().size());
        Assert.assertEquals((Object)Integer.toString(((KafkaServer)this.servers().apply(2)).config().brokerId()), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(2)).config().logCleanerThreads().toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).value());
        PlaintextAdminIntegrationTest$.MODULE$.checkValidAlterConfigs(this.client(), topicResource1, topicResource2);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreatePartitions() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_$this7;
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "create-partitions-topic-1";
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        String topic2 = "create-partitions-topic-2";
        this.createTopic(topic2, 1, 2, this.createTopic$default$4());
        TopicDescription topic1_metadata = this.getTopicMetadata(this.client(), topic1, this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4());
        TopicDescription topic2_metadata = this.getTopicMetadata(this.client(), topic2, this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topic1_metadata.partitions().size());
        Assert.assertEquals((long)1L, (long)topic2_metadata.partitions().size());
        CreatePartitionsOptions validateOnly = new CreatePartitionsOptions().validateOnly(true);
        CreatePartitionsOptions actuallyDoIt = new CreatePartitionsOptions().validateOnly(false);
        Tuple2[] tuple2Array = new Tuple2[1];
        NewPartitions newPartitions = NewPartitions.increaseTo((int)3);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topic1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y7);
        ObjectRef alterResult = ObjectRef.create((Object)this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava(), validateOnly));
        ObjectRef altered = ObjectRef.create((Object)((Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get()));
        Assert.assertEquals((long)1L, (long)this.numPartitions$1(topic1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        Tuple2[] tuple2Array2 = new Tuple2[1];
        NewPartitions newPartitions2 = NewPartitions.increaseTo((int)3);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)topic1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        alterResult.elem = this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testCreatePartitions$1(this, topic1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testCreatePartitions$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        java.util.List<Object> newPartition2Assignments = Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})});
        Tuple2[] tuple2Array3 = new Tuple2[1];
        NewPartitions newPartitions3 = NewPartitions.increaseTo((int)3, newPartition2Assignments);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)topic2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        alterResult.elem = this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3))).asJava(), validateOnly);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        Assert.assertEquals((long)1L, (long)this.numPartitions$1(topic2, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        Tuple2[] tuple2Array4 = new Tuple2[1];
        NewPartitions newPartitions4 = NewPartitions.increaseTo((int)3, newPartition2Assignments);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)topic2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        alterResult.elem = this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array4))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        java.util.List actualPartitions2 = this.partitions$1(topic2, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)));
        Assert.assertEquals((long)3L, (long)actualPartitions2.size());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)actualPartitions2.get(1)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id()), Buffer$.MODULE$.canBuildFrom())).toList());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)actualPartitions2.get(2)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id()), Buffer$.MODULE$.canBuildFrom())).toList());
        new .colon.colon((Object)validateOnly, (List)new .colon.colon((Object)actuallyDoIt, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)option -> {
            PlaintextAdminIntegrationTest.$anonfun$testCreatePartitions$5(this, alterResult, topic1, topic2, newPartition2Assignments, altered, option);
            return BoxedUnit.UNIT;
        });
        Tuple2[] tuple2Array5 = new Tuple2[2];
        NewPartitions newPartitions5 = NewPartitions.increaseTo((int)4);
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)topic1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array5[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        NewPartitions newPartitions6 = NewPartitions.increaseTo((int)2);
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)topic2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array5[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        alterResult.elem = this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array5))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testCreatePartitions$6(this, topic1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testCreatePartitions$7(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        try {
            altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((Object)"Topic currently has 3 partitions, which is higher than the requested 2.", (Object)e.getCause().getMessage());
            Assert.assertEquals((long)3L, (long)this.numPartitions$1(topic2, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        ((KafkaFuture)this.client().deleteTopics(Arrays.asList((Object[])new String[]{topic1})).values().get(topic1)).get();
        Tuple2[] tuple2Array6 = new Tuple2[1];
        NewPartitions newPartitions7 = NewPartitions.increaseTo((int)4);
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)topic1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array6[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        alterResult.elem = this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array6))).asJava(), validateOnly);
        try {
            altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
            Assert.fail((String)"Expect InvalidTopicException when the topic is queued for deletion");
            return;
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidTopicException));
            Assert.assertEquals((Object)"The topic is queued for deletion.", (Object)e.getCause().getMessage());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSeekAfterDeleteRecords() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        consumer.seekToBeginning(Collections.singleton(this.topicPartition()));
        Assert.assertEquals((long)0L, (long)consumer.position(this.topicPartition()));
        Tuple2[] tuple2Array = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)5L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        long lowWatermark = ((DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).lowWatermarks().get(this.topicPartition())).get()).lowWatermark();
        Assert.assertEquals((long)5L, (long)lowWatermark);
        consumer.seekToBeginning(Collections.singletonList(this.topicPartition()));
        Assert.assertEquals((long)5L, (long)consumer.position(this.topicPartition()));
        consumer.seek(this.topicPartition(), 7L);
        Assert.assertEquals((long)7L, (long)consumer.position(this.topicPartition()));
        Tuple2[] tuple2Array2 = new Tuple2[1];
        RecordsToDelete recordsToDelete2 = RecordsToDelete.beforeOffset((long)-1L);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava()).all().get();
        consumer.seekToBeginning(Collections.singletonList(this.topicPartition()));
        Assert.assertEquals((long)10L, (long)consumer.position(this.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogStartOffsetCheckpoint() {
        void intWrapper_x;
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Tuple2[] tuple2Array = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)5L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ObjectRef result = ObjectRef.create((Object)this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()));
        ObjectRef lowWatermark = ObjectRef.create((Object)new Some((Object)BoxesRunTime.boxToLong((long)((DeletedRecords)((KafkaFuture)((DeleteRecordsResult)result.elem).lowWatermarks().get(this.topicPartition())).get()).lowWatermark())));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Object)((Option)lowWatermark.elem));
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0((int)intWrapper_x, this.brokerCount());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                this.killBroker(foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        this.restartDeadBrokers();
        this.client().close();
        this.brokerList_$eq(TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), this.listenerName()));
        this.client_$eq(Admin.create(this.createConfig()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testLogStartOffsetCheckpoint$2(this, result, lowWatermark)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testLogStartOffsetCheckpoint$3(lowWatermark), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogStartOffsetAfterDeleteRecords() {
        void intWrapper_x;
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Tuple2[] tuple2Array = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)3L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        long lowWatermark = ((DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).lowWatermarks().get(this.topicPartition())).get()).lowWatermark();
        Assert.assertEquals((long)3L, (long)lowWatermark);
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0((int)intWrapper_x, this.brokerCount());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                PlaintextAdminIntegrationTest.$anonfun$testLogStartOffsetAfterDeleteRecords$1(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void intWrapper_x;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        int followerIndex = BoxesRunTime.unboxToInt((Object)this.createTopic(this.topic(), 1, this.brokerCount(), this.createTopic$default$4()).apply((Object)BoxesRunTime.boxToInteger((int)0))) != ((KafkaServer)this.servers().apply(0)).config().brokerId() ? 0 : 1;
        this.killBroker(followerIndex);
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.topicPartition());
        Tuple2[] tuple2Array = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)3L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).all().get();
        this.restartDeadBrokers();
        this.waitForFollowerLog$1(3L, 100L, followerIndex);
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0((int)intWrapper_x, this.brokerCount());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$7(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        this.killBroker(followerIndex);
        this.sendRecords(producer, 100, this.topicPartition());
        Tuple2[] tuple2Array2 = new Tuple2[1];
        RecordsToDelete recordsToDelete2 = RecordsToDelete.beforeOffset((long)117L);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava()).all().get();
        this.restartDeadBrokers();
        this.waitForFollowerLog$1(117L, 200L, followerIndex);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterLogDirsAfterDeleteRecords() {
        void $minus$greater$extension_$this;
        void intWrapper_x;
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this2;
        this.client_$eq(Admin.create(this.createConfig()));
        this.createTopic(this.topic(), 1, this.brokerCount(), this.createTopic$default$4());
        int expectedLEO = 100;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, expectedLEO, this.topicPartition());
        Tuple2[] tuple2Array = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)3L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).all().get();
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0((int)intWrapper_x, this.brokerCount());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                PlaintextAdminIntegrationTest.$anonfun$testAlterLogDirsAfterDeleteRecords$1(this, expectedLEO, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        String futureLogDir = (String)((KafkaServer)this.servers().apply(0)).config().logDirs().apply(1);
        TopicPartitionReplica futureReplica = new TopicPartitionReplica(this.topic(), 0, ((KafkaServer)this.servers().apply(0)).config().brokerId());
        Tuple2[] tuple2Array2 = new Tuple2[1];
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)futureReplica);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)futureLogDir);
        this.client().alterReplicaLogDirs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava()).all().get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testAlterLogDirsAfterDeleteRecords$2(this, futureLogDir)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testAlterLogDirsAfterDeleteRecords$3(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Assert.assertEquals((long)3L, (long)((Log)((KafkaServer)this.servers().head()).replicaManager().localLog(this.topicPartition()).get()).logStartOffset());
        Assert.assertEquals((long)expectedLEO, (long)((Log)((KafkaServer)this.servers().head()).replicaManager().localLog(this.topicPartition()).get()).logEndOffset());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOffsetsForTimesAfterDeleteRecords() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Tuple2[] tuple2Array = new Tuple2[1];
        Long l = 0L;
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        Assert.assertEquals((long)0L, (long)((OffsetAndTimestamp)consumer.offsetsForTimes((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).get(this.topicPartition())).offset());
        Tuple2[] tuple2Array2 = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)5L);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava()).all().get();
        Tuple2[] tuple2Array3 = new Tuple2[1];
        Long l2 = 0L;
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Assert.assertEquals((long)5L, (long)((OffsetAndTimestamp)consumer.offsetsForTimes((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3))).asJava()).get(this.topicPartition())).offset());
        Tuple2[] tuple2Array4 = new Tuple2[1];
        RecordsToDelete recordsToDelete2 = RecordsToDelete.beforeOffset((long)-1L);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array4))).asJava()).all().get();
        Tuple2[] tuple2Array5 = new Tuple2[1];
        Long l3 = 0L;
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array5[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Assert.assertNull(consumer.offsetsForTimes((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array5))).asJava()).get(this.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConsumeAfterDeleteRecords() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        TestUtils$.MODULE$.consumeRecords(consumer, 10, TestUtils$.MODULE$.consumeRecords$default$3());
        Tuple2[] tuple2Array = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)3L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).all().get();
        consumer.seek(this.topicPartition(), 1L);
        TestUtils$.MODULE$.consumeRecords(consumer, 7, TestUtils$.MODULE$.consumeRecords$default$3());
        Tuple2[] tuple2Array2 = new Tuple2[1];
        RecordsToDelete recordsToDelete2 = RecordsToDelete.beforeOffset((long)8L);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava()).all().get();
        consumer.seek(this.topicPartition(), 1L);
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteRecordsWithException() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Tuple2[] tuple2Array = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)5L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Assert.assertEquals((long)5L, (long)((DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).lowWatermarks().get(this.topicPartition())).get()).lowWatermark());
        Throwable cause = ((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)20L);
            Object object = Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition());
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return (DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).lowWatermarks().get(this.topicPartition())).get();
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 864))).getCause();
        Assert.assertEquals(OffsetOutOfRangeException.class, cause.getClass());
        TopicPartition nonExistPartition = new TopicPartition(this.topic(), 3);
        cause = ((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)20L);
            Object object = Predef$.MODULE$.ArrowAssoc((Object)nonExistPartition);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return (DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).lowWatermarks().get(nonExistPartition)).get();
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 871))).getCause();
        Assert.assertEquals(LeaderNotAvailableException.class, cause.getClass());
    }

    @Test
    public void testDescribeConfigsForTopic() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(Admin.create(this.createConfig()));
        ConfigResource existingTopic = new ConfigResource(ConfigResource.Type.TOPIC, this.topic());
        ((KafkaFuture)this.client().describeConfigs(Collections.singletonList(existingTopic)).values().get(existingTopic)).get();
        ConfigResource nonExistentTopic = new ConfigResource(ConfigResource.Type.TOPIC, "unknown");
        DescribeConfigsResult describeResult1 = this.client().describeConfigs(Collections.singletonList(nonExistentTopic));
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Config)((KafkaFuture)describeResult1.values().get(nonExistentTopic)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 888))).getCause() instanceof UnknownTopicOrPartitionException));
        ConfigResource invalidTopic = new ConfigResource(ConfigResource.Type.TOPIC, "(invalid topic)");
        DescribeConfigsResult describeResult2 = this.client().describeConfigs(Collections.singletonList(invalidTopic));
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Config)((KafkaFuture)describeResult2.values().get(invalidTopic)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 893))).getCause() instanceof InvalidTopicException));
    }

    /*
     * WARNING - void declaration
     */
    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        void pollUntilTrue_action;
        consumer.subscribe(Collections.singletonList(topic));
        long l = TestUtils$.MODULE$.pollUntilTrue$default$4();
        JFunction0.mcZ.sp & Serializable & scala.Serializable intersect = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !consumer.assignment().isEmpty();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long pollUntilTrue_x$3 = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$pollUntilTrue$1(consumer, (Function0)pollUntilTrue_action)) {
            void pollUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$subscribeAndWaitForAssignment$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)pollUntilTrue_waitTimeMs, pollUntilTrue_x$3));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition topicPartition) {
        void intWrapper_x;
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        ((IndexedSeq)RichInt$.MODULE$.until$extension0((int)intWrapper_x, numRecords).map((Function1 & Serializable & scala.Serializable)i -> PlaintextAdminIntegrationTest.$anonfun$sendRecords$1(this, topicPartition, producer, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$8 -> (RecordMetadata)x$8.get());
    }

    @Test
    public void testInvalidAlterConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        PlaintextAdminIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this.zkClient(), (Seq<KafkaServer>)this.servers(), this.client());
    }

    @Test
    public void testAclOperations() {
        AclBinding acl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic3", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        this.client_$eq(Admin.create(this.createConfig()));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().describeAcls(AclBindingFilter.ANY).values(), SecurityDisabledException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().createAcls(Collections.singleton(acl)).all(), SecurityDisabledException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().deleteAcls(Collections.singleton(acl.toFilter())).all(), SecurityDisabledException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
    }

    @Test
    public void testDelayedClose() {
        this.client_$eq(Admin.create(this.createConfig()));
        Seq newTopics = (Seq)new .colon.colon((Object)"mytopic", (List)new .colon.colon((Object)"mytopic2", (List)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$9 -> new NewTopic(x$9, 1, (short)1), Seq$.MODULE$.canBuildFrom());
        KafkaFuture future = this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        this.client().close(java.time.Duration.ofHours(2L));
        KafkaFuture future2 = this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future2, TimeoutException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        future.get();
        this.client().close(java.time.Duration.ofMinutes(30L));
    }

    @Test
    public void testForceClose() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", new StringBuilder(10).append("localhost:").append(TestUtils$.MODULE$.IncorrectBrokerPort()).toString());
        this.client_$eq(Admin.create(config));
        KafkaFuture future = this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"mytopic", (List)new .colon.colon((Object)"mytopic2", (List)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$10 -> new NewTopic(x$10, 1, (short)1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(900000))).all();
        this.client().close(java.time.Duration.ZERO);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
    }

    @Test
    public void testMinimumRequestTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", new StringBuilder(10).append("localhost:").append(TestUtils$.MODULE$.IncorrectBrokerPort()).toString());
        config.put("request.timeout.ms", "0");
        this.client_$eq(Admin.create(config));
        long startTimeMs = Time.SYSTEM.milliseconds();
        KafkaFuture future = this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"mytopic", (List)new .colon.colon((Object)"mytopic2", (List)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$11 -> new NewTopic(x$11, 1, (short)1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(2))).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        long endTimeMs = Time.SYSTEM.milliseconds();
        Assert.assertTrue((String)"Expected the timeout to take at least one millisecond.", (endTimeMs > startTimeMs ? 1 : 0) != 0);
    }

    @Test
    public void testCallInFlightTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("default.api.timeout.ms", "100000000");
        KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory factory = new KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory();
        this.client_$eq((Admin)KafkaAdminClientTest.createInternal((AdminClientConfig)new AdminClientConfig(config), (KafkaAdminClient.TimeoutProcessorFactory)factory));
        KafkaFuture future = this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"mytopic", (List)new .colon.colon((Object)"mytopic2", (List)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$12 -> new NewTopic(x$12, 1, (short)1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"mytopic3", (List)new .colon.colon((Object)"mytopic4", (List)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$13 -> new NewTopic(x$13, 1, (short)1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().validateOnly(true)).all().get();
        Assert.assertEquals((long)1L, (long)factory.failuresInjected());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConsumerGroups() {
        java.util.Map<String, Object> config = this.createConfig();
        this.client_$eq(Admin.create(config));
        try {
            ListConsumerGroupsResult list1 = this.client().listConsumerGroups();
            Assert.assertTrue((0 == ((Collection)list1.all().get()).size() ? 1 : 0) != 0);
            Assert.assertTrue((0 == ((Collection)list1.errors().get()).size() ? 1 : 0) != 0);
            Assert.assertTrue((0 == ((Collection)list1.valid().get()).size() ? 1 : 0) != 0);
            String testTopicName = "test_topic";
            String testTopicName1 = new StringBuilder(1).append(testTopicName).append("1").toString();
            String testTopicName2 = new StringBuilder(1).append(testTopicName).append("2").toString();
            int testNumPartitions = 2;
            this.client().createTopics(Arrays.asList((Object[])new NewTopic[]{new NewTopic(testTopicName, testNumPartitions, (short)1), new NewTopic(testTopicName1, testNumPartitions, (short)1), new NewTopic(testTopicName2, testNumPartitions, (short)1)})).all().get();
            this.waitForTopics(this.client(), (Seq<String>)new .colon.colon((Object)testTopicName, (List)new .colon.colon((Object)testTopicName1, (List)new .colon.colon((Object)testTopicName2, (List)Nil$.MODULE$))), (Seq<String>)Nil$.MODULE$);
            KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
            try {
                producer.send(new ProducerRecord(testTopicName, Predef$.MODULE$.int2Integer(0), null, null)).get();
            }
            finally {
                Utils.closeQuietly(producer, (String)"producer");
            }
            String EMPTY_GROUP_INSTANCE_ID = "";
            String testGroupId = "test_group_id";
            String testClientId = "test_client_id";
            String testInstanceId1 = "test_instance_id_1";
            String testInstanceId2 = "test_instance_id_2";
            String fakeGroupId = "fake_group_id";
            scala.collection.immutable.Set groupInstanceSet = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{testInstanceId1, testInstanceId2, EMPTY_GROUP_INSTANCE_ID}));
            scala.collection.immutable.Set consumerSet = (scala.collection.immutable.Set)groupInstanceSet.map((Function1 & Serializable & scala.Serializable)groupInstanceId -> {
                Properties x$1 = this.createProperties$1((String)groupInstanceId, testGroupId, testClientId, EMPTY_GROUP_INSTANCE_ID);
                ByteArrayDeserializer x$2 = this.createConsumer$default$1();
                ByteArrayDeserializer x$3 = this.createConsumer$default$2();
                List<String> x$4 = this.createConsumer$default$4();
                return this.createConsumer(x$2, x$3, x$1, x$4);
            }, Set$.MODULE$.canBuildFrom());
            scala.collection.immutable.Set topicSet = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{testTopicName, testTopicName1, testTopicName2}));
            CountDownLatch latch = new CountDownLatch(consumerSet.size());
            try {
                scala.collection.immutable.Set consumerThreads = (scala.collection.immutable.Set)((SetLike)consumerSet.zip((GenIterable)topicSet, Set$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)zipped -> PlaintextAdminIntegrationTest.createConsumerThread$1((KafkaConsumer)zipped._1(), (String)zipped._2(), latch), Set$.MODULE$.canBuildFrom());
                try {
                    consumerThreads.foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
                        x$14.start();
                        return BoxedUnit.UNIT;
                    });
                    Assert.assertTrue((boolean)latch.await(30000L, TimeUnit.MILLISECONDS));
                    long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
                    long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                    if (TestUtils$.MODULE$ == null) {
                        throw null;
                    }
                    long waitUntilTrue_startTime = System.currentTimeMillis();
                    while (!PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$4(this, testGroupId)) {
                        void waitUntilTrue_pause;
                        void waitUntilTrue_waitTimeMs;
                        if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                            throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$6(testGroupId), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
                        }
                        if (Predef$.MODULE$ == null) {
                            throw null;
                        }
                        Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
                    }
                    long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                    long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                    if (TestUtils$.MODULE$ == null) {
                        throw null;
                    }
                    long waitUntilTrue_startTime2 = System.currentTimeMillis();
                    while (!PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$7(this, testGroupId)) {
                        void waitUntilTrue_pause;
                        void waitUntilTrue_waitTimeMs;
                        if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                            throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$9(testGroupId), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
                        }
                        if (Predef$.MODULE$ == null) {
                            throw null;
                        }
                        Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
                    }
                    long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                    long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                    if (TestUtils$.MODULE$ == null) {
                        throw null;
                    }
                    long waitUntilTrue_startTime3 = System.currentTimeMillis();
                    while (!PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$10(this, testGroupId)) {
                        void waitUntilTrue_pause;
                        void waitUntilTrue_waitTimeMs;
                        if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                            throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$12(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
                        }
                        if (Predef$.MODULE$ == null) {
                            throw null;
                        }
                        Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
                    }
                    DescribeConsumerGroupsResult describeWithFakeGroupResult = this.client().describeConsumerGroups((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)testGroupId, (List)new .colon.colon((Object)fakeGroupId, (List)Nil$.MODULE$))).asJava(), new DescribeConsumerGroupsOptions().includeAuthorizedOperations(true));
                    Assert.assertEquals((long)2L, (long)describeWithFakeGroupResult.describedGroups().size());
                    Assert.assertTrue((boolean)describeWithFakeGroupResult.describedGroups().containsKey(testGroupId));
                    ConsumerGroupDescription testGroupDescription = (ConsumerGroupDescription)((KafkaFuture)describeWithFakeGroupResult.describedGroups().get(testGroupId)).get();
                    Assert.assertEquals((Object)testGroupId, (Object)testGroupDescription.groupId());
                    Assert.assertFalse((boolean)testGroupDescription.isSimpleConsumerGroup());
                    Assert.assertEquals((long)groupInstanceSet.size(), (long)testGroupDescription.members().size());
                    Collection members = testGroupDescription.members();
                    ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(members).asScala()).foreach((Function1 & Serializable & scala.Serializable)member -> {
                        PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$13(testClientId, member);
                        return BoxedUnit.UNIT;
                    });
                    scala.collection.immutable.Map topicPartitionsByTopic = ((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(members).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$16 -> (Set)CollectionConverters$.MODULE$.asScalaSetConverter(x$16.assignment().topicPartitions()).asScala(), scala.collection.Iterable$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$17 -> x$17.topic());
                    topicSet.foreach((Function1 & Serializable & scala.Serializable)topic -> {
                        PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$16(topicPartitionsByTopic, testNumPartitions, topic);
                        return BoxedUnit.UNIT;
                    });
                    java.util.Set expectedOperations = (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)AclEntry$.MODULE$.supportedOperations(ResourceType.GROUP)).asJava();
                    Assert.assertEquals((Object)expectedOperations, (Object)testGroupDescription.authorizedOperations());
                    Assert.assertTrue((boolean)describeWithFakeGroupResult.describedGroups().containsKey(fakeGroupId));
                    ConsumerGroupDescription fakeGroupDescription = (ConsumerGroupDescription)((KafkaFuture)describeWithFakeGroupResult.describedGroups().get(fakeGroupId)).get();
                    Assert.assertEquals((Object)fakeGroupId, (Object)fakeGroupDescription.groupId());
                    Assert.assertEquals((long)0L, (long)fakeGroupDescription.members().size());
                    Assert.assertEquals((Object)"", (Object)fakeGroupDescription.partitionAssignor());
                    Assert.assertEquals((Object)ConsumerGroupState.DEAD, (Object)fakeGroupDescription.state());
                    Assert.assertEquals((Object)expectedOperations, (Object)fakeGroupDescription.authorizedOperations());
                    Assert.assertEquals((long)2L, (long)((java.util.Map)describeWithFakeGroupResult.all().get()).size());
                    long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                    long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                    if (TestUtils$.MODULE$ == null) {
                        throw null;
                    }
                    long waitUntilTrue_startTime4 = System.currentTimeMillis();
                    while (!PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$18(this, testGroupId, testTopicName)) {
                        void waitUntilTrue_pause;
                        void waitUntilTrue_waitTimeMs;
                        if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                            throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$19(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
                        }
                        if (Predef$.MODULE$ == null) {
                            throw null;
                        }
                        Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
                    }
                    String invalidInstanceId = "invalid-instance-id";
                    RemoveMembersFromConsumerGroupResult removeMembersResult = this.client().removeMembersFromConsumerGroup(testGroupId, new RemoveMembersFromConsumerGroupOptions(Collections.singleton(new MemberToRemove(invalidInstanceId))));
                    TestUtils$.MODULE$.assertFutureExceptionTypeEquals(removeMembersResult.all(), UnknownMemberIdException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                    KafkaFuture firstMemberFuture = removeMembersResult.memberResult(new MemberToRemove(invalidInstanceId));
                    TestUtils$.MODULE$.assertFutureExceptionTypeEquals(firstMemberFuture, UnknownMemberIdException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                    DeleteConsumerGroupsResult deleteResult = this.client().deleteConsumerGroups((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)testGroupId, (List)new .colon.colon((Object)fakeGroupId, (List)Nil$.MODULE$))).asJava());
                    Assert.assertEquals((long)2L, (long)deleteResult.deletedGroups().size());
                    Assert.assertTrue((boolean)deleteResult.deletedGroups().containsKey(fakeGroupId));
                    TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)deleteResult.deletedGroups().get(fakeGroupId), GroupIdNotFoundException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                    Assert.assertTrue((boolean)deleteResult.deletedGroups().containsKey(testGroupId));
                    TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)deleteResult.deletedGroups().get(testGroupId), GroupNotEmptyException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                    removeMembersResult = this.client().removeMembersFromConsumerGroup(testGroupId, new RemoveMembersFromConsumerGroupOptions(Collections.singleton(new MemberToRemove(testInstanceId1))));
                    Assert.assertNull((Object)removeMembersResult.all().get());
                    Assert.assertNull((Object)removeMembersResult.memberResult(new MemberToRemove(testInstanceId1)).get());
                    DescribeConsumerGroupsResult describeTestGroupResult = this.client().describeConsumerGroups((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)testGroupId, (List)Nil$.MODULE$)).asJava(), new DescribeConsumerGroupsOptions().includeAuthorizedOperations(true));
                    Assert.assertEquals((long)1L, (long)describeTestGroupResult.describedGroups().size());
                    testGroupDescription = (ConsumerGroupDescription)((KafkaFuture)describeTestGroupResult.describedGroups().get(testGroupId)).get();
                    Assert.assertEquals((Object)testGroupId, (Object)testGroupDescription.groupId());
                    Assert.assertFalse((boolean)testGroupDescription.isSimpleConsumerGroup());
                    Assert.assertEquals((long)(consumerSet.size() - 1), (long)testGroupDescription.members().size());
                    removeMembersResult = this.client().removeMembersFromConsumerGroup(testGroupId, new RemoveMembersFromConsumerGroupOptions());
                    Assert.assertNull((Object)removeMembersResult.all().get());
                    testGroupDescription = (ConsumerGroupDescription)((KafkaFuture)this.client().describeConsumerGroups((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)testGroupId, (List)Nil$.MODULE$)).asJava(), new DescribeConsumerGroupsOptions().includeAuthorizedOperations(true)).describedGroups().get(testGroupId)).get();
                    Assert.assertTrue((boolean)testGroupDescription.members().isEmpty());
                    deleteResult = this.client().deleteConsumerGroups((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)testGroupId, (List)Nil$.MODULE$)).asJava());
                    Assert.assertEquals((long)1L, (long)deleteResult.deletedGroups().size());
                    Assert.assertTrue((boolean)deleteResult.deletedGroups().containsKey(testGroupId));
                    Assert.assertNull((Object)((KafkaFuture)deleteResult.deletedGroups().get(testGroupId)).get());
                }
                finally {
                    consumerThreads.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$20(x0$1);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            finally {
                ((IterableLike)consumerSet.zip((GenIterable)groupInstanceSet, Set$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)zipped -> {
                    PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$21(zipped);
                    return BoxedUnit.UNIT;
                });
            }
        }
        finally {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"adminClient");
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsets() {
        java.util.Map<String, Object> config = this.createConfig();
        this.client_$eq(Admin.create(config));
        try {
            String testTopicName = "test_topic";
            String testGroupId = "test_group_id";
            String testClientId = "test_client_id";
            String fakeGroupId = "fake_group_id";
            TopicPartition tp1 = new TopicPartition(testTopicName, 0);
            TopicPartition tp2 = new TopicPartition("foo", 0);
            this.client().createTopics(Collections.singleton(new NewTopic(testTopicName, 1, (short)1))).all().get();
            this.waitForTopics(this.client(), (Seq<String>)new .colon.colon((Object)testTopicName, (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
            KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
            try {
                producer.send(new ProducerRecord(testTopicName, Predef$.MODULE$.int2Integer(0), null, null)).get();
            }
            finally {
                Utils.closeQuietly(producer, (String)"producer");
            }
            Properties newConsumerConfig = new Properties(this.consumerConfig());
            newConsumerConfig.setProperty("group.id", testGroupId);
            newConsumerConfig.setProperty("client.id", testClientId);
            newConsumerConfig.setProperty("max.poll.interval.ms", Integer.toString(Integer.MAX_VALUE));
            newConsumerConfig.setProperty("session.timeout.ms", Integer.toString(Defaults$.MODULE$.GroupMaxSessionTimeoutMs()));
            ByteArrayDeserializer x$2 = this.createConsumer$default$1();
            ByteArrayDeserializer x$3 = this.createConsumer$default$2();
            List<String> x$4 = this.createConsumer$default$4();
            KafkaConsumer consumer = this.createConsumer(x$2, x$3, newConsumerConfig, x$4);
            try {
                TestUtils$.MODULE$.subscribeAndWaitForRecords(testTopicName, consumer, TestUtils$.MODULE$.subscribeAndWaitForRecords$default$3());
                consumer.commitSync();
                DeleteConsumerGroupOffsetsResult offsetDeleteResult = this.client().deleteConsumerGroupOffsets(testGroupId, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.all(), GroupSubscribedToTopicException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(tp1), GroupSubscribedToTopicException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(tp2), UnknownTopicOrPartitionException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                DeleteConsumerGroupOffsetsResult fakeDeleteResult = this.client().deleteConsumerGroupOffsets(fakeGroupId, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(fakeDeleteResult.all(), GroupIdNotFoundException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(fakeDeleteResult.partitionResult(tp1), GroupIdNotFoundException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(fakeDeleteResult.partitionResult(tp2), GroupIdNotFoundException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
            }
            finally {
                Utils.closeQuietly(consumer, (String)"consumer");
            }
            DeleteConsumerGroupOffsetsResult offsetDeleteResult = this.client().deleteConsumerGroupOffsets(testGroupId, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.all(), UnknownTopicOrPartitionException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
            Assert.assertNull((Object)offsetDeleteResult.partitionResult(tp1).get());
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(tp2), UnknownTopicOrPartitionException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        }
        finally {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"adminClient");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testElectPreferredLeaders() {
        void $minus$greater$extension_$this;
        void $minus$greater$extension_$this2;
        this.client_$eq(Admin.create(this.createConfig()));
        Seq prefer0 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Seq prefer1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
        Seq prefer2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 1}));
        TopicPartition partition1 = new TopicPartition("elect-preferred-leaders-topic-1", 0);
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)prefer0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), partition1.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), (Seq<KafkaServer>)this.servers());
        TopicPartition partition2 = new TopicPartition("elect-preferred-leaders-topic-2", 0);
        Tuple2[] tuple2Array2 = new Tuple2[1];
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition2.partition()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)prefer0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), partition2.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))), (Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 0);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 0);
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava());
        Throwable exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).get();
        Assert.assertEquals(ElectionNotNeededException.class, exception.getClass());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 0);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, null);
        Assert.assertTrue((boolean)((java.util.Map)electResult.partitions().get()).isEmpty());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 0);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 0);
        this.changePreferredLeader$1(prefer1, partition1, partition2);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava());
        Assert.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 1);
        Assert.assertFalse((boolean)((java.util.Map)electResult.partitions().get()).containsKey(partition2));
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 0);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, null);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition2})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(((java.util.Map)electResult.partitions().get()).keySet()).asScala());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 1);
        TopicPartition unknownPartition = new TopicPartition("topic-does-not-exist", 0);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition}))).asJava());
        Assert.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(unknownPartition)).get();
        Assert.assertEquals(UnknownTopicOrPartitionException.class, exception.getClass());
        Assert.assertEquals((Object)"The partition does not exist.", (Object)exception.getMessage());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 1);
        this.changePreferredLeader$1(prefer2, partition1, partition2);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition, partition1}))).asJava());
        Assert.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition, partition1}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 1);
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(unknownPartition)).get();
        Assert.assertEquals(UnknownTopicOrPartitionException.class, exception.getClass());
        Assert.assertEquals((Object)"The partition does not exist.", (Object)exception.getMessage());
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition2}))).asJava());
        Assert.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition2}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 2);
        this.changePreferredLeader$1(prefer1, partition1, partition2);
        ((KafkaServer)this.servers().apply(1)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))));
        ElectLeadersOptions shortTimeout = (ElectLeadersOptions)new ElectLeadersOptions().timeoutMs(Predef$.MODULE$.int2Integer(10000));
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava(), shortTimeout);
        Assert.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).get();
        Assert.assertEquals(PreferredLeaderNotAvailableException.class, exception.getClass());
        Assert.assertTrue((String)new StringBuilder(14).append("Wrong message ").append(exception.getMessage()).toString(), (boolean)exception.getMessage().contains("Failed to elect leader for partition elect-preferred-leaders-topic-1-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"));
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 2);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, null, shortTimeout);
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).get();
        Assert.assertEquals(PreferredLeaderNotAvailableException.class, exception.getClass());
        Assert.assertTrue((String)new StringBuilder(14).append("Wrong message ").append(exception.getMessage()).toString(), (boolean)exception.getMessage().contains("Failed to elect leader for partition elect-preferred-leaders-topic-1-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"));
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).get();
        Assert.assertEquals(PreferredLeaderNotAvailableException.class, exception.getClass());
        Assert.assertTrue((String)new StringBuilder(14).append("Wrong message ").append(exception.getMessage()).toString(), (boolean)exception.getMessage().contains("Failed to elect leader for partition elect-preferred-leaders-topic-2-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"));
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 2);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testElectUncleanLeadersForOnePartition() {
        void $minus$greater$extension_$this;
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        TopicPartition partition1 = new TopicPartition("unclean-test-topic-1", 0);
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment1);
        TestUtils$.MODULE$.createTopic(this.zkClient(), partition1.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), (Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertNoLeader(this.client(), partition1);
        ((KafkaServer)this.servers().apply(broker2)).startup();
        Assert.assertFalse((boolean)((Optional)((java.util.Map)this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava()).partitions().get()).get(partition1)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testElectUncleanLeadersForManyPartitions() {
        void $minus$greater$extension_$this;
        void $minus$greater$extension_$this2;
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TopicPartition partition2 = new TopicPartition(topic, 1);
        Tuple2[] tuple2Array = new Tuple2[2];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)assignment1);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition2.partition()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment2);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), (Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertNoLeader(this.client(), partition1);
        TestUtils$.MODULE$.assertNoLeader(this.client(), partition2);
        ((KafkaServer)this.servers().apply(broker2)).startup();
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2}))).asJava());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker2);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testElectUncleanLeadersForAllPartitions() {
        void $minus$greater$extension_$this;
        void $minus$greater$extension_$this2;
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        int broker3 = 0;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker3}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TopicPartition partition2 = new TopicPartition(topic, 1);
        Tuple2[] tuple2Array = new Tuple2[2];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)assignment1);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition2.partition()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment2);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), (Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertNoLeader(this.client(), partition1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker3);
        ((KafkaServer)this.servers().apply(broker2)).startup();
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, null);
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        Assert.assertFalse((boolean)((java.util.Map)electResult.partitions().get()).containsKey(partition2));
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker3);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testElectUncleanLeadersForUnknownPartitions() {
        void $minus$greater$extension_$this;
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        String topic = "unclean-test-topic-1";
        TopicPartition unknownPartition = new TopicPartition(topic, 1);
        TopicPartition unknownTopic = new TopicPartition("unknown-topic", 0);
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment1);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), (Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), new TopicPartition(topic, 0), broker1);
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition, unknownTopic}))).asJava());
        Assert.assertTrue((boolean)(((Optional)((java.util.Map)electResult.partitions().get()).get(unknownPartition)).get() instanceof UnknownTopicOrPartitionException));
        Assert.assertTrue((boolean)(((Optional)((java.util.Map)electResult.partitions().get()).get(unknownTopic)).get() instanceof UnknownTopicOrPartitionException));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testElectUncleanLeadersWhenNoLiveBrokers() {
        void $minus$greater$extension_$this;
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment1);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), (Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertNoLeader(this.client(), partition1);
        Assert.assertTrue((boolean)(((Optional)((java.util.Map)this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava()).partitions().get()).get(partition1)).get() instanceof EligibleLeadersNotAvailableException));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testElectUncleanLeadersNoop() {
        void $minus$greater$extension_$this;
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment1);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), (Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
        ((KafkaServer)this.servers().apply(broker1)).startup();
        Assert.assertTrue((boolean)(((Optional)((java.util.Map)this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava()).partitions().get()).get(partition1)).get() instanceof ElectionNotNeededException));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testElectUncleanLeadersAndNoop() {
        void $minus$greater$extension_$this;
        void $minus$greater$extension_$this2;
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        int broker3 = 0;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker3}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TopicPartition partition2 = new TopicPartition(topic, 1);
        Tuple2[] tuple2Array = new Tuple2[2];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)assignment1);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition2.partition()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment2);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), (Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertNoLeader(this.client(), partition1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker3);
        ((KafkaServer)this.servers().apply(broker2)).startup();
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2}))).asJava());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        Assert.assertTrue((boolean)(((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).get() instanceof ElectionNotNeededException));
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker3);
    }

    @Test
    public void testListReassignmentsDoesNotShowNonReassigningPartitions() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "list-reassignments-no-reassignments";
        this.createTopic(topic, 1, 3, this.createTopic$default$4());
        TopicPartition tp = new TopicPartition(topic, 0);
        java.util.Map reassignmentsMap = (java.util.Map)this.client().listPartitionReassignments((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()).reassignments().get();
        Assert.assertEquals((long)0L, (long)reassignmentsMap.size());
        java.util.Map allReassignmentsMap = (java.util.Map)this.client().listPartitionReassignments().reassignments().get();
        Assert.assertEquals((long)0L, (long)allReassignmentsMap.size());
    }

    @Test
    public void testListReassignmentsDoesNotShowDeletedPartitions() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "list-reassignments-no-reassignments";
        TopicPartition tp = new TopicPartition(topic, 0);
        java.util.Map reassignmentsMap = (java.util.Map)this.client().listPartitionReassignments((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()).reassignments().get();
        Assert.assertEquals((long)0L, (long)reassignmentsMap.size());
        java.util.Map allReassignmentsMap = (java.util.Map)this.client().listPartitionReassignments().reassignments().get();
        Assert.assertEquals((long)0L, (long)allReassignmentsMap.size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidIncrementalAlterConfigs() {
        void $minus$greater$extension_$this;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_$this6;
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "incremental-alter-configs-topic-1";
        ConfigResource topic1Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topic1CreateConfigs = new Properties();
        topic1CreateConfigs.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        topic1CreateConfigs.setProperty(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.createTopic(topic1, 1, 1, topic1CreateConfigs);
        String topic2 = "incremental-alter-configs-topic-2";
        ConfigResource topic2Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        Collection topic1AlterConfigs = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.FlushMsProp(), "1000"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete()), AlterConfigOp.OpType.APPEND), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.RetentionMsProp(), ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$)))).asJavaCollection();
        Collection topic2AlterConfigs = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "lz4"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()), AlterConfigOp.OpType.APPEND), (List)Nil$.MODULE$)))).asJavaCollection();
        Tuple2[] tuple2Array = new Tuple2[2];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topic1Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)topic1AlterConfigs);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)topic2Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)topic2AlterConfigs);
        AlterConfigsResult alterResult = this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava());
        Assert.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava(), alterResult.values().keySet());
        alterResult.all().get();
        java.util.Map configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1Resource, (List)new .colon.colon((Object)topic2Resource, (List)Nil$.MODULE$))).asJava()).all().get();
        Assert.assertEquals((long)2L, (long)configs.size());
        Assert.assertEquals((Object)"1000", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.FlushMsProp()).value());
        Assert.assertEquals((Object)"compact,delete", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        Assert.assertEquals((Object)Integer.toString(Defaults$.MODULE$.LogRetentionHours() * 60 * 60 * 1000), (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        Assert.assertEquals((Object)"0.9", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertEquals((Object)"lz4", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        Assert.assertEquals((Object)"delete,compact", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        topic1AlterConfigs = (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()), AlterConfigOp.OpType.SUBTRACT), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0"), AlterConfigOp.OpType.SUBTRACT), (List)Nil$.MODULE$))).asJava();
        topic2AlterConfigs = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString()), AlterConfigOp.OpType.SUBTRACT), (List)Nil$.MODULE$)).asJavaCollection();
        Tuple2[] tuple2Array2 = new Tuple2[2];
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)topic1Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)topic1AlterConfigs);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)topic2Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)topic2AlterConfigs);
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava());
        Assert.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava(), alterResult.values().keySet());
        alterResult.all().get();
        configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1Resource, (List)new .colon.colon((Object)topic2Resource, (List)Nil$.MODULE$))).asJava()).all().get();
        Assert.assertEquals((long)2L, (long)configs.size());
        Assert.assertEquals((Object)"delete", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        Assert.assertEquals((Object)"1000", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.FlushMsProp()).value());
        Assert.assertEquals((Object)"", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()).value());
        Assert.assertEquals((Object)"", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        topic1AlterConfigs = (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()), AlterConfigOp.OpType.APPEND), (List)Nil$.MODULE$)).asJava();
        Tuple2[] tuple2Array3 = new Tuple2[1];
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)topic1Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)topic1AlterConfigs);
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3))).asJava(), new AlterConfigsOptions().validateOnly(true));
        alterResult.all().get();
        configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1Resource, (List)Nil$.MODULE$)).asJava()).all().get();
        Assert.assertEquals((Object)"delete", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        topic1AlterConfigs = (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "zip"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJava();
        Tuple2[] tuple2Array4 = new Tuple2[1];
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)topic1Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)topic1AlterConfigs);
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array4))).asJava(), new AlterConfigsOptions().validateOnly(true));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Invalid config value for resource"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIncrementalAlterConfigsDeleteAndSetBrokerConfigs() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        this.client_$eq(Admin.create(this.createConfig()));
        ConfigResource broker0Resource = new ConfigResource(ConfigResource.Type.BROKER, "0");
        Tuple2[] tuple2Array = new Tuple2[1];
        Collection collection = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), "123"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), "456"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$))).asJavaCollection();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)broker0Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).all().get();
        long x$3 = 25L;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$1(this, broker0Resource)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$5(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(x$4, x$3));
        }
        Tuple2[] tuple2Array2 = new Tuple2[1];
        Collection collection2 = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), ""), AlterConfigOp.OpType.DELETE), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), "654"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), "987"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)))).asJavaCollection();
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)broker0Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava()).all().get();
        long x$7 = 25L;
        long x$8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$6(this, broker0Resource)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + x$8) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$11(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(x$8, x$7));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIncrementalAlterConfigsDeleteBrokerConfigs() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        this.client_$eq(Admin.create(this.createConfig()));
        ConfigResource broker0Resource = new ConfigResource(ConfigResource.Type.BROKER, "0");
        Tuple2[] tuple2Array = new Tuple2[1];
        Collection collection = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), "123"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), "456"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), "789"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)))).asJavaCollection();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)broker0Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).all().get();
        long x$3 = 25L;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$1(this, broker0Resource)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$6(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(x$4, x$3));
        }
        Tuple2[] tuple2Array2 = new Tuple2[1];
        Collection collection2 = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), ""), AlterConfigOp.OpType.DELETE), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), ""), AlterConfigOp.OpType.DELETE), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$)))).asJavaCollection();
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)broker0Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava()).all().get();
        long x$7 = 25L;
        long x$8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$7(this, broker0Resource)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + x$8) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$12(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(x$8, x$7));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidIncrementalAlterConfigs() {
        void $minus$greater$extension_$this;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_$this5;
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "incremental-alter-configs-topic-1";
        ConfigResource topic1Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        String topic2 = "incremental-alter-configs-topic-2";
        ConfigResource topic2Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        Collection topic1AlterConfigs = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.75"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.65"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "gzip"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)))).asJavaCollection();
        Collection topic2AlterConfigs = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        Tuple2[] tuple2Array = new Tuple2[2];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topic1Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)topic1AlterConfigs);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)topic2Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)topic2AlterConfigs);
        AlterConfigsResult alterResult = this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava());
        Assert.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Error due to duplicate config keys"));
        ((KafkaFuture)alterResult.values().get(topic2Resource)).get();
        java.util.Map configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1Resource, (List)new .colon.colon((Object)topic2Resource, (List)Nil$.MODULE$))).asJava()).all().get();
        Assert.assertEquals((long)2L, (long)configs.size());
        Assert.assertEquals((Object)Double.toString(Defaults$.MODULE$.LogCleanerMinCleanRatio()), (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertEquals((Object)Defaults$.MODULE$.CompressionType().toString(), (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        Assert.assertEquals((Object)"0.9", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        topic1AlterConfigs = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "gzip"), AlterConfigOp.OpType.APPEND), (List)Nil$.MODULE$)).asJavaCollection();
        topic2AlterConfigs = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "snappy"), AlterConfigOp.OpType.SUBTRACT), (List)Nil$.MODULE$)).asJavaCollection();
        Tuple2[] tuple2Array2 = new Tuple2[2];
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)topic1Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)topic1AlterConfigs);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)topic2Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)topic2AlterConfigs);
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava());
        Assert.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Config value append is not allowed for config"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic2Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Config value subtract is not allowed for config"));
        topic1AlterConfigs = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "1.1"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        Tuple2[] tuple2Array3 = new Tuple2[1];
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)topic1Resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)topic1AlterConfigs);
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3))).asJava());
        Assert.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Invalid config value for resource"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidAlterPartitionReassignments() {
        void $minus$greater$extension_$this;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_$this3;
        void intWrapper_x;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_$this7;
        void $minus$greater$extension_$this8;
        void intWrapper_x2;
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "alter-reassignments-topic-1";
        TopicPartition tp1 = new TopicPartition(topic, 0);
        TopicPartition tp2 = new TopicPartition(topic, 1);
        TopicPartition tp3 = new TopicPartition(topic, 2);
        this.createTopic(topic, 4, this.createTopic$default$3(), this.createTopic$default$4());
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Optional<NewPartitionReassignment> validAssignment = Optional.of(new NewPartitionReassignment((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)RichInt$.MODULE$.until$extension0((int)intWrapper_x2, this.brokerCount()).map((Function1 & Serializable & scala.Serializable)x$18 -> PlaintextAdminIntegrationTest.$anonfun$testInvalidAlterPartitionReassignments$1(BoxesRunTime.unboxToInt((Object)x$18)), IndexedSeq$.MODULE$.canBuildFrom())).asJava()));
        TopicPartition nonExistentTp1 = new TopicPartition("topicA", 0);
        TopicPartition nonExistentTp2 = new TopicPartition(topic, 4);
        Tuple2[] tuple2Array = new Tuple2[5];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)tp1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this8, validAssignment);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)tp2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this7, validAssignment);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)tp3);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this6, validAssignment);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)nonExistentTp1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[3] = new Tuple2((Object)$minus$greater$extension_$this5, validAssignment);
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)nonExistentTp2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[4] = new Tuple2((Object)$minus$greater$extension_$this4, validAssignment);
        java.util.Map nonExistentPartitionsResult = this.client().alterPartitionReassignments((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).values();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)nonExistentPartitionsResult.get(nonExistentTp1), UnknownTopicOrPartitionException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)nonExistentPartitionsResult.get(nonExistentTp2), UnknownTopicOrPartitionException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        boolean bl2 = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Optional<NewPartitionReassignment> extraNonExistentReplica = Optional.of(new NewPartitionReassignment((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)RichInt$.MODULE$.until$extension0((int)intWrapper_x, this.brokerCount() + 1).map((Function1 & Serializable & scala.Serializable)x$19 -> PlaintextAdminIntegrationTest.$anonfun$testInvalidAlterPartitionReassignments$2(BoxesRunTime.unboxToInt((Object)x$19)), IndexedSeq$.MODULE$.canBuildFrom())).asJava()));
        Optional<NewPartitionReassignment> negativeIdReplica = Optional.of(new NewPartitionReassignment((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-3, -2, -1}))).map((Function1 & Serializable & scala.Serializable)x$20 -> PlaintextAdminIntegrationTest.$anonfun$testInvalidAlterPartitionReassignments$3(BoxesRunTime.unboxToInt((Object)x$20)), Seq$.MODULE$.canBuildFrom())).asJava()));
        Optional<NewPartitionReassignment> duplicateReplica = Optional.of(new NewPartitionReassignment((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 1}))).map((Function1 & Serializable & scala.Serializable)x$21 -> PlaintextAdminIntegrationTest.$anonfun$testInvalidAlterPartitionReassignments$4(BoxesRunTime.unboxToInt((Object)x$21)), Seq$.MODULE$.canBuildFrom())).asJava()));
        Tuple2[] tuple2Array2 = new Tuple2[3];
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)tp1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this3, extraNonExistentReplica);
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)tp2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this2, negativeIdReplica);
        Object object8 = Predef$.MODULE$.ArrowAssoc((Object)tp3);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[2] = new Tuple2((Object)$minus$greater$extension_$this, duplicateReplica);
        java.util.Map invalidReplicaResult = this.client().alterPartitionReassignments((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava()).values();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)invalidReplicaResult.get(tp1), InvalidReplicaAssignmentException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)invalidReplicaResult.get(tp2), InvalidReplicaAssignmentException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)invalidReplicaResult.get(tp3), InvalidReplicaAssignmentException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLongTopicNames() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Admin client = Admin.create(this.createConfig());
        String longTopicName = String.join((CharSequence)"", Collections.nCopies(249, "x"));
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(250, "x"));
        .colon.colon newTopics2 = new .colon.colon((Object)new NewTopic(invalidTopicName, 3, (short)3), (List)new .colon.colon((Object)new NewTopic(longTopicName, 3, (short)3), (List)Nil$.MODULE$));
        java.util.Map results = client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)newTopics2).asJava()).values();
        Assert.assertTrue((boolean)results.containsKey(longTopicName));
        ((KafkaFuture)results.get(longTopicName)).get();
        Assert.assertTrue((boolean)results.containsKey(invalidTopicName));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get(invalidTopicName), InvalidTopicException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = ((KafkaServer)this.servers().apply(0)).config().logDirs().apply(0);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(longTopicName, 0, 0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(client.alterReplicaLogDirs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).all(), InvalidTopicException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        client.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNullConfigs() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_$this3;
        this.client_$eq(Admin.create(this.createConfig()));
        Tuple2[] tuple2Array = new Tuple2[2];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageFormatVersionProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, null);
        String string = "producer";
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CompressionTypeProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        java.util.Map invalidConfigs = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        NewTopic newTopic = new NewTopic(this.topic(), 2, (short)this.brokerCount());
        ExecutionException e1 = (ExecutionException)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)this.client().createTopics(Collections.singletonList(newTopic.configs(invalidConfigs))).all().get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2036));
        Assert.assertTrue((String)new StringBuilder(21).append("Unexpected exception ").append(e1.getCause().getClass()).toString(), (boolean)(e1.getCause() instanceof InvalidRequestException));
        Tuple2[] tuple2Array2 = new Tuple2[1];
        String string2 = "producer";
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CompressionTypeProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        java.util.Map validConfigs = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava();
        this.client().createTopics(Collections.singletonList(newTopic.configs(validConfigs))).all().get();
        this.waitForTopics(this.client(), (Seq<String>)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
        this.validateLogConfig$1("producer");
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, this.topic());
        .colon.colon alterOps = new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MessageFormatVersionProp(), null), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "lz4"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$));
        ExecutionException e2 = (ExecutionException)Assertions$.MODULE$.intercept(() -> PlaintextAdminIntegrationTest.$anonfun$testNullConfigs$2(this, topicResource, (Seq)alterOps), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2051));
        Assert.assertTrue((String)new StringBuilder(21).append("Unexpected exception ").append(e2.getCause().getClass()).toString(), (boolean)(e2.getCause() instanceof InvalidRequestException));
        this.validateLogConfig$1("producer");
    }

    @Test
    public void testDescribeConfigsForLog4jLogLevels() {
        this.client_$eq(Admin.create(this.createConfig()));
        Config loggerConfig = this.describeBrokerLoggers();
        String rootLogLevel = loggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value();
        ConfigEntry logCleanerLogLevelConfig = loggerConfig.get("kafka.cluster.Replica");
        Assert.assertEquals((Object)rootLogLevel, (Object)logCleanerLogLevelConfig.value());
        Assert.assertEquals((Object)"kafka.cluster.Replica", (Object)logCleanerLogLevelConfig.name());
        Assert.assertEquals((Object)ConfigEntry.ConfigSource.DYNAMIC_BROKER_LOGGER_CONFIG, (Object)logCleanerLogLevelConfig.source());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)logCleanerLogLevelConfig.isReadOnly()));
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)logCleanerLogLevelConfig.isSensitive()));
        Assert.assertTrue((boolean)logCleanerLogLevelConfig.synonyms().isEmpty());
    }

    @Test
    @Ignore
    public void testIncrementalAlterConfigsForLog4jLogLevels() {
        this.client_$eq(Admin.create(this.createConfig()));
        Config initialLoggerConfig = this.describeBrokerLoggers();
        String initialRootLogLevel = initialLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value();
        Assert.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get("kafka.controller.KafkaController").value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get("kafka.log.LogCleaner").value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get("kafka.server.ReplicaManager").value());
        String newRootLogLevel = "DEBUG";
        Collection alterRootLoggerEntry = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), newRootLogLevel), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        this.alterBrokerLoggers(alterRootLoggerEntry, true);
        Config validatedLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get("kafka.controller.KafkaController").value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get("kafka.log.LogCleaner").value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get("kafka.server.ReplicaManager").value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get("kafka.zookeeper.ZooKeeperClient").value());
        this.alterBrokerLoggers(alterRootLoggerEntry, this.alterBrokerLoggers$default$2());
        Config changedRootLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get("kafka.controller.KafkaController").value());
        Assert.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get("kafka.log.LogCleaner").value());
        Assert.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get("kafka.server.ReplicaManager").value());
        Assert.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get("kafka.zookeeper.ZooKeeperClient").value());
        Collection alterZKLoggerEntry = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.zookeeper.ZooKeeperClient", "ERROR"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        this.alterBrokerLoggers(alterZKLoggerEntry, this.alterBrokerLoggers$default$2());
        Config changedZKLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)"ERROR", (Object)changedZKLoggerConfig.get("kafka.zookeeper.ZooKeeperClient").value());
        Collection alterLogLevelsEntries = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.controller.KafkaController", "INFO"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.log.LogCleaner", "ERROR"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.ReplicaManager", "TRACE"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.zookeeper.ZooKeeperClient", ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$))))).asJavaCollection();
        this.alterBrokerLoggers(alterLogLevelsEntries, this.alterBrokerLoggers$default$2());
        Config alteredLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)newRootLogLevel, (Object)alteredLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)"INFO", (Object)alteredLoggerConfig.get("kafka.controller.KafkaController").value());
        Assert.assertEquals((Object)"ERROR", (Object)alteredLoggerConfig.get("kafka.log.LogCleaner").value());
        Assert.assertEquals((Object)"TRACE", (Object)alteredLoggerConfig.get("kafka.server.ReplicaManager").value());
        Assert.assertEquals((Object)newRootLogLevel, (Object)alteredLoggerConfig.get("kafka.zookeeper.ZooKeeperClient").value());
    }

    @Test
    @Ignore
    public void testIncrementalAlterConfigsForLog4jLogLevelsCanResetLoggerToCurrentRoot() {
        this.client_$eq(Admin.create(this.createConfig()));
        String initialRootLogLevel = "TRACE";
        Collection alterRootLoggerEntry = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), initialRootLogLevel), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        this.alterBrokerLoggers(alterRootLoggerEntry, this.alterBrokerLoggers$default$2());
        Config initialLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get("kafka.controller.KafkaController").value());
        Collection alterControllerLoggerEntry = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.controller.KafkaController", "INFO"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        this.alterBrokerLoggers(alterControllerLoggerEntry, this.alterBrokerLoggers$default$2());
        Config changedControllerLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)initialRootLogLevel, (Object)changedControllerLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)"INFO", (Object)changedControllerLoggerConfig.get("kafka.controller.KafkaController").value());
        Collection deleteControllerLoggerEntry = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.controller.KafkaController", ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$)).asJavaCollection();
        this.alterBrokerLoggers(deleteControllerLoggerEntry, this.alterBrokerLoggers$default$2());
        Config deletedControllerLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)initialRootLogLevel, (Object)deletedControllerLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)deletedControllerLoggerConfig.get("kafka.controller.KafkaController").value());
        String newRootLogLevel = "ERROR";
        Collection newAlterRootLoggerEntry = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), newRootLogLevel), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        this.alterBrokerLoggers(newAlterRootLoggerEntry, this.alterBrokerLoggers$default$2());
        Config newRootLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)newRootLogLevel, (Object)newRootLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)newRootLogLevel, (Object)newRootLoggerConfig.get("kafka.controller.KafkaController").value());
    }

    @Test
    @Ignore
    public void testIncrementalAlterConfigsForLog4jLogLevelsCannotResetRootLogger() {
        this.client_$eq(Admin.create(this.createConfig()));
        Collection deleteRootLoggerEntry = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$)).asJavaCollection();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterBrokerLoggers(deleteRootLoggerEntry, this.alterBrokerLoggers$default$2()), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2187))).getCause() instanceof InvalidRequestException));
    }

    @Test
    @Ignore
    public void testIncrementalAlterConfigsForLog4jLogLevelsDoesNotWorkWithInvalidConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String validLoggerName = "kafka.server.KafkaRequestHandler";
        ConfigEntry expectedValidLoggerLogLevel = this.describeBrokerLoggers().get(validLoggerName);
        Collection appendLogLevelEntries = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.KafkaRequestHandler", "INFO"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.network.SocketServer", "ERROR"), AlterConfigOp.OpType.APPEND), (List)Nil$.MODULE$))).asJavaCollection();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterBrokerLoggers(appendLogLevelEntries, this.alterBrokerLoggers$default$2()), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2207))).getCause() instanceof InvalidRequestException));
        this.assertLogLevelDidNotChange$1(expectedValidLoggerLogLevel, validLoggerName);
        Collection subtractLogLevelEntries = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.KafkaRequestHandler", "INFO"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.network.SocketServer", "ERROR"), AlterConfigOp.OpType.SUBTRACT), (List)Nil$.MODULE$))).asJavaCollection();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterBrokerLoggers(subtractLogLevelEntries, this.alterBrokerLoggers$default$2()), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2214))).getCause() instanceof InvalidRequestException));
        this.assertLogLevelDidNotChange$1(expectedValidLoggerLogLevel, validLoggerName);
        Collection invalidLogLevelLogLevelEntries = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.KafkaRequestHandler", "INFO"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.network.SocketServer", "OFF"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$))).asJavaCollection();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterBrokerLoggers(invalidLogLevelLogLevelEntries, this.alterBrokerLoggers$default$2()), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2221))).getCause() instanceof InvalidRequestException));
        this.assertLogLevelDidNotChange$1(expectedValidLoggerLogLevel, validLoggerName);
        Collection invalidLoggerNameLogLevelEntries = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.KafkaRequestHandler", "INFO"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("Some Other LogCleaner", "ERROR"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$))).asJavaCollection();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterBrokerLoggers(invalidLoggerNameLogLevelEntries, this.alterBrokerLoggers$default$2()), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2228))).getCause() instanceof InvalidRequestException));
        this.assertLogLevelDidNotChange$1(expectedValidLoggerLogLevel, validLoggerName);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    @Ignore
    public void testAlterConfigsForLog4jLogLevelsDoesNotWork() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        this.client_$eq(Admin.create(this.createConfig()));
        Collection alterLogLevelsEntries = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("kafka.controller.KafkaController", "INFO"), (List)Nil$.MODULE$)).asJavaCollection();
        Tuple2[] tuple2Array = new Tuple2[1];
        Config config = new Config(alterLogLevelsEntries);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.brokerLoggerConfigResource());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        AlterConfigsResult alterResult = this.client().alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava());
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)alterResult.values().get(this.brokerLoggerConfigResource())).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2245))).getCause() instanceof InvalidRequestException));
    }

    /*
     * WARNING - void declaration
     */
    public void alterBrokerLoggers(Collection<AlterConfigOp> entries, boolean validateOnly) {
        void $minus$greater$extension_$this;
        if (!validateOnly) {
            ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(entries).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$alterBrokerLoggers$1(this, entry)));
        }
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.brokerLoggerConfigResource());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, entries);
        ((KafkaFuture)this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava(), new AlterConfigsOptions().validateOnly(validateOnly)).values().get(this.brokerLoggerConfigResource())).get();
    }

    public boolean alterBrokerLoggers$default$2() {
        return false;
    }

    public Config describeBrokerLoggers() {
        return (Config)((KafkaFuture)this.client().describeConfigs(Collections.singletonList(this.brokerLoggerConfigResource())).values().get(this.brokerLoggerConfigResource())).get();
    }

    private void teardownBrokerLoggers() {
        if (this.changedBrokerLoggers().nonEmpty()) {
            scala.collection.immutable.Set validLoggers = ((TraversableOnce)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.describeBrokerLoggers().entries()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$teardownBrokerLoggers$1(x$22)))).map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.name(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet();
            Collection unsetBrokerLoggersEntries = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)((SetLike)this.changedBrokerLoggers().intersect((GenSet)validLoggers)).map((Function1 & Serializable & scala.Serializable)logger -> new AlterConfigOp(new ConfigEntry(logger, ""), AlterConfigOp.OpType.DELETE), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).asJavaCollection();
            this.alterBrokerLoggers(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), "FATAL"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection(), this.alterBrokerLoggers$default$2());
            this.alterBrokerLoggers(unsetBrokerLoggersEntries, this.alterBrokerLoggers$default$2());
            this.changedBrokerLoggers().clear();
            return;
        }
    }

    public static final /* synthetic */ Void $anonfun$testCreateExistingTopicsThrowTopicExistsException$1(PlaintextAdminIntegrationTest $this, Seq newTopicsWithInvalidRF$1) {
        return (Void)$this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(newTopicsWithInvalidRF$1).asJava(), new CreateTopicsOptions().validateOnly(true)).all().get();
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataRefresh$1(PlaintextAdminIntegrationTest $this, KafkaServer x$1) {
        return x$1.config().brokerId() == TestUtils$.MODULE$.waitUntilControllerElected($this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
    }

    public static final /* synthetic */ int $anonfun$testDescribeCluster$1() {
        return -1;
    }

    public static final /* synthetic */ void $anonfun$testDescribeCluster$2(String[] brokers$1, Node node) {
        String hostStr = new StringBuilder(1).append(node.host()).append(":").append(node.port()).toString();
        Assert.assertTrue((String)new StringBuilder(45).append("Unknown host:port pair ").append(hostStr).append(" in brokerVersionInfos").toString(), (boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokers$1)).contains((Object)hostStr));
    }

    public static final /* synthetic */ int $anonfun$testDescribeLogDirs$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            return x0$1._2$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeLogDirs$5(int brokerId$1, KafkaServer x$3) {
        return x$3.config().brokerId() == brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeLogDirs$7(String topic$1, Tuple2 x0$4) {
        if (x0$4 != null) {
            String string = ((TopicPartition)x0$4._1()).topic();
            return !(string != null ? !string.equals(topic$1) : topic$1 != null);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testDescribeLogDirs$10(KafkaServer server$1, String logDir$1, TopicPartition tp) {
        LogManager qual$1 = server$1.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Assert.assertEquals((Object)((Log)qual$1.getLog(tp, x$2).get()).dir().getParent(), (Object)logDir$1);
    }

    public static final /* synthetic */ void $anonfun$testDescribeLogDirs$4(PlaintextAdminIntegrationTest $this, scala.collection.immutable.Map partitionsByBroker$1, java.util.Map logDirInfosByBroker$1, String topic$1, int brokerId) {
        KafkaServer server = (KafkaServer)$this.servers().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$5(brokerId, x$3))).get();
        Seq expectedPartitions = (Seq)partitionsByBroker$1.apply((Object)BoxesRunTime.boxToInteger((int)brokerId));
        java.util.Map logDirInfos = (java.util.Map)logDirInfosByBroker$1.get(BoxesRunTime.boxToInteger((int)brokerId));
        scala.collection.mutable.Map replicaInfos = (scala.collection.mutable.Map)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(logDirInfos).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 != null) {
                DescribeLogDirsResponse.LogDirInfo logDirInfo = (DescribeLogDirsResponse.LogDirInfo)x0$3._2();
                return (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos).asScala();
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$7(topic$1, x0$4)));
        Assert.assertEquals((Object)expectedPartitions.toSet(), (Object)((TraversableOnce)replicaInfos.keys().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.partition()), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
        logDirInfos.forEach((logDir, logDirInfo) -> ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos).asScala()).keys().foreach((Function1 & Serializable & scala.Serializable)tp -> {
            PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$10(server, logDir, tp);
            return BoxedUnit.UNIT;
        }));
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeReplicaLogDirs$3(TopicPartitionReplica topicPartitionReplica$1, KafkaServer x$5) {
        return x$5.config().brokerId() == topicPartitionReplica$1.brokerId();
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$4(KafkaFuture future) {
        Assert.assertTrue((boolean)(((ExecutionException)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)future.get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236))).getCause() instanceof UnknownTopicOrPartitionException));
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$6(TopicPartition tp$1, scala.collection.immutable.Map firstReplicaAssignment$1, String topic$3, KafkaServer server) {
        LogManager qual$1 = server.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        String logDir = ((Log)qual$1.getLog(tp$1, x$2).get()).dir().getParent();
        Assert.assertEquals((Object)firstReplicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server.config().brokerId())), (Object)logDir);
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirs$8(KafkaServer server$2, TopicPartition tp$1, scala.collection.immutable.Map secondReplicaAssignment$1, String topic$3) {
        LogManager qual$2 = server$2.logManager();
        boolean x$4 = qual$2.getLog$default$2();
        String logDir = ((Log)qual$2.getLog(tp$1, x$4).get()).dir().getParent();
        Object object = secondReplicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server$2.config().brokerId()));
        return !(object != null ? !object.equals(logDir) : logDir != null);
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirs$9() {
        return "timed out waiting for replica movement";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$7(TopicPartition tp$1, scala.collection.immutable.Map secondReplicaAssignment$1, String topic$3, KafkaServer server) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$8(server, tp$1, secondReplicaAssignment$1, topic$3)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$9(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirs$11(AtomicInteger numMessages$1) {
        return numMessages$1.get() > 10;
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirs$12(AtomicInteger numMessages$1, scala.concurrent.Future producerFuture$1) {
        return new StringBuilder(60).append("only ").append(numMessages$1).append(" messages are produced before timeout. Producer future ").append(producerFuture$1.value()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirs$14(KafkaServer server$3, TopicPartition tp$1, scala.collection.immutable.Map firstReplicaAssignment$1, String topic$3) {
        LogManager qual$3 = server$3.logManager();
        boolean x$22 = qual$3.getLog$default$2();
        String logDir = ((Log)qual$3.getLog(tp$1, x$22).get()).dir().getParent();
        Object object = firstReplicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server$3.config().brokerId()));
        return !(object != null ? !object.equals(logDir) : logDir != null);
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirs$15(scala.concurrent.Future producerFuture$1) {
        return new StringBuilder(56).append("timed out waiting for replica movement. Producer future ").append(producerFuture$1.value()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$13(TopicPartition tp$1, scala.collection.immutable.Map firstReplicaAssignment$1, String topic$3, scala.concurrent.Future producerFuture$1, KafkaServer server) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$14(server, tp$1, firstReplicaAssignment$1, topic$3)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$15(producerFuture$1), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirs$16(AtomicInteger numMessages$1, int currentMessagesNum$1) {
        return numMessages$1.get() - currentMessagesNum$1 > 10;
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirs$17(AtomicInteger numMessages$1, int currentMessagesNum$1, scala.concurrent.Future producerFuture$1) {
        return new StringBuilder(83).append("only ").append(numMessages$1.get() - currentMessagesNum$1).append(" messages are produced within timeout after replica movement. Producer future ").append(producerFuture$1.value()).toString();
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$18(Tuple2 x0$1) {
        if (x0$1 != null) {
            ConsumerRecord consumerRecord = (ConsumerRecord)x0$1._1();
            int index = x0$1._2$mcI$sp();
            Assert.assertEquals((Object)new StringBuilder(21).append("xxxxxxxxxxxxxxxxxxxx-").append(index).toString(), (Object)new String((byte[])consumerRecord.value()));
            return;
        }
        throw new MatchError(null);
    }

    private final java.util.List partitions$1(String topic, Option expectedNumPartitionsOpt) {
        Admin x$1 = this.client();
        DescribeTopicsOptions x$4 = this.getTopicMetadata$default$3();
        return this.getTopicMetadata(x$1, topic, x$4, (Option<Object>)expectedNumPartitionsOpt).partitions();
    }

    private final int numPartitions$1(String topic, Option expectedNumPartitionsOpt) {
        return this.partitions$1(topic, expectedNumPartitionsOpt).size();
    }

    private static final Option numPartitions$default$2$1() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$testCreatePartitions$1(PlaintextAdminIntegrationTest $this, String topic1$1) {
        return $this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()) == 3;
    }

    public static final /* synthetic */ String $anonfun$testCreatePartitions$2() {
        return "Timed out waiting for new partitions to appear";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testCreatePartitions$5(PlaintextAdminIntegrationTest $this, ObjectRef alterResult$1, String topic1$1, String topic2$1, java.util.List newPartition2Assignments$1, ObjectRef altered$1, CreatePartitionsOptions option) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_$this7;
        void $minus$greater$extension_y8;
        void $minus$greater$extension_$this8;
        void $minus$greater$extension_y9;
        void $minus$greater$extension_$this9;
        void $minus$greater$extension_y10;
        void $minus$greater$extension_$this10;
        void $minus$greater$extension_y11;
        void $minus$greater$extension_$this11;
        void $minus$greater$extension_y12;
        void $minus$greater$extension_$this12;
        void $minus$greater$extension_y13;
        void $minus$greater$extension_$this13;
        String desc = option.validateOnly() ? "validateOnly" : "validateOnly=false";
        Tuple2[] tuple2Array = new Tuple2[1];
        NewPartitions newPartitions = NewPartitions.increaseTo((int)1);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this13, (Object)$minus$greater$extension_y13);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava(), option);
        try {
            ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(63).append(desc).append(": Expect InvalidPartitionsException when newCount is a decrease").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((String)desc, (Object)"Topic currently has 3 partitions, which is higher than the requested 1.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        Tuple2[] tuple2Array2 = new Tuple2[1];
        NewPartitions newPartitions2 = NewPartitions.increaseTo((int)3);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)topic2$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this12, (Object)$minus$greater$extension_y12);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava(), option);
        try {
            ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get();
            Assert.fail((String)new StringBuilder(58).append(desc).append(": Expect InvalidPartitionsException when requesting a noop").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic2$1, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3))));
        }
        Tuple2[] tuple2Array3 = new Tuple2[1];
        NewPartitions newPartitions3 = NewPartitions.increaseTo((int)3, (java.util.List)newPartition2Assignments$1);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)topic2$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)$minus$greater$extension_y11);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3))).asJava(), option);
        try {
            ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic2$1, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3))));
        }
        Tuple2[] tuple2Array4 = new Tuple2[1];
        NewPartitions newPartitions4 = NewPartitions.increaseTo((int)3, (java.util.List)((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(newPartition2Assignments$1).asScala()).reverse()).toList()).asJava()));
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)topic2$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[0] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)$minus$greater$extension_y10);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array4))).asJava(), option);
        try {
            ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic2$1, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3))));
        }
        String unknownTopic = "an-unknown-topic";
        Tuple2[] tuple2Array5 = new Tuple2[1];
        NewPartitions newPartitions5 = NewPartitions.increaseTo((int)2);
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)unknownTopic);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array5[0] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)$minus$greater$extension_y9);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array5))).asJava(), option);
        try {
            ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(unknownTopic)).get();
            Assert.fail((String)new StringBuilder(58).append(desc).append(": Expect InvalidTopicException when using an unknown topic").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof UnknownTopicOrPartitionException));
            Assert.assertEquals((String)desc, (Object)"The topic 'an-unknown-topic' does not exist.", (Object)e.getCause().getMessage());
        }
        Tuple2[] tuple2Array6 = new Tuple2[1];
        NewPartitions newPartitions6 = NewPartitions.increaseTo((int)-22);
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array6[0] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y8);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array6))).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(60).append(desc).append(": Expect InvalidPartitionsException when newCount is invalid").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((String)desc, (Object)"Topic currently has 3 partitions, which is higher than the requested -22.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        Tuple2[] tuple2Array7 = new Tuple2[1];
        NewPartitions newPartitions7 = NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})}));
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array7[0] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y7);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array7))).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(71).append(desc).append(": Expect InvalidPartitionsException when #brokers != replication factor").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Inconsistent replication factor between partitions, partition 0 has 1 while partitions [3] have replication factors [2], respectively.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        Tuple2[] tuple2Array8 = new Tuple2[1];
        NewPartitions newPartitions8 = NewPartitions.increaseTo((int)6, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)})}));
        Object object8 = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array8[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array8))).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(83).append(desc).append(": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 3 but 1 assignments provided.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        Tuple2[] tuple2Array9 = new Tuple2[1];
        NewPartitions newPartitions9 = NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2)})}));
        Object object9 = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array9[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array9))).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(83).append(desc).append(": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 1 but 2 assignments provided.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        Tuple2[] tuple2Array10 = new Tuple2[1];
        NewPartitions newPartitions10 = NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(1)})}));
        Object object10 = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array10[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array10))).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(81).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments has duplicate brokers").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Duplicate brokers not allowed in replica assignment: 1, 1 for partition id 3.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        Tuple2[] tuple2Array11 = new Tuple2[1];
        NewPartitions newPartitions11 = NewPartitions.increaseTo((int)5, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)})}));
        Object object11 = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array11[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array11))).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(94).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments have differently sized inner lists").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Inconsistent replication factor between partitions, partition 0 has 1 while partitions [4] have replication factors [2], respectively.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        Tuple2[] tuple2Array12 = new Tuple2[1];
        NewPartitions newPartitions12 = NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(12)})}));
        Object object12 = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array12[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array12))).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(86).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments contains an unknown broker").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Unknown broker(s) in replica assignment: 12.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        Tuple2[] tuple2Array13 = new Tuple2[1];
        NewPartitions newPartitions13 = NewPartitions.increaseTo((int)4, Collections.emptyList());
        Object object13 = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array13[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array13))).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(68).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments is empty").toString());
            return;
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 1 but 0 assignments provided.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testCreatePartitions$6(PlaintextAdminIntegrationTest $this, String topic1$1) {
        return $this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()) == 4;
    }

    public static final /* synthetic */ String $anonfun$testCreatePartitions$7() {
        return "Timed out waiting for new partitions to appear";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testLogStartOffsetCheckpoint$2(PlaintextAdminIntegrationTest $this, ObjectRef result$1, ObjectRef lowWatermark$1) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Tuple2[] tuple2Array = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)0L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)$this.topicPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        result$1.elem = $this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava());
        lowWatermark$1.elem = None$.MODULE$;
        KafkaFuture future = (KafkaFuture)((DeleteRecordsResult)result$1.elem).lowWatermarks().get($this.topicPartition());
        try {
            lowWatermark$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)((DeletedRecords)future.get()).lowWatermark()));
            return ((Option)lowWatermark$1.elem).contains((Object)BoxesRunTime.boxToLong((long)5L));
        }
        catch (Throwable throwable) {
            ExecutionException executionException;
            if (throwable instanceof ExecutionException && ((executionException = (ExecutionException)throwable).getCause() instanceof LeaderNotAvailableException || executionException.getCause() instanceof NotLeaderOrFollowerException)) {
                return false;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ String $anonfun$testLogStartOffsetCheckpoint$4() {
        return "no response within the timeout";
    }

    public static final /* synthetic */ String $anonfun$testLogStartOffsetCheckpoint$3(ObjectRef lowWatermark$1) {
        Option getOrElse_this;
        Option option = (Option)lowWatermark$1.elem;
        if (option == null) {
            throw null;
        }
        return new StringBuilder(56).append("Expected low watermark of the partition to be 5 but got ").append((getOrElse_this = option).isEmpty() ? PlaintextAdminIntegrationTest.$anonfun$testLogStartOffsetCheckpoint$4() : getOrElse_this.get()).toString();
    }

    public static final /* synthetic */ void $anonfun$testLogStartOffsetAfterDeleteRecords$1(PlaintextAdminIntegrationTest $this, int i) {
        Assert.assertEquals((long)3L, (long)((Log)((KafkaServer)$this.servers().apply(i)).replicaManager().localLog($this.topicPartition()).get()).logStartOffset());
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$1(PlaintextAdminIntegrationTest $this, int followerIndex$1) {
        Option option = ((KafkaServer)$this.servers().apply(followerIndex$1)).replicaManager().localLog($this.topicPartition());
        None$ none$ = None$.MODULE$;
        return option == null ? none$ != null : !option.equals(none$);
    }

    public static final /* synthetic */ String $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$2() {
        return "Expected follower to create replica for partition";
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$3(PlaintextAdminIntegrationTest $this, int followerIndex$1, long expectedStartOffset$1) {
        return ((Log)((KafkaServer)$this.servers().apply(followerIndex$1)).replicaManager().localLog($this.topicPartition()).get()).logStartOffset() == expectedStartOffset$1;
    }

    public static final /* synthetic */ String $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$4(long expectedStartOffset$1) {
        return new StringBuilder(51).append("Expected follower to discover new log start offset ").append(expectedStartOffset$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$5(PlaintextAdminIntegrationTest $this, int followerIndex$1, long expectedEndOffset$1) {
        return ((Log)((KafkaServer)$this.servers().apply(followerIndex$1)).replicaManager().localLog($this.topicPartition()).get()).logEndOffset() == expectedEndOffset$1;
    }

    public static final /* synthetic */ String $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$6(long expectedEndOffset$1) {
        return new StringBuilder(48).append("Expected follower to catch up to log end offset ").append(expectedEndOffset$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final void waitForFollowerLog$1(long expectedStartOffset, long expectedEndOffset, int followerIndex$1) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$1(this, followerIndex$1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$3(this, followerIndex$1, expectedStartOffset)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$4(expectedStartOffset), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$5(this, followerIndex$1, expectedEndOffset)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$6(expectedEndOffset), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$7(PlaintextAdminIntegrationTest $this, int i) {
        Assert.assertEquals((long)3L, (long)((Log)((KafkaServer)$this.servers().apply(i)).replicaManager().localLog($this.topicPartition()).get()).logStartOffset());
    }

    public static final /* synthetic */ void $anonfun$testAlterLogDirsAfterDeleteRecords$1(PlaintextAdminIntegrationTest $this, int expectedLEO$1, int i) {
        Assert.assertEquals((long)3L, (long)((Log)((KafkaServer)$this.servers().apply(i)).replicaManager().localLog($this.topicPartition()).get()).logStartOffset());
        Assert.assertEquals((long)expectedLEO$1, (long)((Log)((KafkaServer)$this.servers().apply(i)).replicaManager().localLog($this.topicPartition()).get()).logEndOffset());
    }

    public static final /* synthetic */ boolean $anonfun$testAlterLogDirsAfterDeleteRecords$2(PlaintextAdminIntegrationTest $this, String futureLogDir$1) {
        String string = futureLogDir$1;
        LogManager qual$1 = ((KafkaServer)$this.servers().apply(0)).logManager();
        TopicPartition x$1 = $this.topicPartition();
        boolean x$2 = qual$1.getLog$default$2();
        String string2 = ((Log)qual$1.getLog(x$1, x$2).get()).dir().getParent();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$testAlterLogDirsAfterDeleteRecords$3() {
        return "timed out waiting for replica movement";
    }

    public static final /* synthetic */ String $anonfun$subscribeAndWaitForAssignment$2() {
        return "Expected non-empty assignment";
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1(PlaintextAdminIntegrationTest $this, TopicPartition topicPartition$1, KafkaProducer producer$1, int i) {
        ProducerRecord record = new ProducerRecord(topicPartition$1.topic(), Predef$.MODULE$.int2Integer(topicPartition$1.partition()), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes(), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Sending this record: ").append(record).toString());
        return producer$1.send(record);
    }

    private final Properties createProperties$1(String groupInstanceId, String testGroupId$1, String testClientId$1, String EMPTY_GROUP_INSTANCE_ID$1) {
        Properties newConsumerConfig = new Properties(this.consumerConfig());
        newConsumerConfig.setProperty("group.id", testGroupId$1);
        newConsumerConfig.setProperty("client.id", testClientId$1);
        String string = groupInstanceId;
        if (string == null ? EMPTY_GROUP_INSTANCE_ID$1 != null : !string.equals(EMPTY_GROUP_INSTANCE_ID$1)) {
            newConsumerConfig.setProperty("group.instance.id", groupInstanceId);
        }
        return newConsumerConfig;
    }

    private static final Thread createConsumerThread$1(KafkaConsumer consumer, String topic, CountDownLatch latch$1) {
        return new Thread(null, consumer, topic, latch$1){
            private final KafkaConsumer consumer$2;
            private final String topic$4;
            private final CountDownLatch latch$1;

            public void run() {
                this.consumer$2.subscribe(Collections.singleton(this.topic$4));
                try {
                    while (true) {
                        this.consumer$2.poll(java.time.Duration.ofSeconds(5L));
                        if (!this.consumer$2.assignment().isEmpty() && this.latch$1.getCount() > 0L) {
                            this.latch$1.countDown();
                        }
                        this.consumer$2.commitSync();
                    }
                }
                catch (InterruptException interruptException) {
                    return;
                }
            }
            {
                this.consumer$2 = consumer$2;
                this.topic$4 = topic$4;
                this.latch$1 = latch$1;
            }
        };
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$5(String testGroupId$1, ConsumerGroupListing group) {
        String string = group.groupId();
        if (!(string != null ? !string.equals(testGroupId$1) : testGroupId$1 != null)) {
            Object t = group.state().get();
            ConsumerGroupState consumerGroupState = ConsumerGroupState.STABLE;
            if (!(t != null ? !t.equals(consumerGroupState) : consumerGroupState != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$4(PlaintextAdminIntegrationTest $this, String testGroupId$1) {
        return ((Iterable)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)$this.client().listConsumerGroups().all().get()).asScala()).filter((Function1 & Serializable & scala.Serializable)group -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$5(testGroupId$1, group)))).size() == 1;
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroups$6(String testGroupId$1) {
        return new StringBuilder(28).append("Expected to be able to list ").append(testGroupId$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$8(String testGroupId$1, ConsumerGroupListing group) {
        String string = group.groupId();
        if (!(string != null ? !string.equals(testGroupId$1) : testGroupId$1 != null)) {
            Object t = group.state().get();
            ConsumerGroupState consumerGroupState = ConsumerGroupState.STABLE;
            if (!(t != null ? !t.equals(consumerGroupState) : consumerGroupState != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$7(PlaintextAdminIntegrationTest $this, String testGroupId$1) {
        ListConsumerGroupsOptions options = new ListConsumerGroupsOptions().inStates((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.STABLE}))).asJava());
        return ((Iterable)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)$this.client().listConsumerGroups(options).all().get()).asScala()).filter((Function1 & Serializable & scala.Serializable)group -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$8(testGroupId$1, group)))).size() == 1;
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroups$9(String testGroupId$1) {
        return new StringBuilder(44).append("Expected to be able to list ").append(testGroupId$1).append(" in state Stable").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$11(String testGroupId$1, ConsumerGroupListing x$15) {
        String string = x$15.groupId();
        return !(string != null ? !string.equals(testGroupId$1) : testGroupId$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$10(PlaintextAdminIntegrationTest $this, String testGroupId$1) {
        ListConsumerGroupsOptions options = new ListConsumerGroupsOptions().inStates((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.EMPTY}))).asJava());
        return ((Iterable)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)$this.client().listConsumerGroups(options).all().get()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$11(testGroupId$1, x$15)))).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroups$12() {
        return "Expected to find zero groups";
    }

    public static final /* synthetic */ void $anonfun$testConsumerGroups$13(String testClientId$1, MemberDescription member) {
        Assert.assertEquals((Object)testClientId$1, (Object)member.clientId());
    }

    public static final /* synthetic */ void $anonfun$testConsumerGroups$16(scala.collection.immutable.Map topicPartitionsByTopic$1, int testNumPartitions$1, String topic) {
        Iterable topicPartitions = (Iterable)topicPartitionsByTopic$1.getOrElse((Object)topic, (Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty());
        Assert.assertEquals((long)testNumPartitions$1, (long)topicPartitions.size());
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$18(PlaintextAdminIntegrationTest $this, String testGroupId$1, String testTopicName$1) {
        TopicPartition part;
        java.util.Map parts = (java.util.Map)$this.client().listConsumerGroupOffsets(testGroupId$1).partitionsToOffsetAndMetadata().get();
        return parts.containsKey(part = new TopicPartition(testTopicName$1, 0)) && ((OffsetAndMetadata)parts.get(part)).offset() == 1L;
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroups$19() {
        return "Expected the offset for partition 0 to eventually become 1.";
    }

    public static final /* synthetic */ void $anonfun$testConsumerGroups$20(Thread x0$1) {
        x0$1.interrupt();
        x0$1.join();
    }

    public static final /* synthetic */ void $anonfun$testConsumerGroups$21(Tuple2 zipped) {
        Utils.closeQuietly((AutoCloseable)((AutoCloseable)zipped._1()), (String)((String)zipped._2()));
    }

    private final int preferredLeader$1(TopicPartition topicPartition) {
        return ((Node)((TopicPartitionInfo)this.getTopicMetadata(this.client(), topicPartition.topic(), this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4()).partitions().get(topicPartition.partition())).replicas().get(0)).id();
    }

    public static final /* synthetic */ boolean $anonfun$testElectPreferredLeaders$1(PlaintextAdminIntegrationTest $this, TopicPartition partition1$1, int preferred$1, TopicPartition partition2$1) {
        return $this.preferredLeader$1(partition1$1) == preferred$1 && $this.preferredLeader$1(partition2$1) == preferred$1;
    }

    public static final /* synthetic */ String $anonfun$testElectPreferredLeaders$2(PlaintextAdminIntegrationTest $this, int preferred$1, TopicPartition partition1$1, TopicPartition partition2$1) {
        return new StringBuilder(50).append("Expected preferred leader to become ").append(preferred$1).append(", but is ").append($this.preferredLeader$1(partition1$1)).append(" and ").append($this.preferredLeader$1(partition2$1)).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final void changePreferredLeader$1(Seq newAssignment, TopicPartition partition1$1, TopicPartition partition2$1) {
        int preferred = BoxesRunTime.unboxToInt((Object)newAssignment.head());
        int prior1 = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(partition1$1).get());
        int prior2 = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(partition2$1).get());
        scala.collection.immutable.Map m = Predef$.MODULE$.Map().empty();
        if (prior1 != preferred) {
            void $minus$greater$extension_$this;
            Object object = Predef$.MODULE$.ArrowAssoc((Object)partition1$1);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            m = m.$plus(new Tuple2((Object)$minus$greater$extension_$this, (Object)newAssignment));
        }
        if (prior2 != preferred) {
            void $minus$greater$extension_$this;
            Object object = Predef$.MODULE$.ArrowAssoc((Object)partition2$1);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            m = m.$plus(new Tuple2((Object)$minus$greater$extension_$this, (Object)newAssignment));
        }
        this.zkClient().createPartitionReassignment((Map)m);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 10000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testElectPreferredLeaders$1(this, partition1$1, preferred, partition2$1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testElectPreferredLeaders$2(this, preferred, partition1$1, partition2$1), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        TestUtils$.MODULE$.assertLeader(this.client(), partition1$1, prior1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2$1, prior2);
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$1(PlaintextAdminIntegrationTest $this, ConfigResource broker0Resource$1) {
        scala.collection.immutable.Map broker0Configs = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)((java.util.Map)$this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)broker0Resource$1, (List)Nil$.MODULE$)).asJava()).all().get()).get(broker0Resource$1)).entries()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> new Tuple2((Object)x0$1.name(), (Object)x0$1.value()), scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return "123".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Function0 & Serializable & scala.Serializable)() -> "")) && "456".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Function0 & Serializable & scala.Serializable)() -> ""));
    }

    public static final /* synthetic */ String $anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$5() {
        return "Expected to see the broker properties we just set";
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$6(PlaintextAdminIntegrationTest $this, ConfigResource broker0Resource$1) {
        scala.collection.immutable.Map broker0Configs = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)((java.util.Map)$this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)broker0Resource$1, (List)Nil$.MODULE$)).asJava()).all().get()).get(broker0Resource$1)).entries()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> new Tuple2((Object)x0$2.name(), (Object)x0$2.value()), scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return "".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Function0 & Serializable & scala.Serializable)() -> "")) && "654".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Function0 & Serializable & scala.Serializable)() -> "")) && "987".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), (Function0 & Serializable & scala.Serializable)() -> ""));
    }

    public static final /* synthetic */ String $anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$11() {
        return "Expected to see the broker properties we just modified";
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$1(PlaintextAdminIntegrationTest $this, ConfigResource broker0Resource$2) {
        scala.collection.immutable.Map broker0Configs = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)((java.util.Map)$this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)broker0Resource$2, (List)Nil$.MODULE$)).asJava()).all().get()).get(broker0Resource$2)).entries()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> new Tuple2((Object)x0$1.name(), (Object)x0$1.value()), scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return "123".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Function0 & Serializable & scala.Serializable)() -> "")) && "456".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Function0 & Serializable & scala.Serializable)() -> "")) && "789".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), (Function0 & Serializable & scala.Serializable)() -> ""));
    }

    public static final /* synthetic */ String $anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$6() {
        return "Expected to see the broker properties we just set";
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$7(PlaintextAdminIntegrationTest $this, ConfigResource broker0Resource$2) {
        scala.collection.immutable.Map broker0Configs = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)((java.util.Map)$this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)broker0Resource$2, (List)Nil$.MODULE$)).asJava()).all().get()).get(broker0Resource$2)).entries()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> new Tuple2((Object)x0$2.name(), (Object)x0$2.value()), scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return "".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Function0 & Serializable & scala.Serializable)() -> "")) && "".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Function0 & Serializable & scala.Serializable)() -> "")) && "".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), (Function0 & Serializable & scala.Serializable)() -> ""));
    }

    public static final /* synthetic */ String $anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$12() {
        return "Expected to see the broker properties we just removed to be deleted";
    }

    public static final /* synthetic */ Integer $anonfun$testInvalidAlterPartitionReassignments$1(int x$18) {
        return BoxesRunTime.boxToInteger((int)x$18);
    }

    public static final /* synthetic */ Integer $anonfun$testInvalidAlterPartitionReassignments$2(int x$19) {
        return BoxesRunTime.boxToInteger((int)x$19);
    }

    public static final /* synthetic */ Integer $anonfun$testInvalidAlterPartitionReassignments$3(int x$20) {
        return BoxesRunTime.boxToInteger((int)x$20);
    }

    public static final /* synthetic */ Integer $anonfun$testInvalidAlterPartitionReassignments$4(int x$21) {
        return BoxesRunTime.boxToInteger((int)x$21);
    }

    private final void validateLogConfig$1(String compressionType) {
        LogConfig logConfig = (LogConfig)((MapLike)this.zkClient().getLogConfigs((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), Collections.emptyMap())._1()).apply((Object)this.topic());
        Assert.assertEquals((Object)compressionType, logConfig.originals().get(LogConfig$.MODULE$.CompressionTypeProp()));
        Assert.assertNull(logConfig.originals().get(LogConfig$.MODULE$.MessageFormatVersionProp()));
        Assert.assertEquals((Object)ApiVersion$.MODULE$.latestVersion(), (Object)logConfig.messageFormatVersion());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Void $anonfun$testNullConfigs$2(PlaintextAdminIntegrationTest $this, ConfigResource topicResource$1, Seq alterOps$1) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Tuple2[] tuple2Array = new Tuple2[1];
        Collection collection = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)alterOps$1).asJavaCollection();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topicResource$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        return (Void)$this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).all().get();
    }

    private final void assertLogLevelDidNotChange$1(ConfigEntry expectedValidLoggerLogLevel$1, String validLoggerName$1) {
        Assert.assertEquals((Object)expectedValidLoggerLogLevel$1, (Object)this.describeBrokerLoggers().get(validLoggerName$1));
    }

    public static final /* synthetic */ boolean $anonfun$alterBrokerLoggers$1(PlaintextAdminIntegrationTest $this, AlterConfigOp entry) {
        return $this.changedBrokerLoggers().add((Object)entry.configEntry().name());
    }

    public static final /* synthetic */ boolean $anonfun$teardownBrokerLoggers$1(ConfigEntry x$22) {
        return x$22.name().equals(Log4jController$.MODULE$.ROOT_LOGGER());
    }

    public PlaintextAdminIntegrationTest() {
        this.topic = "topic";
        this.partition = 0;
    }
}

