/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.tools.ReplicaVerificationTool;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReplicaVerificationToolTest {
    @Test
    void testReplicaBufferVerifyChecksum() {
        StringBuilder sb = new StringBuilder();
        HashMap<TopicPartition, Integer> expectedReplicasPerTopicAndPartition = new HashMap<TopicPartition, Integer>(){
            {
                this.put(new TopicPartition("a", 0), 3);
                this.put(new TopicPartition("a", 1), 3);
                this.put(new TopicPartition("b", 0), 2);
            }
        };
        ReplicaVerificationTool.ReplicaBuffer replicaBuffer = new ReplicaVerificationTool.ReplicaBuffer((Map)expectedReplicasPerTopicAndPartition, Collections.emptyMap(), 2, 0L);
        expectedReplicasPerTopicAndPartition.forEach((tp, numReplicas) -> IntStream.range(0, numReplicas).forEach(replicaId -> {
            SimpleRecord[] records = (SimpleRecord[])IntStream.rangeClosed(0, 5).mapToObj(index -> new SimpleRecord(("key " + index).getBytes(), ("value " + index).getBytes())).toArray(SimpleRecord[]::new);
            long initialOffset = 4L;
            MemoryRecords memoryRecords = MemoryRecords.withRecords((long)initialOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])records);
            FetchResponseData.PartitionData partitionData = new FetchResponseData.PartitionData().setPartitionIndex(tp.partition()).setHighWatermark(20L).setLastStableOffset(20L).setLogStartOffset(0L).setRecords((BaseRecords)memoryRecords);
            replicaBuffer.addFetchedData(tp, replicaId, partitionData);
        }));
        replicaBuffer.verifyCheckSum(line -> sb.append(String.format("%s%n", line)));
        String output = sb.toString().trim();
        Assertions.assertTrue((boolean)output.endsWith(": max lag is 10 for partition a-1 at offset 10 among 3 partitions"), (String)String.format("Max lag information should be in output: %s", output));
    }
}

