/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.tools.EndToEndLatency;
import org.apache.kafka.tools.TerseException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class EndToEndLatencyTest {
    @Mock
    KafkaConsumer<byte[], byte[]> consumer;
    @Mock
    ConsumerRecords<byte[], byte[]> records;

    @Test
    public void shouldFailWhenSuppliedUnexpectedArgs() {
        String[] args = new String[]{"localhost:9092", "test", "10000", "1", "200", "propsfile.properties", "random"};
        Assertions.assertThrows(TerseException.class, () -> EndToEndLatency.execute((String[])args));
    }

    @Test
    public void shouldFailWhenProducerAcksAreNotSynchronised() {
        String[] args = new String[]{"localhost:9092", "test", "10000", "0", "200"};
        Assertions.assertThrows(IllegalArgumentException.class, () -> EndToEndLatency.execute((String[])args));
    }

    @Test
    public void shouldFailWhenConsumerRecordsIsEmpty() {
        Mockito.when((Object)this.records.isEmpty()).thenReturn((Object)true);
        Assertions.assertThrows(RuntimeException.class, () -> EndToEndLatency.validate(this.consumer, (byte[])new byte[0], this.records));
    }

    @Test
    public void shouldFailWhenSentIsNotEqualToReceived() {
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        ConsumerRecord record = (ConsumerRecord)Mockito.mock(ConsumerRecord.class);
        Mockito.when((Object)this.records.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.records.iterator()).thenReturn((Object)iterator);
        Mockito.when((Object)((ConsumerRecord)iterator.next())).thenReturn((Object)record);
        Mockito.when((Object)((byte[])record.value())).thenReturn((Object)"kafkab".getBytes(StandardCharsets.UTF_8));
        Assertions.assertThrows(RuntimeException.class, () -> EndToEndLatency.validate(this.consumer, (byte[])"kafkaa".getBytes(StandardCharsets.UTF_8), this.records));
    }

    @Test
    public void shouldFailWhenReceivedMoreThanOneRecord() {
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        ConsumerRecord record = (ConsumerRecord)Mockito.mock(ConsumerRecord.class);
        Mockito.when((Object)this.records.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.records.iterator()).thenReturn((Object)iterator);
        Mockito.when((Object)((ConsumerRecord)iterator.next())).thenReturn((Object)record);
        Mockito.when((Object)((byte[])record.value())).thenReturn((Object)"kafkaa".getBytes(StandardCharsets.UTF_8));
        Mockito.when((Object)this.records.count()).thenReturn((Object)2);
        Assertions.assertThrows(RuntimeException.class, () -> EndToEndLatency.validate(this.consumer, (byte[])"kafkaa".getBytes(StandardCharsets.UTF_8), this.records));
    }

    @Test
    public void shouldPassInValidation() {
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        ConsumerRecord record = (ConsumerRecord)Mockito.mock(ConsumerRecord.class);
        Mockito.when((Object)this.records.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.records.iterator()).thenReturn((Object)iterator);
        Mockito.when((Object)((ConsumerRecord)iterator.next())).thenReturn((Object)record);
        Mockito.when((Object)((byte[])record.value())).thenReturn((Object)"kafkaa".getBytes(StandardCharsets.UTF_8));
        Mockito.when((Object)this.records.count()).thenReturn((Object)1);
        Assertions.assertDoesNotThrow(() -> EndToEndLatency.validate(this.consumer, (byte[])"kafkaa".getBytes(StandardCharsets.UTF_8), this.records));
    }
}

