/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.query.FailureReason;
import org.apache.kafka.streams.query.KeyQuery;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryConfig;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.query.RangeQuery;
import org.apache.kafka.streams.query.WindowKeyQuery;
import org.apache.kafka.streams.query.WindowRangeQuery;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.OffsetCheckpoint;
import org.apache.kafka.streams.state.internals.ValueAndTimestampDeserializer;
import org.apache.kafka.streams.state.internals.ValueAndTimestampSerde;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public final class StoreQueryUtils {
    private static final Map<Class, QueryHandler> QUERY_HANDLER_MAP = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry(RangeQuery.class, StoreQueryUtils::runRangeQuery), Utils.mkEntry(KeyQuery.class, StoreQueryUtils::runKeyQuery), Utils.mkEntry(WindowKeyQuery.class, StoreQueryUtils::runWindowKeyQuery), Utils.mkEntry(WindowRangeQuery.class, StoreQueryUtils::runWindowRangeQuery)});

    private StoreQueryUtils() {
    }

    public static <R> QueryResult<R> handleBasicQueries(Query<R> query, PositionBound positionBound, QueryConfig config, StateStore store, Position position, StateStoreContext context) {
        long start = config.isCollectExecutionInfo() ? System.nanoTime() : -1L;
        QueryHandler handler = QUERY_HANDLER_MAP.get(query.getClass());
        QueryResult<Object> result = handler == null ? QueryResult.forUnknownQueryType(query, store) : (context == null || !StoreQueryUtils.isPermitted(position, positionBound, context.taskId().partition()) ? QueryResult.notUpToBound(position, positionBound, context == null ? null : Integer.valueOf(context.taskId().partition())) : handler.apply(query, positionBound, config, store));
        if (config.isCollectExecutionInfo()) {
            result.addExecutionInfo("Handled in " + store.getClass() + " in " + (System.nanoTime() - start) + "ns");
        }
        result.setPosition(position);
        return result;
    }

    public static void updatePosition(Position position, StateStoreContext stateStoreContext) {
        RecordMetadata meta;
        if (stateStoreContext != null && stateStoreContext.recordMetadata().isPresent() && (meta = stateStoreContext.recordMetadata().get()).topic() != null) {
            position.withComponent(meta.topic(), meta.partition(), meta.offset());
        }
    }

    public static boolean isPermitted(Position position, PositionBound positionBound, int partition) {
        Position bound = positionBound.position();
        for (String topic : bound.getTopics()) {
            Map<Integer, Long> partitionBounds = bound.getPartitionPositions(topic);
            Map<Integer, Long> seenPartitionPositions = position.getPartitionPositions(topic);
            if (!partitionBounds.containsKey(partition)) continue;
            if (!seenPartitionPositions.containsKey(partition)) {
                return false;
            }
            if (seenPartitionPositions.get(partition) >= partitionBounds.get(partition)) continue;
            return false;
        }
        return true;
    }

    private static <R> QueryResult<R> runRangeQuery(Query<R> query, PositionBound positionBound, QueryConfig config, StateStore store) {
        if (!(store instanceof KeyValueStore)) {
            return QueryResult.forUnknownQueryType(query, store);
        }
        KeyValueStore kvStore = (KeyValueStore)store;
        RangeQuery rangeQuery = (RangeQuery)query;
        Optional lowerRange = rangeQuery.getLowerBound();
        Optional upperRange = rangeQuery.getUpperBound();
        try {
            KeyValueIterator iterator = !lowerRange.isPresent() && !upperRange.isPresent() ? kvStore.all() : kvStore.range(lowerRange.orElse(null), upperRange.orElse(null));
            KeyValueIterator result = iterator;
            return QueryResult.forResult(result);
        }
        catch (Exception e) {
            String message = StoreQueryUtils.parseStoreException(e, store, query);
            return QueryResult.forFailure(FailureReason.STORE_EXCEPTION, message);
        }
    }

    private static <R> QueryResult<R> runKeyQuery(Query<R> query, PositionBound positionBound, QueryConfig config, StateStore store) {
        if (store instanceof KeyValueStore) {
            KeyQuery rawKeyQuery = (KeyQuery)query;
            KeyValueStore keyValueStore = (KeyValueStore)store;
            try {
                byte[] bytes = (byte[])keyValueStore.get((Bytes)rawKeyQuery.getKey());
                return QueryResult.forResult(bytes);
            }
            catch (Exception e) {
                String message = StoreQueryUtils.parseStoreException(e, store, query);
                return QueryResult.forFailure(FailureReason.STORE_EXCEPTION, message);
            }
        }
        return QueryResult.forUnknownQueryType(query, store);
    }

    private static <R> QueryResult<R> runWindowKeyQuery(Query<R> query, PositionBound positionBound, QueryConfig config, StateStore store) {
        if (store instanceof WindowStore) {
            WindowKeyQuery windowKeyQuery = (WindowKeyQuery)query;
            WindowStore windowStore = (WindowStore)store;
            try {
                if (windowKeyQuery.getTimeFrom().isPresent() && windowKeyQuery.getTimeTo().isPresent()) {
                    WindowStoreIterator iterator = windowStore.fetch((Bytes)windowKeyQuery.getKey(), windowKeyQuery.getTimeFrom().get(), windowKeyQuery.getTimeTo().get());
                    return QueryResult.forResult(iterator);
                }
                return QueryResult.forFailure(FailureReason.UNKNOWN_QUERY_TYPE, "This store (" + store.getClass() + ") doesn't know how to execute the given query (" + query + ") because it only supports closed-range queries. Contact the store maintainer if you need support for a new query type.");
            }
            catch (Exception e) {
                String message = StoreQueryUtils.parseStoreException(e, store, query);
                return QueryResult.forFailure(FailureReason.STORE_EXCEPTION, message);
            }
        }
        return QueryResult.forUnknownQueryType(query, store);
    }

    private static <R> QueryResult<R> runWindowRangeQuery(Query<R> query, PositionBound positionBound, QueryConfig config, StateStore store) {
        if (store instanceof WindowStore) {
            WindowRangeQuery windowRangeQuery = (WindowRangeQuery)query;
            WindowStore windowStore = (WindowStore)store;
            try {
                if (windowRangeQuery.getTimeFrom().isPresent() && windowRangeQuery.getTimeTo().isPresent()) {
                    KeyValueIterator iterator = windowStore.fetchAll(windowRangeQuery.getTimeFrom().get(), windowRangeQuery.getTimeTo().get());
                    return QueryResult.forResult(iterator);
                }
                return QueryResult.forFailure(FailureReason.UNKNOWN_QUERY_TYPE, "This store (" + store.getClass() + ") doesn't know how to execute the given query (" + query + ") because WindowStores only supports WindowRangeQuery.withWindowStartRange. Contact the store maintainer if you need support for a new query type.");
            }
            catch (Exception e) {
                String message = StoreQueryUtils.parseStoreException(e, store, query);
                return QueryResult.forFailure(FailureReason.STORE_EXCEPTION, message);
            }
        }
        if (store instanceof SessionStore) {
            WindowRangeQuery windowRangeQuery = (WindowRangeQuery)query;
            SessionStore sessionStore = (SessionStore)store;
            try {
                if (windowRangeQuery.getKey().isPresent()) {
                    KeyValueIterator iterator = sessionStore.fetch((Bytes)windowRangeQuery.getKey().get());
                    return QueryResult.forResult(iterator);
                }
                return QueryResult.forFailure(FailureReason.UNKNOWN_QUERY_TYPE, "This store (" + store.getClass() + ") doesn't know how to execute the given query (" + query + ") because SessionStores only support WindowRangeQuery.withKey. Contact the store maintainer if you need support for a new query type.");
            }
            catch (Exception e) {
                String message = StoreQueryUtils.parseStoreException(e, store, query);
                return QueryResult.forFailure(FailureReason.STORE_EXCEPTION, message);
            }
        }
        return QueryResult.forUnknownQueryType(query, store);
    }

    public static <V> Function<byte[], V> getDeserializeValue(StateSerdes<?, V> serdes, StateStore wrapped) {
        Deserializer deserializer;
        Serde<V> valueSerde = serdes.valueSerde();
        boolean timestamped = WrappedStateStore.isTimestamped(wrapped);
        if (!timestamped && valueSerde instanceof ValueAndTimestampSerde) {
            ValueAndTimestampDeserializer valueAndTimestampDeserializer = (ValueAndTimestampDeserializer)((ValueAndTimestampSerde)valueSerde).deserializer();
            deserializer = valueAndTimestampDeserializer.valueDeserializer;
        } else {
            deserializer = valueSerde.deserializer();
        }
        return arg_0 -> StoreQueryUtils.lambda$getDeserializeValue$0((Deserializer)deserializer, serdes, arg_0);
    }

    public static void checkpointPosition(OffsetCheckpoint checkpointFile, Position position) {
        try {
            checkpointFile.write(StoreQueryUtils.positionToTopicPartitionMap(position));
        }
        catch (IOException e) {
            throw new ProcessorStateException("Error writing checkpoint file", e);
        }
    }

    public static Position readPositionFromCheckpoint(OffsetCheckpoint checkpointFile) {
        try {
            return StoreQueryUtils.topicPartitionMapToPosition(checkpointFile.read());
        }
        catch (IOException e) {
            throw new ProcessorStateException("Error reading checkpoint file", e);
        }
    }

    private static Map<TopicPartition, Long> positionToTopicPartitionMap(Position position) {
        HashMap<TopicPartition, Long> topicPartitions = new HashMap<TopicPartition, Long>();
        Set<String> topics = position.getTopics();
        for (String t : topics) {
            Map<Integer, Long> partitions = position.getPartitionPositions(t);
            for (Map.Entry<Integer, Long> e : partitions.entrySet()) {
                TopicPartition tp = new TopicPartition(t, e.getKey().intValue());
                topicPartitions.put(tp, e.getValue());
            }
        }
        return topicPartitions;
    }

    private static Position topicPartitionMapToPosition(Map<TopicPartition, Long> topicPartitions) {
        HashMap<String, Map> pos = new HashMap<String, Map>();
        for (Map.Entry<TopicPartition, Long> e : topicPartitions.entrySet()) {
            pos.computeIfAbsent(e.getKey().topic(), t -> new HashMap()).put(e.getKey().partition(), e.getValue());
        }
        return Position.fromMap(pos);
    }

    private static <R> String parseStoreException(Exception e, StateStore store, Query<R> query) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(store.getClass() + " failed to handle query " + query + ":");
        e.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }

    private static /* synthetic */ Object lambda$getDeserializeValue$0(Deserializer deserializer, StateSerdes serdes, byte[] byteArray) {
        return deserializer.deserialize(serdes.topic(), byteArray);
    }

    @FunctionalInterface
    public static interface QueryHandler {
        public QueryResult<?> apply(Query<?> var1, PositionBound var2, QueryConfig var3, StateStore var4);
    }
}

