/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.function.Function;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.state.WindowStoreIterator;

class MeteredWindowStoreIterator<V>
implements WindowStoreIterator<V> {
    private final WindowStoreIterator<byte[]> iter;
    private final Sensor sensor;
    private final StreamsMetrics metrics;
    private final Function<byte[], V> valueFrom;
    private final long startNs;
    private final Time time;

    MeteredWindowStoreIterator(WindowStoreIterator<byte[]> iter, Sensor sensor, StreamsMetrics metrics, Function<byte[], V> valueFrom, Time time) {
        this.iter = iter;
        this.sensor = sensor;
        this.metrics = metrics;
        this.valueFrom = valueFrom;
        this.startNs = time.nanoseconds();
        this.time = time;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public KeyValue<Long, V> next() {
        KeyValue next = (KeyValue)this.iter.next();
        return KeyValue.pair((Long)next.key, this.valueFrom.apply((byte[])next.value));
    }

    @Override
    public void close() {
        try {
            this.iter.close();
        }
        finally {
            this.sensor.record((double)(this.time.nanoseconds() - this.startNs));
        }
    }

    @Override
    public Long peekNextKey() {
        return (Long)this.iter.peekNextKey();
    }
}

