/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.mapr;

import com.mapr.fs.MapRFileAce;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.mapr.tools.KafkaMaprStreams;
import org.apache.kafka.mapr.tools.KafkaMaprTools;
import org.apache.kafka.mapr.tools.KafkaMaprfs;
import org.apache.kafka.mapr.tools.MaprfsPermissions;
import org.apache.kafka.streams.StreamsConfig;

public class InternalStorageManager {
    public static Storage storage(String applicationId) {
        return new Storage(applicationId);
    }

    public static void create(StreamsConfig config) {
        Storage storage = InternalStorageManager.storage(config.getString("application.id"));
        InternalStorageManager.createAppDir(storage, config);
        InternalStorageManager.createInternalStreams(storage);
    }

    public static void delete(String applicationId) {
        Storage storage = InternalStorageManager.storage(applicationId);
        InternalStorageManager.deleteAppDir(storage);
        InternalStorageManager.deleteInternalStreams(storage);
    }

    private static void createAppDir(Storage storage, StreamsConfig config) {
        try (KafkaMaprfs maprfs = KafkaMaprTools.tools().maprfs();){
            maprfs.requireParentExisting(storage.appDir);
            if (!maprfs.exists(storage.appDir)) {
                maprfs.mkdirs(storage.appDir);
                maprfs.setPermissions(storage.appDir, MaprfsPermissions.permissions().put(MapRFileAce.AccessType.READDIR, "p").put(MapRFileAce.AccessType.LOOKUPDIR, "p").put(MapRFileAce.AccessType.ADDCHILD, "<startup.user>").put(MapRFileAce.AccessType.DELETECHILD, "<startup.user>").put(MapRFileAce.AccessType.WRITEFILE, "<startup.user>").loadFromConfig(config.getString("streams.appdir.aces")));
            }
            if (!maprfs.isAccessibleAsDirectory(storage.appDir)) {
                String user = KafkaMaprTools.tools().getCurrentUserName();
                String applicationId = config.getString("application.id");
                throw new KafkaException(String.format("User '%s' has no permissions to run KStreams application with ID '%s'", user, applicationId));
            }
        }
    }

    private static void createInternalStreams(Storage storage) {
        try (KafkaMaprStreams maprStreams = KafkaMaprTools.tools().streams();){
            if (!maprStreams.streamExists(storage.internalStream)) {
                maprStreams.createStreamForClusterAdmin(storage.internalStream);
            }
            if (!maprStreams.streamExists(storage.internalStreamCompacted)) {
                maprStreams.createStreamForCurrentUser(storage.internalStreamCompacted);
            }
            maprStreams.ensureStreamLogCompactionIsEnabled(storage.internalStreamCompacted);
        }
    }

    private static void deleteAppDir(Storage storage) {
        try (KafkaMaprfs fs = KafkaMaprTools.tools().maprfs();){
            if (fs.exists(storage.appDir)) {
                fs.deleteRecursive(storage.appDir);
            }
        }
    }

    private static void deleteInternalStreams(Storage storage) {
        try (KafkaMaprStreams maprStreams = KafkaMaprTools.tools().streams();){
            if (maprStreams.streamExists(storage.internalStream)) {
                maprStreams.deleteStream(storage.internalStream);
            }
            if (maprStreams.streamExists(storage.internalStreamCompacted)) {
                maprStreams.deleteStream(storage.internalStreamCompacted);
            }
        }
    }

    public static class Storage {
        public final String appDir;
        public final String internalStream;
        public final String internalStreamCompacted;

        public Storage(String applicationId) {
            this.appDir = "/apps/kafka-streams/" + applicationId + "/";
            this.internalStream = this.appDir + "kafka-internal-stream";
            this.internalStreamCompacted = this.internalStream + "-compacted";
        }
    }
}

