/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.internals.RocksDBRangeIterator;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.rocksdb.RocksIterator;

public class RocksDBRangeIteratorTest {
    private final String storeName = "store";
    private final String key1 = "a";
    private final String key2 = "b";
    private final String key3 = "c";
    private final String key4 = "d";
    private final String value = "value";
    private final Bytes key1Bytes = Bytes.wrap((byte[])"a".getBytes());
    private final Bytes key2Bytes = Bytes.wrap((byte[])"b".getBytes());
    private final Bytes key3Bytes = Bytes.wrap((byte[])"c".getBytes());
    private final Bytes key4Bytes = Bytes.wrap((byte[])"d".getBytes());
    private final byte[] valueBytes = "value".getBytes();

    @Test
    public void shouldReturnAllKeysInTheRangeInForwardDirection() {
        RocksIterator rocksIterator = (RocksIterator)EasyMock.mock(RocksIterator.class);
        rocksIterator.seek(this.key1Bytes.get());
        EasyMock.expect((Object)rocksIterator.isValid()).andReturn((Object)true).andReturn((Object)true).andReturn((Object)true).andReturn((Object)false);
        EasyMock.expect((Object)rocksIterator.key()).andReturn((Object)this.key1Bytes.get()).andReturn((Object)this.key2Bytes.get()).andReturn((Object)this.key3Bytes.get());
        EasyMock.expect((Object)rocksIterator.value()).andReturn((Object)this.valueBytes).times(3);
        rocksIterator.next();
        EasyMock.expectLastCall().times(3);
        EasyMock.replay((Object[])new Object[]{rocksIterator});
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, this.key1Bytes, this.key3Bytes, true, true);
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((Bytes)((KeyValue)rocksDBRangeIterator.next()).key), (Matcher)Is.is((Object)this.key1Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((Bytes)((KeyValue)rocksDBRangeIterator.next()).key), (Matcher)Is.is((Object)this.key2Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((Bytes)((KeyValue)rocksDBRangeIterator.next()).key), (Matcher)Is.is((Object)this.key3Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)false));
        EasyMock.verify((Object[])new Object[]{rocksIterator});
    }

    @Test
    public void shouldReturnAllKeysInTheRangeReverseDirection() {
        RocksIterator rocksIterator = (RocksIterator)EasyMock.mock(RocksIterator.class);
        rocksIterator.seekForPrev(this.key3Bytes.get());
        EasyMock.expect((Object)rocksIterator.isValid()).andReturn((Object)true).andReturn((Object)true).andReturn((Object)true).andReturn((Object)false);
        EasyMock.expect((Object)rocksIterator.key()).andReturn((Object)this.key3Bytes.get()).andReturn((Object)this.key2Bytes.get()).andReturn((Object)this.key1Bytes.get());
        EasyMock.expect((Object)rocksIterator.value()).andReturn((Object)this.valueBytes).times(3);
        rocksIterator.prev();
        EasyMock.expectLastCall().times(3);
        EasyMock.replay((Object[])new Object[]{rocksIterator});
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, this.key1Bytes, this.key3Bytes, false, true);
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((Bytes)((KeyValue)rocksDBRangeIterator.next()).key), (Matcher)Is.is((Object)this.key3Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((Bytes)((KeyValue)rocksDBRangeIterator.next()).key), (Matcher)Is.is((Object)this.key2Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((Bytes)((KeyValue)rocksDBRangeIterator.next()).key), (Matcher)Is.is((Object)this.key1Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)false));
        EasyMock.verify((Object[])new Object[]{rocksIterator});
    }

    @Test
    public void shouldReturnAllKeysWhenLastKeyIsGreaterThanLargestKeyInStateStoreInForwardDirection() {
        Bytes toBytes = Bytes.increment((Bytes)this.key4Bytes);
        RocksIterator rocksIterator = (RocksIterator)EasyMock.mock(RocksIterator.class);
        rocksIterator.seek(this.key1Bytes.get());
        EasyMock.expect((Object)rocksIterator.isValid()).andReturn((Object)true).andReturn((Object)true).andReturn((Object)true).andReturn((Object)true).andReturn((Object)false);
        EasyMock.expect((Object)rocksIterator.key()).andReturn((Object)this.key1Bytes.get()).andReturn((Object)this.key2Bytes.get()).andReturn((Object)this.key3Bytes.get()).andReturn((Object)this.key4Bytes.get());
        EasyMock.expect((Object)rocksIterator.value()).andReturn((Object)this.valueBytes).times(4);
        rocksIterator.next();
        EasyMock.expectLastCall().times(4);
        EasyMock.replay((Object[])new Object[]{rocksIterator});
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, this.key1Bytes, toBytes, true, true);
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((Bytes)((KeyValue)rocksDBRangeIterator.next()).key), (Matcher)Is.is((Object)this.key1Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((Bytes)((KeyValue)rocksDBRangeIterator.next()).key), (Matcher)Is.is((Object)this.key2Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((Bytes)((KeyValue)rocksDBRangeIterator.next()).key), (Matcher)Is.is((Object)this.key3Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((Bytes)((KeyValue)rocksDBRangeIterator.next()).key), (Matcher)Is.is((Object)this.key4Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)false));
        EasyMock.verify((Object[])new Object[]{rocksIterator});
    }

    @Test
    public void shouldReturnAllKeysWhenLastKeyIsSmallerThanSmallestKeyInStateStoreInReverseDirection() {
        RocksIterator rocksIterator = (RocksIterator)EasyMock.mock(RocksIterator.class);
        rocksIterator.seekForPrev(this.key4Bytes.get());
        EasyMock.expect((Object)rocksIterator.isValid()).andReturn((Object)true).andReturn((Object)true).andReturn((Object)true).andReturn((Object)true).andReturn((Object)false);
        EasyMock.expect((Object)rocksIterator.key()).andReturn((Object)this.key4Bytes.get()).andReturn((Object)this.key3Bytes.get()).andReturn((Object)this.key2Bytes.get()).andReturn((Object)this.key1Bytes.get());
        EasyMock.expect((Object)rocksIterator.value()).andReturn((Object)this.valueBytes).times(4);
        rocksIterator.prev();
        EasyMock.expectLastCall().times(4);
        EasyMock.replay((Object[])new Object[]{rocksIterator});
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, this.key1Bytes, this.key4Bytes, false, true);
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((Bytes)((KeyValue)rocksDBRangeIterator.next()).key), (Matcher)Is.is((Object)this.key4Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((Bytes)((KeyValue)rocksDBRangeIterator.next()).key), (Matcher)Is.is((Object)this.key3Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((Bytes)((KeyValue)rocksDBRangeIterator.next()).key), (Matcher)Is.is((Object)this.key2Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((Bytes)((KeyValue)rocksDBRangeIterator.next()).key), (Matcher)Is.is((Object)this.key1Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)false));
        EasyMock.verify((Object[])new Object[]{rocksIterator});
    }

    @Test
    public void shouldReturnNoKeysWhenLastKeyIsSmallerThanSmallestKeyInStateStoreForwardDirection() {
        RocksIterator rocksIterator = (RocksIterator)EasyMock.mock(RocksIterator.class);
        rocksIterator.seek(this.key1Bytes.get());
        EasyMock.expect((Object)rocksIterator.isValid()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{rocksIterator});
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, this.key1Bytes, this.key2Bytes, true, true);
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)false));
        EasyMock.verify((Object[])new Object[]{rocksIterator});
    }

    @Test
    public void shouldReturnNoKeysWhenLastKeyIsLargerThanLargestKeyInStateStoreReverseDirection() {
        String from = "g";
        String to = "h";
        Bytes fromBytes = Bytes.wrap((byte[])"g".getBytes());
        Bytes toBytes = Bytes.wrap((byte[])"h".getBytes());
        RocksIterator rocksIterator = (RocksIterator)EasyMock.mock(RocksIterator.class);
        rocksIterator.seekForPrev(toBytes.get());
        EasyMock.expect((Object)rocksIterator.isValid()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{rocksIterator});
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, fromBytes, toBytes, false, true);
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)false));
        EasyMock.verify((Object[])new Object[]{rocksIterator});
    }

    @Test
    public void shouldReturnAllKeysInPartiallyOverlappingRangeInForwardDirection() {
        RocksIterator rocksIterator = (RocksIterator)EasyMock.mock(RocksIterator.class);
        rocksIterator.seek(this.key1Bytes.get());
        EasyMock.expect((Object)rocksIterator.isValid()).andReturn((Object)true).andReturn((Object)true).andReturn((Object)false);
        EasyMock.expect((Object)rocksIterator.key()).andReturn((Object)this.key2Bytes.get()).andReturn((Object)this.key3Bytes.get());
        EasyMock.expect((Object)rocksIterator.value()).andReturn((Object)this.valueBytes).times(2);
        rocksIterator.next();
        EasyMock.expectLastCall().times(2);
        EasyMock.replay((Object[])new Object[]{rocksIterator});
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, this.key1Bytes, this.key3Bytes, true, true);
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((Bytes)((KeyValue)rocksDBRangeIterator.next()).key), (Matcher)Is.is((Object)this.key2Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((Bytes)((KeyValue)rocksDBRangeIterator.next()).key), (Matcher)Is.is((Object)this.key3Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)false));
        EasyMock.verify((Object[])new Object[]{rocksIterator});
    }

    @Test
    public void shouldReturnAllKeysInPartiallyOverlappingRangeInReverseDirection() {
        RocksIterator rocksIterator = (RocksIterator)EasyMock.mock(RocksIterator.class);
        String to = "e";
        Bytes toBytes = Bytes.wrap((byte[])"e".getBytes());
        rocksIterator.seekForPrev(toBytes.get());
        EasyMock.expect((Object)rocksIterator.isValid()).andReturn((Object)true).andReturn((Object)true).andReturn((Object)false);
        EasyMock.expect((Object)rocksIterator.key()).andReturn((Object)this.key4Bytes.get()).andReturn((Object)this.key3Bytes.get());
        EasyMock.expect((Object)rocksIterator.value()).andReturn((Object)this.valueBytes).times(2);
        rocksIterator.prev();
        EasyMock.expectLastCall().times(2);
        EasyMock.replay((Object[])new Object[]{rocksIterator});
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, this.key3Bytes, toBytes, false, true);
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((Bytes)((KeyValue)rocksDBRangeIterator.next()).key), (Matcher)Is.is((Object)this.key4Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((Bytes)((KeyValue)rocksDBRangeIterator.next()).key), (Matcher)Is.is((Object)this.key3Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)false));
        EasyMock.verify((Object[])new Object[]{rocksIterator});
    }

    @Test
    public void shouldReturnTheCurrentKeyOnInvokingPeekNextKeyInForwardDirection() {
        RocksIterator rocksIterator = (RocksIterator)EasyMock.mock(RocksIterator.class);
        rocksIterator.seek(this.key1Bytes.get());
        EasyMock.expect((Object)rocksIterator.isValid()).andReturn((Object)true).andReturn((Object)true).andReturn((Object)false);
        EasyMock.expect((Object)rocksIterator.key()).andReturn((Object)this.key2Bytes.get()).andReturn((Object)this.key3Bytes.get());
        EasyMock.expect((Object)rocksIterator.value()).andReturn((Object)this.valueBytes).times(2);
        rocksIterator.next();
        EasyMock.expectLastCall().times(2);
        EasyMock.replay((Object[])new Object[]{rocksIterator});
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, this.key1Bytes, this.key3Bytes, true, true);
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.peekNextKey(), (Matcher)Is.is((Object)this.key2Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.peekNextKey(), (Matcher)Is.is((Object)this.key2Bytes));
        MatcherAssert.assertThat((Object)((Bytes)((KeyValue)rocksDBRangeIterator.next()).key), (Matcher)Is.is((Object)this.key2Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.peekNextKey(), (Matcher)Is.is((Object)this.key3Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.peekNextKey(), (Matcher)Is.is((Object)this.key3Bytes));
        MatcherAssert.assertThat((Object)((Bytes)((KeyValue)rocksDBRangeIterator.next()).key), (Matcher)Is.is((Object)this.key3Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)false));
        Assert.assertThrows(NoSuchElementException.class, () -> ((RocksDBRangeIterator)rocksDBRangeIterator).peekNextKey());
        EasyMock.verify((Object[])new Object[]{rocksIterator});
    }

    @Test
    public void shouldReturnTheCurrentKeyOnInvokingPeekNextKeyInReverseDirection() {
        RocksIterator rocksIterator = (RocksIterator)EasyMock.mock(RocksIterator.class);
        Bytes toBytes = Bytes.increment((Bytes)this.key4Bytes);
        rocksIterator.seekForPrev(toBytes.get());
        EasyMock.expect((Object)rocksIterator.isValid()).andReturn((Object)true).andReturn((Object)true).andReturn((Object)false);
        EasyMock.expect((Object)rocksIterator.key()).andReturn((Object)this.key4Bytes.get()).andReturn((Object)this.key3Bytes.get());
        EasyMock.expect((Object)rocksIterator.value()).andReturn((Object)this.valueBytes).times(2);
        rocksIterator.prev();
        EasyMock.expectLastCall().times(2);
        EasyMock.replay((Object[])new Object[]{rocksIterator});
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, this.key3Bytes, toBytes, false, true);
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.peekNextKey(), (Matcher)Is.is((Object)this.key4Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.peekNextKey(), (Matcher)Is.is((Object)this.key4Bytes));
        MatcherAssert.assertThat((Object)((Bytes)((KeyValue)rocksDBRangeIterator.next()).key), (Matcher)Is.is((Object)this.key4Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.peekNextKey(), (Matcher)Is.is((Object)this.key3Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.peekNextKey(), (Matcher)Is.is((Object)this.key3Bytes));
        MatcherAssert.assertThat((Object)((Bytes)((KeyValue)rocksDBRangeIterator.next()).key), (Matcher)Is.is((Object)this.key3Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)false));
        Assert.assertThrows(NoSuchElementException.class, () -> ((RocksDBRangeIterator)rocksDBRangeIterator).peekNextKey());
        EasyMock.verify((Object[])new Object[]{rocksIterator});
    }

    @Test
    public void shouldCloseIterator() {
        RocksIterator rocksIterator = (RocksIterator)EasyMock.mock(RocksIterator.class);
        rocksIterator.seek(this.key1Bytes.get());
        rocksIterator.close();
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{rocksIterator});
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, this.key1Bytes, this.key2Bytes, true, true);
        rocksDBRangeIterator.onClose(() -> {});
        rocksDBRangeIterator.close();
        EasyMock.verify((Object[])new Object[]{rocksIterator});
    }

    @Test
    public void shouldCallCloseCallbackOnClose() {
        RocksIterator rocksIterator = (RocksIterator)EasyMock.mock(RocksIterator.class);
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, this.key1Bytes, this.key2Bytes, true, true);
        AtomicBoolean callbackCalled = new AtomicBoolean(false);
        rocksDBRangeIterator.onClose(() -> callbackCalled.set(true));
        rocksDBRangeIterator.close();
        MatcherAssert.assertThat((Object)callbackCalled.get(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldExcludeEndOfRange() {
        RocksIterator rocksIterator = (RocksIterator)EasyMock.mock(RocksIterator.class);
        rocksIterator.seek(this.key1Bytes.get());
        EasyMock.expect((Object)rocksIterator.isValid()).andReturn((Object)true).andReturn((Object)true);
        EasyMock.expect((Object)rocksIterator.key()).andReturn((Object)this.key1Bytes.get()).andReturn((Object)this.key2Bytes.get());
        EasyMock.expect((Object)rocksIterator.value()).andReturn((Object)this.valueBytes).times(2);
        rocksIterator.next();
        EasyMock.expectLastCall().times(2);
        EasyMock.replay((Object[])new Object[]{rocksIterator});
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, this.key1Bytes, this.key2Bytes, true, false);
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((Bytes)((KeyValue)rocksDBRangeIterator.next()).key), (Matcher)Is.is((Object)this.key1Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)false));
        EasyMock.verify((Object[])new Object[]{rocksIterator});
    }
}

