/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.KeyValueStoreTestDriver;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.internals.AbstractKeyValueStoreTest;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStore;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InMemoryKeyValueStoreTest
extends AbstractKeyValueStoreTest {
    private KeyValueStore<Bytes, byte[]> byteStore;
    private final Serializer<String> stringSerializer = new StringSerializer();
    private final KeyValueStoreTestDriver<Bytes, byte[]> byteStoreDriver = KeyValueStoreTestDriver.create(Bytes.class, byte[].class);
    private InMemoryKeyValueStore inMemoryKeyValueStore;

    @Before
    public void createStringKeyValueStore() {
        super.before();
        StateStoreContext byteStoreContext = this.byteStoreDriver.context();
        StoreBuilder storeBuilder = Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"in-memory-byte-store"), (Serde)new Serdes.BytesSerde(), (Serde)new Serdes.ByteArraySerde());
        this.byteStore = (KeyValueStore)storeBuilder.build();
        this.byteStore.init(byteStoreContext, this.byteStore);
        this.inMemoryKeyValueStore = this.getInMemoryStore();
    }

    @Override
    @After
    public void after() {
        super.after();
        this.byteStore.close();
        this.byteStoreDriver.clear();
    }

    @Override
    protected <K, V> KeyValueStore<K, V> createKeyValueStore(StateStoreContext context) {
        StoreBuilder storeBuilder = Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"my-store"), (Serde)context.keySerde(), (Serde)context.valueSerde());
        KeyValueStore store = (KeyValueStore)storeBuilder.build();
        store.init(context, (StateStore)store);
        return store;
    }

    InMemoryKeyValueStore getInMemoryStore() {
        return new InMemoryKeyValueStore("in-memory-store-test");
    }

    @Test
    public void shouldRemoveKeysWithNullValues() {
        this.store.close();
        this.driver.addEntryToRestoreLog(0, "zero");
        this.driver.addEntryToRestoreLog(1, "one");
        this.driver.addEntryToRestoreLog(2, "two");
        this.driver.addEntryToRestoreLog(3, "three");
        this.driver.addEntryToRestoreLog(0, null);
        this.store = this.createKeyValueStore(this.driver.context());
        this.context.restore(this.store.name(), this.driver.restoredEntries());
        Assert.assertEquals((long)3L, (long)this.driver.sizeOf(this.store));
        MatcherAssert.assertThat((Object)((String)this.store.get((Object)0)), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldReturnKeysWithGivenPrefix() {
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        entries.add(new KeyValue((Object)new Bytes(this.stringSerializer.serialize(null, (Object)"k1")), (Object)this.stringSerializer.serialize(null, (Object)"a")));
        entries.add(new KeyValue((Object)new Bytes(this.stringSerializer.serialize(null, (Object)"prefix_3")), (Object)this.stringSerializer.serialize(null, (Object)"b")));
        entries.add(new KeyValue((Object)new Bytes(this.stringSerializer.serialize(null, (Object)"k2")), (Object)this.stringSerializer.serialize(null, (Object)"c")));
        entries.add(new KeyValue((Object)new Bytes(this.stringSerializer.serialize(null, (Object)"prefix_2")), (Object)this.stringSerializer.serialize(null, (Object)"d")));
        entries.add(new KeyValue((Object)new Bytes(this.stringSerializer.serialize(null, (Object)"k3")), (Object)this.stringSerializer.serialize(null, (Object)"e")));
        entries.add(new KeyValue((Object)new Bytes(this.stringSerializer.serialize(null, (Object)"prefix_1")), (Object)this.stringSerializer.serialize(null, (Object)"f")));
        this.byteStore.putAll(entries);
        this.byteStore.flush();
        ArrayList<String> valuesWithPrefix = new ArrayList<String>();
        int numberOfKeysReturned = 0;
        try (KeyValueIterator keysWithPrefix = this.byteStore.prefixScan((Object)"prefix", this.stringSerializer);){
            while (keysWithPrefix.hasNext()) {
                KeyValue next = (KeyValue)keysWithPrefix.next();
                valuesWithPrefix.add(new String((byte[])next.value));
                ++numberOfKeysReturned;
            }
        }
        MatcherAssert.assertThat((Object)numberOfKeysReturned, (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)((String)valuesWithPrefix.get(0)), (Matcher)CoreMatchers.is((Object)"f"));
        MatcherAssert.assertThat((Object)((String)valuesWithPrefix.get(1)), (Matcher)CoreMatchers.is((Object)"d"));
        MatcherAssert.assertThat((Object)((String)valuesWithPrefix.get(2)), (Matcher)CoreMatchers.is((Object)"b"));
    }

    @Test
    public void shouldReturnKeysWithGivenPrefixExcludingNextKeyLargestKey() {
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        entries.add(new KeyValue((Object)new Bytes(this.stringSerializer.serialize(null, (Object)"abc")), (Object)this.stringSerializer.serialize(null, (Object)"f")));
        entries.add(new KeyValue((Object)new Bytes(this.stringSerializer.serialize(null, (Object)"abcd")), (Object)this.stringSerializer.serialize(null, (Object)"f")));
        entries.add(new KeyValue((Object)new Bytes(this.stringSerializer.serialize(null, (Object)"abce")), (Object)this.stringSerializer.serialize(null, (Object)"f")));
        this.byteStore.putAll(entries);
        this.byteStore.flush();
        try (KeyValueIterator keysWithPrefixAsabcd = this.byteStore.prefixScan((Object)"abcd", this.stringSerializer);){
            int numberOfKeysReturned = 0;
            while (keysWithPrefixAsabcd.hasNext()) {
                ((Bytes)((KeyValue)keysWithPrefixAsabcd.next()).key).get();
                ++numberOfKeysReturned;
            }
            MatcherAssert.assertThat((Object)numberOfKeysReturned, (Matcher)CoreMatchers.is((Object)1));
        }
    }

    @Test
    public void shouldReturnUUIDsWithStringPrefix() {
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        Serializer uuidSerializer = Serdes.UUID().serializer();
        UUID uuid1 = UUID.randomUUID();
        UUID uuid2 = UUID.randomUUID();
        String prefix = uuid1.toString().substring(0, 4);
        entries.add(new KeyValue((Object)new Bytes(uuidSerializer.serialize(null, (Object)uuid1)), (Object)this.stringSerializer.serialize(null, (Object)"a")));
        entries.add(new KeyValue((Object)new Bytes(uuidSerializer.serialize(null, (Object)uuid2)), (Object)this.stringSerializer.serialize(null, (Object)"b")));
        this.byteStore.putAll(entries);
        this.byteStore.flush();
        ArrayList<String> valuesWithPrefix = new ArrayList<String>();
        int numberOfKeysReturned = 0;
        try (KeyValueIterator keysWithPrefix = this.byteStore.prefixScan((Object)prefix, this.stringSerializer);){
            while (keysWithPrefix.hasNext()) {
                KeyValue next = (KeyValue)keysWithPrefix.next();
                valuesWithPrefix.add(new String((byte[])next.value));
                ++numberOfKeysReturned;
            }
        }
        MatcherAssert.assertThat((Object)numberOfKeysReturned, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((String)valuesWithPrefix.get(0)), (Matcher)CoreMatchers.is((Object)"a"));
    }

    @Test
    public void shouldReturnNoKeys() {
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        entries.add(new KeyValue((Object)new Bytes(this.stringSerializer.serialize(null, (Object)"a")), (Object)this.stringSerializer.serialize(null, (Object)"a")));
        entries.add(new KeyValue((Object)new Bytes(this.stringSerializer.serialize(null, (Object)"b")), (Object)this.stringSerializer.serialize(null, (Object)"c")));
        entries.add(new KeyValue((Object)new Bytes(this.stringSerializer.serialize(null, (Object)"c")), (Object)this.stringSerializer.serialize(null, (Object)"e")));
        this.byteStore.putAll(entries);
        this.byteStore.flush();
        int numberOfKeysReturned = 0;
        try (KeyValueIterator keysWithPrefix = this.byteStore.prefixScan((Object)"bb", this.stringSerializer);){
            while (keysWithPrefix.hasNext()) {
                keysWithPrefix.next();
                ++numberOfKeysReturned;
            }
        }
        MatcherAssert.assertThat((Object)numberOfKeysReturned, (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void shouldThrowNullPointerIfPrefixKeySerializerIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.byteStore.prefixScan((Object)"bb", null));
    }

    @Test
    public void shouldMatchPositionAfterPut() {
        this.inMemoryKeyValueStore.init((StateStoreContext)this.context, (StateStore)this.inMemoryKeyValueStore);
        this.context.setRecordContext(new ProcessorRecordContext(0L, 1L, 0, "", (Headers)new RecordHeaders()));
        this.inMemoryKeyValueStore.put(this.bytesKey("key1"), this.bytesValue("value1"));
        this.context.setRecordContext(new ProcessorRecordContext(0L, 2L, 0, "", (Headers)new RecordHeaders()));
        this.inMemoryKeyValueStore.put(this.bytesKey("key2"), this.bytesValue("value2"));
        this.context.setRecordContext(new ProcessorRecordContext(0L, 3L, 0, "", (Headers)new RecordHeaders()));
        this.inMemoryKeyValueStore.put(this.bytesKey("key3"), this.bytesValue("value3"));
        Position expected = Position.fromMap((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)3L)}))}));
        Position actual = this.inMemoryKeyValueStore.getPosition();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private byte[] bytesValue(String value) {
        return value.getBytes();
    }

    private Bytes bytesKey(String key) {
        return Bytes.wrap((byte[])key.getBytes());
    }
}

