/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.streams.state.HostInfo;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class HostInfoTest {
    @Test
    public void shouldCreateHostInfo() {
        String endPoint = "host:9090";
        HostInfo hostInfo = HostInfo.buildFromEndpoint((String)"host:9090");
        MatcherAssert.assertThat((Object)hostInfo.host(), (Matcher)Matchers.is((Object)"host"));
        MatcherAssert.assertThat((Object)hostInfo.port(), (Matcher)Matchers.is((Object)9090));
    }

    @Test
    public void shouldReturnNullHostInfoForNullEndPoint() {
        Assert.assertNull((Object)HostInfo.buildFromEndpoint(null));
    }

    @Test
    public void shouldReturnNullHostInfoForEmptyEndPoint() {
        Assert.assertNull((Object)HostInfo.buildFromEndpoint((String)"  "));
    }

    @Test
    public void shouldThrowConfigExceptionForNonsenseEndPoint() {
        Assert.assertThrows(ConfigException.class, () -> HostInfo.buildFromEndpoint((String)"nonsense"));
    }
}

