/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.HashMap;
import org.apache.kafka.streams.processor.internals.ProcessorMetadata;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class ProcessorMetadataTest {
    @Test
    public void shouldAddandGetKeyValueWithEmptyConstructor() {
        ProcessorMetadata metadata = new ProcessorMetadata();
        String key = "some_key";
        long value = 100L;
        metadata.put("some_key", 100L);
        Long actualValue = metadata.get("some_key");
        MatcherAssert.assertThat((Object)actualValue, (Matcher)CoreMatchers.is((Object)100L));
        Long noValue = metadata.get("no_key");
        MatcherAssert.assertThat((Object)noValue, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldAddandGetKeyValueWithExistingMeta() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("key1", 1L);
        map.put("key2", 2L);
        ProcessorMetadata metadata = new ProcessorMetadata(map);
        long value1 = metadata.get("key1");
        MatcherAssert.assertThat((Object)value1, (Matcher)CoreMatchers.is((Object)1L));
        long value2 = metadata.get("key2");
        MatcherAssert.assertThat((Object)value2, (Matcher)CoreMatchers.is((Object)2L));
        Long noValue = metadata.get("key3");
        MatcherAssert.assertThat((Object)noValue, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        metadata.put("key3", 3L);
        long value3 = metadata.get("key3");
        MatcherAssert.assertThat((Object)value3, (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void shouldSerializeAndDeserialize() {
        ProcessorMetadata metadata = new ProcessorMetadata();
        String key1 = "key1";
        String key2 = "key2";
        String key3 = "key3";
        long value1 = 1L;
        long value2 = 2L;
        long value3 = 3L;
        metadata.put("key1", 1L);
        metadata.put("key2", 2L);
        metadata.put("key3", 3L);
        byte[] serialized = metadata.serialize();
        ProcessorMetadata deserialized = ProcessorMetadata.deserialize((byte[])serialized);
        MatcherAssert.assertThat((Object)deserialized.get("key1"), (Matcher)CoreMatchers.is((Object)1L));
        MatcherAssert.assertThat((Object)deserialized.get("key2"), (Matcher)CoreMatchers.is((Object)2L));
        MatcherAssert.assertThat((Object)deserialized.get("key3"), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void shouldDeserializeNull() {
        ProcessorMetadata deserialized = ProcessorMetadata.deserialize(null);
        MatcherAssert.assertThat((Object)deserialized, (Matcher)CoreMatchers.is((Object)new ProcessorMetadata()));
    }

    @Test
    public void shouldUpdate() {
        ProcessorMetadata emptyMeta = new ProcessorMetadata();
        emptyMeta.update(null);
        MatcherAssert.assertThat((Object)emptyMeta, (Matcher)CoreMatchers.is((Object)new ProcessorMetadata()));
        HashMap<String, Long> map1 = new HashMap<String, Long>();
        map1.put("key1", 1L);
        map1.put("key2", 2L);
        ProcessorMetadata metadata1 = new ProcessorMetadata(map1);
        emptyMeta.update(metadata1);
        MatcherAssert.assertThat((Object)emptyMeta.get("key1"), (Matcher)CoreMatchers.is((Object)1L));
        MatcherAssert.assertThat((Object)emptyMeta.get("key2"), (Matcher)CoreMatchers.is((Object)2L));
        map1 = new HashMap();
        map1.put("key1", 0L);
        map1.put("key2", 1L);
        metadata1 = new ProcessorMetadata(map1);
        emptyMeta.update(metadata1);
        MatcherAssert.assertThat((Object)emptyMeta.get("key1"), (Matcher)CoreMatchers.is((Object)1L));
        MatcherAssert.assertThat((Object)emptyMeta.get("key2"), (Matcher)CoreMatchers.is((Object)2L));
        map1 = new HashMap();
        map1.put("key1", 2L);
        map1.put("key2", 3L);
        metadata1 = new ProcessorMetadata(map1);
        emptyMeta.update(metadata1);
        MatcherAssert.assertThat((Object)emptyMeta.get("key1"), (Matcher)CoreMatchers.is((Object)2L));
        MatcherAssert.assertThat((Object)emptyMeta.get("key2"), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void shouldUpdateCommitFlag() {
        ProcessorMetadata emptyMeta = new ProcessorMetadata();
        Assert.assertFalse((boolean)emptyMeta.needsCommit());
        emptyMeta.setNeedsCommit(true);
        Assert.assertTrue((boolean)emptyMeta.needsCommit());
        emptyMeta.setNeedsCommit(false);
        Assert.assertFalse((boolean)emptyMeta.needsCommit());
        emptyMeta.put("key1", 1L);
        Assert.assertTrue((boolean)emptyMeta.needsCommit());
        HashMap<String, Long> map1 = new HashMap<String, Long>();
        map1.put("key1", 2L);
        map1.put("key2", 3L);
        ProcessorMetadata metadata1 = new ProcessorMetadata(map1);
        emptyMeta.update(metadata1);
        Assert.assertTrue((boolean)emptyMeta.needsCommit());
    }

    @Test
    public void shouldNotUseCommitFlagForHashcodeAndEquals() {
        ProcessorMetadata metadata1 = new ProcessorMetadata();
        metadata1.setNeedsCommit(true);
        ProcessorMetadata metadata2 = new ProcessorMetadata();
        metadata2.setNeedsCommit(false);
        Assert.assertEquals((Object)metadata1, (Object)metadata2);
        Assert.assertEquals((long)metadata1.hashCode(), (long)metadata2.hashCode());
    }
}

