/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.internals.metrics;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.internals.metrics.ClientMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mockito.Mockito;

public class ClientMetricsTest {
    private static final String COMMIT_ID = "test-commit-ID";
    private static final String VERSION = "test-version";
    private final StreamsMetricsImpl streamsMetrics = (StreamsMetricsImpl)Mockito.mock(StreamsMetricsImpl.class);
    private final Sensor expectedSensor = (Sensor)Mockito.mock(Sensor.class);
    private final Map<String, String> tagMap = Collections.singletonMap("hello", "world");

    @Test
    public void shouldAddVersionMetric() {
        String name = "version";
        String description = "The version of the Kafka Streams client";
        this.setUpAndVerifyImmutableMetric("version", "The version of the Kafka Streams client", VERSION, () -> ClientMetrics.addVersionMetric((StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldAddCommitIdMetric() {
        String name = "commit-id";
        String description = "The version control commit ID of the Kafka Streams client";
        this.setUpAndVerifyImmutableMetric("commit-id", "The version control commit ID of the Kafka Streams client", COMMIT_ID, () -> ClientMetrics.addCommitIdMetric((StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldAddApplicationIdMetric() {
        String name = "application-id";
        String description = "The application ID of the Kafka Streams client";
        String applicationId = "thisIsAnID";
        this.setUpAndVerifyImmutableMetric("application-id", "The application ID of the Kafka Streams client", "thisIsAnID", () -> ClientMetrics.addApplicationIdMetric((StreamsMetricsImpl)this.streamsMetrics, (String)"thisIsAnID"));
    }

    @Test
    public void shouldAddTopologyDescriptionMetric() {
        String name = "topology-description";
        String description = "The description of the topology executed in the Kafka Streams client";
        String topologyDescription = "thisIsATopologyDescription";
        Gauge topologyDescriptionProvider = (c, n) -> "thisIsATopologyDescription";
        this.setUpAndVerifyMutableMetric("topology-description", "The description of the topology executed in the Kafka Streams client", topologyDescriptionProvider, () -> ClientMetrics.addTopologyDescriptionMetric((StreamsMetricsImpl)this.streamsMetrics, (Gauge)topologyDescriptionProvider));
    }

    @Test
    public void shouldAddStateMetric() {
        String name = "state";
        String description = "The state of the Kafka Streams client";
        Gauge stateProvider = (config, now) -> KafkaStreams.State.RUNNING;
        this.setUpAndVerifyMutableMetric("state", "The state of the Kafka Streams client", stateProvider, () -> ClientMetrics.addStateMetric((StreamsMetricsImpl)this.streamsMetrics, (Gauge)stateProvider));
    }

    @Test
    public void shouldAddAliveStreamThreadsMetric() {
        String name = "alive-stream-threads";
        String description = "The current number of alive stream threads that are running or participating in rebalance";
        Gauge valueProvider = (config, now) -> 1;
        this.setUpAndVerifyMutableMetric("alive-stream-threads", "The current number of alive stream threads that are running or participating in rebalance", valueProvider, () -> ClientMetrics.addNumAliveStreamThreadMetric((StreamsMetricsImpl)this.streamsMetrics, (Gauge)valueProvider));
    }

    @Test
    public void shouldGetFailedStreamThreadsSensor() {
        String name = "failed-stream-threads";
        String description = "The number of failed stream threads since the start of the Kafka Streams client";
        Mockito.when((Object)this.streamsMetrics.clientLevelSensor("failed-stream-threads", Sensor.RecordingLevel.INFO, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.clientLevelTagMap()).thenReturn(this.tagMap);
        StreamsMetricsImpl.addSumMetricToSensor((Sensor)this.expectedSensor, (String)"stream-metrics", this.tagMap, (String)"failed-stream-threads", (boolean)false, (String)"The number of failed stream threads since the start of the Kafka Streams client");
        Sensor sensor = ClientMetrics.failedStreamThreadSensor((StreamsMetricsImpl)this.streamsMetrics);
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    private <K> void setUpAndVerifyMutableMetric(String name, String description, Gauge<K> valueProvider, Runnable metricAdder) {
        metricAdder.run();
        ((StreamsMetricsImpl)Mockito.verify((Object)this.streamsMetrics)).addClientLevelMutableMetric((String)Mockito.eq((Object)name), (String)Mockito.eq((Object)description), (Sensor.RecordingLevel)Mockito.eq((Object)Sensor.RecordingLevel.INFO), (Gauge)Mockito.eq(valueProvider));
    }

    private void setUpAndVerifyImmutableMetric(String name, String description, String value, Runnable metricAdder) {
        metricAdder.run();
        ((StreamsMetricsImpl)Mockito.verify((Object)this.streamsMetrics)).addClientLevelImmutableMetric((String)Mockito.eq((Object)name), (String)Mockito.eq((Object)description), (Sensor.RecordingLevel)Mockito.eq((Object)Sensor.RecordingLevel.INFO), (Object)((String)Mockito.eq((Object)value)));
    }
}

