/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.internals.AbstractSessionBytesStoreTest;
import org.apache.kafka.streams.state.internals.RocksDbTimeOrderedSessionBytesStoreSupplier;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RocksDBSessionStoreTest
extends AbstractSessionBytesStoreTest {
    private static final String STORE_NAME = "rocksDB session store";
    @Parameterized.Parameter
    public AbstractSessionBytesStoreTest.StoreType storeType;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> getParamStoreType() {
        return Arrays.asList({AbstractSessionBytesStoreTest.StoreType.RocksDBSessionStore}, {AbstractSessionBytesStoreTest.StoreType.RocksDBTimeOrderedSessionStoreWithIndex}, {AbstractSessionBytesStoreTest.StoreType.RocksDBTimeOrderedSessionStoreWithoutIndex});
    }

    @Override
    AbstractSessionBytesStoreTest.StoreType getStoreType() {
        return this.storeType;
    }

    @Override
    <K, V> SessionStore<K, V> buildSessionStore(long retentionPeriod, Serde<K> keySerde, Serde<V> valueSerde) {
        switch (this.storeType) {
            case RocksDBSessionStore: {
                return (SessionStore)Stores.sessionStoreBuilder((SessionBytesStoreSupplier)Stores.persistentSessionStore((String)STORE_NAME, (Duration)Duration.ofMillis(retentionPeriod)), keySerde, valueSerde).build();
            }
            case RocksDBTimeOrderedSessionStoreWithIndex: {
                return (SessionStore)Stores.sessionStoreBuilder((SessionBytesStoreSupplier)new RocksDbTimeOrderedSessionBytesStoreSupplier(STORE_NAME, retentionPeriod, true), keySerde, valueSerde).build();
            }
            case RocksDBTimeOrderedSessionStoreWithoutIndex: {
                return (SessionStore)Stores.sessionStoreBuilder((SessionBytesStoreSupplier)new RocksDbTimeOrderedSessionBytesStoreSupplier(STORE_NAME, retentionPeriod, false), keySerde, valueSerde).build();
            }
        }
        throw new IllegalStateException("Unknown StoreType: " + (Object)((Object)this.storeType));
    }
}

