/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.state.internals.LeftOrRightValue;
import org.apache.kafka.streams.state.internals.LeftOrRightValueSerde;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class LeftOrRightValueSerializerTest {
    private static final String TOPIC = "some-topic";
    private static final LeftOrRightValueSerde<String, Integer> STRING_OR_INTEGER_SERDE = new LeftOrRightValueSerde(Serdes.String(), Serdes.Integer());

    @Test
    public void shouldSerializeStringValue() {
        String value = "some-string";
        LeftOrRightValue leftOrRightValue = LeftOrRightValue.makeLeftValue((Object)"some-string");
        byte[] serialized = STRING_OR_INTEGER_SERDE.serializer().serialize(TOPIC, (Object)leftOrRightValue);
        MatcherAssert.assertThat((Object)serialized, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        LeftOrRightValue deserialized = (LeftOrRightValue)STRING_OR_INTEGER_SERDE.deserializer().deserialize(TOPIC, serialized);
        MatcherAssert.assertThat((Object)deserialized, (Matcher)Matchers.is((Object)leftOrRightValue));
    }

    @Test
    public void shouldSerializeIntegerValue() {
        int value = 5;
        LeftOrRightValue leftOrRightValue = LeftOrRightValue.makeRightValue((Object)5);
        byte[] serialized = STRING_OR_INTEGER_SERDE.serializer().serialize(TOPIC, (Object)leftOrRightValue);
        MatcherAssert.assertThat((Object)serialized, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        LeftOrRightValue deserialized = (LeftOrRightValue)STRING_OR_INTEGER_SERDE.deserializer().deserialize(TOPIC, serialized);
        MatcherAssert.assertThat((Object)deserialized, (Matcher)Matchers.is((Object)leftOrRightValue));
    }

    @Test
    public void shouldThrowIfSerializeValueAsNull() {
        Assert.assertThrows(NullPointerException.class, () -> STRING_OR_INTEGER_SERDE.serializer().serialize(TOPIC, (Object)LeftOrRightValue.makeLeftValue(null)));
    }

    @Test
    public void shouldThrowIfSerializeOtherValueAsNull() {
        Assert.assertThrows(NullPointerException.class, () -> STRING_OR_INTEGER_SERDE.serializer().serialize(TOPIC, (Object)LeftOrRightValue.makeRightValue(null)));
    }
}

