/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.streams.state.internals.RocksDbVersionedKeyValueBytesStoreSupplier;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class RocksDbVersionedKeyValueBytesStoreSupplierTest {
    private static final String STORE_NAME = "versioned_store";

    @Test
    public void shouldUseDefaultSegmentInterval() {
        this.verifyExpectedSegmentInterval(0L, 2000L);
        this.verifyExpectedSegmentInterval(1000L, 2000L);
        this.verifyExpectedSegmentInterval(6000L, 2000L);
        this.verifyExpectedSegmentInterval(30000L, 10000L);
        this.verifyExpectedSegmentInterval(60000L, 20000L);
        this.verifyExpectedSegmentInterval(80000L, 20000L);
        this.verifyExpectedSegmentInterval(100000L, 20000L);
        this.verifyExpectedSegmentInterval(200000L, 40000L);
        this.verifyExpectedSegmentInterval(300000L, 60000L);
        this.verifyExpectedSegmentInterval(600000L, 60000L);
        this.verifyExpectedSegmentInterval(720000L, 60000L);
        this.verifyExpectedSegmentInterval(1200000L, 100000L);
        this.verifyExpectedSegmentInterval(3600000L, 300000L);
        this.verifyExpectedSegmentInterval(6000000L, 300000L);
        this.verifyExpectedSegmentInterval(0x6DDD00L, 300000L);
        this.verifyExpectedSegmentInterval(86400000L, 3600000L);
    }

    private void verifyExpectedSegmentInterval(long historyRetention, long expectedSegmentInterval) {
        MatcherAssert.assertThat((Object)new RocksDbVersionedKeyValueBytesStoreSupplier(STORE_NAME, historyRetention).segmentIntervalMs(), (Matcher)Matchers.is((Object)expectedSegmentInterval));
    }
}

