/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.internals.ApiUtils;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ReadOnlyWindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;

public class ReadOnlyWindowStoreStub<K, V>
implements ReadOnlyWindowStore<K, V>,
StateStore {
    private final long windowSize;
    private final NavigableMap<Long, NavigableMap<K, V>> data = new TreeMap<Long, NavigableMap<K, V>>();
    private boolean open = true;

    ReadOnlyWindowStoreStub(long windowSize) {
        this.windowSize = windowSize;
    }

    public V fetch(K key, long time) {
        Map kvMap = (Map)this.data.get(time);
        if (kvMap != null) {
            return kvMap.get(key);
        }
        return null;
    }

    public WindowStoreIterator<V> fetch(K key, Instant timeFrom, Instant timeTo) {
        if (!this.open) {
            throw new InvalidStateStoreException("Store is not open");
        }
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        for (long now = timeFrom.toEpochMilli(); now <= timeTo.toEpochMilli(); ++now) {
            Map kvMap = (Map)this.data.get(now);
            if (kvMap == null || !kvMap.containsKey(key)) continue;
            results.add(new KeyValue((Object)now, kvMap.get(key)));
        }
        return new TheWindowStoreIterator(results.iterator());
    }

    public WindowStoreIterator<V> backwardFetch(K key, Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        long timeFromTs = ApiUtils.validateMillisecondInstant((Instant)timeFrom, (String)ApiUtils.prepareMillisCheckFailMsgPrefix((Object)timeFrom, (String)"timeFrom"));
        long timeToTs = ApiUtils.validateMillisecondInstant((Instant)timeTo, (String)ApiUtils.prepareMillisCheckFailMsgPrefix((Object)timeTo, (String)"timeTo"));
        if (!this.open) {
            throw new InvalidStateStoreException("Store is not open");
        }
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        for (long now = timeToTs; now >= timeFromTs; --now) {
            Map kvMap = (Map)this.data.get(now);
            if (kvMap == null || !kvMap.containsKey(key)) continue;
            results.add(new KeyValue((Object)now, kvMap.get(key)));
        }
        return new TheWindowStoreIterator(results.iterator());
    }

    public KeyValueIterator<Windowed<K>, V> all() {
        if (!this.open) {
            throw new InvalidStateStoreException("Store is not open");
        }
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        Iterator iterator = this.data.keySet().iterator();
        while (iterator.hasNext()) {
            long now = (Long)iterator.next();
            NavigableMap kvMap = (NavigableMap)this.data.get(now);
            if (kvMap == null) continue;
            for (Map.Entry entry : kvMap.entrySet()) {
                results.add(new KeyValue((Object)new Windowed(entry.getKey(), (Window)new TimeWindow(now, now + this.windowSize)), entry.getValue()));
            }
        }
        final Iterator iterator2 = results.iterator();
        return new KeyValueIterator<Windowed<K>, V>(){

            public void close() {
            }

            public Windowed<K> peekNextKey() {
                throw new UnsupportedOperationException("peekNextKey() not supported in " + this.getClass().getName());
            }

            public boolean hasNext() {
                return iterator2.hasNext();
            }

            public KeyValue<Windowed<K>, V> next() {
                return (KeyValue)iterator2.next();
            }
        };
    }

    public KeyValueIterator<Windowed<K>, V> backwardAll() {
        if (!this.open) {
            throw new InvalidStateStoreException("Store is not open");
        }
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        for (long now : this.data.descendingKeySet()) {
            NavigableMap kvMap = (NavigableMap)this.data.get(now);
            if (kvMap == null) continue;
            for (Map.Entry entry : kvMap.descendingMap().entrySet()) {
                results.add(new KeyValue((Object)new Windowed(entry.getKey(), (Window)new TimeWindow(now, now + this.windowSize)), entry.getValue()));
            }
        }
        final Iterator iterator = results.iterator();
        return new KeyValueIterator<Windowed<K>, V>(){

            public void close() {
            }

            public Windowed<K> peekNextKey() {
                throw new UnsupportedOperationException("peekNextKey() not supported in " + this.getClass().getName());
            }

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public KeyValue<Windowed<K>, V> next() {
                return (KeyValue)iterator.next();
            }
        };
    }

    public KeyValueIterator<Windowed<K>, V> fetchAll(Instant timeFrom, Instant timeTo) {
        if (!this.open) {
            throw new InvalidStateStoreException("Store is not open");
        }
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        Iterator iterator = this.data.keySet().iterator();
        while (iterator.hasNext()) {
            NavigableMap kvMap;
            long now = (Long)iterator.next();
            if (now < timeFrom.toEpochMilli() || now > timeTo.toEpochMilli() || (kvMap = (NavigableMap)this.data.get(now)) == null) continue;
            for (Map.Entry entry : kvMap.entrySet()) {
                results.add(new KeyValue((Object)new Windowed(entry.getKey(), (Window)new TimeWindow(now, now + this.windowSize)), entry.getValue()));
            }
        }
        final Iterator iterator2 = results.iterator();
        return new KeyValueIterator<Windowed<K>, V>(){

            public void close() {
            }

            public Windowed<K> peekNextKey() {
                throw new UnsupportedOperationException("peekNextKey() not supported in " + this.getClass().getName());
            }

            public boolean hasNext() {
                return iterator2.hasNext();
            }

            public KeyValue<Windowed<K>, V> next() {
                return (KeyValue)iterator2.next();
            }
        };
    }

    public KeyValueIterator<Windowed<K>, V> backwardFetchAll(Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        long timeFromTs = ApiUtils.validateMillisecondInstant((Instant)timeFrom, (String)ApiUtils.prepareMillisCheckFailMsgPrefix((Object)timeFrom, (String)"timeFrom"));
        long timeToTs = ApiUtils.validateMillisecondInstant((Instant)timeTo, (String)ApiUtils.prepareMillisCheckFailMsgPrefix((Object)timeTo, (String)"timeTo"));
        if (!this.open) {
            throw new InvalidStateStoreException("Store is not open");
        }
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        for (long now : this.data.descendingKeySet()) {
            NavigableMap kvMap;
            if (now < timeFromTs || now > timeToTs || (kvMap = (NavigableMap)this.data.get(now)) == null) continue;
            for (Map.Entry entry : kvMap.descendingMap().entrySet()) {
                results.add(new KeyValue((Object)new Windowed(entry.getKey(), (Window)new TimeWindow(now, now + this.windowSize)), entry.getValue()));
            }
        }
        final Iterator iterator = results.iterator();
        return new KeyValueIterator<Windowed<K>, V>(){

            public void close() {
            }

            public Windowed<K> peekNextKey() {
                throw new UnsupportedOperationException("peekNextKey() not supported in " + this.getClass().getName());
            }

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public KeyValue<Windowed<K>, V> next() {
                return (KeyValue)iterator.next();
            }
        };
    }

    public KeyValueIterator<Windowed<K>, V> fetch(K keyFrom, K keyTo, Instant timeFrom, Instant timeTo) {
        if (!this.open) {
            throw new InvalidStateStoreException("Store is not open");
        }
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        for (long now = timeFrom.toEpochMilli(); now <= timeTo.toEpochMilli(); ++now) {
            NavigableMap kvMap = (NavigableMap)this.data.get(now);
            if (kvMap == null) continue;
            NavigableMap kvSubMap = keyFrom == null && keyFrom == null ? kvMap : (keyFrom == null ? kvMap.headMap(keyTo, true) : (keyTo == null ? kvMap.tailMap(keyFrom, true) : kvMap.subMap(keyFrom, true, keyTo, true)));
            for (Map.Entry entry : kvSubMap.entrySet()) {
                results.add(new KeyValue((Object)new Windowed(entry.getKey(), (Window)new TimeWindow(now, now + this.windowSize)), entry.getValue()));
            }
        }
        final Iterator iterator = results.iterator();
        return new KeyValueIterator<Windowed<K>, V>(){

            public void close() {
            }

            public Windowed<K> peekNextKey() {
                throw new UnsupportedOperationException("peekNextKey() not supported in " + this.getClass().getName());
            }

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public KeyValue<Windowed<K>, V> next() {
                return (KeyValue)iterator.next();
            }
        };
    }

    public KeyValueIterator<Windowed<K>, V> backwardFetch(K keyFrom, K keyTo, Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        long timeFromTs = ApiUtils.validateMillisecondInstant((Instant)timeFrom, (String)ApiUtils.prepareMillisCheckFailMsgPrefix((Object)timeFrom, (String)"timeFrom"));
        long timeToTs = ApiUtils.validateMillisecondInstant((Instant)timeTo, (String)ApiUtils.prepareMillisCheckFailMsgPrefix((Object)timeTo, (String)"timeTo"));
        if (!this.open) {
            throw new InvalidStateStoreException("Store is not open");
        }
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        for (long now = timeToTs; now >= timeFromTs; --now) {
            NavigableMap kvMap = (NavigableMap)this.data.get(now);
            if (kvMap == null) continue;
            NavigableMap kvSubMap = keyFrom == null && keyFrom == null ? kvMap : (keyFrom == null ? kvMap.headMap(keyTo, true) : (keyTo == null ? kvMap.tailMap(keyFrom, true) : kvMap.subMap(keyFrom, true, keyTo, true)));
            for (Map.Entry entry : kvSubMap.descendingMap().entrySet()) {
                results.add(new KeyValue((Object)new Windowed(entry.getKey(), (Window)new TimeWindow(now, now + this.windowSize)), entry.getValue()));
            }
        }
        final Iterator iterator = results.iterator();
        return new KeyValueIterator<Windowed<K>, V>(){

            public void close() {
            }

            public Windowed<K> peekNextKey() {
                throw new UnsupportedOperationException("peekNextKey() not supported in " + this.getClass().getName());
            }

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public KeyValue<Windowed<K>, V> next() {
                return (KeyValue)iterator.next();
            }
        };
    }

    public void put(K key, V value, long timestamp) {
        if (!this.data.containsKey(timestamp)) {
            this.data.put(timestamp, new TreeMap());
        }
        ((NavigableMap)this.data.get(timestamp)).put(key, value);
    }

    public String name() {
        return null;
    }

    @Deprecated
    public void init(ProcessorContext context, StateStore root) {
    }

    public void flush() {
    }

    public void close() {
    }

    public boolean persistent() {
        return false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public Position getPosition() {
        throw new UnsupportedOperationException("Position handling not implemented");
    }

    void setOpen(boolean open) {
        this.open = open;
    }

    private static class TheWindowStoreIterator<E>
    implements WindowStoreIterator<E> {
        private final Iterator<KeyValue<Long, E>> underlying;

        TheWindowStoreIterator(Iterator<KeyValue<Long, E>> underlying) {
            this.underlying = underlying;
        }

        public void close() {
        }

        public Long peekNextKey() {
            throw new UnsupportedOperationException("peekNextKey() not supported in " + this.getClass().getName());
        }

        public boolean hasNext() {
            return this.underlying.hasNext();
        }

        public KeyValue<Long, E> next() {
            return this.underlying.next();
        }
    }
}

