/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Instant;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ReadOnlyWindowStore;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.KeyValueIteratorFacade;

public class ReadOnlyWindowStoreFacade<K, V>
implements ReadOnlyWindowStore<K, V> {
    protected final TimestampedWindowStore<K, V> inner;

    protected ReadOnlyWindowStoreFacade(TimestampedWindowStore<K, V> store) {
        this.inner = store;
    }

    @Override
    public V fetch(K key, long time) {
        return ValueAndTimestamp.getValueOrNull((ValueAndTimestamp)this.inner.fetch(key, time));
    }

    @Override
    public WindowStoreIterator<V> fetch(K key, long timeFrom, long timeTo) {
        return new WindowStoreIteratorFacade(this.inner.fetch(key, timeFrom, timeTo));
    }

    @Override
    public WindowStoreIterator<V> fetch(K key, Instant from, Instant to) throws IllegalArgumentException {
        return new WindowStoreIteratorFacade(this.inner.fetch(key, from, to));
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetch(K from, K to, long timeFrom, long timeTo) {
        return new KeyValueIteratorFacade(this.inner.fetch(from, to, timeFrom, timeTo));
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetch(K from, K to, Instant fromTime, Instant toTime) throws IllegalArgumentException {
        return new KeyValueIteratorFacade(this.inner.fetch(from, to, fromTime, toTime));
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetchAll(long timeFrom, long timeTo) {
        return new KeyValueIteratorFacade(this.inner.fetchAll(timeFrom, timeTo));
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetchAll(Instant from, Instant to) throws IllegalArgumentException {
        KeyValueIterator innerIterator = this.inner.fetchAll(from, to);
        return new KeyValueIteratorFacade(innerIterator);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> all() {
        KeyValueIterator innerIterator = this.inner.all();
        return new KeyValueIteratorFacade(innerIterator);
    }

    private static class WindowStoreIteratorFacade<V>
    implements WindowStoreIterator<V> {
        final KeyValueIterator<Long, ValueAndTimestamp<V>> innerIterator;

        WindowStoreIteratorFacade(KeyValueIterator<Long, ValueAndTimestamp<V>> iterator) {
            this.innerIterator = iterator;
        }

        @Override
        public void close() {
            this.innerIterator.close();
        }

        @Override
        public Long peekNextKey() {
            return this.innerIterator.peekNextKey();
        }

        @Override
        public boolean hasNext() {
            return this.innerIterator.hasNext();
        }

        @Override
        public KeyValue<Long, V> next() {
            KeyValue innerKeyValue = (KeyValue)this.innerIterator.next();
            return KeyValue.pair((Long)innerKeyValue.key, ValueAndTimestamp.getValueOrNull((ValueAndTimestamp)innerKeyValue.value));
        }
    }
}

