/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.errors;

import java.util.Collection;
import java.util.Map;
import org.apache.kafka.clients.consumer.InvalidOffsetException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.TaskId;

public class TaskCorruptedException
extends StreamsException {
    private final Map<TaskId, Collection<TopicPartition>> taskWithChangelogs;

    public TaskCorruptedException(Map<TaskId, Collection<TopicPartition>> taskWithChangelogs) {
        super("Tasks with changelogs " + taskWithChangelogs + " are corrupted and hence needs to be re-initialized");
        this.taskWithChangelogs = taskWithChangelogs;
    }

    public TaskCorruptedException(Map<TaskId, Collection<TopicPartition>> taskWithChangelogs, InvalidOffsetException e) {
        super("Tasks with changelogs " + taskWithChangelogs + " are corrupted and hence needs to be re-initialized", (Throwable)e);
        this.taskWithChangelogs = taskWithChangelogs;
    }

    public Map<TaskId, Collection<TopicPartition>> corruptedTaskWithChangelogs() {
        return this.taskWithChangelogs;
    }
}

