/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.util.Arrays;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class KeyValueStoreFacadeTest {
    private final TimestampedKeyValueStore<String, String> mockedKeyValueTimestampStore = (TimestampedKeyValueStore)Mockito.mock(TimestampedKeyValueStore.class);
    private TopologyTestDriver.KeyValueStoreFacade<String, String> keyValueStoreFacade;

    @BeforeEach
    public void setup() {
        this.keyValueStoreFacade = new TopologyTestDriver.KeyValueStoreFacade(this.mockedKeyValueTimestampStore);
    }

    @Test
    public void shouldForwardDeprecatedInit() {
        ProcessorContext context = (ProcessorContext)Mockito.mock(ProcessorContext.class);
        StateStore store = (StateStore)Mockito.mock(StateStore.class);
        this.keyValueStoreFacade.init(context, store);
        ((TimestampedKeyValueStore)Mockito.verify(this.mockedKeyValueTimestampStore)).init(context, store);
    }

    @Test
    public void shouldForwardInit() {
        StateStoreContext context = (StateStoreContext)Mockito.mock(StateStoreContext.class);
        StateStore store = (StateStore)Mockito.mock(StateStore.class);
        this.keyValueStoreFacade.init(context, store);
        ((TimestampedKeyValueStore)Mockito.verify(this.mockedKeyValueTimestampStore)).init(context, store);
    }

    @Test
    public void shouldPutWithUnknownTimestamp() {
        this.keyValueStoreFacade.put((Object)"key", (Object)"value");
        ((TimestampedKeyValueStore)Mockito.verify(this.mockedKeyValueTimestampStore)).put((Object)"key", (Object)ValueAndTimestamp.make((Object)"value", (long)-1L));
    }

    @Test
    public void shouldPutIfAbsentWithUnknownTimestamp() {
        ((TimestampedKeyValueStore)Mockito.doReturn(null, (Object[])new Object[]{ValueAndTimestamp.make((Object)"oldValue", (long)42L)}).when(this.mockedKeyValueTimestampStore)).putIfAbsent((Object)"key", (Object)ValueAndTimestamp.make((Object)"value", (long)-1L));
        Assertions.assertNull((Object)this.keyValueStoreFacade.putIfAbsent((Object)"key", (Object)"value"));
        MatcherAssert.assertThat((Object)((String)this.keyValueStoreFacade.putIfAbsent((Object)"key", (Object)"value")), (Matcher)CoreMatchers.is((Object)"oldValue"));
        ((TimestampedKeyValueStore)Mockito.verify(this.mockedKeyValueTimestampStore, (VerificationMode)Mockito.times((int)2))).putIfAbsent((Object)"key", (Object)ValueAndTimestamp.make((Object)"value", (long)-1L));
    }

    @Test
    public void shouldPutAllWithUnknownTimestamp() {
        this.keyValueStoreFacade.putAll(Arrays.asList(KeyValue.pair((Object)"key1", (Object)"value1"), KeyValue.pair((Object)"key2", (Object)"value2")));
        ((TimestampedKeyValueStore)Mockito.verify(this.mockedKeyValueTimestampStore)).put((Object)"key1", (Object)ValueAndTimestamp.make((Object)"value1", (long)-1L));
        ((TimestampedKeyValueStore)Mockito.verify(this.mockedKeyValueTimestampStore)).put((Object)"key2", (Object)ValueAndTimestamp.make((Object)"value2", (long)-1L));
    }

    @Test
    public void shouldDeleteAndReturnPlainValue() {
        ((TimestampedKeyValueStore)Mockito.doReturn(null, (Object[])new Object[]{ValueAndTimestamp.make((Object)"oldValue", (long)42L)}).when(this.mockedKeyValueTimestampStore)).delete((Object)"key");
        Assertions.assertNull((Object)this.keyValueStoreFacade.delete((Object)"key"));
        MatcherAssert.assertThat((Object)((String)this.keyValueStoreFacade.delete((Object)"key")), (Matcher)CoreMatchers.is((Object)"oldValue"));
        ((TimestampedKeyValueStore)Mockito.verify(this.mockedKeyValueTimestampStore, (VerificationMode)Mockito.times((int)2))).delete((Object)"key");
    }

    @Test
    public void shouldForwardFlush() {
        this.keyValueStoreFacade.flush();
        ((TimestampedKeyValueStore)Mockito.verify(this.mockedKeyValueTimestampStore)).flush();
    }

    @Test
    public void shouldForwardClose() {
        this.keyValueStoreFacade.close();
        ((TimestampedKeyValueStore)Mockito.verify(this.mockedKeyValueTimestampStore)).close();
    }

    @Test
    public void shouldReturnName() {
        Mockito.when((Object)this.mockedKeyValueTimestampStore.name()).thenReturn((Object)"name");
        MatcherAssert.assertThat((Object)this.keyValueStoreFacade.name(), (Matcher)CoreMatchers.is((Object)"name"));
        ((TimestampedKeyValueStore)Mockito.verify(this.mockedKeyValueTimestampStore)).name();
    }

    @Test
    public void shouldReturnIsPersistent() {
        Mockito.when((Object)this.mockedKeyValueTimestampStore.persistent()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        MatcherAssert.assertThat((Object)this.keyValueStoreFacade.persistent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.keyValueStoreFacade.persistent(), (Matcher)CoreMatchers.is((Object)false));
        ((TimestampedKeyValueStore)Mockito.verify(this.mockedKeyValueTimestampStore, (VerificationMode)Mockito.times((int)2))).persistent();
    }

    @Test
    public void shouldReturnIsOpen() {
        Mockito.when((Object)this.mockedKeyValueTimestampStore.isOpen()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        MatcherAssert.assertThat((Object)this.keyValueStoreFacade.isOpen(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.keyValueStoreFacade.isOpen(), (Matcher)CoreMatchers.is((Object)false));
        ((TimestampedKeyValueStore)Mockito.verify(this.mockedKeyValueTimestampStore, (VerificationMode)Mockito.times((int)2))).isOpen();
    }
}

